<?php


class Booking extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strBookingName;
	public $strDescription;
	public $strEmail;
	public $strPhone;
	public $strCell;
	public $strTitle;
	public $intID;
	public $strAction;

	public $strUploadsDir;
	public $strUploadsUrl;
	public $strDisplayImage;

	public $strPaymentReports;
	public $strDetailReports;

	public $arrFilesToDelete;

	public function __construct($strPageId,$strAction) {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'booking_people';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/booking/';

		$this->strTitle = 'Booking People';

		$this->strUploadsDir = ROOT_DIR.'/application/uploads/booking/';
        $this->strUploadsUrl = ROOT_URL.'/application/uploads/booking/';

	}


	public function handlePost($post,$id) {
		$this->intID = $id;
		$this->strBookingName = isset($post['booking_name']) ? $post['booking_name'] : '';
		$this->strEmail = isset($post['booking_email']) ? $post['booking_email'] : '';
		$this->strPhone = isset($post['booking_phone']) ? $post['booking_phone'] : '';
		$this->strCell = isset($post['booking_cell']) ? $post['booking_cell'] : '';
		$this->strTitle = isset($post['booking_title']) ? $post['booking_title'] : '';
		$this->strDescription = isset($post['booking_description']) ? $post['booking_description'] : '';
		$this->arrFilesToDelete = isset($post['files_to_delete']) ? $post['files_to_delete'] : '';

		$this->strPaymentReports = isset($post['payment_status_cron']) ? 1 : 0;
		$this->strDetailReports = isset($post['detail_reports_cron']) ? 1 : 0;

		if($this->strBookingName == '') { $this->strErrorMessage .= "Please enter a name for this person.<br />"; }

		if($this->strErrorMessage == '') {

			$keys = array('booking_name','booking_email','booking_phone', 'booking_description', 'booking_title', 'booking_office_cell', 'payment_status_cron', 'detail_reports_cron');
			$vals = array( $this->strBookingName,$this->strEmail,$this->strPhone,$this->strDescription, $this->strTitle, $this->strCell, $this->strPaymentReports, $this->strDetailReports);
			$types = array('ssssssii');

			if($this->intID == '') {

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,$types);
				$this->intID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added:'.$this->intID;


			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,$types,$this->intID);
				$this->strSuccessMessage = 'Record Saved';

			}

			// Delete any files that were checked for deletion
            if (!empty($this->arrFilesToDelete)) {
                foreach ($this->arrFilesToDelete as $strFieldName => $strFilePath) {
                    if (Util::deleteFile($strFilePath)) {
                        $this->strQuery = "UPDATE $this->strTableName SET `$strFieldName` = NULL WHERE `id` = $this->intID";
                        $this->short_query($this->strQuery);
                    }
                }
            }

			//File Upload
			if($_FILES['booking_image']['error'] != 4) {
                // Upload our display image
                $arrUploaded = Util::uploadFile(
                    $_FILES['booking_image'],
                    $this->strUploadsDir,
                    $this->intID.'_booking_person',
                    array('image/*')
                );

                if ($arrUploaded) {
                    // If the file uploaded successfully
                    $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
                    $fileName = $url.$arrUploaded['file'];

                    $this->strQuery = 'UPDATE '.$this->strTableName.' SET `booking_image` = \''.$fileName.'\' WHERE id=' . $this->intID;
                    if($this->short_query($this->strQuery)) {
                        $this->strSuccessMessage .= '<br> Logo Image Updated';
                    } else {
                        $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
                    }
                }
            }


        } //error message check

        return $this->intID;

	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT t.* 
		From $this->strTableName t 
		WHERE t.id=$id
		LIMIT 0,1";
		//echo $this->strQuery;

		if($this->query($this->strQuery)) {

			$result = $this->getMysqliResults($this->strQuery,true);

			$result = $result[0];
			
			$this->strBookingName = isset($result['booking_name']) ? $result['booking_name'] : '';
			$this->strEmail = isset($result['booking_email']) ? $result['booking_email'] : '';
			$this->strTitle = isset($result['booking_title']) ? $result['booking_title'] : '';
			$this->strPhone = isset($result['booking_phone']) ? $result['booking_phone'] : '';
			$this->strCell = isset($result['booking_office_cell']) ? $result['booking_office_cell'] : '';
			$this->strDescription = isset($result['booking_description']) ? $result['booking_description'] : '';
			$this->strDisplayImage = isset($result['booking_image']) ? $result['booking_image'] : '';

			$this->strPaymentReports = isset($result['payment_status_cron']) ? $result['payment_status_cron'] : 0;
			$this->strDetailReports = isset($result['detail_reports_cron']) ? $result['detail_reports_cron'] : 0;

	     	return $result;
	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.booking_name like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.* 
	     From $this->strTableName t  
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.booking_name like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id) {

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}

}



?>