<?php


class Ads extends Database  {

	public $strQuery;
	public $strQuery1;
	public $arrResult;
	public $arrPages;
	public $intPageCount;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strTitle;
	public $strSearchWord;
	public $strShortName;
	public $strAdTitle ;
	public $intID;
	public $strAdDetail;
	public $strAction;



	public function __construct($strPageId,$strAction) {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'ads';
		$this->strTableSlug = $strPageId;
		$this->strAdminSlug = '/admin/ads/';

		$this->strTitle = 'Sidebar Advertisements';



	}


	public function handlePost($post,$id) {
		$this->intID = $id;
		$this->strAdTitle = isset($post['ad_title']) ? $post['ad_title'] : '';
		$this->strAdDetail = isset($post['ad_detail']) ? $post['ad_detail'] : '';

		if($this->strAdTitle == '') { $this->strErrorMessage .= "Please enter a title for this ad.<br />"; }
		if($this->strAdDetail == '') { $this->strErrorMessage .= "Please enter the content for this ad.<br />"; }

		if($this->strErrorMessage == '') {

			$keys = array('ad_title','ad_detail');
			$vals = array( $this->strAdTitle,$this->strAdDetail);
			//$types = array('ss');

			if($this->intID == '') {

				//no ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->intID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added:'.$this->intID;

			} else {

				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$this->intID);
				$this->strSuccessMessage = 'Record Saved';

			}

        } //error message check

        return $this->intID;

	}


    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT *
		From $this->strTableName
		WHERE id=$id
		LIMIT 0,1";

		if($this->query($this->strQuery)) {
	     	$result = $this->getMysqliResults($this->strQuery,true);
	     	$result = $result[0];
	     	$this->strAdTitle = isset($result['ad_title']) ? $result['ad_title'] : '';
			$this->strAdDetail = isset($result['ad_detail']) ? $result['ad_detail'] : '';
			return $result;

	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($cats != '') {
	   	 	$this->strQuery1 .= "AND cat_id='$cats' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.ad_title like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.* 
	     From $this->strTableName t 
	     WHERE t.`id` > 0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.ad_title like '%$searchWord%' )";
		 }

		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function getStates() {

		$strQuery = "SELECT * 
		from state t WHERE status='Active'";

		//if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}

	public function getCountries() {

		$strQuery = "SELECT * 
		from country t WHERE status='Active'";

		//if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}


	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id) {

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}


	}

}



?>