<?php


class aPage extends Database  {

	public $strQuery;
	public $strQuery1;
	public $arrResult;
	public $arrPages;
	public $intPageCount;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;
	public $strTitle;
	public $strSlug;
	public $strContent;

    public $strFocusKeyword;
	public $strMetaTitle;
	public $strMetaKeywords;
	public $strMetaDescription;
	public $strMetaRobots;
    public $intScoreSEO;

	public $strSearchWord;
	public $strDateCreated;
	public $strDateModified;

	public $strFacebookTitle;
	public $strFacebookDescription;
	public $strTwitterTitle;
	public $strTwitterDescription;
	public $strGoogleDescription;
	public $strStatus;

    public $strUploadsDir;
    public $strUploadsUrl;
    public $arrFilesToDelete;
    public $strDisplayImage;

	public $intID;
	public $strAction;
	public $strPubStatus;
	public $blnShowFeatured = 1;
	public $blnLockSlug = 0;
	public $intCategory;
	public $intNavOrder;

    public $strVideoEmbed;
    public $strVideoSmallHeading;
    public $strVideoLargeHeading;
    public $strVideoText;
    public $strVideoBtnText;
    public $strVideoLink;

	public function __construct($strPageId,$strAction) {

		parent::__construct();

		$this->strErrorMessage = "";
		$this->strTableName = 'pages';
		$this->strTableSlug = $strPageId;
		$this->strTitle = 'Pages CMS';
		$this->strDateCreated = date('Y-m-d H:i:s');
		$this->strDateModified = date('Y-m-d H:i:s');

        $this->strUploadsDir = ROOT_DIR.'/application/uploads/pages/'.date('Y').'/';
        $this->strUploadsUrl = ROOT_URL.'/application/uploads/pages/'.date('Y').'/';

        $this->arrCategories = $this->getCategories();

	}





	public function handlePost($post,$id) {
		$this->intID = $id;
		$this->strTitle = isset($post['title']) ? $post['title'] : '';
		$this->intNavOrder = isset($post['nav_order']) ? $post['nav_order'] : '0';
		$this->strSlug = isset($post['slug']) ? $post['slug'] : '';
		$this->strContent = isset($post['content']) ? $post['content'] : '';
        $this->strStatus = isset($post['status']) ? $post['status'] : '';
        $this->intCategory = isset($post['category']) ? $post['category'] : 'Null';

        $this->strFocusKeyword = isset($post['focus_keyword']) ? $post['focus_keyword'] : '';
		$this->strMetaTitle = isset($post['meta_title']) ? $post['meta_title'] : '';
		$this->strMetaKeywords = isset($post['meta_keywords']) ? $post['meta_keywords'] : '';
        $this->strMetaDescription = isset($post['meta_description']) ? $post['meta_description'] : '';
        $this->strMetaRobots = isset($post['meta_robots']) ? $post['meta_robots'] : "index,follow";
        $this->intScoreSEO = isset($post['score_seo']) ? $post['score_seo'] : '';

		$this->strFacebookTitle = isset($post['facebook_title']) ? $post['facebook_title'] : '';
		$this->strFacebookDescription = isset($post['facebook_description']) ? $post['facebook_description'] : '';
		$this->strTwitterTitle = isset($post['twitter_title']) ? $post['twitter_title'] : '';
		$this->strTwitterDescription = isset($post['twitter_description']) ? $post['twitter_description'] : '';
		$this->strGoogleDescription = isset($post['google_description']) ? $post['google_description'] : '';
		$this->blnShowFeatured = isset($post['bln_show_featured']) ? $post['bln_show_featured'] : '';

        $this->arrFilesToDelete = isset($post['files_to_delete']) ? $post['files_to_delete'] : '';

        $this->strVideoEmbed = isset($post['video_embed']) ? $post['video_embed'] : '';
        $this->strVideoSmallHeading = isset($post['video_smallheading']) ? $post['video_smallheading'] : '';
        $this->strVideoLargeHeading= isset($post['video_largeheading']) ? $post['video_largeheading'] : '';
        $this->strVideoText = isset($post['video_text']) ? $post['video_text'] : '';
        $this->strVideoBtnText = isset($post['video_buttontext']) ? $post['video_buttontext'] : '';
        $this->strVideoLink = isset($post['video_link']) ? $post['video_link'] : '';

        // Required Fields
		if($this->strTitle == '') { $this->strErrorMessage .= "Please enter a title for this page.<br />"; }
		if($this->strSlug == '' && $this->strTitle != '') { $this->strSlug = $this->strTitle; }
        $this->strSlug = Util::cleanForUrl($this->strSlug);

		$slug_exists = $this->validSlug('pages', $this->strSlug, $id);
		if(!empty($slug_exists)){
			$this->strErrorMessage .= "Page with this slug already exists.<br />";
		}


		if($this->strErrorMessage == '') {

			$keys = array(
                'title',
                'content',
                'cat_id',
                'slug',
                'nav_order',
                'focus_keyword',
                'meta_title',
                'meta_keywords',
                'meta_description',
                'meta_robots',
                'score_seo',
                'status',
                'date_modified',
                'facebook_title',
                'facebook_description',
                'twitter_title',
                'twitter_description',
                'bln_show_featured',
                'google_description',
                'video_embed',
                'video_smallheading',
                'video_largeheading',
                'video_text',
                'video_buttontext',
                'video_link'
            );
			$vals = array(
                $this->strTitle,
                $this->strContent,
                $this->intCategory,
                $this->strSlug,
                $this->intNavOrder,
                $this->strFocusKeyword,
                $this->strMetaTitle,
                $this->strMetaKeywords,
                $this->strMetaDescription,
                $this->strMetaRobots,
                $this->intScoreSEO,
				$this->strStatus,
                Date('Y-m-d H:i:s'),
                $this->strFacebookTitle,
                $this->strFacebookDescription,
                $this->strTwitterTitle,
                $this->strTwitterDescription,
                $this->blnShowFeatured,
                $this->strGoogleDescription,
                $this->strVideoEmbed,
                $this->strVideoSmallHeading,
                $this->strVideoLargeHeading,
                $this->strVideoText,
                $this->strVideoBtnText,
                $this->strVideoLink
            );
			//$types = array('ssissssssssssss');

			if($this->intID == '') {
				// No ability to add categories is required.
				$this->strErrorMessage = $this->mysqliinsert($this->strTableName,$keys,$vals,'');
				$this->intID = $this->insert_id;
				$this->strSuccessMessage = 'Record Added:'.$this->intID;
			} else {
				$this->strErrorMessage = $this->mysqliupdate($this->strTableName,$keys,$vals,'',$id);
				$this->strSuccessMessage = 'Record Saved';
			}

			// Delete any files that were checked for deletion
            if (!empty($this->arrFilesToDelete)) {
                foreach ($this->arrFilesToDelete as $strFieldName => $strFilePath) {
                    if (Util::deleteFile($strFilePath)) {
                        $this->strQuery = "UPDATE $this->strTableName SET `$strFieldName` = NULL WHERE `id` = $this->intID";
                        $this->short_query($this->strQuery);
                    }
                }
            }

            if($_FILES['display_image']['error'] != 4) {
                // Upload our display image
                $arrUploaded = Util::uploadFile(
                    $_FILES['display_image'],
                    $this->strUploadsDir,
                    $this->intID.'_display_image',
                    array('image/*')
                );
                if ($arrUploaded) {
                    // If the file uploaded successfully
                    $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
                    $fileName = $url.$arrUploaded['file'];

                    $this->strQuery = 'UPDATE '.$this->strTableName.' SET `display_image` = \''.$fileName.'\' WHERE id=' . $this->intID;
                    if($this->short_query($this->strQuery)) {
                        $this->strSuccessMessage .= '<br> Display Image Updated';
                    } else {
                        $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
                    }
                }
            }


			if($_FILES['facebook_image']['error'] != 4) {
	            // Upload our Facebook image
	            $arrUploaded = Util::uploadFile(
	                $_FILES['facebook_image'],
	                $this->strUploadsDir,
	                $this->intID.'_facebook',
	                array('image/*')
	            );
	            if ($arrUploaded) {
	                // If the file uploaded successfully
	                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
	                $fileName = $url.$arrUploaded['file'];

	                $this->strQuery = 'UPDATE '.$this->strTableName.' SET `facebook_image` = \''.$fileName.'\' WHERE id=' . $this->intID;
	                if($this->short_query($this->strQuery)) {
	                    $this->strSuccessMessage .= '<br> Facebook Image Updated';
	                } else {
	                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
	                }
	            }
	        }


	        if($_FILES['twitter_image']['error'] != 4) {
	            // Upload our twitter image
	            $arrUploaded = Util::uploadFile(
	                $_FILES['twitter_image'],
	                $this->strUploadsDir,
	                $this->intID.'_twitter',
	                array('image/*')
	            );

	            if ($arrUploaded) {
	                // If the file uploaded successfully
	                $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
	                $fileName = $url.$arrUploaded['file'];

	                $this->strQuery = 'UPDATE '.$this->strTableName.' SET `twitter_image` = \''.$fileName.'\' WHERE id=' . $this->intID;
	                if($this->short_query($this->strQuery)) {
	                    $this->strSuccessMessage .= '<br> Twitter Image Updated';
	                } else {
	                    $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
	                }
	            }
	        }

            return $this->intID;

		}



	}

    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            if(empty($action)){
                $action = 'view';
            }
            $userID = $_SESSION['userID']; 
            $query = "SELECT 
                    p.can_add, p.can_edit, p.can_delete ,p.can_view 
                FROM 
                    permissions p 
                INNER JOIN 
                    modules m 
                ON 
                    p.moduleID = m.moduleID 
                WHERE 
                    p.userID = '$userID' 
                    AND m.module_name = '$moduleName'";
            $result = $this->getMysqliResults($query, true);
            if (!empty($result)) {
                
                $permissions = $result[0];
                if ($action === null) {
                    return true;
                }
                if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                    return true;
                }else{
                    return false;
                }
                
            }
            return false;
            
        }
        
	}

	public function getDetail($id) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT *
		From $this->strTableName
		WHERE id=$id
		LIMIT 0,1";





		if($this->query($this->strQuery)) {

	     	$result = $this->getMysqliResults($this->strQuery,true);
            $result = $result[0];

			$this->strTitle = isset($result['title']) ? $result['title'] : '';
			$this->strSlug = isset($result['slug']) ? $result['slug'] : '';
			$this->strContent = isset($result['content']) ? $result['content'] : '';
            $this->strDisplayImage = isset($result['display_image']) ? $result['display_image'] : '';
	        $this->strStatus = isset($result['status']) ? $result['status'] : '';
	        $this->intNavOrder = isset($result['nav_order']) ? $result['nav_order'] : '0';

	        $this->strDateCreated = isset($result['date_created']) ? $result['date_created'] : Date('Y-m-d');
			$this->strDateModified = isset($result['date_modified']) ? $result['date_modified'] :  Date('Y-m-d');
			$this->blnShowFeatured = isset($result['bln_show_featured']) ? $result['bln_show_featured'] : '';

            $this->strFocusKeyword = isset($result['focus_keyword']) ? $result['focus_keyword'] : '';
			$this->strMetaTitle = isset($result['meta_title']) ? $result['meta_title'] : '';
			$this->strMetaKeywords = isset($result['meta_keywords']) ? $result['meta_keywords'] : '';
	        $this->strMetaDescription = isset($result['meta_description']) ? $result['meta_description'] : '';
	        $this->strMetaRobots = isset($result['meta_robots']) ? $result['meta_robots'] : "index,follow";

			$this->strFacebookTitle = isset($result['facebook_title']) ? $result['facebook_title'] : '';
			$this->strFacebookDescription = isset($result['facebook_description']) ? $result['facebook_description'] : '';
			$this->strFacebookImage = isset($result['facebook_image']) ? $result['facebook_image'] : '';
			$this->strTwitterTitle = isset($result['twitter_title']) ? $result['twitter_title'] : '';
			$this->strTwitterDescription = isset($result['twitter_description']) ? $result['twitter_description'] : '';
			$this->strTwitterImage = isset($result['twitter_image']) ? $result['twitter_image'] : '';
			$this->strGoogleDescription = isset($result['google_description']) ? $result['google_description'] : '';
			$this->intCategory = isset($result['cat_id']) ? $result['cat_id'] : 'Null';
			$this->blnLockSlug = $result['blnLockSlug'];

            // Score the SEO content of the page
            if (class_exists('SEO_Scorer')) {
                $objScore = new SEO_Scorer(array(
                    'keyword' => $this->strFocusKeyword,
                    'meta_title' => $this->strMetaTitle,
                    'meta_description' => $this->strMetaDescription,
                    'meta_robots' => $this->strMetaRobots,
                    'content' => $this->strContent,
                    'url' => $this->strSlug
                ));
                $this->arrScore = $objScore->getScore();
            }

            $this->strVideoEmbed = isset($result['video_embed']) ? $result['video_embed'] : '';
            $this->strVideoSmallHeading = isset($result['video_smallheading']) ? $result['video_smallheading'] : '';
            $this->strVideoLargeHeading= isset($result['video_largeheading']) ? $result['video_largeheading'] : '';
            $this->strVideoText = isset($result['video_text']) ? $result['video_text'] : '';
            $this->strVideoBtnText = isset($result['video_buttontext']) ? $result['video_buttontext'] : '';
            $this->strVideoLink = isset($result['video_link']) ? $result['video_link'] : '';

			return $result;

	    } else {
	     	return null;
	    }
	}



	public function getList($pgSize,$pg,$sortBy,$sortOrder,$searchWord, $status = 'Active', $dates, $cats, $debug = false) {


		$this->pgSize = $pgSize;
		$this->pg = ($pg > 0 ? $pg : 1);


		$this->strQuery1 = "SELECT count(t.`id`) as records
	    FROM $this->strTableName t WHERE id>0 ";
	    if($status != 'all') {
            if($status == ''){ $status = 'Active'; } 
	   	 	$this->strQuery1 .= "AND status='$status' ";
	    }

	    if($searchWord != ''){
	    	$this->strQuery1 .= "AND (t.title like '%$searchWord%' )";
	    }

	    $result = $this->getMysqliResults($this->strQuery1,true);
	    $this->records = $result[0]['records'];
	    $this->intPageCount = ceil($result[0]['records']/$this->pgSize);

		$this->pg = ($this->pg <= $this->intPageCount ? $this->pg : $this->intPageCount);
		$start = (($this->pg*$this->pgSize)-$this->pgSize);
		if($start<0) $start = 0;


	     $this->strQuery = "SELECT t.*, c.cat_name
	     from $this->strTableName t
	     LEFT JOIN page_categories c on c.id=t.cat_id
	     WHERE t.id>0 ";

	     if($status != 'all') {
	   	 	$this->strQuery .= "AND t.status='$status' ";
	     }

	     if($searchWord != ''){
		    $this->strQuery .= "AND (t.title like '%$searchWord%' )";
		 }
		 if($sortBy != '') $this->strQuery .= " ORDER BY $sortBy $sortOrder ";

	     $this->strQuery .= " LIMIT $start,$pgSize ";

		 if($debug) {
		 	Util::debugDisplay($this->strQuery);
		 }

	     if($this->query($this->strQuery)) {
	     	return $this->getMysqliResults($this->strQuery,true);
	     } else {
	     	return null;
	     }
	}


	public function getPageCount($type = '') {

		$strQuery = "SELECT count(*) As c
		from $this->strTableName t ";

		if($type != '') $strQuery .= "WHERE status='$type'";
		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res[0]['c'];
	    } else {
	    	return 0;
	    }

	}


	public function getCategories() {

		$strQuery = "SELECT *
		FROM page_categories t
		WHERE status='Active'";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}



	public function getPageImageList($page_id,$debug = false) {


		$strQuery = "SELECT *
		FROM page_img where page_id=$page_id AND status = 'Active'";

		if($debug) {
		 	Util::debugDisplay($strQuery);
		 }

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }

	}



	public function updateStatus($id,$status) {

		$this->strQuery = 'UPDATE '.$this->strTableName.' SET status = \'' . $status . '\', date_modified=\'' . Date('Y-m-d H:i:s') . '\' WHERE id in (' . $id . ')';
		if($this->short_query($this->strQuery)) {
			$this->strSuccessMessage = 'Record Saved (' . $status . ')';
		} else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}

	}


	public function deleteRecord($id) {
        $this->strQuery = 'SELECT facebook_image, twitter_image, display_image FROM '.$this->strTableName.' WHERE id=' . $id;

		// Delete images
        if($this->query($this->strQuery)) {
            $results = $this->getMysqliResults($this->strQuery,true);
            if (!empty($results)) {
                $results = $results[0];
                foreach($results AS $fileName) {
                    Util::deleteFile($fileName);
                }
            }
        }

	    $this->strQuery = 'DELETE FROM '.$this->strTableName.' WHERE id=' . $id;
	    if($this->short_query($this->strQuery)) {
	    	$this->strSuccessMessage = 'Record Deleted';
	    } else {
			$this->strErrorMessage = 'SQL error:'.$this->strQuery;
		}
	}

}



?>