jQuery(document).ready(function($) {


    /*  General Animations + plugins
        ========================================================================== */

    // Add jQuery Date Pickers to fields
    $('.datepicker').attr('autocomplete', 'off').datepicker({
        dateFormat: 'yy-mm-dd',
    });

    $('.datepicker-future').attr('autocomplete', 'off').datepicker({
        dateFormat: 'yy-mm-dd',
        minDate: 0,
    });

    // Animate the header contact form
    $('#slide-out .trigger').on('click', function(event) {
        event.preventDefault();

        var parent = $(this).parents('#slide-out');
        var width = parent.css('width');
        var position = parent.css('right');
        var icon = $(this).find('.fa');

        if (position == '0px') {
            // Hide the slide-out
            parent.animate({
                right: '-'+width
            }, 400, function() {
                // Change the icon
                icon.removeClass('fa-angle-down').addClass('fa-angle-up');
            });
        } else {
            // Show the slide-out
            parent.animate({
                right: '0px'
            }, 400, function() {
                // Change the icon
                icon.removeClass('fa-angle-up').addClass('fa-angle-down');
            });
        }
    });

    $('.partner_step_submit').on('click', function(e) {
        console.log('clickstep');
        console.log($(this).attr('js-step'));
        $('#goto_step').val($(this).attr('js-step'));
    });

    // Partner Form Submit Controls
    $('#partner_form').on('submit', function(e) {

        if ($('#goto_step').val() != '') {
            e.preventDefault();

            if (check_form()) {
                var strAction = $(this).attr('action');
                $(this).attr('action', strAction + $('#goto_step').val() + '/');
                var curStep = $('#step').val();
                console.log(curStep);
                console.log($(this).attr('action'));
                console.log('woo');
                $('#goto_step').val('');
                $('#partner_form').submit();
            }
        }
    });

    // Facebook style show more text
    $('.text-expand .trigger').on('click', function(event) {
        event.preventDefault();
        $(this).hide();
        $(this).parent('.text-expand').find('.text-hidden').show();
    });

    // Video gallery change iframe src
    $('.video-gallery .thumbnail').click(function() {
        var video_id = $(this).data('video');
        var caption = $(this).data('caption');
        $('.video-gallery .large-video iframe').attr('src', 'https://youtube.com/embed/'+video_id);
        $('.video-gallery .large-video h3').html(caption);
        $('.video-gallery .large-video').slideDown();
    });

    // Panel animations
    var allPanels = $('.accordion > dd').hide();
    $('.first_pane').show();
    $('.accordion > dt > a').click(function() {
        allPanels.slideUp();
        $(this).parent().next().slideDown();
        return false;
    })  ;





    /*  Ajax Calls
        ========================================================================== */

    var url = "/application/ajax.php";

    $('#slide-out form').submit(function(event) {
        event.preventDefault();
        var objForm = $(this);
        var objBtn = objForm.find('.btn');

        // Disable the button + change the text inside
        objBtn.addClass('disabled');
        objBtn.html('Sending <span class="fa fa-refresh fa-spin"></span>');

        $.ajax({
            type: 'POST',
            url: url,
            data: {
                action: 'quickContact',
                values: objForm.serialize()
            }
        }).done(function(response) {
            response = $.parseJSON(response);
            var alert = objForm.find('.alert');

            if (typeof(response.success) !== 'undefined' && response.success) {
                alert.removeClass('hidden alert-danger').addClass('alert-success');
                alert.html(response.message);
                objForm[0].reset(); // Clear the form values
            } else {
                alert.removeClass('hidden alert-success').addClass('alert-danger');
                alert.html(response.message);
            }

            // Enable the send button again and change the text back
            objBtn.removeClass('disabled');
            objBtn.html('Book Now');
        });
    });


    $("#country").change(function () {
        $("#state, #city").find("option:gt(0)").remove();
        $("#city").find("option:first").text("Please Choose");
        $("#city").find("option:first").attr("value", "");
        $("#state").find("option:first").text("Loading...");
        $.getJSON("/application/ajax.php", {
            country: $(this).val(),
            action: 'getProvs'
        }, function (json) {
            $("#state").find("option:first").text("Please Choose");
            $("#state").find("option:first").attr("value", 0);

            for (var i = 0; i < json.length; i++) {
                console.log(json[i].id);
                $("<option/>").attr("value", json[i].id).text(json[i].state_name).appendTo($("#state"));
            }
        });
    });

    $("#state").change(function () {
        $("#city").find("option:gt(0)").remove();
        $("#city").find("option:first").text("Loading...");
        $.getJSON("/application/ajax.php", {
            prov: $(this).val(),
            action: 'getCities'
        }, function (json) {

            $("#city").find("option:first").text("Please Choose");
            $("#city").find("option:first").attr("value", 0);

            for (var i = 0; i < json.length; i++) {
                $("<option/>").attr("value", json[i].id).text(json[i].title).appendTo($("#city"));
            }
        });
    });


    $(".course-box").change(function () {

        var allVals = "[{";

        $('#course_list :checked').each(function() {
           allVals += '"id":"' + $(this).val() + '"},{';
        });
        allVals = allVals.rtrim(',{');
        allVals += "]";
        console.log(allVals);

        var json = JSON.stringify(allVals);
        $("#selected_courses").val(json);
        //console.log("/application/ajax.php?action=courseDisplay&courses=" + json);

        var jqxhr = $.ajax({
            url: "/application/ajax.php",
            type: "POST",
            data: {
                action: "courseDisplay",
                courses: allVals
            },
        }).done(function( data ) {
            //console.log( "success:" + data );
            $('#selected-courses').html(data);

        }).fail(function(jqXHR, textStatus) {
            console.log( "error:"+ textStatus );
        });

    });


    $(".hotel-box").change(function () {

        var allVals = "[{";

        $('#hotel_list :checked').each(function() {
           allVals += '"id":"' + $(this).val() + '"},{';
        });
        allVals = allVals.rtrim(',{');
        allVals += "]";

        var json = JSON.stringify(allVals);
        // console.log("/application/ajax.php?action=hotelDisplay&hotels=" + json);

        var jqxhr = $.ajax({
            url: "/application/ajax.php",
            type: "POST",
            data: {
                action: "hotelDisplay",
                hotels: allVals
            },
        }).done(function( data ) {
            //console.log( "success:" + data );
            $('#selected-hotels').html(data);

        }).fail(function(jqXHR, textStatus) {
            console.log( "error:"+ textStatus );
        });

    });


   $('#country_id_search').change(function() {

        //console.log('country_id_search');
        ///application/ajax.php?action=getRegionsForCountry&country=149
        $("#region").find("option:gt(0)").remove();
        //$("#region").find("option:first").text("Please Choose");
        //$("#city").find("option:first").attr("value", "");
        $("#region").find("option:first").text("Loading...");
        $.getJSON("/application/ajax.php", {
            country: $(this).val(),
            action: 'getRegionsForCountry'
        }, function (json) {
            $("#region").find("option:first").text("Please Choose");
            $("#region").find("option:first").attr("value", 0);

            for (var i = 0; i < json.length; i++) {
                //console.log(json[i].id);
                $("<option/>").attr("value", json[i].id).text(json[i].region_name).appendTo($("#region"));
            }
        });
   });

    // Trigger pagination change
    $('.course-filters [data-page]').on('click', function(event) {
        event.preventDefault();

        // Set the pages
        var intPage = $(this).data('page');
        var intPrev = parseInt(intPage - 1);
        var intNext = parseInt(intPage + 1);
        var intPages = $('#course-pages').html();

        // Exit if 0
        if (intPage == 0 || intPage > intPages) return;

        // Set values
        $('.course-prev').attr('data-page', intPrev).data('page', intPrev);
        $('.course-next').attr('data-page', intNext).data('page', intNext);
        $('#course-page').val(intPage).trigger('change');
    });

    // Get new results based off the filters
    $('.course-filters :input').on('change keyup', throttle(function(event) {
        event.preventDefault();

        // Set the data
        var objData = {
            action: 'filterCourses',
            data: $(this).closest('form').serialize(),
        };

        // Show the spinner
        $('.course-loading').addClass('active');
        $('.course-error').html('');

        $.getJSON(url, objData, function(objResponse) {
            // Hide the spinner
            $('.course-loading').removeClass('active');

            // Set the error message
            if (typeof objResponse.error !== 'undefined' && objResponse.error) {
                $('.course-results').html(objResponse.message);
                return;
            }

            // Set the HTML
            if (typeof objResponse.html !== 'undefined' && objResponse.html) {
                $('.course-results').html(objResponse.html);
            }
            if (typeof objResponse.pages !== 'undefined' && objResponse.pages) {
                $('#course-page').html(objResponse.page);
                $('#course-pages').html(objResponse.pages);
                $('#course-next').attr('data-page', parseInt(objResponse.page + 1));
                $('#course-prev').attr('data-page', parseInt(objResponse.page - 1));
            }
        });
    }, 125));

    // Load results when the page is first loaded
    $('.course-filters :input').trigger('change');

    // Function to throtle the AJAX calls
    function throttle(fnFunction, intInterval) {
        var intLastCall = 0;
        return function() {
            var now = Date.now();
            if (intLastCall + intInterval < now) {
                intLastCall = now;
                return fnFunction.apply(this, arguments);
            }
        };
    }

});

String.prototype.rtrim = function(s) {
    return this.replace(new RegExp(s + "*$"),'');
};


function check_feature_form() {

    var dates_arrival = $('#dates_arrival').val();
    var dates_depart = $('#dates_depart').val();
    console.log(dates_arrival);
    console.log(dates_depart);
    if (dates_arrival == ''){
        alert('Please select arrival date') ;
        return false;
    }
    if (dates_depart == ''){
        alert('Please select departure date') ;
        return false;
    }

    return true;
}

function check_user_form() {

    var user_name = $('#user_name').val();
    var user_email = $('#user_email').val();
    ///console.log(dates_arrival);
   /// console.log(dates_depart);
    if (user_name == ''){
        alert('Please enter your name') ;
        return false;
    }
    if (user_email == ''){
        alert('Please enter your email address') ;
        return false;
    }

    return true;
}

function check_form() {
    if (!validateCheck()){
        alert('Please select at least one location.') ;
        return false;
    }
    return true;
}

function validateCheck() {
    // Set variables
    var objCourses = document.getElementsByClassName('course-box');
    var objHotels  = document.getElementsByClassName('hotel-box');

    // See if there's a checked course
    if (typeof objCourses !== 'undefined' && objCourses.length > 0) {
        for (i=0; i<objCourses.length; i++) {
            if (objCourses[i].checked) return true;
        }
        return false;
    }

    // See if there's a checked hotel
    if (typeof objHotels !== 'undefined' && objHotels.length > 0) {
        for (i=0; i<objHotels.length; i++) {
            if (objHotels[i].checked) return true;
        }
        return false;
    }

    // No fields defined
    if (objCourses.length == 0 && objHotels.length == 0) {
        return true;
    }

    return false;
}

function checkEmailAddress(field) {
    var goodEmail = field.value.match(/\b(^(\S+@).+((\.com)|(\.net)|(\.edu)|(\.mil)|(\.ca)|(\.gov)|(\.org)|(\..{2,2}))$)\b/gi);
    if (goodEmail) return true;
    alert('Enter a valid e-mail address.')
    field.focus()
    field.select()
    return false;
}

function mailThisUrl(){
    if (checkEmailAddress(document.email_page.sendaddress))
        window.location = "mailto:"+document.email_page.sendaddress.value+"?subject=This golf web page and site may interest you.&body="+document.title+" "+window.location;
}

$.fn.serializeObject = function()
{
    var o = {};
    var a = this.serializeArray();
    $.each(a, function() {
        if (o[this.name] !== undefined) {
            if (!o[this.name].push) {
                o[this.name] = [o[this.name]];
            }
            o[this.name].push(this.value || '');
        } else {
            o[this.name] = this.value || '';
        }
    });
    return o;
};