function validateEmail(email) 
{
    var re = /\S+@\S+\.\S+/;
    return re.test(email);
}


jQuery(document).ready(function($) {


	$('.help-button').click(function() {
		$( "#dialog" ).dialog({
		  width: 500
		});
	});


	$('.help-button-submit').click(function() {
		
		var help_name = $('#help_name').val();
		var help_email = $('#help_email').val();
		var help_phone = $('#help_phone').val();
		var help_comment = $('#help_comment').val();
		var session = $('#session').val();

		var error = '';

		if(help_name == '') {
			error = 'Please enter your name';
		}

		if(!validateEmail(help_email)) {
			error = 'Please enter a valid email';
		}

		if(help_phone == '') {
			error = 'Please enter your phone number';
		}

		if(help_comment == '') {
			error = 'Please enter your comment';
		}

		if(error == ''){

			$.getJSON("/application/ajax.php", {
	            help_name: help_name,
	            help_email: help_email,
	            help_phone: help_phone,
	            help_comment: help_comment,
	            session: session, 
	            action: 'helpRequest'
	        }, function (json) {
	        	console.log(json);

	        	$( "#dialog" ).dialog( "close" );


	        });
	        
			alert('Email sent');

		} else{
			alert(error);
		}





	});

	$( "#email" ).blur(function() {
	  if($( "#email" ).val() != ''){
		$.post('/application/ajax.php', {
			action: "lookupMember",
			email: $( "#email" ).val()
		}, function(data) {

			if(data){
				//user exists
				$( "#check_result").html("User found!");
				$( "#first_name").val(data.first_name);
				$( "#last_name").val(data.last_name);
				$( "#first_name").val(data.first_name);

				if (data.phone) {
					var ph = data.phone.split('-');
					$('#first_block').val(ph[0]);
					$('#second_block').val(ph[1]);
					$('#third_block').val(ph[2]);
					$('#phone_number').val(data.phone);
				}
				if (data.cell) {
					var ph = data.cell.split('-');
					$('#first_block_2').val(ph[0]);
					$('#second_block_2').val(ph[1]);
					$('#third_block_2').val(ph[2]);
					$('#cell').val(data.cell);
				}
				if (data.fax) {
					var ph = data.fax.split('-');
					$('#first_block_3').val(ph[0]);
					$('#second_block_3').val(ph[1]);
					$('#third_block_3').val(ph[2]);
					$('#fax').val(data.fax);
				}
				if (data.enable_txt) {
					$("#enable_txt").prop( "checked", true );
				}
				if (data.provider) {
					$('#provider').val(data.provider);
				}
				if (data.postal_code) {
					$('#postal_code').val(data.postal_code);
				}
				if (data.address) {
					$('#address').val(data.address);
				}

				// Ajax Options
				if (data.country_id) {
					getProvinceOptions(data.country_id, function() {
						// Set the values
						$('#country').val(data.country_id);
						$('#state').val(data.state_id);
						$('#city').val(data.city_id);
					});
				}
				if (data.state_id) {
					getCityOptions(data.state_id, function() {
						// Set the values
						$('#state').val(data.state_id);
						$('#city').val(data.city_id);
					});
				}
				if (data.city_id) {
					$('#city').val(data.city_id);
				}

				if (data.id) {
					$('#id').val(data.id);
				}
			} else {
				//user not found
				$( "#check_result").html("New User");
			}

		}, "json");

	  }
	});


	$('#country').change(function() {
		var id = $(this).val();
		getProvinceOptions(id);
	});

	$('#state').change(function() {
		var id = $(this).val();
		getCityOptions(id);
	});

    $('#people_name_ddl').change(function(){
    	var pn = $('#people_name_ddl').find("option:selected").attr("data");

        if( pn != '') {
        	var arr = pn.split('|');
        	fn = arr[0];
        	ln = arr[1];

            $('#hiddeninfo').slideDown();
        	$('#first_name').val(fn);
       		$('#last_name').val(ln);

        } else {
            $('#hiddeninfo').slideUp();
        }

    });


    function getProvinceOptions(id, callback) {
		// Call ajax to get provinces / states
		$.getJSON("/application/ajax.php", {
            country: id,
            action: 'getProvs'
        }, function (json) {
        	var strOptions = '<option value="0">Please Choose</option>';
            for (var i = 0; i < json.length; i++) {
                strOptions += '<option value="'+json[i].id+'">'+json[i].state_name+'</option>';
            }
            $('#state').html(strOptions);

            if (typeof(callback) != 'undefined') {
            	callback();
            }
        });
	}

	function getCityOptions(id, callback) {
		// Call ajax to get provinces / states
		$.getJSON("/application/ajax.php", {
	        prov: id,
	        action: 'getCities'
	    }, function (json) {
	    	var strOptions = '<option value="0">Please Choose</option>';
	        for (var i = 0; i < json.length; i++) {
                strOptions += '<option value="'+json[i].id+'">'+json[i].title+'</option>';
	        }
	        $('#city').html(strOptions);

            if (typeof(callback) != 'undefined') {
            	callback();
            }
    	});
	}


});


$(function(){

	$('#first_block,#second_block,#third_block').change(function(){

		var nr = $('#first_block').val()+'-'+$('#second_block').val()+'-'+$('#third_block').val();
		$('#phone_number').val(nr);
	});

	if ($('#phone_number').val()) {
		var ph = $('#phone_number').val().split('-');
		$('#first_block').val(ph[0]);
		$('#second_block').val(ph[1]);
		$('#third_block').val(ph[2]);
	}
});


$(function(){

	$('#first_block_2,#second_block_2,#third_block_2').change(function(){

		var nr = $('#first_block_2').val()+'-'+$('#second_block_2').val()+'-'+$('#third_block_2').val();
		$('#cell').val(nr);
	});

	if ($('#cell').val()) {
		var ph = $('#cell' ).val().split('-');
		$('#first_block_2').val(ph[0]);
		$('#second_block_2').val(ph[1]);
		$('#third_block_2' ).val(ph[2]);
	}
});

$(function(){
	$('#first_block_3,#second_block_3,#third_block_3').change(function(){
		var nr = $('#first_block_3').val()+'-'+$('#second_block_3').val()+'-'+$('#third_block_3').val();
		$('#fax').val(nr);
	});

	if ($('#fax').val()) {
		var ph = $('#fax' ).val().split('-');
		$('#first_block_3').val(ph[0]);
		$('#second_block_3').val(ph[1]);
		$('#third_block_3' ).val(ph[2]);
	}
});


$(function(){
	$('#cc_number_1,#cc_number_2,#cc_number_3,#cc_number_4').change(function(){

		var nr = $('#cc_number_1').val()+'-'+$('#cc_number_2').val()+'-'+$('#cc_number_3').val()+'-'+$('#cc_number_4').val();
		$('#cc_number').val(nr);
	});

	if ($('#cc_number').val()) {
		var ph = $('#cc_number' ).val().split('-');
		$('#cc_number_1').val(ph[0]);
		$('#cc_number_2').val(ph[1]);
		$('#cc_number_3' ).val(ph[2]);
		$('#cc_number_4' ).val(ph[3]);
	}



});

function checkSubmit() {
	// if($("#payment_terms_accepted").is(":checked") && $("#waived").is(":checked")) {
	if($("#payment_terms_accepted").is(":checked")) {
		document.getElementById('submitbutton').style.display = '';
	} else
		document.getElementById('submitbutton').style.display = 'none';
}


function UpdateTotal() {

	var total = 0;
	$(".make_payment").each(function(e) {
		if($.trim($(this).val()) != "") total += Number($.trim($(this).val()));
	});

	$("#make_payment_total").val(total);
	$("#make_payment_total_hidden").val(total);

}

function ForceNumber(obj, max) {
    obj.value = obj.value.replace(/[^0-9]/, "");

    if(parseInt(obj.value) > max) obj.value = max;
    else if(parseInt(obj.value) < 0) obj.value = 0;

    obj.focus();

    UpdateTotal();
}
