


function nav_listing_setupMarker(marker, map, mapHolder){
	google.maps.event.addListener(marker, 'dragend', function(evt){


		//console.log(map.getZoom());

		jQuery('#latitude').val(evt.latLng.lat().toFixed(5));
		jQuery('#longitude').val(evt.latLng.lng().toFixed(5));

		/*
		mapHolder.closest('.cuztom-gmap-wrap').find('input[type=hidden]').val(JSON.stringify({
			"lat": evt.latLng.lat().toFixed(5),
			"lng": evt.latLng.lng().toFixed(5),
			"zoom": map.getZoom()
		}));

		mapHolder.attr('data-lat', evt.latLng.lat().toFixed(5)).attr('data-lng', evt.latLng.lng().toFixed(5));
		*/


	});
}

function nav_listing_handleNoGeolocation(map) {
	map.setCenter(new google.maps.LatLng(60, 105));
}


function nav_listing_codeAddress(map, address, marker, mapHolder) {
	var geocoder = new google.maps.Geocoder();

	//console.log('nav_listing_codeAddress='+address);
	//console.log(marker);

	geocoder.geocode( { 'address': address}, function(results, status) {
		if (status == google.maps.GeocoderStatus.OK) {

			//var bounds = new google.maps.LatLngBounds();

			var newLatLng = results[0].geometry.location;
			map.panTo(newLatLng);
			marker.setPosition(newLatLng)

			//bounds.extend(newLatLng);
			//map.fitBounds(bounds);

			//setLocation(bounds);
			console.log(results);

			//console.log('setting lat to:'+results[0].geometry.location.lat());
			//console.log('setting long to:'+results[0].geometry.location.lng());

			// Save the results
			jQuery('#latitude').val(results[0].geometry.location.lat());
			jQuery('#longitude').val(results[0].geometry.location.lng());

		} else {
			if(status == 'ZERO_RESULTS'){
				alert("We are unable to find the location of that address. Try dragging the marker to the location.");
			}
			else{
				alert("Geocode was not successful for the following reason: " + status);
			}
		}
	});
}





jQuery(document).ready(function($) {

	$('#mm_view_update_list').click(function() {

        $.getJSON("/application/ajax.php", {
            action: 'mass_mail_email_list',
            data: $('#mass-mailer-form').serializeArray(),
            mailtype: $("ul.nav-tabs li.active a").html(),
        }, function (objReturn) {
            var strHTML = '';
            $(".email-list-preview").html(strHTML);
            if (objReturn === null) {
                $(".email-list-preview").html('No Results Found');
                $("#send_test_email").prop('disabled', true);
                $("#send_emails_go").prop('disabled', true);
            } else {
                $("#send_test_email").prop('disabled', false);
                $("#send_emails_go").prop('disabled', false);
                for(var i = 0; i < objReturn.length; i++) {

                    if ($("ul.nav-tabs li.active a").html() == 'Packages Mailer') {
                        strHTML += "<a target='_blank' href='/admin/package/edit/"+objReturn[i]['id']+"/'>"+objReturn[i]['group_name']+" "+objReturn[i]['user_email']+"</a><br />";
                    } else {
                        strHTML += "<a target='_blank' href='/admin/quote/"+objReturn[i]['quote_group_id']+"/edit/"+objReturn[i]['id']+"'>"+objReturn[i]['group_name']+" "+objReturn[i]['user_email']+"</a><br />";
                    }
                }
                $(".email-list-preview").html(strHTML);
            }
        });
    });

    $('#send_test_email').click(function() {
         $.getJSON("/application/ajax.php", {
            action: 'mass_mail_email_test',
            data: $('#mass-mailer-form').serializeArray(),
            test_email: $("#test_email").val(),
            package_content: $("#package_content").val(),
            quote_content: $("#quote_email_content").val(),
            package_subject: $("#email_subject").val(),
            quote_subject: $("#quote_email_subject").val(),
            mailtype: $("ul.nav-tabs li.active a").html(),
        }, function (objReturn) {
            if (objReturn === null) {
                // fail
                alert('test email not sent');
            } else {
                // success
                //$(".email-list-preview").html(strHTML);
                alert('test email sent');
            }
        });
    });

    $('#send_emails_go').click(function() {

        $("#send_test_email").prop('disabled', true);
        $("#send_emails_go").prop('disabled', true);

         $.getJSON("/application/ajax.php", {
            action: 'mass_mail_email_go',
            data: $('#mass-mailer-form').serializeArray(),
            package_content: $("#package_content").val(),
            quote_content: $("#quote_email_content").val(),
            package_subject: $("#email_subject").val(),
            quote_subject: $("#quote_email_subject").val(),
            mailtype: $("ul.nav-tabs li.active a").html(),
        }, function (objReturn) {
            if (objReturn === null) {
                alert('Problem Sending List');

                $("#send_test_email").prop('disabled', false);
                $("#send_emails_go").prop('disabled', false);

            } else {
                // success
                var strHTML = '';
                //$("#send_test_email").prop('disabled', true);
                //$("#send_emails_go").prop('disabled', true);

                for(var i = 0; i < objReturn.length; i++) {
                    strHTML += objReturn[i]['email'] + " &nbsp; - &nbsp; " + objReturn[i]['sent'] + "<br />";
                }

                $(".email-list-preview").html(strHTML);
            }
        });
    });

    //$('.jHtmlArea iframe').webkitimageresize().webkittableresize().webkittdresize();

	// Collapse the menu
	$('.collapse-menu').on('click', function(event) {
		event.preventDefault();
		var objWrapper = $(this).parents('#wrapper');
		var objIcon = $(this).find('.fa');

		// Toggle the class + close any open submenus
		objWrapper.toggleClass('nav-hidden');
		$('.sub-nav.in').removeClass('in');

		// Switch the icon
		if (objIcon.hasClass('fa-chevron-circle-left')) {
			objIcon.removeClass('fa-chevron-circle-left').addClass('fa-chevron-circle-right');
		} else {
			objIcon.removeClass('fa-chevron-circle-right').addClass('fa-chevron-circle-left');
		}
	});

	$('body').delegate('#wrapper.nav-hidden .navbar-nav>li', 'click', function() {
		// Exit if its the toggle button
		if ($(this).hasClass('collapse-menu')) return false;

		// Remove the hidden class to show the navigation
		var objWrapper = $(this).parents('#wrapper');
		objWrapper.removeClass('nav-hidden');
	});

	function openQuickEdit(obj) {
		// Close existing rows that are open
		$('.quick-edit-content').addClass('hidden');
		$('.quick-edit-row-open').removeClass('quick-edit-row-open hidden');

		// Get the container tr
		var objRow = obj.parents('tr');

		if (objRow.hasClass('quick-edit-content')) {
			// close button clicked
			objRow.addClass('hidden');
			objRow.prev('tr').removeClass('hidden quick-edit-row-open');
		} else {
			// open button clicked
			objRow.addClass('hidden quick-edit-row-open');
			objRow.next('tr').removeClass('hidden');
		}
	}

	var newIdent = '';

	$('#report_course_payment_brand_id').change(function(){
		var slBrand = $(this);
		var slCourse = $("#course_id");

		// clear current list of courses
		slCourse.html('');

		// make first dropdown
		slCourse.append('<option value>-- Select Course --</option>');

		if(slBrand.find(':selected').val().length == 0){
			// if it's the "select" option don't load any courses
			return;
		}

		// make ajax call to get list of courses for this brand
		var objData = {
			action: 'getBrandCourses',
			brandId: slBrand.find(':selected').val()
		}

		$.getJSON('/application/ajax.php', objData, function(objReturn){
			if(objReturn.blnError === true){
				// error occured
				console.log('Unknown Error Occured: ' + objReturn.strMessage);
				alert('Unknown Error Occured: ' + objReturn.strMessage);
				return false;
			}

			if(objReturn.arrCourses.length == 0){
				// no courses found
				console.log('No courses found for brand with id: ' + objData.brandId);
				alert('No courses found for brand with id: ' + objData.brandId);
				return false;
			}

			// make dropdown for each course
			for(var intCourse = 0; intCourse < objReturn.arrCourses.length; intCourse++){
				slCourse.append('<option value="' + objReturn.arrCourses[intCourse].course_id + '">' + objReturn.arrCourses[intCourse].course_name + '</option>');
			}

			return true;
		});
	});

	$('#report_hotel_payment_brand_id').change(function(){
		var slBrand = $(this);
		var slCourse = $("#hotel_id");

		// clear current list of courses
		slCourse.html('');

		// make first dropdown
		slCourse.append('<option value>-- Select Hotel --</option>');

		if(slBrand.find(':selected').val().length == 0){
			// if it's the "select" option don't load any courses
			return;
		}

		// make ajax call to get list of courses for this brand
		var objData = {
			action: 'getBrandHotels',
			brandId: slBrand.find(':selected').val()
		}

		$.getJSON('/application/ajax.php', objData, function(objReturn){
			if(objReturn.blnError === true){
				// error occured
				console.log('Unknown Error Occured: ' + objReturn.strMessage);
				alert('Unknown Error Occured: ' + objReturn.strMessage);
				return false;
			}

			if(objReturn.arrHotels.length == 0){
				// no courses found
				console.log('No courses found for brand with id: ' + objData.brandId);
				alert('No courses found for brand with id: ' + objData.brandId);
				return false;
			}

			// make dropdown for each course
			for(var intHotel = 0; intHotel < objReturn.arrHotels.length; intHotel++){
				slCourse.append('<option value="' + objReturn.arrHotels[intHotel].hotel_id + '">' + objReturn.arrHotels[intHotel].hotel_name + '</option>');
			}

			return true;
		});
	});

	$("#course_id").change(function () {
		var newHtml = '';
		var oldHtml = $("#description").val();
		//console.log('oldHtml='+oldHtml);
		//var course = ucwords($("#course_id option:selected").text(),true);
		var course = $("#course_id option:selected").text();
		if(newIdent == ''){
			newHtml = oldHtml.replace("[item_name]",course);
		} else {
			newHtml = oldHtml.replace(newIdent,course);
		}


		//console.log('newHtml='+newHtml);
		$("#description").val(newHtml);

		newIdent = course;

    });

	$("#hotel_id").change(function () {
		var newHtml = '';
		var oldHtml = $("#description").val();
		//console.log('oldHtml='+oldHtml);
		//var course = ucwords($("#course_id option:selected").text(),true);
		var course = $("#hotel_id option:selected").text();
		if(newIdent == ''){
			newHtml = oldHtml.replace("[item_name]",course);
		} else {
			newHtml = oldHtml.replace(newIdent,course);
		}


		//console.log('newHtml='+newHtml);
		$("#description").val(newHtml);

		newIdent = course;

    });

	$(".update_stat").click(function () {

		var packageID = $(this).attr("data-id");
		var val1 = $('#completed'+packageID).val();

		console.log(packageID);
		console.log(val1);


		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				packageID : packageID,
				stat : val1,
				action: 'updatePackageStatus'
			},
		  })
		  .done(function( data ) {

		    console.log( "success:" + data );

		 })
		 .fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		 });

	});


	$("#generate_pdf").click(function () {

		var packageID = $('#packageID').val();
		//console.log('packageID'+packageID);
		//http://preview.bcgolfguide.com/application/ajax.php?action=generatePDF&packageID=8395
		$('#generate_pdf').attr('disabled','disabled');
		$('#print_pdf').hide();
		$('#pdf_notice').html('Generating Please Wait');
		$('#pdf_notice').show();


		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				packageID : packageID,
				action: 'generatePDF'
			},
		  })
		  .done(function( data ) {
		    console.log( "success:" + data );
		    $('#generate_pdf').removeAttr('disabled');
		    $('#print_pdf').show();
		    $('#pdf_notice').hide();
		    $('#delete_pdf').show();
		 })
		 .fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		 });


	});

	$("#delete_pdf").click(function () {

		var packageID = $('#packageID').val();
		$('#print_pdf').hide();
		$('#delete_pdf').hide();

		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				packageID : packageID,
				action: 'deletePDF'
			},
		  })
		  .done(function( data ) {
		    console.log( "success:" + data );
		    //$('#pdf_notice').hide();
		    $('#pdf_notice').html(data);
		    $('#pdf_notice').show();

		 })
		 .fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		 });

	});

	$("#copy_mini").click(function(event){
		event.preventDefault()

		var packageID = $('#packageID').val();
		var brandID = $('#brandID').val();

		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				brandID : brandID,
				packageID : packageID,
				action: 'getBrandMiniInfo'
			},
		  })
		  .done(function( data ) {
		    $('#mini_content').val(data.replace(/\n/g,"<br>"));
		    $('#mini_content').keyup();
		 })
		 .fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		 });
	});

	$("#copy_quote_mini").click(function(event){
		event.preventDefault()

		var quoteID = $('#quoteID').val();
		var brandID = $('#brandID').val();

		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				brandID : brandID,
				quoteID : quoteID,
				action: 'getBrandMiniQuoteInfo'
			},
		  })
		  .done(function( data ) {
		    $('#mini_content').val(data.replace(/\n/g,"<br>"));
		    $('#mini_content').keyup();

		 })
		 .fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		 });

	});

	$('#copy_voucher').click(function(event){
		event.preventDefault()

		var intBrandId = $('#brandID').val();
		var intPackageId = $('#packageID').val();

		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				brandID : intBrandId,
				packageID : intPackageId,
				action: 'getBrandVoucherInfo'
			},
		})
		.done(function( data ) {
			$('#voucher_email_text').val(data.replace(/\n/g,"<br>"));
			$('#voucher_email_text').keyup();
		})
		.fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		});
	});

	$('#copy_teetime_update_email').click(function(event){
		event.preventDefault()

		var intPackageCourseId = $('#relCourseID').val();

		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				packageCourseID : intPackageCourseId,
				action: 'getTeeTimeUpdateEmail'
			},
		})
		.done(function( data ) {
			$('#course_teetimes_update_email').val(data);
		})
		.fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		});
	});

	$('#send_tee_times_update_email').click(function(event){
		event.preventDefault();

		$('#tee_times_update_email_result').removeClass('text-danger');
		$('#tee_times_update_email_result').removeClass('text-success');
		$('#tee_times_update_email_result').html('');

		// get form values we need
		var objFormValues = $('#detail-form').serializeObject();
		objFormValues.action = 'sendTeeTimesUpdateEmail';

		// make ajax call to send email
		$.post("/application/ajax.php", objFormValues, function(strResponse){
			// deal with errors/success
			var objResponse = JSON.parse(strResponse);

			console.log(objResponse);

			if(objResponse.blnError){
				// error occured
				$('#tee_times_update_email_result').addClass('text-danger');
				$('#tee_times_update_email_result').html(objResponse.strMessage);
				return;
			}

			// success
			$('#tee_times_update_email_result').addClass('text-success');
			$('#tee_times_update_email_result').html(objResponse.strMessage);
			return;
		});
	});





	$(".copy_text").click(function () {

		var e = document.getElementById('brandID');
		var brandID = e.options[e.selectedIndex].value;
		var el = $(this).attr("data-id");
		console.log('brandID='+brandID);
		console.log('el='+el);

		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				brandID : brandID,
				ident : el,
				action: 'getBrandText'
			},
		  })
		  .done(function( data ) {
		    //console.log( "success:" + data );

		    $('#voucher_text_'+el).val(data);


		 })
		 .fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		 });
	});

    $(".copy_hotel_special").click(function () {

        var packageID = $('#packageID').val();
        console.log(packageID);

        var jqxhr = $.ajax({
            url: "/application/ajax.php",
            type: "POST",
            data: {
                packageID : packageID,
                action: 'getHotelSpecial'
            },
          })
          .done(function( data ) {
            $('#hotel_special_instructions').val(data.replace(/\n/g,"<br>"));
		    $('#hotel_special_instructions').keyup();
         })
         .fail(function(jqXHR, textStatus) {
            console.log( "error:"+ textStatus );
         });

    });

	$("#send_email").click(function () {
		var note = $('#note').val();
		var packageID = $('#packageID').val();
		var quoteGroupId = $('input[name=group_id]').val();
		var quoteId = $('#quote_id').val();

		if(note.length > 1) {
			var jqxhr = $.ajax({
				url: "/application/ajax.php",
				type: "POST",
				data: {
					note : note,
					groupID : quoteGroupId,
					quoteID : quoteId,
                    packageID : packageID,
					action: 'sendNote'
				},
			})
			.done(function( data ) {
			    $('#result').html('Mail Sent!');
			    $('#notes_list > li').remove();

			    var d = $.parseJSON(data);

				for(var i =0;i<d.length;i++){
				    $("#notes_list").append('<li><strong>'+d[i].contact_person+'</strong> on <em>'+d[i].timestamp+'</em><pre>'+d[i].comment+'</pre></li>');
				}
			})
			.fail(function(jqXHR, textStatus) {
			    console.log( "error:"+ textStatus );
			});
		}
	});

	$("#send_hotel_email").click(function () {
		var relhotelID = $('#relhotelID').val();
		var email_content = $('#email_content').val();
		var packageID = $('#package_id').val();

		//console.log( "packageID:"+ packageID );
		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				email_content : email_content,
				relhotelID : relhotelID,
				packageID : packageID,
				action: 'sendHotelNotice'
			},
		})
		.done(function( data ) {
		    console.log( "success:" + data );
		    $('#result_hotel').html('Mail Sent!');

		})
		.fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		});
	});



	$("#refresh_hotel_email").click(function () {
		var relhotelID = $('#relhotelID').val();
		//console.log( "packageID:"+ packageID );
		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				relhotelID : relhotelID,
				action: 'refreshHotelNotice'
			},
		})
		.done(function( data ) {
		    console.log( "success:" + data );
		    $('#result_hotel').html('Page Refreshed!');
		    $('#email_content').val(data);
		})
		.fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		});
	});

	$("#refresh_quote_hotel_email").click(function () {
		var relhotelID = $('#relhotelID').val();
		//console.log( "packageID:"+ packageID );
		var jqxhr = $.ajax({
			url: "/application/ajax.php?admin=true",
			type: "POST",
			data: {
				relhotelID : relhotelID,
				action: 'refreshQuoteHotelNotice'
			},
		})
		.done(function( data ) {
		    console.log( "success:" + data );
		    $('#result_hotel').html('Page Refreshed!');
		    $('#email_content').val(data);
		})
		.fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		});
	});


	$("#copy_mini_hotel").click(function () {

		var e = document.getElementById('brandID');
		var packageID = $('#packageID').val();
		//var mini_content = document.getElementById('mini_content');
		var brandID = e.options[e.selectedIndex].value;
		//console.log('brandID='+brandID);

		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				brandID : brandID,
				packageID : packageID,
				action: 'getBrandHotelMiniInfo'
			},
		  })
		  .done(function( data ) {
		    //console.log( "success:" + data );

		    $('#mini_hotel_content').val(data);


		 })
		 .fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		 });
	});

    $("#select_email_all").change(function(e) {

        var checked = $(this).prop('checked');
        $("input[name*='send_email_to']").each(function(e) {
            $(this).prop('checked', checked);
        });
    });

	$("#send_client_email").click(function () {

        var additionalEmails = '';
        $("input[name*='send_email_to']:checked").each(function(e) {
            if (additionalEmails != '') {
                additionalEmails += ',';
            }
           additionalEmails += $(this).val();
        });

		var mini_content = $('#mini_content').val();
		var packageID = $('#packageID').val();

		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				mini_content : mini_content,
				packageID : packageID,
                additionalEmails : additionalEmails,
				action: 'sendPackageLink'
			},
		})
		.done(function( data ) {
		    $('#result').html('Mail Sent!');
		})
		.fail(function(jqXHR, textStatus) {
		    console.log("error:" + textStatus);
		});
	});

	$("#send_client_quote_email").click(function () {
		var mini_content = $('#mini_content').val();
		var quoteID = $('#quoteID').val();

		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				mini_content : mini_content,
				quoteID : quoteID,
				action: 'sendQuoteLink'
			},
		})
		.done(function( data ) {
		    $('#result').html('Mail Sent!');
		})
		.fail(function(jqXHR, textStatus) {
		    console.log( "error:"+ textStatus );
		});
	});

	$('#send_client_voucher_email').click(function(event){
		event.preventDefault();

		var strVoucherContent = $('#voucher_email_text').val();
		var intPackageID = $('#packageID').val();

		var jqxhr = $.ajax({
			url: "/application/ajax.php",
			type: "POST",
			data: {
				voucherContent: strVoucherContent,
				packageID: intPackageID,
				action: 'sendPackageVoucherLink'
			},
		})
		.done(function( data ) {
		    //console.log( "success:" + data );
		    $('#voucher_result').html('Mail Sent!');

		})
		.fail(function(jqXHR, textStatus) {
		    console.log( "error:" + textStatus );
		});
	});




	$(".course_region_checkbox").change(function () {

		var region_id = $('#region_id').val();


        $.getJSON("/application/ajax.php", {
            val: $(this).val(),
            check: $(this).is(':checked'),
            region: region_id,
            action: 'updateCourseRegion'
        }, function (json) {

            console.log(json);


        });

    });

	$(".hotel_region_checkbox").change(function () {

		var region_id = $('#region_id').val();


        $.getJSON("/application/ajax.php", {
            val: $(this).val(),
            check: $(this).is(':checked'),
            region: region_id,
            action: 'updateHotelRegion'
        }, function (json) {

            console.log(json);


        });

    });

	// Change the title of the snippet when someone types in the meta title text input.
	$('.meta-title').keyup(function() {
		updateCharacterLength($(this), 70);
		updateSnippet($(this), '.seo-snippet .title');
	});

	// Change the description of the snippet when someone types in the meta description text input.
	$('.meta-description').keyup(function() {
		updateCharacterLength($(this), 153);
		updateSnippet($(this), '.seo-snippet .desc');
	});

	/**
	 * Updates the characters remaining + adds css classes
	 * relies on having a focused element / .char-count object to change
	 */
	function updateCharacterLength(object, max_length) {
		var field 		= object.find(':focus');
		var char_count 	= object.find('.char-count');
		var length 		= field.val().length;
		var remaining 	= max_length - length;

		// Update the remaining character
		char_count.html(remaining);

		// Add remove css classes
		if (remaining <= 0) {
			char_count.removeClass('text-success');
			char_count.addClass('text-danger');
		} else {
			char_count.removeClass('text-success');
			char_count.addClass('text-success');
		}
	}

	/**
	 * Updates the SEO snippet based of the passed object
	 *
	 */
	function updateSnippet(value_object, snippet_object) {
		var field = value_object.find(':focus');
		var value = field.val();

		// Update the snippet text
		$(snippet_object).html(value);

		// Replace with placeholder text if empty
		if (value == '') {
			$(snippet_object).html(field.attr('placeholder'));
		}
	}

	$('.selectall').click(function(event) {
	    if(this.checked) {
	        // Iterate each checkbox
	        $(':checkbox').each(function() {
	            this.checked = true;
	        });
	    } else {
	    	$(':checkbox').each(function() {
	            this.checked = false;
	        });

	    }
	});

	$('.selectallcourses').click(function(event) {
	    if(this.checked) {
	        // Iterate each checkbox
	        $(':checkbox.course_brand_checkbox').each(function() {
	            this.checked = true;
	        });
	    } else {
	    	$(':checkbox.course_brand_checkbox').each(function() {
	            this.checked = false;
	        });

	    }
	});

	$('.selectallhotels').click(function(event) {
	    if(this.checked) {
	        // Iterate each checkbox
	        $(':checkbox.hotel_brand_checkbox').each(function() {
	            this.checked = true;
	        });
	    } else {
	    	$(':checkbox.hotel_brand_checkbox').each(function() {
	            this.checked = false;
	        });

	    }
	});

	// Add jQuery Date Pickers to fields
	$('.datepicker').datepicker({
		dateFormat: 'yy-mm-dd'
	});

	// Event Recurring Scripts
	$('#recurring_type').change(function(){
		updateEventRecurringType();
	});

	function updateEventRecurringType(){
		if($('#recurring_type').length == 0){
			// we are NOT on a page with the recurring event type
			return;
		}

		var optSelected = $('#recurring_type').find('option:selected');
		var divRecurringType = optSelected.closest('div.recurring-type');
		var hdnRecurringDetails = divRecurringType.find('.recurring-details');

		// check if defaults was included
		objDefaults = {
			"monday": false,
			"tuesday": false,
			"wensday": false,
			"thursday": false,
			"friday": false,
			"saturday": false,
			"sunday": false,
		};

		if(hdnRecurringDetails.val().length > 0){
			//objDefaults = objRecurringDetails;
			objDefaults = JSON.parse(hdnRecurringDetails.val());
		}

		// toggle discription
		divRecurringType.find('.description').html(optSelected.data('description'));

		// show additional details
		// clear current details
		divRecurringType.find('.additional-options').html('');
		switch(parseInt(optSelected.val())){
			case 4:
				// Weekly (multiple)
				var objDays = new Array(
					{"value": 'monday', "label": 'Monday', "day": 1},
					{"value": 'tuesday', "label": 'Tuesday', "day": 2},
					{"value": 'wednesday', "label": 'Wednesday', "day": 3},
					{"value": 'thursday', "label": 'Thursday', "day": 4},
					{"value": 'friday', "label": 'Friday', "day": 5},
					{"value": 'saturday', "label": 'Saturday', "day": 6},
					{"value": 'sunday', "label": 'Sunday', "day": 7}
				);

				var strHTML = '';

				strHTML += '<ul class="list-unstyled">';

				for(var i = 0; i < objDays.length; i++){
					var strChecked = '';
					if(objDefaults != null && Object.keys(objDefaults).length > 0){
						// check if this day is checked
						if(objDefaults[objDays[i].value] !== undefined && objDefaults[objDays[i].value].selected !== undefined && objDefaults[objDays[i].value].selected == true){
							strChecked = 'checked="checked"';
						}
					}

					strHTML += '<li>';

					strHTML += '<span class="day day-' + objDays[i].value + '">';

					strHTML += '<label>'
						  + '<input type="checkbox" name="recurring_type_details[]" value="' + encodeURIComponent(JSON.stringify(objDays[i])) + '" ' + strChecked + ' />'
						  + ' <span>' + objDays[i].label + '</span>';
						  + '</label>';

					strHTML += '</li>';

					strHTML += '</span>';
				}

				strHTML += '</ul>';

				divRecurringType.find('.additional-options').html(strHTML);

				break;
			case 6:
				// Monthly (day)
				var objOrdinal = new Array(
					{"value": 'first', "label": 'First'},
					{"value": 'second', "label": 'Second'},
					{"value": 'third', "label": 'Third'},
					{"value": 'fourth', "label": 'Fourth'},
					{"value": 'fifth', "label": 'Fifth'},
					{"value": 'sixth', "label": 'Sixth'},
					{"value": 'last', "label": 'Last'}
				);

				var objDays = new Array(
					{"value": 'monday', "label": 'Monday', "day": 1},
					{"value": 'tuesday', "label": 'Tuesday', "day": 2},
					{"value": 'wednesday', "label": 'Wednesday', "day": 3},
					{"value": 'thursday', "label": 'Thursday', "day": 4},
					{"value": 'friday', "label": 'Friday', "day": 5},
					{"value": 'saturday', "label": 'Saturday', "day": 6},
					{"value": 'sunday', "label": 'Sunday', "day": 7}
				);

				var strHTML = '<div class="form-inline">';

				// Ordinal
				strHTML += '<div class="form-group">';
				strHTML += '<label for="tbxRecurring_type_details_ordinal"></label>'
						 + '<select id="tbxRecurring_type_details_ordinal" class="form-control" name="recurring_type_details[ordinal]">';
				for(var i = 0; i < objOrdinal.length; i++){
					var strChecked = '';
					if(objDefaults != null && objDefaults.ordinal !== undefined){
						// check if this day is checked
						if(objOrdinal[i].value == objDefaults.ordinal.value){
							strChecked = 'selected="selected"';
						}
					}

					strHTML += '<option value="' + encodeURIComponent(JSON.stringify(objOrdinal[i])) + '" ' + strChecked + '>' + objOrdinal[i].label + '</option>';
				}
				strHTML += '</select>';
				strHTML += '</div>';


				// Days
				strHTML += '<div class="form-group">';
				strHTML += '<label for="tbxRecurring_type_details_day"></label>'
						 + '<select id="tbxRecurring_type_details_day" class="form-control" name="recurring_type_details[day]">';
				for(var i = 0; i < objDays.length; i++){
					var strChecked = '';
					if(objDefaults != null && objDefaults.day !== undefined){
						// check if this day is checked
						if(objDays[i].value == objDefaults.day.value){
							strChecked = 'selected="selected"';
						}
					}

					strHTML += '<option value="' + encodeURIComponent(JSON.stringify(objDays[i])) + '" ' + strChecked + '>' + objDays[i].label + '</option>';
				}
				strHTML += '</select>';
				strHTML += '</div>';

				strHTML += ' of the month.'

				strHTML += '</div>'; // end of .form-inline

				divRecurringType.find('.additional-options').html(strHTML);

				break;
		}
	}

	// default event recurring type details
	updateEventRecurringType();

	if($('.js-duplicate-quote-modal').length > 0){
		// only run if the quote modal exists
		// show duplicate dialog
		$('.js-btn-duplicate-quote').click(function(event){
			event.preventDefault();

			// make sure there is a quote id attached
			var intQuoteId = $(this).data('quote-id');

			if(typeof(intQuoteId) == 'undefined'){
				// no quote id attached
				return false;
			}

			var divModal = $('.js-duplicate-quote-modal');
			var frmForm = divModal.find('form')

			var strAction = divModal.data('post-url') + intQuoteId;

			divModal.find('.js-quote-id').val(intQuoteId);
			frmForm.attr('action', strAction);

			divModal.modal('show');
		});
	}


});



	function save_paid(val,type,Index) {
	    //alert('test');
	    ///application/ajax.php?action=update_paidout&newval=0&Index=278
	    $.ajax( {
	        url: "/application/ajax.php",
	        data: "action=update_paidout&newval="+val+"&type="+type+"&Index="+Index,
	        type: "post",
	        success:function(result){
	            //alert(result);
	            //console.log(result);
	            alert(result);
	          }
	        });

	}


function doNothing() {


}

function confirmDelete(gotoURL) {
	if(confirm('Are you sure you want to delete this?')) {
		location.href = gotoURL;
	}
}

function confirmPrompt(gotoURL,message) {
	if(confirm(message)) {
		location.href = gotoURL;
	}
}

function ucwords(str,force){
  str=force ? str.toLowerCase() : str;
  return str.replace(/(\b)([a-zA-Z])/g,
           function(firstLetter){
              return   firstLetter.toUpperCase();
           });
}



/* Color picker input */
$(document).ready(function(){
	if(typeof($.minicolors) == 'undefined'){
		return;
	}

	// setup color inputs
	$.minicolors.defaults.theme = 'bootstrap';
	$('input.minicolors').minicolors({
		defaults: {
			theme: 'bootstrap'
		}
	});

	// deal with status dropdown colors
	$('select.color-coded-select').change(function(){
		selectSyncColor(this);
	});

	// deal with first instance
	$('select.color-coded-select').each(function(){
		selectSyncColor(this);
	});

	function selectSyncColor(slSelect){
		// set selected option color to the select color option
		$(slSelect).css('color', $(slSelect).find(':selected').css('color'));
	}
});

$(document).ready(function(){

	function setupSaveButtons(){
		// this function will hide the save button and show the loading button if we have one
		var jobjSaveButtons = $('.btn-save');

		if(jobjSaveButtons.length > 0){
			jobjSaveButtons.each(function(){
				var jobjButtonsDiv = $(this).closest('div.buttons');
				if(jobjButtonsDiv.length == 0){
					// no buttons div holder
					return false;
				}

				$(this).click(function(event){
					$(this).hide();
					jobjButtonsDiv.find('.btn-loading').show();
				});
			});
		}
	}

	setupSaveButtons();

	/* Rich Text Editor */
	$('.js-late-resize-editor').find('iframe').css('height', '200px'); // Required for inner iframe's height
});


$.fn.serializeObject = function()
{
    var o = {};
    var a = this.serializeArray();
    $.each(a, function() {
        if (o[this.name] !== undefined) {
            if (!o[this.name].push) {
                o[this.name] = [o[this.name]];
            }
            o[this.name].push(this.value || '');
        } else {
            o[this.name] = this.value || '';
        }
    });
    return o;
};

/* Number restrict input */
$(document).ready(function(){
	$(document).on('keydown', 'input[type=number][data-restrict-number=true]', function(event){
	    return checkNumberField(event, this);
	});

	function checkNumberField(event, element){
	    var arrAcceptKeyCodes = [
	        8, // backspace
	        9, // tab
	        13, // enter,
	        16, // shift
	        27, // esc
	        35, // end
	        36, // home
	        37, // left arrow
	        38, // up arrow
	        39, // right arrow
	        40, // down arrow
	        46, // del key
	    ];

	    if($(element).data('allow-period') !== undefined && $(element).data('allow-period')){
	        arrAcceptKeyCodes.push(190); // period
	        arrAcceptKeyCodes.push(110); // period in numpad
	    }

	    if($(element).data('allow-comma') !== undefined && $(element).data('allow-comma')){
	        arrAcceptKeyCodes.push(188); // comma
	    }

	    // Check special chars
	    if($.inArray(event.keyCode, arrAcceptKeyCodes) !== -1){
	        return true;
	    }

	    // Check if is not number
	    if(event.shiftKey || (event.keyCode < 48 || event.keyCode > 57) && (event.keyCode < 96 || event.keyCode > 105 )){
	        event.preventDefault();
	        return false;
	    }

	    return true;
	}
});

function guid() {
  function s4() {
    return Math.floor((1 + Math.random()) * 0x10000)
      .toString(16)
      .substring(1);
  }
  return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
    s4() + '-' + s4() + s4() + s4();
}

function isEmptyObject(obj) {
  for(var prop in obj) {
    if (Object.prototype.hasOwnProperty.call(obj, prop)) {
      return false;
    }
  }
  return true;
}

String.prototype.capitalizeFirstLetter = function() {
    return this.charAt(0).toUpperCase() + this.slice(1);
}

function ratesAddFee(intRateId, type, newRate) {

	intNumNewFees = $(".jsNewFeeCount").val();

	strPrefix = '';

	if (newRate) {
		strPrefix = 'newRate_';
	}

	strFeeHTML = `<div class="panel-group panel-group-fee" jsNewFeeId="`+intNumNewFees+`">
					<div class="panel panel-default">
						<div class="panel-heading">
							<h3 style="cursor:pointer" data-toggle="collapse" data-target="#new_rate_fee_`+intNumNewFees+`">
								New Fee `+intNumNewFees+`
								<i style="float:right; color:red; margin-left:10px;" class="fa fa-trash-o jsDeleteNewFee" data-fee-id="`+intNumNewFees+`"></i>
								<i style="float:right;" class="fa fa-chevron-down"></i>
							</h3>
						</div>

						<div id="new_rate_fee_`+intNumNewFees+`" class="panel-collapse collapse in">

							<div class="panel-body">
			                    <div class="form-group">
							    	<label for="new_fee_name">Fee Name</label>
								    <input type="text" name="`+strPrefix+`newFeeName[`+intRateId+`][`+intNumNewFees+`]" class="form-control" id="new_fee_name" value="">
								</div>

								<div class="form-group">
							    	<label for="new_fee_calc_type">Fee Calculation Type</label>
							    	<select name="`+strPrefix+`newFeeCalcType[`+intRateId+`][`+intNumNewFees+`]" id="new_fee_calc_type" class="form-control">
							    		<option value="flat">Flat Value</option>
							    		<option value="percentage">Percentage</option>
							    	</select>
								</div>

								<div class="form-group">
							    	<label for="new_fee_amount">Amount / Percentage</label>
								    <input type="number" name="`+strPrefix+`newFeeAmount[`+intRateId+`][`+intNumNewFees+`]" class="form-control" id="new_fee_amount" value="">
								</div>`;

				if (type == 'hotel') {

					strFeeHTML +=	   `<div class="form-group">
									    	<label for="new_fee_per_night">Per Night</label>
										    <input type="checkbox" name="`+strPrefix+`feePerNight[`+intRateId+`][`+intNumNewFees+`]" class="" id="new_fee_per_night" value="">
										</div>

										<div class="form-group">
									    	<label for="new_fee_per_room">Per Room</label>
										    <input type="checkbox" name="`+strPrefix+`feePerRoom[`+intRateId+`][`+intNumNewFees+`]" class="" id="new_fee_per_room" value="">
										</div>`;
				}

	strFeeHTML +=			   `<div class="form-group">
							    	<label for="new_fee_public">Public</label>
								    <input type="checkbox" name="`+strPrefix+`newFeePublic[`+intRateId+`][`+intNumNewFees+`]" class="" id="new_fee_public" value="">
								    <label for="new_fee_private">Private</label>
								    <input type="checkbox" name="`+strPrefix+`newFeePrivate[`+intRateId+`][`+intNumNewFees+`]" class="" id="new_fee_private" value="">
								</div>
			        		</div>
			        	</div>
		        	</div>
		        </div>`;

 	if (newRate) {
 		$("div#new_rate_"+intRateId+" span.jsNewFeeContainer").append(strFeeHTML);
 	} else {
 		$("div#rate_"+intRateId+" span.jsNewFeeContainer").append(strFeeHTML);
 	}

 	$(".jsNewFeeCount").val(parseInt($(".jsNewFeeCount").val()) + 1);

 	$('div#new_rate_fee_'+intNumNewFees+' input[name="'+strPrefix+'newFeeName['+intRateId+']['+intNumNewFees+']"').focus();

 	return intNumNewFees;

}

function ratesAddRate(rateType) {

	intNumNewRates = $(".jsNewRateCount").val();

	strRateHTML = `
		<div class="panel-group jsNewRate">
			<div class="panel panel-default">
				<div class="panel-heading">
					<h3 style="cursor:pointer" data-toggle="collapse" data-target="#new_rate_`+intNumNewRates+`">
						New Rate `+intNumNewRates+`
						<i style="float:right; color:red; margin-left:10px;" class="fa fa-trash-o jsDeleteNewRate" data-rate-id="`+intNumNewRates+`" data-rate-name="New Rate `+intNumNewRates+`"></i>
						<i style="float:right;" class="fa fa-chevron-down"></i>
					</h3>
				</div>

				<div id="new_rate_`+intNumNewRates+`" class="panel-collapse collapse in">
					<div class="panel-body">

						<div class="form-group">
							<label for="new_rate_name">Rate Name</label>
							<input type="text" name="new_rate_name[`+intNumNewRates+`]" class="form-control" value="">
						</div>

						<div class="form-group">
							<label for="new_rate_datefrom">Start Date</label>
							<input type="text" name="new_rate_datefrom[`+intNumNewRates+`]" class="form-control datepicker jsNewDatepicker" value="">
						</div>

						<div class="form-group">
							<label for="new_rate_dateto">End Date</label>
							<input type="text" name="new_rate_dateto[`+intNumNewRates+`]" class="form-control datepicker jsNewDatepicker" value="">
						</div>

						<div class="form-group">
							<label for="new_rate_public">Public Rate</label>
							<input type="number" name="new_rate_public[`+intNumNewRates+`]" class="form-control" value="">
						</div>

						<div class="form-group">
							<label for="new_rate_private">Private Rate</label>
							<input type="number" name="new_rate_private[`+intNumNewRates+`]" class="form-control" value="">
						</div>`;

	if (rateType == 'hotel') {
		strRateHTML += `
						<div class="form-group">
							<label for="new_rate_occupancy">Occupancy: </label>
							<input type="number" name="new_rate_occupancy[`+intNumNewRates+`]" class="form-control" value="1" />
						</div>`;
	}

	strRateHTML +=	`
						<div class="form-group">
							<input type="checkbox" name="new_rate_feature_package[`+intNumNewRates+`]" class="">
							<label for="new_rate_feature_package">Use This Rate in Feature Packages</label>
						</div>

						<div>
							<h2>
								Rate Fees
								<button style="float:right;" type="button" class="btn btn-success jsAddFeeNewRate" data-id="`+intNumNewRates+`">New Fee</button>
							</h2>
							<span class="jsNewFeeContainer">
	                        </span>
						</div>
					</div>
				</div>
			</div>
		</div>`;

	$('div.child-rates').append(strRateHTML);

	$(".jsNewRateCount").val(parseInt($(".jsNewRateCount").val()) + 1);

	$('div#new_rate_'+intNumNewRates+' input[name="new_rate_name['+intNumNewRates+']"').focus();

	return intNumNewRates;
}

function copyRate(intRateId, rateType) {

	// Copy rate
	intNewRateId = ratesAddRate(rateType);

	// Copy rate Values
	$("div#new_rate_" + intNewRateId + " input[name='new_rate_name["+intNewRateId+"]']").val($("div#rate_" + intRateId + " input[name='rateName["+intRateId+"]']").val());
	$("div#new_rate_" + intNewRateId + " input[name='new_rate_datefrom["+intNewRateId+"]']").val($("div#rate_" + intRateId + " input[name='rateDateFrom["+intRateId+"]']").val());
	$("div#new_rate_" + intNewRateId + " input[name='new_rate_dateto["+intNewRateId+"]']").val($("div#rate_" + intRateId + " input[name='rateDateTo["+intRateId+"]']").val());
	$("div#new_rate_" + intNewRateId + " input[name='new_rate_public["+intNewRateId+"]']").val($("div#rate_" + intRateId + " input[name='ratePublic["+intRateId+"]']").val());
	$("div#new_rate_" + intNewRateId + " input[name='new_rate_private["+intNewRateId+"]']").val($("div#rate_" + intRateId + " input[name='ratePrivate["+intRateId+"]']").val());

	$("div#rate_"+intRateId+" div.panel-group-fee").each(function(e) {

		intNewFeeId = ratesAddFee(intNewRateId, rateType, true);

		strFeeName = '';
		strFeeCalcType = '';
		strAmount = '';
		blnPublic = false;
		blnPrivate = false;

		if ($(this).attr('jsFeeId') != undefined) {
			intFeeId = $(this).attr('jsFeeId');
			console.log('copy jsFee' + intFeeId);

			strFeeName = $("input#fee_name_" + intFeeId).val();
			strFeeCalcType = $("input#fee_calc_type_" + intFeeId).val();
			strAmount = $("input#fee_amount_" + intFeeId).val();
			blnPublic = $("input#feePublic_" + intFeeId).prop('checked');
			blnPrivate = $("input#feePrivate_" + intFeeId).prop('checked');

			if (rateType == 'hotel') {
				blnPerNight = $("input[name='feePerNight["+intFeeId+"]").prop('checked');
				blnPerRoom = $("input[name='feePerRoom["+intFeeId+"]").prop('checked');
			}

		}

		if ($(this).attr('jsNewFeeId') != undefined) {
			intFeeId = $(this).attr('jsNewFeeId');
			console.log('copy NewjsFee' + intFeeId);

			strFeeName = $("input[name='newFeeName["+intRateId+"]["+intFeeId+"]']").val();
			strFeeCalcType = $("input[name='newFeeCalcType["+intRateId+"]["+intFeeId+"]']").val();
			strAmount = $("input[name='newFeeAmount["+intRateId+"]["+intFeeId+"]']").val();
			blnPublic = $("input[name='newFeePublic["+intRateId+"]["+intFeeId+"]']").prop('checked');
			blnPrivate = $("input[name='newFeePrivate["+intRateId+"]["+intFeeId+"]']").prop('checked');

			if (rateType == 'hotel') {
				blnPerNight = $("input[name='feePerNight["+intRateId+"]["+intFeeId+"]").prop('checked');
				blnPerRoom = $("input[name='feePerRoom["+intRateId+"]["+intFeeId+"]").prop('checked');
			}
		}

		$("div#new_rate_fee_"+intNewFeeId+" input[name='newRate_newFeeName["+intNewRateId+"]["+intNewFeeId+"]']").val(strFeeName);
		$("div#new_rate_fee_"+intNewFeeId+" input[name='newRate_newFeeCalcType["+intNewRateId+"]["+intNewFeeId+"]']").val(strFeeCalcType);
		$("div#new_rate_fee_"+intNewFeeId+" input[name='newRate_newFeeAmount["+intNewRateId+"]["+intNewFeeId+"]']").val(strAmount);

		$("div#new_rate_fee_"+intNewFeeId+" input[name='newRate_newFeePublic["+intNewRateId+"]["+intNewFeeId+"]']").prop('checked', blnPublic);
		$("div#new_rate_fee_"+intNewFeeId+" input[name='newRate_newFeePrivate["+intNewRateId+"]["+intNewFeeId+"]']").prop('checked', blnPrivate);

		if (rateType == 'hotel') {
			$("div#new_rate_fee_"+intNewFeeId+" input[name='newRate_feePerNight["+intNewRateId+"]["+intNewFeeId+"]']").prop('checked', blnPerNight);
			$("div#new_rate_fee_"+intNewFeeId+" input[name='newRate_feePerRoom["+intNewRateId+"]["+intNewFeeId+"]']").prop('checked', blnPerRoom);
		}

	});
}

function copyNewRate(intRateId) {

}

function deleteRate(intRateId) {

	$("div#rate_"+intRateId).parents(".panel-group").remove();
	$(".jsDeleteRates").val($(".jsDeleteRates").val() + "," + intRateId);
}

function deleteFee(intFeeId) {

	$("div#rate_fee_"+intFeeId).parents(".panel-group-fee").remove();
	$(".jsDeleteFees").val($(".jsDeleteFees").val() + "," + intFeeId);
}

function deleteNewRate(intFeeId) {
	$("div#new_rate_" + intFeeId).parents(".panel-group").remove();
}

function deleteNewFee(intFeeId) {
	$("div#new_rate_fee_" + intFeeId).parents(".panel-group-fee").remove();
}
