<?php
/**
 * Partial view for the package form
 *
 */

?>
<div class="container-package-form">
    <form action="/golf-vacation-builder/" method="get" class="package-form">
        <div class="container">
            <h2 class="title">Create Your Golf Package</h2>
            <div class="row tight">
                <div class="col-sm-3">

                    <div class="form-group">
                        <label class="sr-only" for="r">Destination:</label>
                        <select name="r" id="r" class="form-control">
                            <option value="">- Select a Destination -</option>
                            <?php
                            // If the region is null set it to kelowna and area
                            $intSelectedRegion = isset($objController->intRegionId) ? $objController->intRegionId : 0;
                            foreach($objController->arrRegions As $r){
                                echo '<option value="' . $r['id'] . '" ' . Util::isSelected($r['id'], $intSelectedRegion) . '>' . $r['region_name'] . '</option>';
                            }
                            ?>
                        </select>
                    </div>

                </div>
                <div class="col-xs-6 col-sm-3">

                    <div class="form-group">
                        <label class="sr-only" for="package_arrival_date">Arrival date:</label>
                        <input type="text" name="arrival_date" id="package_arrival_date" class="form-control datepicker-future" placeholder="Arrival Date" value="">
                    </div>

                </div>
                <div class="col-xs-6 col-sm-3">

                    <div class="form-group">
                        <label class="sr-only" for="nights">Number of nights:</label>
                        <input type="number" name="nights" id="nights" class="form-control" placeholder="Number of nights" value="">
                    </div>

                </div>
                <div class="col-xs-12 col-sm-3">

                    <button type="submit" class="btn btn-primary btn-block">Customize Your Golf Trip</button>

                </div>
            </div>

            <div class="package-form-alert alert alert-danger hidden">Please fill out all form fields.</div>

        </div>
    </form>
</div>
<script>
jQuery(document).ready(function($) {
    $('.package-form').on('submit', function(event) {
        // Set the error
        var blnError = false;

        // Hide the errors
        $('.package-form-alert').addClass('hidden');

        // Check form values
        $(this).find('.form-control').each(function() {
            if ($(this).val() == '') {
                blnError = true; return;
            }
        });

        // Stop the form & show the error
        if (blnError) {
            event.preventDefault();
            $('.package-form-alert').removeClass('hidden');
        }
    });
});
</script>
