<?php
/**
 * The Header template for our Site
 *
 * Displays all of the <head> section and everything up to <div class=row">
 *
 * @package Navigator Multimedia Inc HTML 5 Boiler Template
 * @subpackage Name Of Site We Are Working on
 * @since HTML 5 Boiler Template 1.0
 */

// Build the menu structure
$objMenu = new Menu();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <?php echo $objSettings->getMetaTags(); // uses the model object to create meta tags ?>

    <!-- FAVICON -->
    <link rel="icon" type="image/x-icon" href="<?php echo ROOT_URL; ?>/application/images/favicon.ico" />

    <!-- CSS -->
    <link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="//fonts.googleapis.com/css?family=Lato:400,700,900">
    <link rel="stylesheet" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css">
    <link rel="stylesheet" href="/application/css/style.css">

    <!-- SCRIPTS -->
    <script src="//code.jquery.com/jquery-1.11.0.min.js"></script>
    <script src="//code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
    <script src="//code.jquery.com/jquery-migrate-1.2.1.js"></script>
    <script src="//netdna.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <script src="//maps.googleapis.com/maps/api/js?key=AIzaSyCAEI0_8xMbaP_3Z7MBgAisGPqPZA2MeZ4"></script>
    <script src="//www.google.com/jsapi"></script>
    <script src="/application/js/map_funcs.js"></script>
    <script src="/application/js/scripts.js"></script>

    <!-- THIS SCRIPT PREVENTS LINKS FROM OPENING IN MOBILE SAFARI -->
    <script>(function(a,b,c){if(c in b&&b[c]){var d,e=a.location,f=/^(a|html)$/i;a.addEventListener("click",function(a){d=a.target;while(!f.test(d.nodeName))d=d.parentNode;"href"in d&&(d.href.indexOf("http")||~d.href.indexOf(e.host))&&(a.preventDefault(),e.href=d.href)},!1)}})(document,window.navigator,"standalone")</script>

    <?php echo $objSettings->getHeaderScripts(); // Custom analytics or tracking scripts from the settings ?>
    <?php echo $objController->getPageScripts(); // Custom page scripts can be included with this controller method ?>
</head>
<body>
    <header class="container-header">
        <nav class="navbar yamm navigation-main">
            <div class="container-fluid">

                <div class="navbar-header">
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navigation-main-collapse">
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="sr-only">Toggle navigation</span>
                    </button>
                    <div class="navbar-brand">
                        <a class="logo" href="/">
                            <img class="hidden-xs" src="/application/images/logo-light.png" alt="<?php echo $objSettings->strSiteName; ?>">
                            <img class="visible-xs-block" src="/application/images/logo-dark.png" alt="<?php echo $objSettings->strSiteName; ?>">
                        </a>
                    </div>
                </div>

                <div id="navigation-main-collapse" class="navbar-collapse collapse">
                    <ul class="nav navbar-nav navbar-center">
                        <?php $objMenu->output(); ?>
                    </ul>

                    <ul class="nav navbar-nav navbar-right visible-lg-block">
                        <li>
                            <a class="navbar-button" href="tel:18772237226">
                                <small>Personal Service</small>
                                1-877-223-7226
                            </a>
                        </li>
                    </ul>

                </div>

            </div>
        </nav>
        <div class="call-button visible-xs-block">
            <a href="tel:18772237226"><span class="fa fa-phone"></span> 1-877-223-7226</a>
        </div>
    </header>
    <!-- /.navbar -->

    <div class="header-image">
    <?php
        $altHeader = '';

        // Video from objects on certain table slugs
        if (in_array($objController->strTableSlug, array('featured', 'regions'))) {
            $objController->objModel->strVideoEmbed = $objController->arrDetails['video_embed'];
            $objController->objModel->strVideoSmallHeading = $objController->arrDetails['video_smallheading'];
            $objController->objModel->strVideoLargeHeading = $objController->arrDetails['video_largeheading'];
            $objController->objModel->strVideoText = $objController->arrDetails['video_text'];
            $objController->objModel->strVideoBtnText = $objController->arrDetails['video_buttontext'];
            $objController->objModel->strVideoLink = $objController->arrDetails['video_link'];
        }

        // remove video if these conditions
        if (isset($objController->objFeatured)) {
            if ($objController->objFeatured->intStep > 1) {
                $objController->objModel->strVideoEmbed = '';
            }
        }

    ?>
    <?php if (trim($objController->objModel->strVideoEmbed) != '') {
        $objYoutube = new YouTube();

        echo $objYoutube->displayYoutubeHeader(array(
            'strVideoCode' => $objController->objModel->strVideoEmbed,
            'strVideoSmallHeading' => $objController->objModel->strVideoSmallHeading,
            'strVideoLargeHeading' => $objController->objModel->strVideoLargeHeading,
            'strVideoText' => $objController->objModel->strVideoText,
            'strVideoBtnText' => $objController->objModel->strVideoBtnText,
            'strVideoLink' => $objController->objModel->strVideoLink
        ));
    ?>
    <?php } else if (!empty($objController->objModel->strDisplayImage)) { ?>

        <?php $image = Util::createImageSrc($objController->objModel->strDisplayImage, 1920, 350); ?>
        <img src="<?php echo $image; ?>" class="img-responsive" alt="<?php echo $objSettings->strSiteName; ?>">

    <?php } elseif (!empty($objController->arrImages)) { ?>

        <?php
        echo $objSettings::createHeroCarousel(array(
            'slides' => $objController->arrImages,
            'id' => 'header-carousel',
        ));
    ?>

    <?php } ?>
    </div>

    <?php
    if (Util::isFunnelPage($objController->strView)) {
        include ROOT_DIR . '/application/includes/package_form.php';
    }
    ?>

    <?php if (!Util::isFullWidthTemplate($objController->strView)) { ?>
    <div class="container-content">
        <div class="container">
    <?php } ?>
