<?php
/**
* The template for displaying the footer
*
* Contains footer content and the closing of the .row div element.
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/

?>

    <?php if (!Util::isFullWidthTemplate($objController->strView)) { ?>
        </div><!-- container -->
    </div><!-- container-content -->
    <?php } ?>

    <?php
    if (Util::isFunnelPage($objController->strView)) {
        include ROOT_DIR . '/application/includes/package_form.php';
    }
    ?>

	<footer class="container-footer">

        <nav class="navigation-footer">
            <div class="container">
                <ul class="list-inline">
                    <?php
                    $arrRegions = $objSettings->getRegionsForNav(array('state' => 2));
                    foreach($arrRegions As $r) {
                        echo '<li><a href="/regions/'.$r['slug'].'/">'.$r['region_name'].'</a></li>';
                    }
                    ?>
                    <li><a href="/bc-golf-course-map/">BC Golf Map</a></li>
                </ul>
            </div>
        </nav>

        <div class="footer-content">
            <div class="container">
                <div class="row">

                    <div class="col-md-6">
                        <h4 class="footer-title h5">BCgolfguide.com</h4>
                        <div class="footer-description">
                            <p><a href="/">BCgolfguide.com</a> (BC Golf Guide) has been online since 1997 and has evolved into becoming the largest and most proactive golf tour operator in all of Western Canada.</p>
                            <p>BC Golf Guide has been a pioneer when it comes to online golf resources for British Columbia. BC Golf Guide.com was created and developed back in 1998 by Ross Marrington. It started as a simple online tool to find golf courses and related topics. As our online presences matured and the family moved to Kelowna (a golf mecca) it was the start of an amazing journey.</p>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <h4 class="footer-title h5">Connect</h4>
                        <ul class="footer-contact list-unstyled">
                            <li><a href="tel:18772237226">1-877-223-7226</a></li>
                            <li><address>#304 - 1967 Underhill Street, Kelowna BC V1X 8C9</address></li>
                            <li><a href="https://www.golfblog.bcgolfguide.com">View our golf blog</a></li>
                        </ul>
                        <?php echo $objSettings->getSocialMediaBar(); ?>
                    </div>

                    <div class="col-md-3">
                        <h4 class="footer-title h5">Affiliations</h4>
                        <ul class="footer-logos list-inline">
                            <li><img src="/application/images/acta.png" alt="ACTA" class="img-responsive"></li>
                            <li><img src="/application/images/consumer.png" alt="Consumer Protection" class="img-responsive"></li>
                            <li><img src="/application/images/iata.png" alt="IATA" class="img-responsive"></li>
                            <li><img src="/application/images/iagto.png" alt="IAGTO" class="img-responsive"></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>

        <div class="footer-copyright">
            <div class="container">
                <ul class="list-inline copyright">
                    <li><a href="/bc-golf-guide-privacy-policies/">Privacy Policy</a></li>
                    <li><a href="/terms-conditions-for-bc-golf-travel/">Terms &amp; Conditions</a></li>
                </ul>
                <ul class="list-inline credit">
                    <li><?php echo '&copy; '.date('Y').' '.$objSettings->strSiteName.'. All Rights Reserved.'; ?></li>
                </ul>
            </div>
        </div>

	</footer>
	<!-- /.footer -->

    <?php echo $objSettings->getFooterScripts(); ?>

</body>
</html>