<?php
// set default security level if not already set
if (!isset($secLvl)) {
	$secLvl = 5;
}


if (!isset($_SESSION['user_access'])) {

	$_SESSION['userID'] = '';
	$_SESSION['user_name'] = '';
	$_SESSION['user_password'] = '';
	$_SESSION['user_access'] = 50;

}


if (!empty($_GET['logout'])) {

	session_unset();
	$_SESSION['userID'] = '';
	$_SESSION['user_name'] = '';
	$_SESSION['user_password'] = '';
	$_SESSION['user_access'] = 50;

	$refPage = !empty($_POST['refPage']) ? $_POST['refPage'] : "";
	if ($refPage != "") {
		echo("<meta http-equiv='refresh' content='0;url=" . $refPage . "'");
	} else {
		echo("<meta http-equiv='refresh' content='0;url=/admin/'");
	}
}


// Send Reset link
if (!empty($_GET['action']) && $_GET['action'] == 'lp') {
	if (!empty($_POST['resetPassword'])) {

		$strSuccessMessage = '';
		$strErrorMessage = '';
		$strUserName = $_POST['user_name'];

		if (empty($strUserName)) {
			$strErrorMessage = 'Please type your username or email address.';
		}

		$objUser = validateReset($strUserName);

		if ($objUser) {

			$strEmail = $objUser['user_email'];
			// Set our reset query passing the userID and time the email was sent
			$user_reset_link = base64_encode(base64_encode($objUser['userID']).'|'.base64_encode(time()));
			$link = ROOT_URL.'/admin/?action=rp&k='.$user_reset_link;
			//var_dump($link);

			ob_start();
			include(VIEW_DIR . '/emails/password_recover.php');
			$strMessage = ob_get_clean();

			$blnEmailSent = Util::sendMail(array($strUserName => $strEmail), 'Password Reset', $strMessage);

			if($blnEmailSent){
				$strSuccessMessage = 'Password recovery email sent.';
			} else {
				$strErrorMessage = 'An error occured when sending the email, please try again later.';
			}

		} else {
			$strErrorMessage = 'No user found with that email or username.';
		}

		showLogin($strUserName, $strUserPassword, $strErrorMessage, $strSuccessMessage);

	}
}

// Reset db user password
if (!empty($_GET['action']) && $_GET['action'] == 'rp' && !empty($_GET['k'])) {
	// Key Validation
	$strKey = $_GET['k'];
	$strKey = base64_decode($strKey);
	$strSuccessMessage = '';

	// Format our array and validate array(UserId, time_sent);
	$arrUserData = explode('|', $strKey);
	if (empty($arrUserData) || count($arrUserData) > 2) {
		$strErrorMessage = 'Not a valid key.';
	}

	// Decode our variables
	foreach ($arrUserData as $key => $value) {
		$arrUserData[$key] = base64_decode($value);
	}

	// the sent date + 5 hours
	$strExpireDate = $arrUserData[1] + (60 * 60 * 5);

	// if we have passed the expire date
	if (time() > $strExpireDate) {
		$strErrorMessage = 'This key has expired.';
	}

	if ($strErrorMessage == '') {

		$db = new Database;

		if (!empty($_POST['resetPassword'])) {

			$intUserId = $arrUserData[0];
			$strNewPassword = $_POST['new_password'];
			$strNewPassword2 = $_POST['new_password2'];

			if (empty($strNewPassword) || empty($strNewPassword2)) {
				$strErrorMessage = 'Please fill in the passwords.';
			}

			// Password Validations
			if ($strNewPassword !== $strNewPassword2) {
				$strErrorMessage = 'Your passwords do not match.';
			} else if (strlen($strNewPassword) < 5) {
				$strErrorMessage = 'Your password is too short, must be atleast 5 characters.';
			} else {
				// Hash our string
				$hash = Util::bcryptString($strNewPassword);
				// Set our new password
				$strUserPassword = $hash;
			}

			if ($strErrorMessage == '') {
				$keys = array(
					'user_password'
				);
				$vals = array(
					$strUserPassword
	            );
				$types = array('s');

				$strErrorMessage = $db->mysqliupdate('admins',$keys,$vals,$types,$intUserId,'userID');
				$strSuccessMessage = 'Password Successfully Updated';
			}

			showLogin($strUserName, $strUserPassword, $strErrorMessage, $strSuccessMessage);

		}
	}

}


// Authenticate User
if ($_SESSION['user_access'] > $secLvl) {

	$result = validateLogin($strUserName, $strUserPassword, $secLvl);

	//echo "<br />result=".$result;
	if ($result == 10) {
		if (!isset($_POST['loginButton'])) {

			if ($strCookieName != "") {
				$strUserName = $strCookieName;
				$strUserPassword = $strCookiePassword;
			}
		} else {
			$strErrorMessage = "You must enter a correct username and password before you can view this page.";
		}

		showLogin($strUserName, $strUserPassword, $strErrorMessage);

	} elseif ($result == 9) {
		$strErrorMessage = "Our site is experiencing technical difficulties, please try again later.";
		showLogin($strUserName, $strUserPassword, $strErrorMessage);
	} elseif ($result == 8) {
		$strErrorMessage = "You do not have access permissions to this section.";
		showLogin($strUserName, $strUserPassword, $strErrorMessage);
	} elseif ($result == 7) {
		$strErrorMessage = "Your account has now expired. Please contact an administrator.";
		showLogin($strUserName, $strUserPassword, $strErrorMessage);
	} else {
		if ($strUseCookie == 1) {
			$expCalc = round(30 * 24 * 60 * 60); // 30 days * 24hrs/day * 60min/hr * 60sec/min
			$expTime = time()+ "$expCalc";
			setcookie('password', $strUserPassword, $expTime);
			setcookie('username', $strUserName, $expTime);
			setcookie('user_access', $_SESSION['user_access'], $expTime);
		}
	}
}
//End Authenticate


// Check Username and Password, set the access level
function validateLogin($theUser,$thePassword,$securityLevel) {
	$db = new Database;

	// Hash our password
	$thePassword = Util::bcryptString($thePassword);

	$theUser = $db->getCleanVar($theUser);
	$thePassword = $db->getCleanVar($thePassword);

	$sql = "SELECT a.*
			FROM admins a
			WHERE LENGTH(user_name) > 0 And
			user_name='" . $theUser . "'
			and user_password='" . $thePassword . "' LIMIT 0,1";

	$columns = $db->getMysqliResults( $sql, true );

	if($columns == false) {
		// if the username and password is not found:
		$default = 10;
		return $default;
	}

	// if the username and password is found:
	if ($securityLevel >= $columns[0]['user_access']) {
		$_SESSION['userID'] = $columns[0]['userID'];
		$_SESSION['user_name'] = $columns[0]['user_name'];
		$_SESSION['user_alias'] = $columns[0]['user_alias'];
		$_SESSION['user_access'] = $columns[0]['user_access'];
		$_SESSION['is_admin'] = $columns[0]['is_admin'];
		$login = "";
		$default = 1;
	} else {
		$default = 8;
	}

	return $default;
}
//end check password.

function validateReset($theUser){

	$db = new Database;
	// Escape our pust value
	$theUser = $db->getCleanVar($theUser);

	$sql = 'SELECT a.*
			FROM admins a
			WHERE user_name = "'.$theUser.'"
			OR user_email = "'.$theUser.'"
			LIMIT 0,1';

	$results = $db->getMysqliResults($sql, true);

	if ($results) {
		$results = $results[0];
		return $results;
	} else {
		return false;
	}

}


function checkpageaccess($moduleName,$action){
    
    $db = new Database;
	    
    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
    $columns = $db->getMysqliResults( $sql, true );
    
    $_SESSION['is_admin'] = $columns[0]['is_admin'];
        
    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
        return true;
    }else{
        if(empty($action)){
            $action = 'view';
        }
        $userID = $_SESSION['userID']; 
        $query = "SELECT 
                p.can_add, p.can_edit, p.can_delete ,p.can_view 
            FROM 
                permissions p 
            INNER JOIN 
                modules m 
            ON 
                p.moduleID = m.moduleID 
            WHERE 
                p.userID = '$userID' 
                AND m.module_name = '$moduleName'";
        $result = $db->getMysqliResults($query, true);
        if (!empty($result)) {
            
            $permissions = $result[0];
            if ($action === null) {
                return true;
            }
            if (isset($permissions["can_$action"]) && $permissions["can_$action"] == 1) {
                return true;
            }else{
                return false;
            }
            
        }
        return false;
        
    }
    
}

function adminaccess($moduleName,$action){
    
    $db = new Database;
	    
    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
    $columns = $db->getMysqliResults( $sql, true );
    
    $_SESSION['is_admin'] = $columns[0]['is_admin'];
        
    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
        return true;
    }else{
        return false;
        
    }
    
}



// Show the Login Page
function showLogin($strUserName, $strUserPassword, $strErrorMessage = '', $strSuccessMessage = '') {
    include(ROOT_DIR."/application/views/login.php");
	exit();
}
