<?php
/**
* The Header template for the Admin
*
* Displays all of the <head> section and everything up to <div id=age-wrapper">
*
* @package Navigator Multimedia Inc HTML 5 Boiler Template
* @subpackage Name Of Site We Are Working on
* @since HTML 5 Boiler Template 1.0
*/
?>
<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="utf-8">

            <!-- META TAGS FOR SEARCH ENGINES -->
            <title><?php echo $objSettings->strSiteName; ?> Admin</title>

            <!-- CONTROLS THE LAYOUT OF MOBILE BROWSERS-->
            <meta name="viewport" content="width=device-width, initial-scale=1, minimal-ui">

            <!-- FAVICON -->
            <link rel="icon" type="image/x-icon" href="<?php echo ROOT_URL; ?>/application/images/favicon.ico" />

            <!-- CSS -->
            <!-- Bootstrap latest compiled and minified CSS -->
            <link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.1.1/css/bootstrap.min.css">
            <!-- Google Font -->
            <link href='//fonts.googleapis.com/css?family=Open+Sans:400,700,300' rel='stylesheet' type='text/css'>
            <!-- Font Awsome CSS -->
            <link rel='stylesheet' href="//maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" />
            <!-- Mini Colors CSS -->
            <link rel="stylesheet" type="text/css" href="/application/css/admin/minicolors.css" />
            <link rel="stylesheet" type="text/css" href="/application/css/jquery-ui-timepicker-addon.css">
            <!-- Navigator CSS -->
            <link rel="stylesheet" href="/application/css/admin/admin.css">

            <!-- LOAD JQUERY -->
            <script src="//code.jquery.com/jquery-1.11.0.min.js"></script>
            <script src="/application/js/jquery.mb.browser.min.js"></script>
            <script src="/application/js/jquery.webkitresize.js"></script>
            <script src="//maps.googleapis.com/maps/api/js?key=AIzaSyCAEI0_8xMbaP_3Z7MBgAisGPqPZA2MeZ4&amp;sensor=false"></script>
            <script src="//www.google.com/jsapi"></script>
            <script src="//ajax.googleapis.com/ajax/libs/jqueryui/1.8/jquery-ui.min.js"></script>
            <link href="//ajax.googleapis.com/ajax/libs/jqueryui/1.8/themes/redmond/jquery-ui.css" rel="stylesheet" type="text/css"/>
            <script src="//code.jquery.com/jquery-migrate-1.2.1.js"></script>

            <!-- Wysiwyg Editor Styles -->
            <link rel="Stylesheet" type="text/css" href="/application/vendor/jHtmlArea/style/custom.css" />
            <link rel="Stylesheet" type="text/css" href="/application/vendor/jHtmlArea/style/jHtmlArea.css" />
            <link rel="Stylesheet" type="text/css" href="/application/vendor/jHtmlArea/style/jHtmlArea.ColorPickerMenu.css" />
            <script type="text/javascript" src="/application/vendor/jHtmlArea/scripts/jHtmlArea-0.8.js"></script>
            <script type="text/javascript" src="/application/vendor/jHtmlArea/settings.js"></script>

            <!-- Custom Scripts -->
            <script type="text/javascript" src="/application/js/admin/minicolors.min.js"></script>
            <script type="text/javascript" src="/application/js/admin/admin.js"></script>
            <script type="text/javascript" src="/application/js/admin/cycle.js"></script>
            <script type="text/javascript" src="/application/js/jquery-ui-timepicker-addon.js"></script>

            <!-- Custom Javascript Controls -->
            <script type="text/javascript" src="<?php echo ROOT_URL; ?>/application/js/admin/ctrl_parentRateChanger.js"></script>
            <script type="text/javascript" src="<?php echo ROOT_URL; ?>/application/js/admin/ctrl_typeChanger.js"></script>
        </head>

        <body>

            <div id="wrapper">

                <nav class="navbar navbar-inverse navbar-fixed-top" role="navigation">
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-ex1-collapse">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        <a class="navbar-brand" href="/"><?php echo $objSettings->strSiteName; ?> Admin</a>
                    </div>

                    <!--  Main Navigation for Admin -->
                    <div class="collapse navbar-collapse navbar-ex1-collapse">
                        <ul class="nav navbar-nav side-nav navbar-nav-main">
                            <!-- <li><a><?php echo $strController; ?></a></li> -->
                            <li title="Dashboard" class="<?php Util::getNavClass($strController,'dashboard_controller'); ?>">
                                <a href="/admin/"><i class="fa fa-dashboard"></i> Dashboard</a>
                            </li>
                            <?php if(checkpageaccess('page','add') == 'ture' || checkpageaccess('page','view') == 'ture'){ ?>
                            <li title="Pages" class="<?php Util::getNavClass($strController,array('page_controller','page_images_controller')); ?>">
                                <a href="#sub-menu-pages" data-toggle="<?php Util::getNavToggle($strController,array('page_controller','page_images_controller')); ?>" ><i class="fa fa-file-image-o"></i> Pages</a>
                                <div id="sub-menu-pages" class="sub-nav <?php Util::getNavToggle($strController,array('page_controller','page_images_controller')); ?>">
                                    <ul>
                                        <?= (checkpageaccess('page','view'))?'<li><a href="/admin/page/">View All</a></li>':''?>
                                        <?= (checkpageaccess('page','add'))?'<li><a href="/admin/page/add/">Add New</a></li>':''?>
                                    </ul>
                                </div>
                            </li>
                            <?php } if(checkpageaccess('region','add') == 'ture' || checkpageaccess('region','view') == 'ture' || checkpageaccess('state','add') == 'ture' || checkpageaccess('state','view') == 'ture' || checkpageaccess('city','add') == 'ture' || checkpageaccess('city','view') == 'ture' ){ ?> 
                            <li title="Regions" class="<?php Util::getNavClass($strController,array('region_controller','city_controller','state_controller','region_images_controller')); ?>">
                                <a href="#sub-menu-regions" data-toggle="<?php Util::getNavToggle($strController,array('region_controller','city_controller','state_controller','region_images_controller')); ?>" ><i class="fa fa-globe"></i> Regions</a>
                                <div id="sub-menu-regions" class="sub-nav <?php Util::getNavToggle($strController,array('region_controller','city_controller','state_controller','region_images_controller')); ?>">
                                    <ul>
                                        <?= (checkpageaccess('region','view'))?'<li><a href="/admin/region/">View All Regions</a></li>':''?>
                                        <?= (checkpageaccess('region','view'))?'<li><a href="/admin/region/add/">Add New</a></li>':''?>
                                        <?= (checkpageaccess('state','view'))?'<li><a href="/admin/state/">View All States</a></li>':''?>
                                        <?= (checkpageaccess('state','view'))?'<li><a href="/admin/state/add/">Add New</a></li>':''?>
                                        <?= (checkpageaccess('city','view'))?'<li><a href="/admin/city/">View All Cities</a></li>':''?>
                                        <?= (checkpageaccess('city','view'))?'<li><a href="/admin/city/add/">Add New</a></li>':''?>
                                    </ul>
                                </div>
                            </li>
                            <?php } if(checkpageaccess('brand','add') == 'ture' || checkpageaccess('brand','view') == 'ture' || checkpageaccess('booking','add') == 'ture' || checkpageaccess('booking','view') == 'ture'){ ?> 
                            <li title="WL Brands" class="<?php Util::getNavClass($strController,array('brand_controller','booking_controller')); ?>">
                                <a href="#sub-menu-brands" data-toggle="<?php Util::getNavToggle($strController,array('brand_controller','booking_controller')); ?>" ><i class="fa fa-edit"></i> WL Brands</a>
                                <div id="sub-menu-brands" class="sub-nav <?php Util::getNavToggle($strController,array('brand_controller','booking_controller')); ?>">
                                    <ul>
                                        <?= (checkpageaccess('brand','view'))?'<li><a href="/admin/brand/">View All</a></li>':''?>
                                        <?= (checkpageaccess('brand','add'))?'<li><a href="/admin/brand/add/">Add New</a></li>':''?>
                                        <?= (checkpageaccess('booking','view'))?'<li><a href="/admin/booking/">Booking People</a></li>':''?>
                                        <?= (checkpageaccess('booking','add'))?'<li><a href="/admin/booking/add/">Add New</a></li>':''?>
                                    </ul>
                                </div>
                            </li>
                            <?php } if(checkpageaccess('member','add') == 'ture' || checkpageaccess('member','view') == 'ture'){ ?> 
                            <li title="Members" class="<?php Util::getNavClass($strController,'member_controller'); ?>">
                                <a href="#sub-menu-members" data-toggle="<?php Util::getNavToggle($strController,'member_controller'); ?>" ><i class="fa fa-user"></i> Members</a>
                                <div id="sub-menu-members" class="sub-nav <?php Util::getNavToggle($strController,'member_controller'); ?>">
                                    <ul>
                                        <?= (checkpageaccess('member','view'))?'<li><a href="/admin/member/">View All</a></li>':''?>
                                        <?= (checkpageaccess('member','add'))?'<li><a href="/admin/member/add/">Add New</a></li>':''?>
                                    </ul>
                                </div>
                            </li>
                            <?php } if(checkpageaccess('course','add') == 'ture' || checkpageaccess('course','view') == 'ture' || checkpageaccess('coursecat','add') == 'ture' || checkpageaccess('coursecat','view') == 'ture'){ ?> 
                            <li title="Courses" class="<?php Util::getNavClass($strController,array('course_controller','coursecat_controller','course_videos_controller','course_images_controller','course_reviews_controller','course_testimonials_controller')); ?>">
                                <a href="#sub-menu-course" data-toggle="<?php Util::getNavToggle($strController,array('course_controller','coursecat_controller','course_videos_controller','course_images_controller','course_reviews_controller','course_testimonials_controller')); ?>" ><i class="fa fa-flag"></i> Courses</a>
                                <div id="sub-menu-course" class="sub-nav <?php Util::getNavToggle($strController,array('course_controller','coursecat_controller','course_videos_controller','course_images_controller','course_reviews_controller','course_testimonials_controller')); ?>">
                                    <ul>
                                        <?= (checkpageaccess('course','view'))?'<li><a href="/admin/course/">View All</a></li>':''?>
                                        <?= (checkpageaccess('course','add'))?'<li><a href="/admin/course/add/">Add New</a></li>':''?>
                                        <?= (checkpageaccess('coursecat','view'))?'<li><a href="/admin/coursecat/">Course Categories</a></li>':''?>
                                        <?= (checkpageaccess('coursecat','add'))?'<li><a href="/admin/coursecat/add/">Add New</a></li>':''?>
                                    </ul>
                                </div>
                            </li>
                            <?php } if(checkpageaccess('hotel','add') == 'ture' || checkpageaccess('hotel','view') == 'ture' || checkpageaccess('hotelcat','add') == 'ture' || checkpageaccess('hotelcat','view') == 'ture'){ ?> 
                            <li title="Hotels" class="<?php Util::getNavClass($strController,array('hotel_controller','hotelcat_controller','hotel_docs_controller','hotel_images_controller','hotel_videos_controller')); ?>">
                                <a href="#sub-menu-hotel" data-toggle="<?php Util::getNavToggle($strController,array('hotel_controller','hotelcat_controller','hotel_docs_controller','hotel_images_controller','hotel_videos_controller')); ?>" ><i class="fa fa-building"></i> Hotels</a>
                                <div id="sub-menu-hotel" class="sub-nav <?php Util::getNavToggle($strController,array('hotel_controller','hotelcat_controller','hotel_docs_controller','hotel_images_controller','hotel_videos_controller')); ?>">
                                    <ul>
                                        <?= (checkpageaccess('hotel','view'))?'<li><a href="/admin/hotel/">View All</a></li>':''?>
                                        <?= (checkpageaccess('hotel','add'))?'<li><a href="/admin/hotel/add/">Add New</a></li>':''?>
                                        <?= (checkpageaccess('hotelcat','view'))?'<li><a href="/admin/hotelcat/">Hotel Categories</a></li>':''?>
                                        <?= (checkpageaccess('hotelcat','add'))?'<li><a href="/admin/hotelcat/add/">Add New</a></li>':''?>
                                    </ul>
                                </div>
                            </li>
                            <?php } if(checkpageaccess('quote-group','add') == 'ture' || checkpageaccess('quote-group','view') == 'ture'){ ?> 
                            <li title="Quotes" class="<?php Util::getNavClass($strController,array('quote_controller')); ?>">
                                <a href="#sub-menu-quote" data-toggle="<?php Util::getNavToggle($strController,array('quote_controller')); ?>" ><i class="fa fa-edit"></i> Quotes</a>
                                <div id="sub-menu-quote" class="sub-nav <?php Util::getNavToggle($strController,array('quote_controller')); ?>">
                                    <ul>
                                        <?= (checkpageaccess('quote-group','view'))?'<li><a href="/admin/quote-group/">View All</a></li>':''?>
                                        <?= (checkpageaccess('quote-group','add'))?'<li><a href="/admin/quote-group/add/">Add New</a></li>':''?>
                                    </ul>
                                </div>
                            </li>
                            <?php } if(checkpageaccess('package','add') == 'ture' || checkpageaccess('package','view') == 'ture' || checkpageaccess('packagecat','view') == 'ture'){ ?> 
                            <li title="Packages" class="<?php Util::getNavClass($strController,array('package_controller','packagecat_controller','trackcode_controller')); ?>">
                                <a href="#sub-menu-package" data-toggle="<?php Util::getNavToggle($strController,array('package_controller','packagecat_controller','trackcode_controller')); ?>" ><i class="fa fa-edit"></i> Packages</a>
                                <div id="sub-menu-package" class="sub-nav <?php Util::getNavToggle($strController,array('package_controller','packagecat_controller','trackcode_controller')); ?>">
                                    <ul>
                                        <?php if(checkpageaccess('package','view')){ ?>
                                        <li><a href="/admin/package/?grid_date=dates_arrival&year=<?php echo date('Y') ?>">View All</a></li>
                                        <?php } ?>
                                        <?= (checkpageaccess('package','add'))?'<li><a href="/admin/package/add/">Add New</a></li>':''?>
                                        <?= (checkpageaccess('packagecat','view'))?'<li><a href="/admin/packagecat/">Package Statuses</a></li>':''?>
                                       <!-- <li><a href="/admin/trackcode/">Track Codes</a></li>-->
                                    </ul>
                                </div>
                            </li>
                            <?php } if(checkpageaccess('featured_package','add') == 'ture' || checkpageaccess('featured_package','view') == 'ture'){ ?> 
                            <li title="Featured Packages" class="<?php Util::getNavClass($strController,array('featured_package_controller')); ?>">
                                <a href="#sub-menu-featured_package" data-toggle="<?php Util::getNavToggle($strController,array('featured_package_controller')); ?>" ><i class="fa fa-edit"></i> Featured Packages</a>
                                <div id="sub-menu-featured_package" class="sub-nav <?php Util::getNavToggle($strController,array('featured_package_controller')); ?>">
                                    <ul>
                                        <?= (checkpageaccess('featured_package','view'))?'<li><a href="/admin/featured_package/">View All</a></li>':''?>
                                        <?= (checkpageaccess('featured_package','add'))?'<li><a href="/admin/featured_package/add/">Add New</a></li>':''?>
                                    </ul>
                                </div>
                            </li>
                            <?php } if(checkpageaccess('mass_mailer','view') == 'ture'){ ?> 
                            <li title="Mass Mailer" class="<?php Util::getNavClass($strController,array('featured_package_controller')); ?>">
                                <a href="/admin/mass_mailer/"><i class="fa fa-edit"></i> Mass Mailer</a>
                            </li>
                            <?php } if(checkpageaccess('report_hotel','view') == 'ture' || checkpageaccess('report_hotel_detail_range','view') == 'ture' || checkpageaccess('report_course','view') == 'ture' || checkpageaccess('report_course_detail_range','view') == 'ture' || checkpageaccess('report_cc_decrypt','view') == 'ture' || checkpageaccess('report_payment_golf','view') == 'ture' || checkpageaccess('report_payment_hotel','view') == 'ture' || checkpageaccess('report_paypal','view') == 'ture'){  ?>
                            <li title="Reports" class="<?php Util::getNavClass($strController,array('report_controller')); ?>">
                                <a href="#sub-menu-reports" data-toggle="<?php Util::getNavToggle($strController,array('report_controller')); ?>" ><i class="fa fa-pie-chart"></i> Reports</a>
                                <div id="sub-menu-reports" class="sub-nav <?php Util::getNavToggle($strController,array('report_controller')); ?>">
                                    <ul>
                                        <?= (checkpageaccess('report_hotel','view'))?'<li><a href="/admin/report/hotel/">Accommodation Report</a></li>':''?>
                                        <?= (checkpageaccess('report_hotel_detail_range','view'))?'<li><a href="/admin/report/hotel_detail_range/">Accommodation Detail Range</a></li>':''?>
                                        <?= (checkpageaccess('report_course','view'))?'<li><a href="/admin/report/course/">Course Report</a></li>':''?>
                                        <?= (checkpageaccess('report_course_detail_range','view'))?'<li><a href="/admin/report/course_detail_range/">Course Detail Range</a></li>':''?>
                                        <?= (checkpageaccess('report_cc_decrypt','view'))?'<li><a href="/admin/report/cc_decrypt/">Decrypt CC Number</a></li>':''?>
                                        <?= (checkpageaccess('report_payment_golf','view'))?'<li><a href="/admin/report/payment_golf/">Payment To Golf Course</a></li>':''?>
                                        <?= (checkpageaccess('report_payment_hotel','view'))?'<li><a href="/admin/report/payment_hotel/">Payment To Hotels</a></li>':''?>
                                        <?= (checkpageaccess('report_paypal','view'))?'<li><a href="/admin/report/paypal/">Paypal Report</a></li>':''?>
                                    </ul>
                                </div>
                            </li>
                            <?php } if(checkpageaccess('rates_calculator','view') == 'ture' || checkpageaccess('rates','view') == 'ture' || checkpageaccess('rate_course','view') == 'ture' || checkpageaccess('rate_hotel','view') == 'ture'){ ?> 

                            <li title="Rates" class="<?php Util::getNavClass($strController, array('rates_controller')); ?>">
                                <a href="#sub-menu-rates" data-toggle="<?php Util::getNavToggle($strController, array('rates_controller')); ?>" ><i class="fa fa-line-chart"></i> Rates</a>
                                <div id="sub-menu-rates" class="sub-nav <?php Util::getNavToggle($strController, array('rates_controller')); ?>">
                                    <ul>
                                        <?= (checkpageaccess('rates_calculator','view'))?'<li><a href="/admin/rates/calculator/">Calculator</a></li>':''?>
                                        <?= (checkpageaccess('rates','view'))?'<li><a href="/admin/rates/">Manage Rates</a></li>':''?>
                                        <?= (checkpageaccess('rate_course','view'))?'<li><a href="/admin/rates/course/">Course Rates</a></li>':''?>
                                        <?= (checkpageaccess('rate_hotel','view'))?'<li><a href="/admin/rates/hotel/">Hotel Rates</a></li>':''?>
                                    </ul>
                                </div>
                            </li>
                            <?php } if(adminaccess('settings','view') == 'ture' || adminaccess('settings','view') == 'ture'){ ?> 

                            <li title="settings" class="<?php Util::getNavClass($strController, array('settings_controller', 'profile_controller')); ?>">
                                <a href="#sub-menu-settings" data-toggle="<?php Util::getNavToggle($strController, array('settings_controller', 'profile_controller')); ?>" ><i class="fa fa-cog"></i> Admin Settings</a>
                                <div id="sub-menu-settings" class="sub-nav <?php Util::getNavToggle($strController, array('settings_controller', 'profile_controller')); ?>">
                                    <ul>
                                        <li><a href="/admin/settings/">Site Settings</a></li>
                                        <li><a href="/admin/report/payment/">Payment Report</a></li>
                                        <?php if($_SESSION['user_access'] ==0) { ?>
                                        <li><a href="/admin/report/package/">Golf Package Report</a></li>
                                        <?php } ?>
                                        <li><a href="/admin/user">Users</a></li>
                                    </ul>
                                </div>
                            </li>
                            <?php } ?>
                            <li title="Collapse / Reveal Menu" class="collapse-menu">
                                <a href="#"><span class="fa fa-chevron-circle-left"></span><small> Collapse</small></a>
                            </li>
                        </ul>

                        <!-- Header Navigation for Admin -->
                        <ul class="nav navbar-nav navbar-right navbar-user">
                            <?php /*
                            <li class="dropdown messages-dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-envelope"></i> Messages <span class="badge">7</span> <b class="caret"></b></a>
                                <ul class="dropdown-menu">
                                    <li class="dropdown-header">7 New Messages</li>
                                    <li class="message-preview">
                                        <a href="#">
                                        <span class="avatar"><img src="http://placehold.it/50x50"></span>
                                        <span class="name">John Smith:</span>
                                        <span class="message">Hey there, I wanted to ask you something...</span>
                                        <span class="time"><i class="fa fa-clock-o"></i> 4:34 PM</span>
                                        </a>
                                    </li>
                                    <li class="divider"></li>
                                    <li class="message-preview">
                                        <a href="#">
                                        <span class="avatar"><img src="http://placehold.it/50x50"></span>
                                        <span class="name">John Smith:</span>
                                        <span class="message">Hey there, I wanted to ask you something...</span>
                                        <span class="time"><i class="fa fa-clock-o"></i> 4:34 PM</span>
                                        </a>
                                    </li>
                                    <li class="divider"></li>
                                    <li class="message-preview">
                                        <a href="#">
                                        <span class="avatar"><img src="http://placehold.it/50x50"></span>
                                        <span class="name">John Smith:</span>
                                        <span class="message">Hey there, I wanted to ask you something...</span>
                                        <span class="time"><i class="fa fa-clock-o"></i> 4:34 PM</span>
                                        </a>
                                    </li>
                                    <li class="divider"></li>
                                    <li><a href="#">View Inbox <span class="badge">7</span></a></li>
                                </ul>
                            </li>
                            <li class="dropdown alerts-dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-bell"></i> Alerts <span class="badge">3</span> <b class="caret"></b></a>
                                <ul class="dropdown-menu">
                                    <li><a href="#">Default <span class="label label-default">Default</span></a></li>
                                    <li><a href="#">Primary <span class="label label-primary">Primary</span></a></li>
                                    <li><a href="#">Success <span class="label label-success">Success</span></a></li>
                                    <li><a href="#">Info <span class="label label-info">Info</span></a></li>
                                    <li><a href="#">Warning <span class="label label-warning">Warning</span></a></li>
                                    <li><a href="#">Danger <span class="label label-danger">Danger</span></a></li>
                                    <li class="divider"></li>
                                    <li><a href="#">View All</a></li>
                                </ul>
                            </li>
                            */ ?>
                            <li class="dropdown user-dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user"></i> <?php echo $_SESSION['user_alias']; ?> <b class="caret"></b></a>
                                <ul class="dropdown-menu">
                                    <li><a href="/admin/profile/"><i class="fa fa-user"></i> Profile</a></li>
                                    <?php if(adminaccess('settings','view') == 'ture' ){ ?>
                                    <li><a href="/admin/settings/"><i class="fa fa-gear"></i> Settings</a></li>
                                    <?php } ?>
                                    <li class="divider"></li>
                                    <li><a href="?logout=true"><i class="fa fa-power-off"></i> Log Out</a></li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </nav>

                <div id="page-wrapper">

