<?php


class Youtube extends Database  {

	public $strQuery;
	public $strErrorMessage;
	public $strSuccessMessage;

	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";
	}

    /**
     * Sets up the youtube video header
     */
    public function displayYoutubeHeader($arrArgs) {

        if ($arrArgs['strVideoCode'] == '') {
            return '';
        }

        $arrTemplateArgs = array(
            'strVideoCode' => 'PsMgSe6__9w',
            'strVideoSmallHeading' => 'SEE IT ALL',
            'strVideoLargeHeading' => 'BOOK ONLINE NOW',
            'strVideoText' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sodales varius tortor vitae sollicitudin. Sed pulvinar fringilla nisl vel commodo. Proin ac turpis quis nibh tempus egestas in vitae quam. Duis scelerisque accumsan dui. Phasellus nec orci cursus, commodo felis vitae, lacinia nisi.',
            'strVideoBtnText' => 'BOOK NOW',
            'strVideoLink' => 'booking',
        );

        foreach ($arrTemplateArgs as $strKey => $strVal ) {
            if (!isset($arrArgs[$strKey])) {
                $arrArgs[$strKey] = $arrTemplateArgs[$strKey];
            }
        }

        $strHtml = '';

        // Set the video options
        $strVideoOptions = http_build_query(array(
            'mute' => 1,
            'autoplay' => 1,
            'loop' => 1,
            'rel' => 0,
            'controls' => 0,
            'showinfo' => 0,
            'modestbranding' => 0,
            'fs' => 0,
            'playlist' => $arrArgs['strVideoCode'],
        ));

        $strVideoSrc = 'https://www.youtube.com/embed/' . $arrArgs['strVideoCode'] . '?' . $strVideoOptions;

        $strHtml .= '<div class="video-header-container">'
                  . '<div class="video-overlay"></div>'
                  . '<div class="youtube-video embed-responsive embed-responsive-16by9">'
                  . '<iframe class="embed-responsive-item" src="' . $strVideoSrc . '" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope;"></iframe>'
                  . '</div>';

        if (!empty($arrArgs['strVideoSmallHeading']) || !empty($arrArgs['strVideoLargeHeading']) || !empty($arrArgs['strVideoText'])) {
            $strHtml .= '<div class="cta-caption">';

            if (!empty($arrArgs['strVideoSmallHeading'])) {
                $strHtml .= '<p class="h6 no-top-margin font-uppercase color-light font-light font-primary">' . $arrArgs['strVideoSmallHeading'] . '</p>';
            }

            if (!empty($arrArgs['strVideoLargeHeading'])) {
                $strHtml .= '<p class="h1 font-uppercase color-light font-secondary no-top-margin">' . $arrArgs['strVideoLargeHeading'] . '</p>';
            }

            if (!empty($arrArgs['strVideoText'])) {
                $strHtml .= '<p class="font-light">' . nl2br($arrArgs['strVideoText']) . '</p>';
            }

            if (!empty($arrArgs['strVideoBtnText']) && !empty($arrArgs['strVideoLink'])) {
                $strHtml .= '<a class="btn btn-primary btn-lg" href="' . $arrArgs['strVideoLink'] . '">' . $arrArgs['strVideoBtnText'] . '</a>';
            }

            $strHtml .= '</div>';
        }

        $strHtml .= '</div>';

        echo $strHtml;
    }

	public function getTYPage($strRequest,$debug = false) {



		if(strpos($strRequest,"v=") > 0 || strpos($strRequest,"http://youtu.be/") > 0 || strpos($strRequest,"/embed/") > 0 || strpos($strRequest,"/v/") > 0) {

			if($debug){

				//echo '<br />$strRequest='.$strRequest;

			}


			$search = "";

			if(strpos($strRequest,"v=") > 0) {
				$firstPos = strpos($strRequest,"v=")+2;
				if(strpos($strRequest,"&",$firstPos) > 0) {
					$secPos = strpos($strRequest,"&",$firstPos);
					$search = substr($strRequest,$firstPos,($secPos-$firstPos));
				} else {
					$search = substr($strRequest,$firstPos,strlen($strRequest)-$firstPos+1);
				}
			} elseif(strpos($strRequest,"/embed/") > 0) {
				$firstPos = strpos($strRequest,"/embed/")+7;
				if(strpos($strRequest,"&",$firstPos) > 0) {
					$secPos = strpos($strRequest,"&",$firstPos);
					$search = substr($strRequest,$firstPos,($secPos-$firstPos));
				} else {
					$search = substr($strRequest,$firstPos,strlen($strRequest)-$firstPos+1);
				}
			} elseif(strpos($strRequest,"/v/") > 0) {
				$firstPos = strpos($strRequest,"/v/")+3;
				if(strpos($strRequest,"&",$firstPos) > 0) {
					$secPos = strpos($strRequest,"&",$firstPos);
					$search = substr($strRequest,$firstPos,($secPos-$firstPos));
				} else {
					$search = substr($strRequest,$firstPos,strlen($strRequest)-$firstPos+1);
				}

			} else {
				$search = str_replace("http://youtu.be/","",$strRequest);
			}


			$url = "https://www.googleapis.com/youtube/v3/videos?part=snippet+&id=" . $search . "&key=" . GOOGLE_API_KEY;

			//getTYPage = url

			// $entry = @simplexml_load_file($url);

			$json = file_get_contents($url);
            //var_dump($json);

			$entry = json_decode($json, true);
            //var_dump($entry);
            //die();
			if(!empty($entry)){
				$entry = $entry['items'][0];
			}

// echo '<pre>';
// print_r($entry);
// die();

			if(!$entry) {
				$video = null;
			} else {
				$video = $this->parseVideoEntry($entry,$search);
			}


			return $video;
			//return 'url='.$url.'<br/>'.$this->getTYstring($content);
		}

	}


	public function parseVideoEntry($entry,$search) {
      $obj= new stdClass;

      $obj->title = $entry['snippet']['title'];
      $obj->description = $entry['snippet']['description'];
      $obj->key = $entry['id'];

      // get video player URL
      $obj->watchURL = 'https://youtube.com/v/' . $entry['id'];

      // get video thumbnail
      $obj->thumbnailURL = $entry['snippet']['thumbnails']['high']['url'];

      // not supported in youtube api v3
      $obj->thumbnailURL1 = null;
      $obj->thumbnailURL2 = null;
      $obj->thumbnailURL3 = null;
      $obj->length = null;
      $obj->viewCount = null;
      $obj->rating = null;
      $obj->commentsURL = null;
      $obj->commentsCount = null;
      $obj->responsesURL = null;
      $obj->relatedURL = null;

      // return object to caller
      return $obj;
    }



}







?>