<?php

class Util {


	/**
	 * Generates Bootstrap HTML for pagination
	 * Outputs HTML with no return value
	 */

	public static function getPagination($pg, $pages, $pageName, $options = '', $pgSize = 50) {
		if($pages > 1) {
			//$page_url = $pageName.'?pgSize='.$pgSize.$options.'&pg='
			if($pg < 1) $pg = 1;
			if($pg > $pages) $pg = $pages;
			$page_url = $pageName;

			?>
			<ul class="grid-pagination pagination pagination-sm">
				<li><a href="<?php echo $page_url.'?pg='.($pg-1);?><?php echo $options;?>">&laquo;</a></li>
			  	<?php for($x=1;$x<=$pages;$x++) {
			    	$class = $x == $pg ? ' class="active"' : ''; ?>
			  	<li <?php echo $class; ?>><a href="<?php echo $page_url.'?pg='.$x.$options;?>"><?php echo $x; ?></a></li>
			  	<?php }  ?>
			  	<li><a href="<?php echo $page_url.'?pg='.($pg+1);?><?php echo $options;?>">&raquo;</a></li>
			</ul>
			<?php
		}
	}



	/**
	 * Slightly different pagination style so that we don't have an endless list of pages
	 * Outputs HTML with no return value
	 */
	public static function getAdminPagination($pg, $records, $pageName, $options = '', $pgSize = 50) {
        ?>
        <div class="grid-pagination">
            <?php
            if (empty($records)) $records = 0;
            echo '<span class="pagination-items">'.$records.' Items</span>';

            $pages = $records > 0 && $pgSize > 0 ? ceil($records / $pgSize) : 1;

            if($pg < 1) $pg = 1;
            if($pg > $pages) $pg = $pages;

            $nextPage = $pg + 1;
            $prevPage = $pg - 1;

            ?>
			<ul class="pagination pagination-sm">
				<li><a href="<?php echo $pageName.$options."&amp;pg=1"; ?>">&laquo; First</a></li>

				<?php if ($prevPage >= 1) { ?>
				<li><a href="<?php echo $pageName.$options."&amp;pg=$prevPage" ?>" title="Previous Page">&lsaquo;</a></li>
				<?php } ?>

				<li class="active"><span><?php echo 'Page '.$pg.' of '.$pages; ?></span></li>

				<?php if ($nextPage <= $pages) { ?>
				<li><a href="<?php echo $pageName.$options."&amp;pg=$nextPage" ?>" title="Next Page">&rsaquo;</a></li>
				<?php } ?>

				<li><a href="<?php echo $pageName.$options."&amp;pg=$pages" ?>">Last &raquo;</a></li>
			</ul>
        </div>
		<?php
	}

    /**
     * Only outputs record count - used for pages where pagination is broken
     */
    public static function getAdminRecordCount($records) {
        ?>
        <div class="grid-pagination">
            <?php
            if (empty($records)) $records = 0;
            echo '<span class="pagination-items">'.$records.' Items</span>';
            ?>
        </div>
        <?php
    }



	/**
	 * Default check against another value, will return true if the return is not specified
	 *
	 * @return boolen / specified value
	 */
	public static function isValue($first, $second, $return = true) {

		// Check if the second parameter is a array check each value in the array
		if (is_array($second)) {
			if (in_array($first, $second)) {
				return $return;
			}
		} else if ($first == $second) {
			return $return;
		}

		// Retrn false
		return false;

	}



	/**
	 * Checks two values and returns the select attribute if true
	 * For use in HTML select boxes
	 *
	 * @return string
	 */
	public static function isSelected($first, $second) {
		$selected = '';
		if(is_array($first)) {
			foreach($first As $f) {
				if($f == $second) {
					$selected = ' selected="selected"';
					break;
				}
			}
		} else {
			if($first == $second) {
				$selected = ' selected="selected"';
			}
		}
		return $selected;
	}



	/**
	 * Checks two calues and returns the checked attribute if true
	 * For use in HTML checkboxes
	 *
	 * @return string
	 */
	public static function isChecked($first, $second) {
		$checked = '';
		if(is_array($first)) {
			foreach($first As $f) {
				if($f == $second) {
					$checked = ' checked="checked"';
					break;
				}
			}
		} else {
			if($first == $second) {
				$checked = ' checked="checked"';
			}
		}
		return $checked;
	}



	/**
	 * Generates a table header with column titles and sort links
	 *
	 * @return string
	 */
	public static function sortingTableHeader($pageName, $tableSQLArray, $tableDisplayArray, $tableSortArray, $sortBy, $sortOrder, $pgNum, $pgSize, $linkVar) {

		$buildVar = '<tr>';

		if($sortOrder == '' || $sortOrder == 'ASC') {
			$sortOrder = 'ASC';
			$revSortOrder = 'DESC';
			$arrow = 'dropup';
		} else {
			$revSortOrder = 'ASC';
			$arrow = '';
		}

		for ($i=0; $i<=(count($tableSQLArray)-1); $i++) {

			if($tableSQLArray[$i] <> '') {
				$buildVar .= '<th class="'.$tableSQLArray[$i].'" >';
			} else {
				$buildVar .= '<th>';
			}

			if($tableSortArray[$i] == 'true') {

				if(($sortBy == $tableSQLArray[$i])==1) {

					$buildVar .= '<a class="'.$arrow.'" href="'.$pageName.'?sortBy='.$tableSQLArray[$i].'&amp;sortOrder='.$revSortOrder.'&amp;pgSize='.$pgSize.'&amp;pgNum='.$pgNum.$linkVar.'">'.$tableDisplayArray[$i].' <span class="caret"></span></a></i>';
				} else {
					$buildVar .= '<a href="'.$pageName.'?sortBy='.$tableSQLArray[$i].'&amp;sortOrder='.$sortOrder.'&amp;pgSize='.$pgSize.'&amp;pgNum='.$pgNum.$linkVar.'">'.$tableDisplayArray[$i].'</a>';
				}
			 } else {
				$buildVar .= $tableDisplayArray[$i];
			 }

			 $buildVar .= '</th>';
		}

		$buildVar .= '</tr>';

		return $buildVar;

	}


	public static function sortingTableHeaderNoTh($pageName, $tableSQLArray, $tableDisplayArray, $tableSortArray, $sortBy, $sortOrder, $pgNum, $pgSize, $linkVar) {

		$buildVar = '<tr>';

		if($sortOrder == '' || $sortOrder == 'ASC') {
			$sortOrder = 'ASC';
			$revSortOrder = 'DESC';
			$arrow = 'dropup';
		} else {
			$revSortOrder = 'ASC';
			$arrow = '';
		}

		for ($i=0; $i<=(count($tableSQLArray)-1); $i++) {

			if($tableSQLArray[$i] <> '') {
				$buildVar .= '<td id="'.$tableSQLArray[$i].'" >';
			} else {
				$buildVar .= '<td>';
			}

			if($tableSortArray[$i] == 'true') {

				if(($sortBy == $tableSQLArray[$i])==1) {

					$buildVar .= '<a class="'.$arrow.'" href="'.$pageName.'?sortBy='.$tableSQLArray[$i].'&amp;sortOrder='.$revSortOrder.'&amp;pgSize='.$pgSize.'&amp;pgNum='.$pgNum.$linkVar.'">'.$tableDisplayArray[$i].' <span class="caret"></span></a></i>';
				} else {
					$buildVar .= '<a href="'.$pageName.'?sortBy='.$tableSQLArray[$i].'&amp;sortOrder='.$sortOrder.'&amp;pgSize='.$pgSize.'&amp;pgNum='.$pgNum.$linkVar.'">'.$tableDisplayArray[$i].'</a>';
				}
			 } else {
				$buildVar .= $tableDisplayArray[$i];
			 }

			 $buildVar .= '</td>';
		}

		$buildVar .= '</tr>';

		return $buildVar;

	}


	/**
	 * Validates a string as a PHP DateTime Object
	 *
	 */
	public static function validateDate($date) {
	    $d = DateTime::createFromFormat('Y-m-d', $date);
	    return $d && $d->format('Y-m-d') == $date;
	}



	/**
	 * Cleans a string for display in HTML
	 * decodes and then reencodes entities for consistant output;
     *
	 * @return string
	 */
	public static function cleanForHtml($string, $tags = true) {
		if ($tags) {
			$string = strip_tags($string);
		}
		$string = trim($string);
		$string = stripslashes($string);
		$string = htmlspecialchars(htmlspecialchars_decode($string), ENT_QUOTES);

        $string = str_replace('&amp;nbsp;', '&nbsp;', $string); // Replace &nbsp; since it's not handled by htmlspecialchars

		// Replace <> so we dont break html tags
		$string = str_replace('&gt;', '>', $string);
		$string = str_replace('&lt;', '<', $string);
		$string = str_replace("\r", ' ', $string);
		$string = str_replace("\n", ' ', $string);

		return $string;
	}

	public static function nl2br($string) {

		$string = trim($string);
		$string = str_replace("\r", '', $string);
		$string = str_replace("\n", '<br />', $string);


		return $string;
	}

	/**
	 * Cleans a string to make it a valid slug url
	 * Similar to wordpresses slug function
     *
	 * @return string
	 */
	public static function cleanForUrl($string) {
		$string	= strtolower($string);
		$string = preg_replace('/[^a-z0-9]+/', '-', $string);

		return $string;
	}



	/**
	 * Cleans a string to remove any non numeric characters
	 * for use in <a href="tel:"></a> tags
	 *
	 * @return string
	 */
	public static function cleanForTel($string) {
        $string = static::formatPhoneLink($string);

		return $string;
	}



	/**
	 * Creates a image src using Timthumb
	 *
	 * @return string
	 */
	public static function createImageSrc($image_src, $width = 100, $height = 100, $zoomcrop = 1, $alignment = 'c', $quality = 80, $rnd = true) {
		$image_src 	= trim($image_src);
		$width 		= intval($width);
		$height 	= intval($height);
		$zoomcrop 	= intval($zoomcrop);
		$quality 	= intval($quality);

		if (!empty($image_src) ) {

			$image_src = ROOT_URL.'/application/images/timthumb.php?src='.urlencode ($image_src);

			if (!empty($width))  		$image_src .= '&w='.$width;
			if (!empty($height))  		$image_src .= '&h='.$height;
			if (!empty($zoomcrop))  	$image_src .= '&zc='.$zoomcrop;
			if (!empty($alignment)) 	$image_src .= '&a='.$alignment;
			if (!empty($quality))  		$image_src .= '&q='.$quality;
			if (!empty($rnd))  			$image_src .= '&rnd='.rand();

			$image_src = htmlentities($image_src);

			return $image_src;

		} else {

			return false;

		}

	}



  	/**
     * Shorten a string by either word or character count
     *
     * @return string
     */
    public static function shortenString($string, $limit = 100, $end = '...', $by_words = true, $strip_tags = true) {
        $limit = intval($limit);

        // Remove HTML tags
        if ($strip_tags) {
           $string = strip_tags($string);
        }

        // Count the string either by words or characters
        if ($by_words) {
           $words      = explode(' ', $string);
           $length     = count($words) + 1; // for 0 index
           $words      = ($length >= $limit) ? array_slice($words, 0, $limit) : $words;
           $string     = implode(' ', $words);
        } else {
           $words      = $string;
           $length     = strlen($words);
           $string     = ($length >= $limit) ? substr($words, 0, $limit) : $words;
        }

        // Add our ending string
        $string = $string.$end;

        return $string;

    }



    /**
     * Shorten a string by word or character count and add a read more extendor link
     *
     * @return string
     */
    public static function shortenStringWithExtention($string, $limit = 100, $end = '... Read More',$tags = '<br>') {
        $limit = intval($limit);

        $string = strip_tags($string, $tags);

        // Count the string either by words or characters
        $words      = explode(' ', $string);
        $length     = count($words) + 1; // for 0 index

        if ($length > $limit) {
            // Split the text into 2 sections
            $text_preview = implode(' ', array_slice($words, 0, $limit));
            $text_hidden  = implode(' ', array_slice($words, $limit));

            $string = '<div class="text-expand">'
                    . '<span class="text-preview">'.$text_preview.'</span> '
                    . '<a class="trigger" href="#">'.$end.'</a>'
                    . '<span class="text-hidden">'.$text_hidden.'</span>'
                    . '</div>';
        }

        return $string;

    }



	/**
	 * Creates an email address generated by Javascript to avoid being detected by bots
	 *
	 * @return string
	 */
	public static function emailProtect($user, $domain) {
		return '
		<SCRIPT TYPE=\'text/javascript\'>
			<!--
			// protected email script by Joe Maller
			// JavaScripts available at http://www.joemaller.com
			// this script is free to use and distribute
			// but please credit me and/or link to my site

			emailE=(\''.$user.'@\' + \''.$domain.'\')
			document.write(\'<a itemprop="email" href="mailto:\' + emailE + \'">\' + emailE + \'</a>\')

			//-->
		</script>

		<NOSCRIPT>
			<em>Email address protected by JavaScript.<BR>
			Please enable JavaScript to contact me.</em>
		</NOSCRIPT>
		';
	}



	/**
	 * Formats an array into a address string and adds Google itemprop attributes
	 * expects the array keys to be the google itemprops used
	 *
	 * @return string
	 */
	public static function formatAddress($address_parts) {
		if (is_array($address_parts)) {
			$address = '';

			// address
			// city
			// province
			// zip
			// country

			foreach ($address_parts as $schema_type => $value) {
				if ($value != '') {
					// Put no comma after the province
					if ($schema_type == 'addressRegion') {
						$address .= '<span itemprop="'.$schema_type.'">'.$value.'</span> &nbsp;';
					} else {
						$address .= '<span itemprop="'.$schema_type.'">'.$value.'</span>, ';
					}
				}
			}

			// Remove trailing comma
			$address = rtrim($address, ', ');

			return $address;

		} else {
			return false;
		}
	}

    /**
     * Formats a date based of the passed formatting
     * 2014-12-12 -> December 12, 2014
     */
    public static function formatDate($strDate, $blnTime = false, $strFormat = 'F j, Y') {
        if ($blnTime) {
            $strFormat .= ' g:i a';
        }
        if (!empty($strDate)) {
            // Format our date and return it
            $strDate = date($strFormat, strtotime($strDate));
            return $strDate;
        } else {
            return false;
        }
    }

    /**
     * Formats a date based of the passed formatting
     * This is dependant on the formatDate function
     */
    public static function formatDates($arrDates, $strSpacer = ' - ', $blnTime = false, $strFormat = 'F j, Y') {
        if (!empty($arrDates) && is_array($arrDates)) {
            $strDates = '';
            foreach ($arrDates as $strDate) {
                if (empty($strDate)) continue; // Skip if it's empty
                $strDates .= static::formatDate($strDate, $blnTime, $strFormat) . $strSpacer;
            }
            $strDates = rtrim($strDates, $strSpacer);
            return $strDates;
        } else {
            return false;
        }
    }


    public static function formatPrice($fltPrice, $strSymbol = '$', $intPrecision = 2) {
        $fltPrice = floatval($fltPrice);
        $fltPrice = $strSymbol . number_format($fltPrice, $intPrecision);

        return $fltPrice;
    }


	/**
	 * Formats a string to work as a link
	 * formats like http://SiteName.com
	 *
	 * @return string
	 */
	public static function formatLink($strLink) {
		if (!empty($strLink)) {
			$strLink = trim($strLink);
			// add http if missing
			if (strpos($strLink, 'http') === false) {
				$strLink = 'http://'.$strLink;
			}
			// remove www.
			$strLink = str_replace('www.', '', $strLink);
			return $strLink;
		} else {
			return false;
		}
	}


    /**
     * Formats a string to work as a link in a tel: tag
     * formats like 250-111-1111 to 2501111111
     *
     * @return string
     */
    public static function formatPhoneLink($strPhoneLink) {
        if (!empty($strPhoneLink)) {
            // Replace all characters that arn't 0-9
            $strPhoneLink = trim(preg_replace('/[^0-9]+/', '', $strPhoneLink));
            return $strPhoneLink;
        } else {
            return false;
        }
    }

    /**
     * Formats a string to display as phone number
     * formats like 2501111111 to (250) 111-1111
     *
     * @return string
     */
    public static function formatPhone($strPhoneLink) {
        if (!empty($strPhoneLink) && strlen($strPhoneLink) == 10) {
            // Replace all characters that arn't 0-9
            $areaCode = substr($strPhoneLink,0,3);
            $first = substr($strPhoneLink,3,3);
            $second = substr($strPhoneLink,-4,4);

            $strPhoneLink = '('.$areaCode.') '.$first.' '.$second;

            return $strPhoneLink;
        } else {
            return false;
        }
    }


    /**
     * Take the Facebook timestamp and dispaly it as seconds, hours, day, and full date based on the unix time stamp.
     *
     * @since 1.0
     */
    public static function formatPostTime($timestamp){

        $time = time() - $timestamp;

        // If under a minute show Seconds
        if ($time < 60) {
            return $time . 's';
        }

        //If Under an hour show Minutes
        if ($time < 3600) {
            $tmp = floor($time / 60);
            return $tmp . ' minutes ago';
        }

        // If Under a Day Show Hours
        if ($time < 86400) {
            $tmp = floor($time / 3600);
            return $tmp . ' h';
        }

        // If under 24hrs show day and month
        if ($time < 2592000) {
            return date('M j \a\t h:m a', $timestamp);
        }

        // If less than 6 month old
        if ($time < 31556926) {
            return date('M j \a\t h:m a', $timestamp);
        }

        // If its been a year show day month and year
        return date( 'j M Y', $timestamp );
    }



	/**
	 * Outputs a debug message in Bootstrap HTML
	 *
	 */
	public static function debugDisplay($message) {
		echo '<div class="row">';
	    echo '<div class="col-lg-8 pull-right">';
	    if(is_array($message) || is_object($message)) {
	    	var_dump($message);
	    } else{
	    	echo($message);
	    }
	    echo '</div></div>';
	}



	/**
	 * Checks the `slug` column in a table for an existing value and returns the number of instances it occurs
	 *
	 * @return int
	 */
	public static function validSlug($table, $slug, $id, $debug = false) {
		$sql = "SELECT count(*) As rCount FROM $table WHERE slug='$slug'";

		if($id != '') {
			$sql .= " AND id != $id";
		}

		if($debug) {
			echo $sql . '<br />';
		}

		if($result = $this->getMysqliResults($sql,true)) {
			return $result[0]['rCount'];
		} else {
			return 0;
		}

	}



	public static function getNavClass($page1,$page2){
		if(is_array($page2)){
			foreach($page2 As $p) {
				if($page1 == $p) {
					echo 'active';
				}
			}

		} else {
			if($page1 == $page2) {
				echo 'active';
			}
		}

	}



	public static function getNavToggle($page1,$page2){
		if(is_array($page2)){
			$d = 'collapse';
			foreach($page2 As $p) {
				if($page1 == $p) {
					$d = '';
					break;
				}
			}
			echo $d;
		} else {
			if($page1 != $page2) {
				echo 'collapse';
			}
		}
	}



	public static function displayThumb($path, $width = 80, $height = 80, $zc = 1){
		if (empty($path) || !is_file(ROOT_DIR.$path)) {
			return false;
		}

		$info = pathinfo($path);
		$allowed_exts = array('jpg', 'jpeg', 'png', 'gif');
		$extension = strtolower($info['extension']);

		if (in_array($extension, $allowed_exts)) {
			$src = self::createImageSrc($path, $width, $height, $zc);
			echo '<img src="'.$src.'" alt="thumbnail" class="grid-thumb" />';
		} else {
			echo '<a href="'.ROOT_URL.$path.'" target="_blank"><span class="fa fa-lg fa-file"></span> See File</a>';
		}
	}


	public static function displayImage($path, $width = 90, $height = 90, $zc = 0, $rnd=true){
		if (empty($path) || !is_file(ROOT_DIR.$path)) {
			return false;
		}

		$info = pathinfo($path);
		$allowed_exts = array('jpg', 'jpeg', 'png', 'gif');
		$extension = strtolower($info['extension']);

		if($rnd) { $path .= '?rnd='.rand(); }

		if (in_array($extension, $allowed_exts)) {
			//$src = self::createImageSrc($path, $width, $height, $zc);
			echo '<img src="'.$path.'" alt="thumbnail" style="max-width:'.$width.'px;max-height:'.$height.'px;" />';
		} else {
			echo '<a href="'.ROOT_URL.$path.'" target="_blank"><span class="fa fa-lg fa-file"></span> See File</a>';
		}
	}



	/**
     * This will take a flat data array and created a recursive
     *
     */
    public static function makeNested($source, $original = null, $nested = array()) {
        $id_array = array();

        if (empty($source)) {
            return;
        }

        // Format the data so the record ID is the KEY of the array
        foreach ($source as $key => $value) {
            $id_array[$value['id']] = $value;
        }

        if ($original == null) {
            $orginal = $id_array;
        }

        foreach ($id_array as $key => $value) {

            // If the current category has a parent that is 0, or is null, add it to the root of the category
            // once it is added skip to the next value in the array
            if ($value['parent_id'] == 0 || is_null($value['parent_id'])) {
                if (isset($nested[$value['id']])) {
                    $nested[$value['id']]['id']             = $value['id'];
                    $nested[$value['id']]['parent_id']      = $value['parent_id'];
                    $nested[$value['id']]['name']           = $value['name'];
                } else {
                    $nested[$value['id']] = $value;
                }
                continue;
            }

            // find its parent stack using getParentId
            // assign to its parents 'children' key
            $parent_ids = static::getParentId($orginal, $key);

            // We check to see if the key already exists, if it does that means that a child category
            // has been looped through previously, so don't overwrite that nested value, just add what we need
            // ex the id, parent_id and name
            eval(
                'if (isset($nested'.$parent_ids.')) {
                    $nested'.$parent_ids.'["id"] = $value["id"];
                    $nested'.$parent_ids.'["parent_id"] = $value["parent_id"];
                    $nested'.$parent_ids.'["name"] = $value["name"];
                } else {
                    $nested'.$parent_ids.' = $value;
                }'
            );

        }

        return $nested;

    }



    public static function getParentId($original, $current_id, &$output = '') {

        if ($original[$current_id]['parent_id'] == 0 || $original[$current_id]['parent_id'] == null) {
            return;
        }

        if (empty($output)) {
            $output = "[$current_id]";
        }

        foreach ($original as $key => $value) {
            if ($key == $original[$current_id]['parent_id']) {
                $output = "[$key]['children']".$output;
                static::getParentId($original, $key, $output);
            }
        }

        return $output;
    }



    /**
     * This function will take a flat data array, parse it into a nested array,
     * and then output the array as a nested UL list supporting up to X depths,  x = whatever the php.ini stack limit is
     */
    public static function createCheckboxListNested($name, $values, $current_id = null, $checkbox_value = 'id', $checkbox_children = 'children', $checkbox_parent = 'parent_id', $checkbox_display = 'name', $checked = null, $html_options = null) {
        $html_opts='';
        if (!empty($html_options)) {
            foreach ($html_options as $attrib => $value) {
                $html_opts.=' '.$attrib.'="'.$value.'"';
            }
        }

        // Format the data into a nested array
        $values = static::makeNested($values);

        if (empty($values)) {
            return '';
        }

        $checkbox = '';

        if ($current_id == null) {
            $checkbox = '<ul '.$html_opts.'>';
        }

	    foreach ($values as $key => $value) {
	        $is_checked='';

	        if (is_array($checked)) {
	            if (in_array($value[$checkbox_value],$checked)) {
	                $is_checked=' checked="checked"';
	            }
	        } elseif ($value[$checkbox_value]==$checked) {
	            $is_checked=' checked="checked"';
	        }

	        $checkbox .= '<li data-attribute="'.$key.'">';
	        $checkbox .= '<label title="'.$value[$checkbox_display].'">';
	        $checkbox .= '<input type="checkbox" name="'.$name.'" value="'.$value[$checkbox_value].'"'.$is_checked.'>';
	        $checkbox .= $value[$checkbox_display].'</label>';

	        if (isset($value[$checkbox_children]) ) {

	            $checkbox .= '<ul class="sub-menu">';
	            $checkbox .= static::createCheckboxListNested($name, $value[$checkbox_children], $key, $checkbox_value, $checkbox_children, $checkbox_parent, $checkbox_display, $checked, $html_options);
	            $checkbox .= '</ul>';
	        }

	        $checkbox .= '</li>';

	    }

        if ($current_id == null) {
            $checkbox .= '</ul>';
        }

        return $checkbox;

    }



    /**
     * Encrypts a string using bcrypt
     *
     */
    public static function bcryptString($string) {
        $salt = SALT;

        // 2a is the bcrypt algorithm selector, 12 is the workload factor
        $hash = crypt($string, '$2a$12$' . $salt);

        return $hash;
    }



    /**
     * Helps retrive the data from feeds
     *
     * @return string
    */
    public static function fetchData( $url ){
        $ch = curl_init();
        curl_setopt( $ch, CURLOPT_URL, $url );
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt( $ch, CURLOPT_TIMEOUT, 20 );
        $result = curl_exec( $ch );
        curl_close( $ch );
        return $result;
    }



    /**
     * Uploads a file to a directory, and creates the directory + sets the write permissions if it doesn't exist
     *
     * @param $file (array) - The $_FILES['file_name'] from the posted form
     * @param $path (string) - The directory to upload the file to
     * @param $newFileName (string) - The new name of the file, if left empty will use the orginal file name
     * @param $allowedTypes (array) - An array of allowed mime-types ex: array('application/pdf', 'image/*')
     * @param $rewriteFile (boolean) - If another file is found with the same name, it will overrite it other wise add a suffix
     * @param $debug (boolean) - Set to true to see error messages
     *
     * @return array of file info, false if failed
     */
    public static function uploadFile($file, $path, $newFileName = null, $allowedTypes = null, $fileOverwrite = true, $debug = false) {
        // No File was uploaded
        if ($file['error'] === 4) {
            return;
        }

        // Make a new instance of our upload class
        $handle = new upload($file);

        if (empty($newFileName)) {
            // If our new name is empty use the original file name
            $newFileName = $handle->file_src_name_body;
        }

        if (empty($allowedTypes)) {
            // If the allowed array isn't set use the defaults from the class
            $allowedTypes = $handle->allowed;
        }

        // If it's been uploaded to the temporary sever location
        if ($handle->uploaded) {
            $handle->file_new_name_body = $newFileName; // rename the file
            $handle->allowed = $allowedTypes; // allowed file types
            $handle->file_overwrite = $fileOverwrite; // if the file exists overrite it
            $handle->file_auto_rename = true; // Automatically rename the file if it exists
            $handle->dir_auto_create = true; // create our directory if it doesn't exist
            $handle->dir_auto_chmod = true; // set the permissions to writeable if it isn't
            $handle->dir_chmod = 0775; // the permission type on the folder

            // Create our image with the parameters above, creating the directory etc
            $handle->process($path);

            if ($handle->processed) {
                // Delete the temporary image from the server
                $handle->clean();

                $fileInfo = array(
                    'dir' => $handle->file_dst_path,
                    'file' => $handle->file_dst_name,
                    'name' => $handle->file_dst_name_body,
                    'ext' => $handle->file_dst_name_ext,
                    'size' => $handle->image_src_bits,
                    'width' => $handle->image_src_x,
                    'height' => $handle->image_src_y
                );

                return $fileInfo;
            } else {
                // Dump our errors if debug is on
                if ($debug) Util::debugDisplay($handle->error);
                return $handle->error;
            }
        } else {
            // File failed to upload
            if ($debug) Util::debugDisplay($handle->error);
            return $handle->error;
        }
    }



    /**
     * Checked to see if a value isn't empty and if a file exists with that value
     * for use in checking if images exists
     *
     * @return string
     */
    public static function isFile($strFile) {
        if (empty($strFile) || !is_file(ROOT_DIR.$strFile)) {
            return false;
        }

        return true;
    }



    /**
     * Function that will delete a file if it exists and return a boolean
     *
     * @param $strFilePath (string) - name of the file
     * @param $strFileDir (string) - the server directory the file is located in
     * @return boolean
     */
    public static function deleteFile($strFilePath, $strFileDir = ROOT_DIR) {
        $strFileFullPath = $strFileDir.$strFilePath;
        if (is_file($strFileFullPath)) {
            unlink($strFileFullPath);
            return true;
        } else {
            return false;
        }
    }

    public static function sendMailCore($strTo, $strSubject, $strMessage, $strHeaders) {

        $strMessage = wordwrap($strMessage, 600);

        // Production
        $strDomain = 'mail.bcgolfguide.com';

        // Sandbox
        //$strDomain = 'sandbox4c10fcbcf67c4e35878220feec589729.mailgun.org';

        $url = 'https://api.mailgun.net/v3/'.$strDomain.'/messages';
        $username = 'api';
        $password = 'e1a2afe550d5543faf11db8731a25349-62916a6c-1f25c9ce';

        $arrContent = array(
            'to' => $strTo,
            'subject' => $strSubject,
            'html' => $strMessage,
        );

        //var_dump($strHeaders);
        $arrHeaderLines = explode("\r\n", $strHeaders);
        foreach ($arrHeaderLines as $strHeaderLine) {
            $arrHeaderLine = explode(":", $strHeaderLine);
            if ($arrHeaderLine[0] == 'From') {
                $arrContent['from'] = trim($arrHeaderLine[1]);
            }
            if ($arrHeaderLine[0] == 'Reply-To') {
                $arrContent['h:Reply-To'] = trim($arrHeaderLine[1]);
            }
            if ($arrHeaderLine[0] == 'Bcc') {
                $arrContent['bcc'] = trim($arrHeaderLine[1]);
            }
        }
        //var_dump($arrContent);

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);

        curl_setopt ($ch, CURLOPT_MAXREDIRS, 3);
        curl_setopt ($ch, CURLOPT_FOLLOWLOCATION, false);
        curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt ($ch, CURLOPT_VERBOSE, 0);
        curl_setopt ($ch, CURLOPT_HEADER, 1);
        curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0);

        curl_setopt( $ch, CURLOPT_URL, $url );
        curl_setopt( $ch, CURLOPT_USERPWD, "$username:$password");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );

        curl_setopt($ch, CURLOPT_POSTFIELDS, $arrContent);

        $result = curl_exec( $ch );
        //var_dump($result);
        curl_close( $ch );
        return $result;

        // OLD MAIL CALL
        //return mail($strTo, $strSubject, $strMessage, $strHeaders);
    }

    /**
     * Sends an HTML email
     * @param $strTo (string) - The email to send to
     * @param $strSubject (string) - The subject of the email
     * @param $strMessage (string) - the email body message converts newlines to <br>
     * @param $strFrom (string) - Specifically sets the 'From' in the header defaults to 'SITENAME <no-reply@SITEURL>'
     * @param $strHeaders (string) - Additional headers for the email includes basic headers already
     *
     * @return boolean
     */
    public static function sendMail($strTo, $strSubject, $strMessage = '', $strFrom = '', $strHeaders = '') {
        if (empty($strTo) || empty($strSubject) || empty($strMessage)) {
            return false;
        }

        // Add general email header data
        $strHeaders .= "MIME-Version: 1.0'\r\n"
                    . 'Content-type: text/html; charset=iso-8859-1'."\r\n"
                    . 'X-Mailer: PHP/'.phpversion()."\r\n";
        // Add the 'From' to the header
        $objSettings = new Settings();
        $strHeaders .= !empty($strFrom) ? 'From: '.$strFrom."\r\n" : 'From: '.$objSettings->strSiteName.' <no-reply@'.$_SERVER['HTTP_HOST'].'>'."\r\n";

        // Add formating for the 'to' string
        if (is_array($strTo)) {
            $strTo = implode(', ', $strTo);
        }

        // Format the message so new lines work in the HTML email
        //$strMessage = nl2br($strMessage);

        $blnSentMail = static::sendMailCore($strTo, $strSubject, $strMessage, $strHeaders);

        return $blnSentMail;
    }

    public static function sendTrackingMail($arrArgs = array()) {
        // Set default args
        $arrArgs = static::wp_parse_args($arrArgs, array(
            'to' => '',
            'from' => '',
            'subject' => '',
            'message' => '',
            'headers' => '',
            'tracking_data' => '',
        ));

        // Set variables
        $strTo = trim($arrArgs['to']);
        $strFrom = trim($arrArgs['from']);
        $strSubject = trim($arrArgs['subject']);
        $strMessage = trim($arrArgs['message']);
        $strHeaders = trim($arrArgs['headers']);
        $arrTrackingData = is_array($arrArgs['tracking_data']) ? array_filter($arrArgs['tracking_data']) : array();

        if (!empty($arrTrackingData)) {
            // Create the url
            $strTrackingUrl = ROOT_URL . '/application/services/email_tracking.php';
            $strTrackingParams = http_build_query($arrTrackingData);
            $strUrl = $strTrackingUrl . '?' . $strTrackingParams;

            // Add the tracking image to the message
            $strMessage .= '<img alt="tracking" src="' . $strUrl . '" width="1" height="1" border="0" />';
        }

        // Send the email
        return static::sendMail($strTo, $strSubject, $strMessage, $strFrom, $strHeaders);
    }

	public static function mail_attachment ($from , $to, $cc, $subject, $message, $attachment){

		$email_from    = $from; // Who the email is from
		$email_subject =  $subject; // The Subject of the email
		$email_txt     = $message; // Message that the email has in it
		$email_to      = $to; // Who the email is to

		$headers = "From: ".$email_from;
		$headers.= "\nCc: " . $cc;
	    //______________________________________________________________________________
		$semi_rand     = md5(time());
		$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";

		$headers .= "\nMIME-Version: 1.0\n" .
	            "Content-Type: multipart/mixed; boundary=\"{$mime_boundary}\"\n\n";

		$email_message = "This is a multi-part message in MIME format.\n" .
	                "--{$mime_boundary}\n" .
	                "Content-Type:text/html; charset=\"iso-8859-1\"\n" .
	               "Content-Transfer-Encoding: 7bit\n\n" .
		            $email_txt . "\n\n";

	    //______________________________________________________________________________
		######Attachments

		$atts = explode(";", $attachment);
		$kirk = 0;
		if(count($atts)>1){
		   for($i=0; $i<count($atts); $i++){
			 $kirk++;
			 $tmp = $mime_boundary . $kirk;
			 if($atts[$i]!=""){
		       $fileatt      = $atts[$i]; // Path to the file
			   $fileatt_type = "application/octet-stream"; // File Type
			   $start        =	strrpos($atts[$i], '/') == -1 ? strrpos($atts[$i], '//') : strrpos($atts[$i], '/')+1;
			   $fileatt_name = substr($atts[$i], $start, strlen($atts[$i])); // Filename that will be used for the file as the attachment

			   $file = fopen($fileatt,'rb');
			   $data = fread($file,filesize($fileatt));
			   fclose($file);

			   $data = chunk_split(base64_encode($data));

			   $email_message .= "--{$mime_boundary}\n" .
	                  "Content-Type: {$fileatt_type}; name=\"{$fileatt_name}\"\n" .
	                  //"Content-Disposition: attachment;\n" .
	                  //" filename=\"{$fileatt_name}\"\n" .
	                  "Content-Transfer-Encoding: base64\n\n" .
					  $data . "\n\n";
			   unset($data);
			   unset($file) ;
			   unset($fileatt) ;
			   unset($fileatt_type) ;
			   unset($fileatt_name) ;
			 }
		   }
		}
		$email_message .= "--{$tmp}--\n";

		$ok = @mail($email_to, $email_subject, $email_message, $headers);

        // Wont Work
        //$ok = @static::sendMailCore($email_to, $email_subject, $email_message, $headers);

		if($ok) {
		} else {
			die("Sorry but the email could not be sent. Please go back and try again!");
		}
	}

	public static function cleanWordText($strText){
		  // First, replace UTF-8 characters.
		  $strText = str_replace(
		  array("\xe2\x80\x98", "\xe2\x80\x99", "\xe2\x80\x9c", "\xe2\x80\x9d",
				"\xe2\x80\x93", "\xe2\x80\x94", "\xe2\x80\xa6"),
		  array("&lsquo;", "&rsquo;", '&ldquo;', '&rdquo;', '&ndash;',
				'&mdash;', '&hellip;'),
		  $strText);

		  // Next, replace their Windows-1252 equivalents.
		  $strText = str_replace(
		  	array(chr(145), chr(146), chr(147), chr(148), chr(150), chr(151),
			chr(133), chr(149), chr(174), chr(169), chr(153)),
		  array("&lsquo;", "&rsquo;", '&ldquo;', '&rdquo;', '&ndash;',
		 '&mdash;', '&hellip;', '&bull;', '&reg;', '&copy;', '&trade;'),
		  $strText);

		  return $strText;
	}

	// Taken from wordpress
	public static function wp_parse_args( $args, $defaults = '' ) {
	    if ( is_object( $args ) )
	        $r = get_object_vars( $args );
	    elseif ( is_array( $args ) )
	        $r =& $args;
	    else
	        static::wp_parse_str( $args, $r );

	    if ( is_array( $defaults ) )
	        return array_merge( $defaults, $r );
	    return $r;
	}

	public static function wp_parse_str( $string, &$array ) {
	    parse_str( $string, $array );
	    if ( get_magic_quotes_gpc() )
	        $array = static::stripslashes_deep( $array );
	}

	public static function stripslashes_deep( $value ) {
	    if ( is_array($value) ) {
	        $value = array_map(array('static', 'stripslashes_deep'), $value);
	    } elseif ( is_object($value) ) {
	        $vars = get_object_vars( $value );
	        foreach ($vars as $key=>$data) {
	            $value->{$key} = static::stripslashes_deep( $data );
	        }
	    } elseif ( is_string( $value ) ) {
	        $value = stripslashes($value);
	    }

	    return $value;
	}

    /**
     * Returns if the view starts the package builder funneling
     *
     */
    public static function isFunnelPage($strView) {
        // Blacklist certain views
        $arrViews = array(
            'builder',
            'featured',
        );

        return !in_array($strView, $arrViews) ? true : false;
    }

    /**
     * Return if the view uses full width elements
     *
     */
    public static function isFullWidthTemplate($strView) {
        // Whitelist certain views
        $arrViews = array(
            'home',
            'region',
            'bcmap',
            'list_featured',
            'builder',
            //'featured',
        );

        return in_array($strView, $arrViews) ? true : false;
    }

    /**
     * Validates a captcha response
     *
     */
    public static function recaptcha($strInput) {
        // Post options
        $strData = http_build_query(array(
            'secret'   => GOOGLE_RECAPTCHA_V2_SECRET_KEY,
            'response' => $strInput,
            'remoteip' => $_SERVER['REMOTE_ADDR'],
        ));
        $arrArgs = array('http' => array(
            'method'  => 'POST',
            'header'  => 'Content-type: application/x-www-form-urlencoded',
            'content' => $strData,
        ));

        // Send the request
        $objContext  = stream_context_create($arrArgs);
        $strResponse = file_get_contents('https://www.google.com/recaptcha/api/siteverify', false, $objContext);
        $objResponse = json_decode($strResponse);

        // Error occured
        if (!$objResponse->success) {
            return false;
        }

        // Success
        return true;
    }

    /**
     * Gets the permalink structure for a data object
     *
     */
    public static function getPermalink($strType, $strSlug) {
        // Sanitize
        $strType = strtolower(trim($strType));
        $strSlug = strtolower(trim($strSlug));

        // Set the permalink structure
        switch ($strType) {
            case 'page':
                $strSlug = '/' . $strSlug . '/';
                break;
            case 'region':
                $strSlug = '/regions/' . $strSlug . '/';
                break;
            case 'region_package':
                $strSlug = '/region/featured-golf-packages/' . $strSlug.'/';
                break;
        }

        // Return the URL
        return ROOT_URL . $strSlug;
    }

}

// Add windows support for format_number (which requries strfmon())
if(!function_exists('money_format')){
	/*
	That it is an implementation of the function money_format for the
	platforms that do not it bear.

	The function accepts to same string of format accepts for the
	original function of the PHP.

	(Sorry. my writing in English is very bad)

	The function is tested using PHP 5.1.4 in Windows XP
	and Apache WebServer.
	*/
	function money_format($format, $number)
	{
	    $regex  = '/%((?:[\^!\-]|\+|\(|\=.)*)([0-9]+)?'.
	              '(?:#([0-9]+))?(?:\.([0-9]+))?([in%])/';
	    if (setlocale(LC_MONETARY, 0) == 'C') {
	        setlocale(LC_MONETARY, '');
	    }
	    $locale = localeconv();

	    // manually setup locale
	    $locale = array(
	        'decimal_point'        => '.',
	        'thousands_sep'        => '',
	        'int_curr_symbol'    => '',
	        'currency_symbol'    => '$',
	        'mon_decimal_point'    => '.',
	        'mon_thousands_sep'    => ',',
	        'positive_sign'        => '',
	        'negative_sign'     => '-',
	        'int_frac_digits'    => 2,
	        'frac_digits'        => 2,
	        'p_cs_precedes'        => 0,
	        'p_sep_by_space'    => 1,
	        'p_sign_posn'        => 1,
	        'n_sign_posn'        => 1,
	        'grouping'            => array(),
	        'mon_grouping'        => array(0 => 3, 1 => 3)
	    );

	    preg_match_all($regex, $format, $matches, PREG_SET_ORDER);
	    foreach ($matches as $fmatch) {
	        $value = floatval($number);
	        $flags = array(
	            'fillchar'  => preg_match('/\=(.)/', $fmatch[1], $match) ?
	                           $match[1] : ' ',
	            'nogroup'   => preg_match('/\^/', $fmatch[1]) > 0,
	            'usesignal' => preg_match('/\+|\(/', $fmatch[1], $match) ?
	                           $match[0] : '+',
	            'nosimbol'  => preg_match('/\!/', $fmatch[1]) > 0,
	            'isleft'    => preg_match('/\-/', $fmatch[1]) > 0
	        );
	        $width      = trim($fmatch[2]) ? (int)$fmatch[2] : 0;
	        $left       = trim($fmatch[3]) ? (int)$fmatch[3] : 0;
	        $right      = trim($fmatch[4]) ? (int)$fmatch[4] : $locale['int_frac_digits'];
	        $conversion = $fmatch[5];

	        $positive = true;
	        if ($value < 0) {
	            $positive = false;
	            $value  *= -1;
	        }
	        $letter = $positive ? 'p' : 'n';

	        $prefix = $suffix = $cprefix = $csuffix = $signal = '';

	        $signal = $positive ? $locale['positive_sign'] : $locale['negative_sign'];
	        switch (true) {
	            case $locale["{$letter}_sign_posn"] == 1 && $flags['usesignal'] == '+':
	                $prefix = $signal;
	                break;
	            case $locale["{$letter}_sign_posn"] == 2 && $flags['usesignal'] == '+':
	                $suffix = $signal;
	                break;
	            case $locale["{$letter}_sign_posn"] == 3 && $flags['usesignal'] == '+':
	                $cprefix = $signal;
	                break;
	            case $locale["{$letter}_sign_posn"] == 4 && $flags['usesignal'] == '+':
	                $csuffix = $signal;
	                break;
	            case $flags['usesignal'] == '(':
	            case $locale["{$letter}_sign_posn"] == 0:
	                $prefix = '(';
	                $suffix = ')';
	                break;
	        }
	        if (!$flags['nosimbol']) {
	            $currency = $cprefix .
	                        ($conversion == 'i' ? $locale['int_curr_symbol'] : $locale['currency_symbol']) .
	                        $csuffix;
	        } else {
	            $currency = '';
	        }
	        $space  = $locale["{$letter}_sep_by_space"] ? ' ' : '';

	        $value = number_format($value, $right, $locale['mon_decimal_point'],
	                 $flags['nogroup'] ? '' : $locale['mon_thousands_sep']);
	        $value = @explode($locale['mon_decimal_point'], $value);

	        $n = strlen($prefix) + strlen($currency) + strlen($value[0]);
	        if ($left > 0 && $left > $n) {
	            $value[0] = str_repeat($flags['fillchar'], $left - $n) . $value[0];
	        }
	        $value = implode($locale['mon_decimal_point'], $value);
	        if ($locale["{$letter}_cs_precedes"]) {
	            $value = $prefix . $currency . $space . $value . $suffix;
	        } else {
	            $value = $prefix . $value . $space . $currency . $suffix;
	        }
	        if ($width > 0) {
	            $value = str_pad($value, $width, $flags['fillchar'], $flags['isleft'] ?
	                     STR_PAD_RIGHT : STR_PAD_LEFT);
	        }

	        $format = str_replace($fmatch[0], $value, $format);
	    }
	    return $format;
	}
}

