<?php
/**
 * @package   Chimera_Framework
 * @author    Christopher Satterthwaite <chris@navigatormm.com>
 * @link      http://www.navigatormm.com
 * @copyright 2014 Navigator Multimedia Inc
 */

class Twitter_feed {

    /**
     * Filter the Tweet and add in the correct link html via regex.
     *
     * @since 1.0
     */
    public static function messageFilter($content){
        // Filter and modify the text using regex
        $string = $content;
        $patterns = array();
        $patterns[0] = '@(https?://([-\w\.]+)+(/([\w/_\.]*(\?\S+)?(#\S+)?)?)?)@';// parsing links out of the raw tweet text
        $patterns[1] = '/^@(\w+)/';//parsing Twitter usernames: get’s all your retweets and such that begin with @
        $patterns[2] = '/ @(\w+)/';//parsing Twitter usernames: with a space then an @
        $patterns[3] = '/\#(\w+)/';//parsing Twitter hashtags

        $replacements = array();
        $replacements[0] = ' <a href="$1" rel="nofollow" target="_blank">$1</a>';
        $replacements[1] = ' <a href="https://twitter.com/$1" rel="nofollow" target="_blank"> @$1</a>';
        $replacements[2] = ' <a href="https://twitter.com/$1" rel="nofollow" target="_blank"> @$1</a>';
        $replacements[3] = ' <a href="https://twitter.com/search?q=%23$1&src=hash" rel="nofollow" target="_blank"> #$1</a>';

        $message = preg_replace($patterns, $replacements, $string);

        return $message;
    }

    public static function createTwitterFeed($tweet_count = '10') {
        $twitter_account = TW_ACCOUNT;
        $twitter_access_token = TW_ACCESS_TOKEN;
        $twitter_access_token_secret = TW_ACCESS_TOKEN_SECRET;
        $twitter_consumer_key = TW_CONSUMER_KEY;
        $twitter_consumer_secret = TW_CONSUMER_SECRET;
        $html = '';

        // Check to see if the settings are filled out.
        if (empty($twitter_account) || empty($twitter_access_token) || empty($twitter_access_token_secret) || empty($twitter_consumer_key) || empty($twitter_consumer_secret)){
            $html .= '<div class="alert alert-danger">The Twitter Feed is configured incorrectly.</div>' . "\n";
            echo $html;
            return;
        }

        // Load Twitter script.
        $html .= "<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>";

        // Get Twitter Feed.
        $response = static::getFeed($tweet_count);

        // There are no results to display.
        if(isset($response->errors)){
            $html .= '<div class="alert alert-danger">The Twitter Feed is down or configured incorrectly.</div>' . "\n";
            echo $html;
            return;
        }

        // Output the HTML.
        $html .= '<div class="panel panel-default">' . "\n";
            $html .= '<div class="panel-heading clearfix">' . "\n";
                $html .= '<a href="https://twitter.com/' . TW_ACCOUNT . '" class="pull-left" rel="nofollow"><strong>Tweets</strong></a>' . "\n";
                $html .= '<a href="https://twitter.com/' . TW_ACCOUNT . '" class="twitter-follow-button pull-right" data-show-count="false" data-size="large" data-show-screen-name="false" data-dnt="true" rel="nofollow" target="_blank">Follow @' . TW_ACCOUNT . '</a>' . "\n";
            $html .= '</div>' . "\n";

            $html .= '<ul class="twitter-feed list-group">' . "\n";

            // Limit the amount of tweets to display base don the # of records in the data base.
            if($tweet_count > count($response)){
                $tweet_count = count($response);
            }

            // Loop through the feed based on the tweet_count.
            for ($i = 0; $i < $tweet_count; $i++) {
                $tweet = $response[$i];

                $html .= '<li class="list-group-item clearfix">' . "\n";
                    $html .= '<a href="https://twitter.com/' . $tweet->user->screen_name . '" rel="nofollow" target="_blank"><img class="avatar img-responsive" src="' . $tweet->user->profile_image_url_https . '" alt="' . $tweet->user->name . '"></a>' . "\n";
                    $html .= '<div class="content">';
                    $html .= '<a class="tweet-header" href="https://twitter.com/' . $tweet->user->screen_name . '" rel="nofollow" target="_blank"><strong class="fullname">' . $tweet->user->name . '</strong><span>  &#64;' . $tweet->user->screen_name .'</span></a> - <a class="time" href="https://twitter.com/' . $tweet->user->screen_name . '/status/' . $tweet->id . '" target="_blank">' . Util::formatPostTime(strtotime($tweet->created_at)) . '</a>' . "\n";
                    $html .= '<p class="text">' . static::messageFilter($tweet->text). '</p>' . "\n";
                    $html .= '<ul class="intent list-inline">';
                        $html .= '<li><a href="https://twitter.com/intent/tweet?in_reply_to=' . $tweet->id . '" rel="nofollow"><i class="fa fa-reply"></i> Reply</a></li>' . "\n";
                        $html .= '<li><a href="https://twitter.com/intent/retweet?tweet_id=' . $tweet->id . '" rel="nofollow"><i class="fa fa-retweet"></i> Retweet</a></li>' . "\n";
                        $html .= '<li><a href="https://twitter.com/intent/favorite?tweet_id=' . $tweet->id . '" rel="nofollow"><i class="fa fa-star"></i> Favorite</a></li>' . "\n";
                    $html .= '</ul>' . "\n";
                    $html .= '</div>';
                $html .= '</li>' . "\n";
            }

            $html .= '</ul>' . "\n";

        $html .= '</div>' . "\n";

        //Echo The HTML
        echo $html;
    }

    /**
    * Gets the Twitter feed from twitter via the Twitter API.
    * Cache's the Twitter will refresh the database ever hour based on the Last_updated timestamp.
    *
    * @since 1.6
    */
    public static function getFeed($tweet_count){
        // Get from source.
        // Set access tokens here - see: https://dev.twitter.com/apps/
        $settings = array(
            'oauth_access_token' => TW_ACCESS_TOKEN,
            'oauth_access_token_secret' => TW_ACCESS_TOKEN_SECRET,
            'consumer_key' => TW_CONSUMER_KEY,
            'consumer_secret' => TW_CONSUMER_SECRET
        );

        //Get The feed from Twitter.
        $url = 'https://api.twitter.com/1.1/statuses/user_timeline.json';
        $requestMethod = 'GET';
        $getfield = '?screen_name=' . TW_ACCOUNT . '&count=' . $tweet_count;

        $twitter = new TwitterAPIExchange($settings);

        $api_response = $twitter->setGetfield($getfield)
                            ->buildOauth($url, $requestMethod)
                            ->performRequest();

        $responseSource = json_decode($api_response);

        return $responseSource;
    }
}