<?php

class Settings extends Database {

	// The last query we executed
	public $strQuery;

	// The resource returned from above query
	public $arrResult;

	// Number of affected rows from above query.
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;

	public $strSiteName;
    public $strSiteDescription;
    public $strAdminEmail;

    // SEO Fields
    public $strTitle;
    public $strMetaTitle;
    public $strMetaKeywords;
    public $strMetaDescription;
    public $strMetaRobots;
    public $strFacebookTitle;
    public $strFacebookDescription;
    public $strFacebookImage;
    public $strTwitterTitle;
    public $strTwitterDescription;
    public $strTwitterImage;
    public $strGoogleDescription;

    // OG Images
    public $strOGImage;
    public $strOGImageOriginal;
    public $strAppleImage152;
    public $strAppleImage144;
    public $strAppleImage114;
    public $strAppleImage76;
    public $strAppleImage72;
    public $strAppleImage57;

    public $strGoogleAnalytics;
    public $strHeaderTrackingCode;
    public $strFooterTrackingCode;
    public $strFacebookInsights;

    public $strGoogleWebmaster;
    public $strBingWebmaster;
    public $strAlexaVerificationId;
    public $strPinterestVerification;

    public $strRobotsNoodp;
    public $strRobotsNoydir;
    public $strRobots;

	public $strFacebookURL;
	public $strTwitterURL;
	public $strTwitterName;
	public $strPintrestURL;
	public $strLinkedinURL;
    public $strGoogleURL;
    public $strInstagramURL;
    public $strRSSURL;
    public $strYoutubeURL;
    public $intPayPalMode;
    public $intVoucherBreak;

	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";
        $this->strTableName = 'settings';

		$this->strQuery = "SELECT * FROM $this->strTableName WHERE id=1";

		if($this->query($this->strQuery)) {
	     	$this->arrResult=$this->getMysqliResults($this->strQuery,true);

	     	$this->strSiteName = $this->arrResult[0]['site_name'];
            $this->strSiteDescription = $this->arrResult[0]['site_description'];
            $this->strAdminEmail = $this->arrResult[0]['admin_email'];
            $this->intPayPalMode = $this->arrResult[0]['paypal_mode'];
            $this->intVoucherBreak = $this->arrResult[0]['voucher_force_break_amount'];

            $this->strOGImage = !empty($this->arrResult[0]['og_image']) ? $this->arrResult[0]['og_image'] : '/application/images/touch/apple-touch-icon-144x144.png';
            $this->strOGImageOriginal = !empty($this->arrResult[0]['og_image']) ? $this->arrResult[0]['og_image'] : '/application/images/touch/apple-touch-icon-144x144.png';
            $this->strAppleImage152 = !empty($this->arrResult[0]['apple_image_152']) ? $this->arrResult[0]['apple_image_152'] : '/application/images/touch/apple-touch-icon-152x152.png';
            $this->strAppleImage144 = !empty($this->arrResult[0]['apple_image_144']) ? $this->arrResult[0]['apple_image_144'] : '/application/images/touch/apple-touch-icon-144x144.png';
            $this->strAppleImage114 = !empty($this->arrResult[0]['apple_image_114']) ? $this->arrResult[0]['apple_image_114'] : '/application/images/touch/apple-touch-icon-114x114.png';
            $this->strAppleImage76 = !empty($this->arrResult[0]['apple_image_76']) ? $this->arrResult[0]['apple_image_76'] : '/application/images/touch/apple-touch-icon-76x76.png';
            $this->strAppleImage72 = !empty($this->arrResult[0]['apple_image_72']) ? $this->arrResult[0]['apple_image_72'] : '/application/images/touch/apple-touch-icon-72x72.png';
            $this->strAppleImage57 = !empty($this->arrResult[0]['apple_image_57']) ? $this->arrResult[0]['apple_image_57'] : '/application/images/touch/apple-touch-icon-57x57.png';

            $this->strGoogleAnalytics = $this->arrResult[0]['google_analytics'];
            $this->strHeaderTrackingCode = $this->arrResult[0]['header_tracking_code'];
            $this->strFooterTrackingCode = $this->arrResult[0]['footer_tracking_code'];
            $this->strFacebookInsights = $this->arrResult[0]['facebook_insights'];
            $this->strGoogleWebmaster = $this->arrResult[0]['google_webmaster'];
            $this->strBingWebmaster = $this->arrResult[0]['bing_webmaster'];
            $this->strAlexaVerificationId = $this->arrResult[0]['alexa_verification_id'];
            $this->strPinterestVerification = $this->arrResult[0]['pinterest_verification'];
            $this->strRobotsNoodp = $this->arrResult[0]['robots_noodp'];
            $this->strRobotsNoydir = $this->arrResult[0]['robots_noydir'];
            $this->strRobots = $this->arrResult[0]['robots'];

	     	$this->strFacebookURL = $this->arrResult[0]['facebook_url'];
	     	$this->strTwitterURL = $this->arrResult[0]['twitter_url'];
	     	$this->strTwitterName = $this->arrResult[0]['twitter_name'];
	     	$this->strPintrestURL = $this->arrResult[0]['pintrest_url'];
	     	$this->strLinkedinURL = $this->arrResult[0]['linkedin_url'];
            $this->strGoogleURL = $this->arrResult[0]['google_url'];
            $this->strInstagramURL = $this->arrResult[0]['instagram_url'];
            $this->strRSSURL = $this->arrResult[0]['rss_url'];
            $this->strYoutubeURL = $this->arrResult[0]['youtube_url'];

            // SEO Fields
            $this->strMetaTitle = $this->strSiteName;
            $this->strMetaKeywords = '';
            $this->strMetaDescription = $this->strSiteDescription;
            $this->strMetaRobots = '';
            $this->strFacebookTitle = $this->strSiteName;
            $this->strFacebookDescription = $this->strSiteDescription;
            $this->strFacebookImage = $this->strOGImage;
            $this->strTwitterTitle = $this->strSiteName;
            $this->strTwitterDescription = $this->strSiteDescription;
            $this->strTwitterImage = $this->strOGImage;
	    }

	}


    public function getDetail() {
        $this->strQuery = "SELECT *
        FROM $this->strTableName
        LIMIT 0,1";

        if($this->query($this->strQuery)) {
            return $this->getMysqliResults($this->strQuery,true);
        } else {
            return null;
        }
    }

    public function handlePost($post) {
        $this->strSiteName = isset($post['site_name']) ? $post['site_name'] : '';
        $this->strSiteDescription = isset($post['site_description']) ? $post['site_description'] : '';
        $this->strAdminEmail = isset($post['admin_email']) ? $post['admin_email'] : '';

        $this->strGoogleAnalytics = isset($post['google_analytics']) ? $post['google_analytics'] : '';
        $this->strHeaderTrackingCode = isset($post['header_tracking_code']) ? $post['header_tracking_code']: '';
        $this->strFooterTrackingCode = isset($post['footer_tracking_code']) ? $post['footer_tracking_code']: '';
        $this->strFacebookInsights = isset($post['facebook_insights']) ? $post['facebook_insights'] : '';
        $this->strGoogleWebmaster = isset($post['google_webmaster']) ? $post['google_webmaster']: '';
        $this->strBingWebmaster = isset($post['bing_webmaster']) ? $post['bing_webmaster'] : '';
        $this->strAlexaVerificationId = isset($post['alexa_verification_id']) ? $post['alexa_verification_id'] : '';
        $this->strPinterestVerification = isset($post['pinterest_verification']) ? $post['pinterest_verification'] : '';
        $this->strRobotsNoodp = isset($post['robots_noodp']) ? $post['robots_noodp'] : '';
        $this->strRobotsNoydir = isset($post['robots_noydir']) ? $post['robots_noydir'] : '';
        $this->strRobots = isset($post['robots']) ? $post['robots'] : '';
        $this->strFacebookURL = isset($post['facebook_url']) ? $post['facebook_url'] : '';
        $this->strTwitterURL = isset($post['twitter_url']) ? $post['twitter_url'] : '';
        $this->strTwitterName = isset($post['twitter_name']) ? $post['twitter_name'] : '';
        $this->strPintrestURL = isset($post['pintrest_url']) ? $post['pintrest_url'] : '';
        $this->strLinkedinURL = isset($post['linkedin_url']) ? $post['linkedin_url'] : '';
        $this->strGoogleURL = isset($post['google_url']) ? $post['google_url'] : '';
        $this->strInstagramURL = isset($post['instagram_url']) ? $post['instagram_url'] : '';
        $this->strRSSURL = isset($post['rss_url']) ? $post['rss_url'] : '';
        $this->strYoutubeURL = isset($post['youtube_url']) ? $post['youtube_url'] : '';
        $this->intPayPalMode = isset($post['paypal_mode']) ? $post['paypal_mode'] : '';
        $this->intVoucherBreak = isset($post['voucher_force_break_amount']) ? $post['voucher_force_break_amount'] : '';

        if($this->strSiteName == '') { $this->strErrorMessage .= "Please enter a site name.<br />"; }
        if($this->strSiteDescription == '') { $this->strErrorMessage .= "Please enter a site description.<br />"; }
        if($this->strAdminEmail == '') { $this->strErrorMessage .= "Please enter an admin email address.<br />"; }

        if($this->strErrorMessage == '') {

            $keys = array(
                'site_name',
                'site_description',
                'admin_email',
                'og_image',
                'google_analytics',
                'header_tracking_code',
                'footer_tracking_code',
                'facebook_insights',
                'google_webmaster',
                'bing_webmaster',
                'alexa_verification_id',
                'pinterest_verification',
                'robots_noodp',
                'robots_noydir',
                'robots',
                'facebook_url',
                'twitter_url',
                'twitter_name',
                'pintrest_url',
                'linkedin_url',
                'google_url',
                'instagram_url',
                'rss_url',
                'youtube_url',
                'paypal_mode',
                'voucher_force_break_amount'
            );

            $vals = array(
                $this->strSiteName,
                $this->strSiteDescription,
                $this->strAdminEmail,
                $this->strOGImage,
                $this->strGoogleAnalytics,
                $this->strHeaderTrackingCode,
                $this->strFooterTrackingCode,
                $this->strFacebookInsights,
                $this->strGoogleWebmaster,
                $this->strBingWebmaster,
                $this->strAlexaVerificationId,
                $this->strPinterestVerification,
                $this->strRobotsNoodp,
                $this->strRobotsNoydir,
                $this->strRobots,
                $this->strFacebookURL,
                $this->strTwitterURL,
                $this->strTwitterName,
                $this->strPintrestURL,
                $this->strLinkedinURL,
                $this->strGoogleURL,
                $this->strInstagramURL,
                $this->strRSSURL,
                $this->strYoutubeURL,
                $this->intPayPalMode,
                $this->intVoucherBreak
            );

            //$types = array('ssssssssssssssssssssssss');

            $this->strErrorMessage = $this->mysqliupdate('settings',$keys,$vals,'','1');
            $this->strSuccessMessage = 'Settings Updated';
        }


        if (!empty($_FILES)) {

            foreach ($_FILES as $name => $file) {

                // Skip any files that didn't upload correctly
                if ($file['error'] !== 0) {
                    continue;
                }

                $arrUploaded = Util::uploadFile(
                    $_FILES[$name],
                    ROOT_DIR.'/application/uploads/images/'.Date('Y').'/',
                    $name,
                    array('image/*')
                );

                if ($arrUploaded) {
                    // If the file uploaded successfully
                    $url = str_replace(ROOT_DIR, '', $arrUploaded['dir']);
                    $fileName = $url.$arrUploaded['file'];
                    $strDisplayname = str_replace('_', ' ', ucwords($name));
                    $strObjName = str_replace('_', '', $name);

                    if ($name == 'og_image') {
                        $strObjName = 'strOGImage';
                    } else {
                        $strObjName = 'str' . str_replace(' ', '', ucwords(str_replace('_', ' ', $name)));
                    }
                    // Update the value
                    $this->{$strObjName} = $fileName;

                    $this->strQuery = 'UPDATE '.$this->strTableName.' SET `'.$name.'` = "'.$fileName.'" WHERE id=1';
                    if($this->short_query($this->strQuery)) {
                        $this->strSuccessMessage .= '<br> '.$strDisplayname.' Updated';
                    } else {
                        $this->strErrorMessage .= 'SQL error:'.$this->strQuery;
                    }
                }

            }
        }
    }
    
    public function checkpageaccess($moduleName,$action){
	    
	    $sql = "SELECT * FROM admins WHERE userID=" . $_SESSION['userID'] ;
	    $columns = $this->getMysqliResults( $sql, true );
	    
	    $_SESSION['is_admin'] = $columns[0]['is_admin'];
	        
	    if(!is_null($_SESSION['is_admin']) && $_SESSION['is_admin'] == 'true'){
            return true;
        }else{
            return false;
            
        }
        
	}


    public function getSocialMediaBar() {
        $strOutput = '';
        $arrAccounts = array(
            'facebook' => $this->strFacebookURL,
            'twitter' => $this->strTwitterURL,
            'linkedin' => $this->strLinkedinURL,
            'google-plus' => $this->strGoogleURL,
            'youtube' => $this->strYoutubeURL,
            'pinterest' => $this->strPintrestURL,
            'instagram' => $this->strInstagramURL,
            'rss' => $this->strRSSURL
        );

        $strOutput .= '<ul class="social-media list-inline">';
        foreach ($arrAccounts as $type => $account) {
            if (!empty($account)) {
                $strOutput .= '<li class="'.$type.'"><a class="btn btn-social-media" href="'.$account.'" target="_blank"><span class="fa fa-'.$type.' fa-lg"></span></a></li>';
            }
        }
        $strOutput .= '</ul>';

        return $strOutput;
    }



    public function initSEO($objSEO) {

        $this->strMetaTitle = $objSEO->strMetaTitle;
        $this->strTitle = $objSEO->strTitle;
        $this->strMetaTitle = $objSEO->strMetaTitle;
        $this->strMetaKeywords = $objSEO->strMetaKeywords;
        $this->strMetaDescription = $objSEO->strMetaDescription;
        $this->strMetaRobots = $objSEO->strMetaRobots;
        $this->strOGImage = $objSEO->strOGImage;

        $this->strFacebookTitle = $objSEO->strFacebookTitle;
        $this->strFacebookDescription = $objSEO->strFacebookDescription;
        $this->strFacebookImage = $objSEO->strFacebookImage;
        $this->strTwitterTitle = $objSEO->strTwitterTitle;
        $this->strTwitterDescription = $objSEO->strTwitterDescription;
        $this->strTwitterImage = $objSEO->strTwitterImage;
        $this->strGoogleDescription = $objSEO->strGoogleDescription;

        // Page specific SEO settings. These may override the default settings.
        /*
        $this->strQuery = "SELECT *
        FROM $objSEO->strTableName
        WHERE slug
        LIKE '$objSEO->strTableSlug'
        LIMIT 0,1";

        if($this->query($this->strQuery)) {
            $this->arrResult = $this->getMysqliResults($this->strQuery,true);


            if(count($this->arrResult) > 0) {
                $this->strSiteName = $this->strSiteName;
                $this->strTitle = !empty($this->arrResult[0][$strTitle]) ? $this->arrResult[0][$strTitle] : '';
                $this->strContent = !empty($this->arrResult[0][$strContent]) ? $this->arrResult[0][$strContent] : '';
                $this->strMetaTitle = !empty($this->arrResult[0][$strMetaTitle]) ? $this->arrResult[0][$strMetaTitle] : '';
                $this->strMetaKeywords = !empty($this->arrResult[0][$strMetaKeywords]) ? $this->arrResult[0][$strMetaKeywords] : '';
                $this->strMetaDescription = !empty($this->arrResult[0][$strMetaDescription]) ? $this->arrResult[0][$strMetaDescription] : '';
                $this->strMetaRobots = !empty($this->arrResult[0][$strMetaRobots]) ? $this->arrResult[0][$strMetaRobots] : '';
                $this->strOGImage = !empty($this->arrResult[0][$strOGImage]) ? $this->arrResult[0][$strOGImage] : '';

                $this->strFacebookTitle = !empty($this->arrResult[0][$strFacebookTitle]) ? $this->arrResult[0][$strFacebookTitle] : '';
                $this->strFacebookDescription = !empty($this->arrResult[0][$strFacebookDescription]) ? $this->arrResult[0][$strFacebookDescription] : '';
                $this->strFacebookImage = !empty($this->arrResult[0][$strFacebookImage]) ? $this->arrResult[0][$strFacebookImage] : '';

                $this->strTwitterTitle = !empty($this->arrResult[0][$strTwitterTitle]) ? $this->arrResult[0][$strTwitterTitle] : '';
                $this->strTwitterDescription = !empty($this->arrResult[0][$strTwitterDescription]) ? $this->arrResult[0][$strTwitterDescription] : '';
                $this->strTwitterImage = !empty($this->arrResult[0][$strTwitterImage]) ? $this->arrResult[0][$strTwitterImage] : '';

                $this->strGoogleDescription = !empty($this->arrResult[0][$strGoogleDescription]) ? $this->arrResult[0][$strGoogleDescription] : '';
            }

        } else {
            $this->strErrorMessage = null;
        }
        */

    }



    public function getMetaTags() {
        $strOutput = '';
        $cr = "\n\r";

        // Fall backs for our titles, descriptions, images
        $strTitle = !empty($this->strMetaTitle) ? $this->strMetaTitle : $this->strSiteName;
        $strDescription = !empty($this->strMetaDescription) ? $this->strMetaDescription : $this->strSiteDescription;
        $strImage = !empty($this->strOGImage) ? ROOT_URL.$this->strOGImage : ROOT_URL.$this->strOGImageOriginal;
        $strRobots = !empty($this->strMetaRobots) ? $this->strMetaRobots : 'follow,index';

        // Facebook
        $strFacebookTitle = !empty($this->strFacebookTitle) ? $this->strFacebookTitle : $strTitle;
        $strFacebookDescription = !empty($this->strFacebookDescription) ? $this->strFacebookDescription : $strDescription;
        $strFacebookImage = !empty($this->strFacebookImage) ? ROOT_URL.$this->strFacebookImage : $strImage;

        // Twitter
        $strTwitterTitle = !empty($this->strTwitterTitle) ? $this->strTwitterTitle : $strTitle;
        $strTwitterDescription = !empty($this->strTwitterDescription) ? $this->strTwitterDescription : $strDescription;
        $strTwitterImage = !empty($this->strTwitterImage) ? ROOT_URL.$this->strTwitterImage : $strImage;


        $strOutput .= '<title>'.$strTitle.'</title>'.$cr.$cr;

        $strOutput .= '<!-- META TAGS FOR SEARCH ENGINES -->'.$cr;

        if(!empty($this->strMetaKeywords)) {
            $strOutput .= '<meta name="keywords" content="'.$this->strMetaKeywords.'">'.$cr;
        }
        if(!empty($strDescription)) {
            $strOutput .= '<meta name="description" content="'.$strDescription.'">'.$cr;
        }
        if (!empty($this->strGoogleDescription)) {
            $strOutput .= '<meta itemprop="description" content="'.$this->strGoogleDescription.'">'.$cr;
        }

        // Add a global value to the robots from the site settings
        $strNoodp   = !empty($this->strRobotsNoodp) ? ',noodp' : '';
        $strNoydir  = !empty($this->strRobotsNoydir) ? ',noydir' : '';

        $strOutput .= '<meta name="robots" content="'.$strRobots.$strNoodp.$strNoydir.'" />'.$cr;
        $strOutput .= '<link rel="canonical" href="'.ROOT_URL.$_SERVER['REQUEST_URI'].'" />'.$cr.$cr;

        $strOutput .= '<!-- META TAGS FOR OPEN GRAPH -->'.$cr;
        $strOutput .= '<meta property="og:locale" content="en_US"/>'.$cr;
        $strOutput .= '<meta property="og:type" content="website" />'.$cr;
        $strOutput .= '<meta property="og:title" content="'.$strFacebookTitle.'" />'.$cr;
        $strOutput .= '<meta property="og:description" content="'.$strFacebookDescription.'" />'.$cr;
        $strOutput .= '<meta property="og:url" content="'.ROOT_URL.$_SERVER['REQUEST_URI'].'"/>'.$cr;
        $strOutput .= '<meta property="og:site_name" content="'.$this->strSiteName.'" />'.$cr;
        $strOutput .= '<meta property="og:image" content="'.$strFacebookImage.'" />'.$cr.$cr;

        $strOutput .= '<!-- META TAGS FOR TWITTER CARD -->'.$cr;
        $strOutput .= '<meta name="twitter:card" content="summary">'.$cr;
        $strOutput .= '<meta name="twitter:site" content="'.$this->strTwitterURL.'">'.$cr;
        $strOutput .= '<meta name="twitter:title" content="'.$strTwitterTitle.'">'.$cr;
        $strOutput .= '<meta name="twitter:description" content="'.$strTwitterDescription.'">'.$cr;
        $strOutput .= '<meta name="twitter:creator" content="'.$this->strTwitterName.'">'.$cr;
        $strOutput .= '<meta name="twitter:image:src" content="'.$strTwitterImage.'">'.$cr;
        $strOutput .= '<meta name="twitter:domain" content="'.ROOT_URL.'">'.$cr.$cr;

        $strOutput .= '<!-- WEBMASTER VERIFICATIONS -->'.$cr;
        if (!empty($this->strGoogleWebmaster)) {
            $strOutput .= stripslashes($this->strGoogleWebmaster).$cr;
        }
        if (!empty($this->strBingWebmaster)) {
            $strOutput .= stripslashes($this->strBingWebmaster).$cr;
        }
        if (!empty($this->strAlexaVerificationId)) {
            $strOutput .= stripslashes($this->strAlexaVerificationId).$cr;
        }
        if (!empty($this->strPinterestVerification)) {
            $strOutput .= stripslashes($this->strPinterestVerification).$cr;
        }

        $strOutput .= $cr;

        if (!empty($this->strFacebookInsights)) {
            $strOutput .= '<!-- FACEBOOK INSIGHTS -->'.$cr;
            $strOutput .= stripslashes($this->strFacebookInsights).$cr;
        }

        $strOutput .= $cr;

        $strOutput .= '<!-- MOBILE IE ALLOWS US TO ACTIVATE CLEARTYPE TECHNOLOGY FOR SMOOTHING FONTS FOR EASY READING -->'.$cr;
        $strOutput .= '<meta http-equiv="cleartype" content="on">'.$cr.$cr;

        $strOutput .= '<!-- ADD TO HOMESCREEN FOR CHROME ON ANDROID -->'.$cr;
        $strOutput .= '<meta name="mobile-web-app-capable" content="yes">'.$cr.$cr;

        $strOutput .= '<!-- FOR IOS WEB APPS -->'.$cr;
        $strOutput .= '<meta name="apple-mobile-web-app-capable" content="yes">'.$cr;
        $strOutput .= '<meta name="apple-mobile-web-app-status-bar-style" content="black">'.$cr;
        $strOutput .= '<meta name="apple-mobile-web-app-title" content="Navigator Multimedia Inc Web App Template">'.$cr.$cr;

        $strOutput .= '<!-- HOME SCREEN ICONS -->'.$cr;
        $strOutput .= '<link href="'.ROOT_URL.$this->strAppleImage152.'" sizes="152x152" rel="apple-touch-icon">'.$cr;
        $strOutput .= '<link href="'.ROOT_URL.$this->strAppleImage144.'" sizes="144x144" rel="apple-touch-icon">'.$cr;
        $strOutput .= '<link href="'.ROOT_URL.$this->strAppleImage114.'" sizes="114x114" rel="apple-touch-icon">'.$cr;
        $strOutput .= '<link href="'.ROOT_URL.$this->strAppleImage76.'" sizes="76x76" rel="apple-touch-icon">'.$cr;
        $strOutput .= '<link href="'.ROOT_URL.$this->strAppleImage72.'" sizes="72x72" rel="apple-touch-icon">'.$cr;
        $strOutput .= '<link href="'.ROOT_URL.$this->strAppleImage57.'" sizes="57x57" rel="apple-touch-icon">'.$cr.$cr;

        $strOutput .= '<!-- TILE ICON FOR WINDOWS (144x144 + tile color) -->'.$cr;
        $strOutput .= '<meta name="msapplication-TileImage" content="'.$this->strAppleImage144.'">'.$cr;
        $strOutput .= '<meta name="msapplication-TileColor" content="#222222">'.$cr;

        return $strOutput;
    }


    public function getHeaderScripts() {
        $objSettings = new Settings;
        $strOutput = '';
        $cr = "\n\r";

        if (!empty($objSettings->strGoogleAnalytics)) {
            $strOutput .= '<!-- GOOGLE ANALYTICS -->'.$cr;
            $strOutput .= $objSettings->strGoogleAnalytics.$cr.$cr;
        }

        if (!empty($objSettings->strHeaderTrackingCode)) {
            $strOutput .= '<!-- HEADER TRACKING CODE -->'.$cr;
            $strOutput .= $objSettings->strHeaderTrackingCode.$cr.$cr;
        }

        return $strOutput;
    }

    public function getFooterScripts() {
        $objSettings = new Settings;
        $strOutput = '';
        $cr = "\n\r";

        if (!empty($objSettings->strFooterTrackingCode)) {
            $strOutput .= '<!-- FOOTER TRACKING CODE -->'.$cr;
            $strOutput .= $objSettings->strFooterTrackingCode.$cr.$cr;
        }

        return $strOutput;
    }




    /**
     * Gets regions for the nav
     *
     */
    public function getRegionsForNav($arrArgs = array()) {
        // Set default args
        $arrArgs = Util::wp_parse_args($arrArgs, array(
            'country' => '',
            'state' => '',
            'city' => '',
            'international' => false,
            'packages' => false,
            'other' => false,
        ));

        // Build the query
        $this->strQuery = "SELECT * FROM `region` r WHERE r.`status` = 'Active' AND r.`display_order` > 0";

        if ($arrArgs['international']) {
            $this->strQuery .= " AND r.`country_id` NOT IN (261, 148, -1) "; // Not in CA or USA
        } else if ($arrArgs['other']) {
            $this->strQuery .= " AND r.`country_id` = -1 "; // N/A Selected for country
        } else {
            if (!empty($arrArgs['country'])) {
                $this->strQuery .= " AND r.`country_id` = " . $arrArgs['country'] . " ";
            }
            if (!empty($arrArgs['state'])) {
                $this->strQuery .= " AND r.`state_id` = " . $arrArgs['state'] . " ";
            }
            if (!empty($arrArgs['city'])) {
                $this->strQuery .= " AND r.`city` LIKE '%|" . $arrArgs['city'] . "|%' ";
            }
        }

        if ($arrArgs['packages']) {
            // Add the subquery to check the number of packages in a region
            $strPackageQuery = "SELECT COUNT(id) FROM `feature_packages` WHERE 1=1"
                             . " AND `region_id` = r.`id` "
                             . " AND `status` = 'Active' "
                             . " AND `start_date` < '" . date('Y-m-d') . "' "
                             . " AND `end_date` >= '" . date('Y-m-d') . "' ";

            // Exclude regions that have no packages
            $this->strQuery .= " AND ($strPackageQuery) > 0 ";
        }

        // Add orderby
        $this->strQuery .= ' ORDER BY `display_order` ';

        if($this->query($this->strQuery)) {
            $arrResult = $this->getMysqliResults($this->strQuery, true);
            return $arrResult;
        }

        return array();
    }




    public function getCoursesForNav() {
        //page specific SEO settings. These may override the default settings.
        $this->strQuery = "SELECT id, course_name, slug
        FROM course
        WHERE status ='Active' AND type_id=3
        ORDER BY course_name";

        if($this->query($this->strQuery)) {
            $arrResult = $this->getMysqliResults($this->strQuery,true);
            return $arrResult;
        }

    }


    public function getCitiesForNav() {
        //page specific SEO settings. These may override the default settings.
        $this->strQuery = "SELECT distinct title
        FROM city
        WHERE status ='Active'
        AND title != ''
        ORDER BY title";

        if($this->query($this->strQuery)) {
            $arrResult = $this->getMysqliResults($this->strQuery,true);
            return $arrResult;
        }

    }

    public function getProvsForNav() {
        //page specific SEO settings. These may override the default settings.
        $this->strQuery = "SELECT distinct state_name
        FROM state
        WHERE status ='Active'
        AND state_name != ''
        ORDER BY state_name";

        if($this->query($this->strQuery)) {
            $arrResult = $this->getMysqliResults($this->strQuery,true);
            return $arrResult;
        }

    }

    public function getPagesForNav($cat_id) {
        //page specific SEO settings. These may override the default settings.
        $this->strQuery = "SELECT id, title, slug, cat_id
        FROM pages
        WHERE status ='Active' AND cat_id=$cat_id AND nav_order>0
        ORDER BY nav_order, title";


        //echo Util::debugDisplay($this->strQuery);


        if($this->query($this->strQuery)) {
            $arrResult = $this->getMysqliResults($this->strQuery,true);
            return $arrResult;
        }

    }

    /**
     * Gets 3 random testimonials
     *
     */
    public function getRandomTestimonials() {
        // Get the testimonials
        $this->strQuery = "SELECT * FROM testimonial ORDER BY rand() LIMIT 0, 3";
        if($this->query($this->strQuery)) {
            $arrResult = $this->getMysqliResults($this->strQuery,true);
            return $arrResult;
        }
    }

    /**
     * Creates a hero image
     *
     */
    public static function createHeroImage($arrArgs = array()) {
        // Set default args
        $arrArgs = Util::wp_parse_args($arrArgs, array(
            'file_name' => '',
            'url' => '',
            'hero_title' => '',
            'hero_text' => '',
        ));

        // Set variables
        $strImageSrc  = Util::createImageSrc($arrArgs['file_name'], 1920, 600);
        $strHeroUrl   = !empty($arrArgs['url']) ? $arrArgs['url'] : '' ;
        $strHeroTitle = !empty($arrArgs['hero_title']) ? $arrArgs['hero_title'] : '';
        $strHeroText  = !empty($arrArgs['hero_text']) ? $arrArgs['hero_text'] : '';

        // Build the link
        $strHeroLink = '';
        if (!empty($strHeroUrl)) {
            $strHeroLink .= '<a class="hero-link" href="' . $strHeroUrl . '"></a>';
        }

        // Build the image
        $strHeroImage = '';
        if (!empty($strImageSrc)) {
            $strHeroImage .= '<div class="hero-bg">'
                           . '<div class="hero-image" style="background-image: url(' . $strImageSrc . ');"></div>'
                           . '</div>';
        }

        // Build the caption
        $strHeroCaption = '';
        if (!empty($strHeroTitle) || !empty($strHeroText)) {
            $strHeroCaption .= '<div class="hero-caption">'
                             . '<div class="hero-text">' . $strHeroText . '</div>'
                             . '<div class="hero-title">' . $strHeroTitle . '</div>'
                             . '</div>';
        }

        // Return the HTML
        return '<div class="hero-wrapper">'
             . '<div class="hero-overlay"></div>'
             . $strHeroLink
             . $strHeroImage
             . $strHeroCaption
             . '</div>';
    }

    /**
     * Creates a slideshow of hero images
     *
     */
    public static function createHeroCarousel($arrArgs = array()) {
        // Set default args
        $arrArgs = Util::wp_parse_args($arrArgs, array(
            'slides' => array(),
            'timer' => 6000,
            'controls' => true,
            'bullets' => true,
            'id' => 'slide-show',
        ));

        // Assign variables
        $arrSlides = (array) $arrArgs['slides'];
        $intTimer = (int) $arrArgs['timer'];
        $blnControls = !empty($arrArgs['controls']) ? true : false;
        $blnBullets = !empty($arrArgs['bullets']) ? true : false;
        $strId = (string) $arrArgs['id'];

        if (empty($arrSlides)) {
            return;
        }

        // Build the indicators
        $strBullets = '';
        if ($blnBullets && count($arrSlides) > 1) {
            foreach ($arrSlides as $i => $arrSlide) {
                $strActive = ($i == 0) ? 'active' : '';
                $strBullets .= '<li data-target="#' . $strId . '" data-slide-to="' . $i . '" class="' . $strActive . '"></li>';
            }
        }

        // Build the slides
        $strSlides = '';
        foreach ($arrSlides as $i => $arrSlide) {
            $strActive = ($i == 0) ? 'active' : '';
            $strSlides .= '<div class="item ' . $strActive . '">'
                        . '<div class="carousel-hero">' . static::createHeroImage($arrSlide) . '</div>'
                        . '<div class="carousel-caption"><p>' . $arrSlide['title'] . '</p></div>'
                        . '</div>';
        }

        // Build the next and previous controls
        $strControls = '';
        if ($blnControls && count($arrSlides) > 1) {
            $strControls .= '<a class="left carousel-control" href="#' . $strId . '" data-slide="prev">'
                          . '<span class="glyphicon glyphicon-chevron-left"></span>'
                          . '<span class="sr-only">Previous Slide</span>'
                          . '</a>';
            $strControls .= '<a class="right carousel-control" href="#' . $strId . '" data-slide="next">'
                          . '<span class="glyphicon glyphicon-chevron-right"></span>'
                          . '<span class="sr-only">Next Slide</span>'
                          . '</a>';
        }

        // Return the html
        return '<div id="' . $strId . '" class="carousel slide" data-ride="carousel" data-interval="' . $intTimer . '">'
             . '<ol class="carousel-indicators hidden-xs">' . $strBullets . '</ol>'
             . '<div class="carousel-inner">' . $strSlides . '</div>'
             . $strControls
             . '</div>';
    }

}