<?php

class Mass_Mailer extends Database {

    // The last query we executed
    public $strQuery;

    // The resource returned from above query
    public $arrResult;

    public $strTitle = 'Mass Mailer';

    public $intBrandId;
    public $intBookingPersonID;
    public $intPackageStatus;

    public function __construct() {

        parent::__construct();
        $this->strErrorMessage = "";

        $this->intBrandId = '';
        $this->intBookingPersonID = '';
        $this->intPackageStatus = '';
        $this->strContent = '';
        $this->strQuoteContent = '';
        $this->strEmailsRead = '';

        $this->strGroupName = '';

    }

    public function getBrands() {
        $strQuery = "SELECT * FROM brands ORDER BY business_name";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return null;
        }
    }

    public function getBookingPeople() {
        $strQuery = "SELECT * FROM booking_people ORDER BY booking_name";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return null;
        }
    }

    public function getPackageStatus() {
        $strQuery = "SELECT * FROM order_status ORDER BY status_name";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return null;
        }
    }

    public function getHotels() {
        $strQuery = "SELECT * FROM hotel WHERE deleted = 0 and status = 'Active' ORDER BY hotel_name";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return null;
        }
    }

    public function getCourses() {
        $strQuery = "SELECT * FROM course WHERE deleted = 0 and status = 'Active' ORDER BY course_name";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return null;
        }
    }

    public function getEmailList($arrArgs, $strType) {
        $arrArgs = array_values($arrArgs);

        if ($strType == 'Packages Mailer') {

            $this->strQuery = "
                SELECT DISTINCT(p.id),
                    p.user_email,
                    p.user_name,
                    p.group_name as group_name,
                    CONCAT('<a href=\"https://bcgolfguide.com/package/', p.session_id, '\">View Package</a>') as group_link,
                    (SELECT count(id) FROM package_hotel_detail WHERE package_hotel_id = ph.id) as golfer_num,
                    (SELECT booking_name FROM booking_people WHERE id = (SELECT booking_people_id FROM package_booking_people WHERE primary_contact = 1 AND package_id = p.id)) as booking_name,
                    (SELECT booking_email FROM booking_people WHERE id = (SELECT booking_people_id FROM package_booking_people WHERE primary_contact = 1 AND package_id = p.id)) as booking_email,
                    ph.check_in_date,
                    ph.check_out_date,
                    (SELECT booking_people_id FROM package_booking_people WHERE primary_contact = 1 and package_id = p.id) as package_id
                 FROM packages as p
                    JOIN package_hotel AS ph ON (ph.package_id = p.id AND ph.default = 1)
                WHERE 1=1
                AND p.status != 'Trash'
                AND p.deleted = 0
            ";

            $arrCourses = array();
            $arrHotels = array();

            foreach ($arrArgs as $arrArg) {
                if (($arrArg['name'] == 'group_name') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND p.group_name LIKE '%".$arrArg['value']."%'";
                }

                if (($arrArg['name'] == 'brandID') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND p.brandID = ".$arrArg['value'];
                }

                if (($arrArg['name'] == 'min_date') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND ph.check_in_date >= '".$arrArg['value'] . "'";
                }

                if (($arrArg['name'] == 'max_date') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND ph.check_out_date <= '".$arrArg['value'] . "'";
                }

                if (($arrArg['name'] == 'packageStatusID') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND p.completed = ".$arrArg['value'];
                }

                if (($arrArg['name'] == 'bookingAgentID') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND (SELECT booking_people_id FROM package_booking_people WHERE primary_contact = 1 AND package_id = p.id) = " . $arrArg['value'];
                }

                if (($arrArg['name'] == 'min_golfers') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND (SELECT count(id) FROM package_hotel_detail WHERE package_hotel_id = ph.id) >= " . $arrArg['value'];
                }

                if (($arrArg['name'] == 'max_golfers') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND (SELECT count(id) FROM package_hotel_detail WHERE package_hotel_id = ph.id) <= " . $arrArg['value'];
                }

                if (strpos($arrArg['name'], 'courses[') > -1) {
                    $arrCourses[] = $arrArg['value'];
                }

                if (strpos($arrArg['name'], 'hotels[') > -1) {
                    $arrHotels[] = $arrArg['value'];
                }
            }

            if (!empty($arrCourses)) {
                $this->strQuery = $this->strQuery .= " AND (SELECT count(id) FROM package_golf WHERE package_id = p.id AND course_id IN (".implode(",",$arrCourses).")) >= 1 ";
            }

            if (!empty($arrHotels)) {
                $this->strQuery = $this->strQuery .= " AND (SELECT count(id) FROM package_hotel WHERE package_id = p.id AND hotel_id IN (".implode(",",$arrHotels).")) >= 1 ";
            }

            $this->strQuery .= " Order By p.user_email, ph.check_in_date";
        }

        if ($strType == 'Quotes Mailer') {

            $this->strQuery = "
                SELECT q.id,
                    qg.group_id as quote_group_id,
                    q.user_email,
                    q.user_name,
                    q.quote_name as group_name,
                    CONCAT('<a href=\"https://bcgolfguide.com/quote-preview/', q.session_id, '\">View Quote</a>') as group_link,
                    (SELECT booking_name FROM booking_people WHERE id = (SELECT booking_people_id FROM quote_booking_people WHERE primary_contact = 1 AND quote_id = q.id)) as booking_name,
                    (SELECT booking_email FROM booking_people WHERE id = (SELECT booking_people_id FROM quote_booking_people WHERE primary_contact = 1 AND quote_id = q.id)) as booking_email,
                    g.group_name
                FROM quotes as q
                JOIN quote_group AS qg ON (q.id = qg.quote_id)
                JOIN quote_hotel AS qh ON (qh.quote_id = q.id AND qh.default = 1)
                JOIN `groups` AS g ON (qg.group_id = g.id)
                WHERE 1=1
                AND q.status = 'Active'
                AND q.deleted = 0
            ";

            $arrCourses = array();
            $arrHotels = array();

            $quote_max_date = '';
            $quote_min_date = '';

            foreach ($arrArgs as $arrArg) {
                if (($arrArg['name'] == 'quote_group_name') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND g.group_name LIKE '%".$arrArg['value']."%' ";
                }

                if (($arrArg['name'] == 'quote_name') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND q.quote_name LIKE '%".$arrArg['value']."%' ";
                }

                if (($arrArg['name'] == 'quoteBrandID') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND q.brandID = ".$arrArg['value'];
                }

                // Note: Quote min quote max should check ALL hotel arrival / departure dates
                // ALSO check the arrival / departure dates on the quote

                if (($arrArg['name'] == 'quote_min_date') && ($arrArg['value'] != '')) {
                    $quote_min_date = $arrArg['value'];
                    //$this->strQuery .= " AND q.dates_arrival >= '".$arrArg['value'] . "'";
                    //$this->strQuery .= " AND qh.check_in_date >= '".$arrArg['value'] . "'";
                }

                if (($arrArg['name'] == 'quote_max_date') && ($arrArg['value'] != '')) {
                    $quote_max_date = $arrArg['value'];
                    //$this->strQuery .= " AND q.dates_arrival <= '".$arrArg['value'] . "'";
                    //$this->strQuery .= " AND qh.check_out_date <= '".$arrArg['value'] . "'";
                }
/*
                if (($arrArg['name'] == 'quotePackageStatusID') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND q.completed = ".$arrArg['value'];
                }
*/
                if (($arrArg['name'] == 'emails_read') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND q.email_read = " . $arrArg['value'] ." ";
                }

                if (($arrArg['name'] == 'quoteAgentID') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND (SELECT booking_people_id FROM quote_booking_people WHERE primary_contact = 1 AND quote_id = q.id) = " . $arrArg['value'];
                }
/*
                if (($arrArg['name'] == 'quote_min_golfers') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND (SELECT count(id) FROM quote_hotel_detail WHERE quote_hotel_id = qh.id) >= " . $arrArg['value'];
                }

                if (($arrArg['name'] == 'quote_max_golfers') && ($arrArg['value'] != '')) {
                    $this->strQuery .= " AND (SELECT count(id) FROM quote_hotel_detail WHERE quote_hotel_id = qh.id) <= " . $arrArg['value'];
                }
                */

                if (strpos($arrArg['name'], 'quote_courses[') > -1) {
                    $arrCourses[] = $arrArg['value'];
                }

                if (strpos($arrArg['name'], 'quote_hotels[') > -1) {
                    $arrHotels[] = $arrArg['value'];
                }
            }

            if (($quote_min_date != '') && ($quote_max_date != '')) {
                $this->strQuery .= " AND ( (SELECT count(id) FROM quote_hotel WHERE quote_id = q.id AND check_in_date >= '".$quote_min_date."' AND check_out_date <= '".$quote_max_date."') > 0
                                        OR (q.dates_arrival >= '".$quote_min_date."' AND q.dates_depart <= '".$quote_max_date."')
                                    )
                ";
            } else if ($quote_min_date != '') {
                $this->strQuery .= " AND ( (SELECT count(id) FROM quote_hotel WHERE quote_id = q.id AND check_in_date >= '".$quote_min_date."') > 0
                                       OR q.dates_arrival >= '".$quote_min_date."'
                                    )
                ";
            } else if ($quote_max_date != '') {
                $this->strQuery .= " AND ( (SELECT count(id) FROM quote_hotel WHERE quote_id = q.id AND check_out_date <= '".$quote_max_date."') > 0
                                        OR q.dates_depart <= '".$quote_max_date."'
                                    )
                ";
            }

            if (!empty($arrCourses)) {
                $this->strQuery = $this->strQuery .= " AND (SELECT count(id) FROM quote_golf WHERE quote_id = q.id AND course_id IN (".implode(",",$arrCourses).")) >= 1 ";
            }

            if (!empty($arrHotels)) {
                $this->strQuery = $this->strQuery .= " AND (SELECT count(id) FROM quote_hotel WHERE quote_id = q.id AND hotel_id IN (".implode(",",$arrHotels).")) >= 1 ";
            }

            $this->strQuery .= " Order By q.user_email, q.id DESC";

        }

        if($this->query($this->strQuery)) {
            $results = $this->getMysqliResults($this->strQuery,true);
            $arrReturn = array();
            $arrUniqueEmails = array();
            foreach ($results as $arrRow) {
                if (!in_array($arrRow['user_email'], $arrUniqueEmails)) {
                    $arrUniqueEmails[] = $arrRow['user_email'];
                    $arrReturn[] = $arrRow;
                }
            }

            // sanity check
            /*
            if (count($arrReturn) > 100) {
                return array();
            }
            */

            return $arrReturn;
        }
    }

    public function getDetail() {

    }

    public function handlePost($post) {

    }
}