<?php


class Location extends Database  {

	public $strQuery;
	public $arrResult;
	public $intAffectedRows;
	public $strErrorMessage;
	public $strSuccessMessage;
	public $strTableName;
	public $strTableSlug;


	public function __construct() {

		parent::__construct();
		$this->strErrorMessage = "";
		$this->strTableName = 'state';

	}


	public function getStates($country,$debug = false) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT id, state_name
		From $this->strTableName WHERE country_id=$country AND status='Active' ORDER BY state_name;";

        if($debug) {
            Util::debugDisplay($this->strQuery);
        }

		if($this->query($this->strQuery)) {
			$r = $this->getMysqliResults($this->strQuery,true);
	     	return $r;
	    } else {
	     	return null;
	    }
	}



	public function getCities($state,$debug = false) {
		//page specific SEO settings. These may override the default settings.
		$this->strQuery = "SELECT id, title
		From city WHERE state_id=$state AND status='Active' ORDER BY title;";

        if($debug) {
            Util::debugDisplay($this->strQuery);
        }

		if($this->query($this->strQuery)) {
			$r = $this->getMysqliResults($this->strQuery,true);
	     	return $r;
	    } else {
	     	return null;
	    }


	}


	public function getCountries($debug = false) {
		$strQuery = "SELECT *
		from country t WHERE status='Active' ORDER BY country_name";

        if($debug) {
            Util::debugDisplay($this->strQuery);
        }

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }
	}

	public function getRegions() {
		$strQuery = "SELECT *
		from region r WHERE status='Active' and display_order>0 ORDER BY display_order, region_name";

		if($this->query($strQuery)) {
	     	$res = $this->getMysqliResults($strQuery,true);
	     	return $res;
	    } else {
	    	return null;
	    }
	}

    public function getRegionsByCountry($countryID,$debug = false) {
        $strQuery = "SELECT *
        from region r WHERE status='Active'
        and display_order>0 ";

        if($countryID != ''){
            if($countryID ==0){
                $strQuery .= "and country_id not in (261,148) ";
            } else {
                $strQuery .= "and country_id=$countryID ";
            }
        }

        $strQuery .= "ORDER BY display_order, region_name";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return null;
        }
    }

    public function getRegionsByState($stateID,$debug = false) {
        $strQuery = "SELECT *
        from region r WHERE status='Active'
        and display_order>0 ";

        if($stateID != ''){
            $strQuery .= "and state_id=$stateID ";
        }

        $strQuery .= "ORDER BY display_order, region_name";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res;
        } else {
            return null;
        }
    }

    public function getRegionIdByName($name) {
        $strQuery = "SELECT id
        from region r WHERE slug like '$name%' ORDER BY region_name";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res[0]['id'];
        } else {
            return null;
        }
    }

    public function getCityNameById($id) {
        $strQuery = "SELECT title
        from city WHERE id = $id";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res[0]['title'];
        } else {
            return null;
        }
    }

    public function getStateNameById($id) {
        $strQuery = "SELECT state_name
        from state WHERE id = $id";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res[0]['state_name'];
        } else {
            return null;
        }
    }

    public function getCountryNameById($id) {
        $strQuery = "SELECT code
        from country WHERE id = $id";

        if($this->query($strQuery)) {
            $res = $this->getMysqliResults($strQuery,true);
            return $res[0]['code'];
        } else {
            return null;
        }
    }

	public function getMapData($data, $showDirections = true, $lat = '49.8946343957342', $long='-119.446105957031', $zlevel = '11') {
        ?>
		<script>
        jQuery(document).ready(function(){

			jQuery('#gmap').each(function(){
                var lat = '<?php echo $lat;?>';
                var long = '<?php echo $long;?>';
                var zoom_lvl = <?php echo $zlevel;?>;
                var init_latlng = new google.maps.LatLng(lat, long);

                var mapHolder = jQuery(this);
                var bounds = new google.maps.LatLngBounds();

                var marker = null;
                var add_marker  = false;

                var mapOptions = {
                    center: init_latlng,
                    zoom: zoom_lvl,
                    scrollwheel: false,
                };

                var map = new google.maps.Map(document.getElementById(mapHolder.attr('id')), mapOptions);

                <?php if($showDirections) { ?>
                    directionsDisplay = new google.maps.DirectionsRenderer();
                    directionsDisplay.setMap(map);
                    directionsDisplay.setPanel(document.getElementById('directions-panel'));
                <?php } ?>

                var obj = '';
                var bounds = new google.maps.LatLngBounds();

                <?php
                if(isset($data->arrCourses) && count($data->arrCourses) > 0) {
                    foreach($data->arrCourses As $course) {
                        $course_name = str_replace("'","",$course['course_name']);
                        $lvl = $course['level'];
                        ?>

                        var myLatlng = new google.maps.LatLng('<?php echo $course['latitude'];?>','<?php echo $course['longitude']; ?>');

                        var marker = new google.maps.Marker({
                            position: myLatlng,
                            map: map,
                            title: '<?php echo $course_name;?>'
                        });

                        <?php if($course['type_id'] == 3 || $course['type_id'] == 7) { ?>
                            marker.setIcon('<?php echo ROOT_URL; ?>/application/images/ico-course-deluxe.png');
                        <?php } else { ?>
                            marker.setIcon('<?php echo ROOT_URL; ?>/application/images/ico-course-basic.png');
                        <?php } ?>

                        google.maps.event.addListener(marker, 'click', function(event){
                            // Start the output
                            var valString = '';

                            valString += '<div class="map-info-window">';
                            valString += '<h4><a href="/golf-courses/<?php echo $course['slug'];?>/"><?php echo $course_name; ?></a></h4>';

                            <?php if($lvl > 0) { ?>
        						valString += '<div class="meta">';
        						valString += '<strong>Price:</strong> ';

    							<?php
                                $lvl = $lvl / 2;
    							for ($i=0; $i <= 10; $i++) {
    								$strActive = ($i < $lvl) ? 'active' : '';

                                    if($i < $lvl) {
                                        ?>
                                        valString += '<span class="fa fa-dollar <?php echo $strActive; ?>"></span>';
                                        <?php
                                    }
                                }
                                ?>

                                valString += ' 1 x $ = $20 / <?php echo $lvl;?> x $ = $<?php echo $lvl*20;?>';
                                valString += '<br />Price scale reflects peak time frame full green fee price with cart – pre tax</div>';
    						<?php } ?>

                            valString += '<div class="row tight">';

                            <?php
                            $intContentCol = 12;
                            if (Util::isFile($course['primary_image'])) {
                                $intContentCol = 9;
                                $strImage = Util::createImageSrc($course['primary_image'], 90, 90, 3);
                                ?>
                                valString += '<div class="col-xs-3">';
                                valString += '<img src="<?php echo $strImage; ?>" class="map-img" />';
                                valString += '</div>'; // col-xs-3
                                <?php
                            }
                            ?>

                            valString += '<div class="col-xs-<?php echo $intContentCol; ?>">';

                            valString += '<div class="content">';

                            valString += "<strong>Address:</strong> <?php echo $course['address']; ?><br />";

                            <?php if( $course['teetimes_phone'] != '' && $course['type_id'] != 3 && $course['type_id'] != 7) { ?>
                                valString += '<strong>Phone:</strong> <?php echo $course['teetimes_phone']; ?><br />';
                            <?php } ?>

                            <?php if($course['type_id'] == 3 || $course['type_id'] == 7) { ?>
                                //valString += '<strong>Packages:</strong> <a href="/r/featured-golf-packages/<?php echo $course['region_id'];?>/">view packages</a><br />';
                            <?php } ?>

                            valString += '<div class="map-btn-wrapper"><a href="/map/course/<?php echo $course['slug']; ?>/" class="btn btn-secondary btn-icon-after pull-left btn-sm" >View Map</a><a href="/golf-courses/<?php echo $course['slug'];?>/" class="btn btn-primary btn-icon-after btn-sm pull-right">View Details</a></div>';

                            valString += '</div>'; // content

                            valString += '</div>'; // col-xs-9

                            valString += '</div>'; // row

                            valString += '</div>'; // info-window

                            infoWindow.setContent(valString);
                            infoWindow.setPosition(event.latLng);
                            infoWindow.open(map);
                        });

                        infoWindow = new google.maps.InfoWindow();

                        <?php
                	}
            	}


                if(isset($data->arrHotels) && count($data->arrHotels) > 0) {
                    foreach($data->arrHotels As $hotel) {
                        $hotel_name = str_replace("'","",$hotel['hotel_name']);
                        $lvl = $hotel['level'];
                        ?>

                        var myLatlng = new google.maps.LatLng('<?php echo $hotel['latitude'];?>','<?php echo $hotel['longitude']; ?>');

                        var marker = new google.maps.Marker({
                            position: myLatlng,
                            map: map,
                            title: '<?php echo $hotel_name;?>'
                        });

                        marker.setIcon('<?php echo ROOT_URL."/application/images/ico-hotel.png"; ?>');

                        google.maps.event.addListener(marker, 'click', function(event){

                            var valString = '<div class="map-info-window">';
                            valString += '<h4><a href="/golf-accommodations/<?php echo $hotel['slug'];?>/"><?php echo $hotel_name; ?></a></h4>';

                            <?php if($lvl > 0) { ?>
                                valString += '<div class="meta">';
                                valString += '<strong>Rating:</strong> ';

                                <?php
                                $lvl = $lvl / 2;
                                for ($i=0; $i < 5; $i++) {
                                    $i = floatval($i);
                                    $strActive = '';

                                    // Determine the icon based off the score
                                    if ($lvl <= $i) {
                                        $strStar = 'fa-star-o';
                                    } else if($lvl > $i && $lvl < ($i+1)) {
                                        $strStar = 'fa-star-half-o';
                                        $strActive = 'active';
                                    } else {
                                        $strStar = 'fa-star';
                                        $strActive = 'active';
                                    }
                                    ?>
                                    valString += '<span class="fa <?php echo $strStar.' '.$strActive; ?>"></span>';
                                    <?php
                                }
                                ?>

                                valString += '</div>';

                            <?php } ?>

                            valString += '<div class="row tight">';

                            <?php
                            $intContentCol = 12;
                            if (Util::isFile($hotel['primary_image'])) {
                                $intContentCol = 9;
                                $strImage = Util::createImageSrc($hotel['primary_image'], 90, 90, 3);
                                ?>
                                valString += '<div class="col-xs-3">';
                                valString += '<img src="<?php echo $strImage; ?>" class="map-img" />';
                                valString += '</div>'; // col-xs-3
                                <?php
                            }
                            ?>

                            valString += '<div class="col-xs-<?php echo $intContentCol; ?>">';

                            valString += '<div class="content">';

                            valString += '<strong>Address:</strong> <?php echo $hotel['address']; ?><br />';

                            valString += '<?php echo $hotel['city']; ?>, <?php echo $hotel['short_name']; ?><br />';

                            valString += '<div class="map-btn-wrapper"><a href="/golf-accommodations/<?php echo $hotel['slug'];?>/" class="btn btn-primary btn-icon-after btn-sm pull-right">View Details</a></div>';

                            valString += '</div>'; // content

                            valString += '</div>'; // col-xs-9

                            valString += '</div>'; // row

                            valString += '</div>'; // info-window

                            infoWindow.setContent(valString);
                            infoWindow.setPosition(event.latLng);
                            infoWindow.open(map);
                        });

                        infoWindow = new google.maps.InfoWindow();

                        <?php
                    }
                }

                ?>

                bounds.extend(myLatlng);

            });

        });
        </script>
        <?php
	}

    public static function getMapData2($arrArgs = array()) {
        // Set default args
        $arrArgs = Util::wp_parse_args($arrArgs, array(
            'courses' => array(),
            'hotels' => array(),
            'tab_id' => '',
            'show_directions' => false,
            'show_directions_id' => 'directions_panel',
            'map_id' => 'gmap',
            'latitude' => '49.8946343957342',
            'longitude' => '-119.446105957031',
            'zoom' => 11,
        ));

        // Set variables
        $arrCourses = $arrArgs['courses'];
        $arrHotels = $arrArgs['hotels'];
        $strTabId = !empty($arrArgs['tab_id']) ? '#' . $arrArgs['tab_id'] : '';
        $blnShowDirections = !empty($arrArgs['show_directions']) ? true : false;
        $strShowDirectionsId = $arrArgs['show_directions_id'];
        $strMapId = !empty($arrArgs['map_id']) ? '#' . $arrArgs['map_id'] : '';
        $strLatitude = !empty($arrArgs['latitude']) ? $arrArgs['latitude'] : '49.8946343957342';
        $strLongitude = !empty($arrArgs['longitude']) ? $arrArgs['longitude'] : '-119.446105957031';
        $intZoom = !empty($arrArgs['zoom']) ? $arrArgs['zoom'] : 11;

        ?>
	    <script>
        jQuery(document).ready(function(){

            <?php if (!empty($strTabId)) { ?>
            var generated = false;

            $('<?php echo $strTabId; ?>').on('click',function(){
                // Exit if it's been generated already
                if (generated) {
                    return;
                }

                generated = true;
            <?php } ?>

                setTimeout(function(){
                    jQuery('<?php echo $strMapId; ?>').each(function(){
                        // Set the initial values for the map
                        var strLatitude = '<?php echo $strLatitude; ?>';
                    	var strLongitude = '<?php echo $strLongitude; ?>';
                   		var intZoom = <?php echo $intZoom; ?>;
                        var objLatLng = new google.maps.LatLng(strLatitude, strLongitude);
                        var objMapOptions = {
                            center: objLatLng,
                            zoom: intZoom,
                            maxZoom: 15,
                            scrollwheel: false,
                        }

                        // Create the map object
                        var jobjMap = jQuery('<?php echo $strMapId; ?>');
                        var objMap = new google.maps.Map(document.getElementById(jobjMap.attr('id')), objMapOptions);
                        var objBounds = new google.maps.LatLngBounds();
                        var blnBoundsExtended = false;

                        <?php if($blnShowDirections) { ?>
                            directionsDisplay = new google.maps.DirectionsRenderer();
                            directionsDisplay.setMap(objMap);
                            directionsDisplay.setPanel(document.getElementById('<?php echo $strShowDirectionsId; ?>'));
                        <?php } ?>

                        <?php
                        // Generate the course markers
                        if (!empty($arrCourses)) {
                            foreach ($arrCourses as $arrCourse) {
                                // Skip if the coordinates don't exist
                                if (empty($arrCourse['latitude']) || empty($arrCourse['longitude'])) {
                                    continue;
                                }

                                // Set the name
                                $strName = '';
                                if (!empty($arrCourse['item_name'])) {
                                    $strName = addslashes($arrCourse['item_name']);
                                } else if (!empty($arrCourse['course_name'])) {
                                    $strName = addslashes($arrCourse['course_name']);
                                }
                                ?>
                                // Create the coordinates
                                var objMarkerLatLng = new google.maps.LatLng(<?php echo $arrCourse['latitude']; ?>, <?php echo $arrCourse['longitude']; ?>);

                                // Add the marker to the map
                                var objMarker = new google.maps.Marker({
                                    position: objMarkerLatLng,
                                    map: objMap,
                                    title: '<?php echo $strName; ?>'
                                });

                                // Add the marker icon
                                <?php if($arrCourse['type_id'] == 3 || $arrCourse['type_id'] == 7) { ?>
                                    objMarker.setIcon('<?php echo ROOT_URL; ?>/application/images/ico-course-deluxe.png');
                                <?php } else { ?>
                                    objMarker.setIcon('<?php echo ROOT_URL; ?>/application/images/ico-course-basic.png');
                                <?php } ?>

                                objInfoWindow = new google.maps.InfoWindow();

                                // Add the marker popup HTML
                                google.maps.event.addListener(objMarker, 'click', function(event){
                                    objInfoWindow.setContent('<?php echo static::createCourseMarkerHtml($arrCourse); ?>');
                                    objInfoWindow.setPosition(event.latLng);
                                    objInfoWindow.open(objMap);
                                });

                                // Extend the map bounds
                                objBounds.extend(objMarkerLatLng);
                                blnBoundsExtended = true;

                                <?php
                            }
                        }

                        // Generate the hotel markers
                        if (!empty($arrHotels)) {
                            foreach ($arrHotels as $arrHotel) {
                                // Skip if the coordinates don't exist
                                if (empty($arrHotel['latitude']) || empty($arrHotel['longitude'])) {
                                    continue;
                                }

                                // Set the name
                                $strName = '';
                                if (!empty($arrHotel['item_name'])) {
                                    $strName = addslashes($arrHotel['item_name']);
                                } else if (!empty($arrHotel['hotel_name'])) {
                                    $strName = addslashes($arrHotel['hotel_name']);
                                }
                                ?>
                                // Create the marker coordinates
                                var objMarkerLatLng = new google.maps.LatLng(<?php echo $arrHotel['latitude']; ?>, <?php echo $arrHotel['longitude']; ?>);

                                // Add the marker to the map
                                var objMarker = new google.maps.Marker({
                                    position: objMarkerLatLng,
                                    map: objMap,
                                    title: '<?php echo $strName; ?>'
                                });

                                // Set the marker icon
                                objMarker.setIcon('<?php echo ROOT_URL."/application/images/ico-hotel.png"; ?>');

                                objInfoWindow = new google.maps.InfoWindow();

                                // Add the marker popup HTML
                                google.maps.event.addListener(objMarker, 'click', function(event){
                                    objInfoWindow.setContent('<?php echo static::createHotelMarkerHtml($arrHotel); ?>');
                                    objInfoWindow.setPosition(event.latLng);
                                    objInfoWindow.open(objMap);
                                });

                                // Extend the map bounds
                                objBounds.extend(objMarkerLatLng);
                                blnBoundsExtended = true;

                                <?php
                            }
                        }
                        ?>

                        // Fit the pins within the map bounds
                        if (blnBoundsExtended) {
                            objMap.fitBounds(objBounds);
                        }
                    });
                }, 30);

            <?php if (!empty($strTabId)) { ?>
            });
            <?php } // tab check  ?>

        });
        </script>
        <?php
	}

    public static function createCourseMarkerHtml($arrCourse = array()) {
        // Exit if the course is empty
        if (empty($arrCourse)) {
            return '';
        }

        // Set variables
        $strName = '';
        if (!empty($arrCourse['item_name'])) {
            $strName = addslashes($arrCourse['item_name']);
        } else if (!empty($arrCourse['course_name'])) {
            $strName = addslashes($arrCourse['course_name']);
        }

        $strImage = '';
        if (!empty($arrCourse['logo']) ) {
            $strImage = $arrCourse['logo'];
        } elseif (!empty($arrCourse['display_image'])) {
            $strImage = $arrCourse['display_image'];
        }

        $strSlug = !empty($arrCourse['slug']) ? $arrCourse['slug'] : '';
        $intLevel = !empty($arrCourse['level']) ? $arrCourse['level'] : 0;
        $strAddress = !empty($arrCourse['address']) ? $arrCourse['address'] : '';
        $strCity = !empty($arrCourse['city']) ? $arrCourse['city'] : '';
        $strShortName = !empty($arrCourse['short_name']) ? $arrCourse['short_name'] : '';
        $strDescription = !empty($arrCourse['description']) ? $arrCourse['description'] : '';

        $strReturn = '';
        $strReturn .= '<div class="map-info-window">';

        // Add the image
        if (Util::isFile($strImage)) {
            $strReturn .= '<div class="map-info-window-image">'
                        . '<img src="' . $strImage . '" alt="' . $strName . '">'
                        . '</div>';
        }

        $strReturn .= '<div class="map-info-window-content">';

        // Add the title
        $strReturn .= '<h4 class="map-info-window-title">'
                    . '<a href="/golf-courses/' . $strSlug . '/">' . $strName . '</a>'
                    . '</h4>';

        // Add the meta
        $strReturn .= '<ul class="map-info-window-meta list-unstyled">'
                    // . '<li>' . Course::getRating($intLevel) . '</li>'
                    . '<li>' . implode(', ', array_filter(array($strAddress, $strCity, $strShortName))) . '</li>'
                    . '</ul>';

        $strReturn .= '</div>';

        // Return the HTML
        return addslashes($strReturn);
    }

    public static function createHotelMarkerHtml($arrHotel = array()) {
        // Exit if the hotel is empty
        if (empty($arrHotel)) {
            return '';
        }

        // Set variables
        $strName = '';
        if (!empty($arrHotel['item_name'])) {
            $strName = addslashes($arrHotel['item_name']);
        } else if (!empty($arrHotel['hotel_name'])) {
            $strName = addslashes($arrHotel['hotel_name']);
        }

        $strImage = '';
        if (!empty($arrHotel['logo']) ) {
            $strImage = $arrHotel['logo'];
        } elseif (!empty($arrHotel['file_name'])) {
            $strImage = $arrHotel['file_name'];
        }

        $strSlug = !empty($arrHotel['slug']) ? $arrHotel['slug'] : '';
        $intLevel = !empty($arrHotel['level']) ? $arrHotel['level'] : 0;
        $strAddress = !empty($arrHotel['address']) ? $arrHotel['address'] : '';
        $strCity = !empty($arrHotel['city']) ? $arrHotel['city'] : '';
        $strShortName = !empty($arrHotel['short_name']) ? $arrHotel['short_name'] : '';
        $strDescription = !empty($arrHotel['description']) ? $arrHotel['description'] : '';

        $strReturn = '';
        $strReturn .= '<div class="map-info-window">';

        // Add the image
        if (Util::isFile($strImage)) {
            $strReturn .= '<div class="map-info-window-image">'
                        . '<img src="' . $strImage . '" alt="' . $strName . '">'
                        . '</div>';
        }

        $strReturn .= '<div class="map-info-window-content">';

        // Add the title
        $strReturn .= '<h4 class="map-info-window-title">'
                    . '<a href="/golf-accommodations/' . $strSlug . '/">' . $strName . '</a>'
                    . '</h4>';

        // Add the meta
        $strReturn .= '<ul class="map-info-window-meta list-unstyled">'
                    . '<li>' . Hotel::getRating($intLevel) . '</li>'
                    . '<li>' . implode(', ', array_filter(array($strAddress, $strCity, $strShortName))) . '</li>'
                    . '</ul>';

        $strReturn .= '</div>';

        // Return the HTML
        return addslashes($strReturn);
    }

}
