<?php
/**
 * @package   Chimera_Framework
 * @author    liam Anderson <liam@navigatormm.com>
 * @link      http://www.navigatormm.com
 * @copyright 2014 Navigator Multimedia Inc
 */

class Facebook_Feed {

    /**
     * Filter the post and add in the correct link html via regex.
     *
     * @since 1.0
     */
    public static function messageFilter($content){
        // Filter and modify the text using regex
        $message = preg_replace('@(?<![.*">])\b(?:(?:https?|ftp|file)://|[a-z]\.)[-A-Z0-9+&#/%=~_|$?!:,.]*[A-Z0-9+&#/%=~_|$]@i', '<a class="site-link" href="\0" rel="nofollow" target="_blank">\0</a>', $content);
        return $message;
    }

    public static function createFacebookFeed($post_count = '10') {
        $facebook_target_id = FB_TARGET_ID;
        $facebook_app_id = FB_APP_ID;
        $facebook_secret_id = FB_SECRET_ID;
        $facebook_access_token = $facebook_app_id . '|' . $facebook_secret_id;
        $html = '';

        if (empty($facebook_target_id) || empty($facebook_app_id) || empty($facebook_secret_id)) {
            $html .= '<div class="alert alert-danger">The Facebook Feed is configured incorrectly.</div>' . "\n";
            echo $html;
            return;
        }

        // Get page details
        $feedUrl = 'https://graph.facebook.com/' . $facebook_target_id . '/?fields=name,link,picture&access_token=' . $facebook_access_token;
        $page_details = json_decode(Util::fetchData($feedUrl));

        // Get the page feed.
        $feedUrl = 'https://graph.facebook.com/' . $facebook_target_id . '/feed/?limit=' . $post_count . '&fields=id,created_time,from,name,link,message,picture,type,object_id,caption,description,actions,shares,comments.limit(1).summary(true),likes.limit(1).summary(true)&access_token=' . $facebook_access_token;
        $response = json_decode(Util::fetchData($feedUrl));

        if(isset($response->error)){
            // There are no results to display
            $html .= '<div class="alert alert-danger">The Facebook Feed is down or configured incorrectly.</div>' . "\n";
            echo $html;
            return;
        }

        if(empty($response->data)){
            // There are no results to display
            return;
        }

        // Output the HTML.
        $html .= '<div class="panel panel-default">' . "\n";
        $html .= '<div class="panel-heading clearfix">' . "\n";
        $html .= '<a href="https://www.facebook.com/' . $facebook_target_id . '/" class="pull-left" rel="nofollow" target="_blank"><strong>Facebook Posts</strong></a>' . "\n";
        $html .= '</div>' . "\n";

        $html .= '<ul class="facebook-feed list-group">' . "\n";

        // Limit the amount of posts to display base don the # of records in the data base.
        if($post_count > count($response->data)){
            $post_count = count($response->data);
        }

        // Loop through the feed based on the tweet_count.
        for ($i = 0; $i < $post_count; $i++) {
            $post = $response->data[$i];

            if(empty($post->message) && empty($post->picture)){
                // There is no text or picture for this post so skip it
                continue;
            }

            // Check if post from a different place then the page
            if($post->from->id != $page_details->id){
                $page_details = Util::fetchData('https://graph.facebook.com/' . $page_details->id . '/?fields=name,link,picture&access_token=' . $facebook_access_token);
                $page_details = json_decode($page_details);
            }

            $html .= '<li class="fb-' . $post->type . ' list-group-item clearfix">' . "\n";
                $html .= '<a href="' . $page_details->link . '" rel="nofollow" target="_blank">' . "\n";
                    $html .= '<img class="avatar img-responsive" src="' . $page_details->picture->data->url . '" alt="' . $page_details->name . '">' . "\n";
                $html .= '</a>' . "\n";

                $html .= '<div class="content">';
                    $html .= '<a class="fullname" href="' . $page_details->link . '" rel="nofollow" target="_blank"><strong>' . $page_details->name . '</strong></a>' . "\n";

                    //If it's a Facebook message.
                    if(!empty($post->message)){
                        $html .= '<p>' . static::messageFilter($post->message) . '</p>' . "\n";
                    }

                    //If it's a Facebook Link with image.
                    if(!empty($post->picture) || $post->type =='link'){
                        $html .= '<div class="attachment">';
                    }

                    //If it's a Facebook Picture.
                    if(!empty($post->picture)){
                            if(!empty($post->object_id) && $post->type != 'offer'){
                                $html .= '<p><a href="' . $post->link . '" rel="nofollow" target="_blank"><img class="img-responsive" src="https://graph.facebook.com/' . $post->object_id . '/picture" alt=""/></a></p>' . "\n";
                            }else{
                                $html .= '<p><a href="' . $post->link . '" rel="nofollow" target="_blank"><img class="img-responsive" src="' . str_replace("_s.jpg","_n.jpg",$post->picture) . '" alt=""/></a></p>' . "\n";
                            }
                    }


                    //If it's a Facebook Link.
                    if($post->type =='link'){
                        if(!empty($post->name)){
                            $html .= '<span><a class="title" href="' . $post->link . '" rel="nofollow" target="_blank"><strong>' . $post->name . '</strong></a></span>' . "\n";
                        }

                        if(!empty($post->caption)){
                            $html .= '<span><a class="link" href="' . $post->link . '" rel="nofollow" target="_blank">' . $post->caption . '</a></span>' . "\n";
                        }

                        if(!empty($post->description)){
                            $html .= '<p>' . $post->description . '</p>' . "\n";
                        }
                    }

                    if(!empty($post->picture) || $post->type =='link'){
                        $html .= '</div>';
                    }

                    $html .= '<div class="meta">'
                       . '<div class="pull-left">';

                $html .= '<span class="time"><i class="fa fa-calendar"></i> ' . Util::formatPostTime(strtotime($post->created_time)) . '</span>' . "\n";

                if(!empty($post->actions)){
                    // Only works if we change the access token to include session part and the user has access
                    foreach($post->actions as $action){
                        $html .= '<a href="' . $action->link . '" rel="nofollow" target="_blank">' . $action->name . '</a>';
                    }
                }

                $html .= '</div>'
                       . '<div class="pull-right">';

                if(!empty($post->likes->summary->total_count) && $post->likes->summary->total_count > 0){
                    $html .= '<span class="likes">' . $post->likes->summary->total_count . ' Likes</span>';
                }

                if(!empty($post->comments->summary->total_count) && $post->comments->summary->total_count > 0){
                    $html .= '<span class="comments">' . $post->comments->summary->total_count . ' Comments</span>';
                }

                if(!empty($post->shares->count) && $post->shares->count > 0){
                    $html .= '<span class="shares">' . $post->shares->count . ' Shares</span>';
                }

                $html .= '</div>';

                $html .= '</div>';

                $html .= '</div>';

            $html .= '</li>' . "\n";
        }

        $html .= '</ul>' . "\n";
        $html .= '</div>' . "\n";

        // Echo the HTML.
        echo $html;
    }


}
