<?
/*

Cron Job to send emails to hotels & golf courses with confirmed packages

The logic for this cron is as follows:
- get list of confirmed groups for each hotel / golf course anywhere within the span of <today> + 1 month
- send an email of that list to the contact

*/
$uuid = $_GET['guid'];
if (strlen($uuid) != 36) {
    die('unauthorized');
}

//Reminder Emails
// Select all packages that are potentailly due & have a balance owing

include($_SERVER['DOCUMENT_ROOT']."/application/config.php");
$objDB = new database;

$arrEmails = array();

$now = new DateTime();

// For Testing
//$now = new DateTime('2018-12-01');

$plusOneMonth = clone $now;
$yesterday = clone $now;
$tomorrow = clone $now;

$plusOneMonth->add(new DateInterval("P60D"));
$yesterday->sub(new DateInterval("P1D"));
$tomorrow->add(new DateInterval("P1D"));

$strNow = $now->format('Y-m-d');
$strPlusOneMonth = $plusOneMonth->format('Y-m-d');
$strYesterday = $yesterday->format('Y-m-d');
$strTomorrow = $tomorrow->format('Y-m-d');


$strSqlHotelInfo = "SELECT * FROM hotel WHERE guid = '$uuid'";
$arrHotelInfo = $objDB->getMysqliResults($strSqlHotelInfo,true);

if (empty($arrHotelInfo)) {
    die('unable to find hotel');
}

echo "<h1>".$arrHotelInfo[0]['hotel_name']."</h1>";
echo "<h2>Booking Snapshot as of ".$strNow. "</h2>";
echo "<h3>Intended for ".$arrHotelInfo[0]['frontdesk_email']. "</h3>";
echo "<p>This is our useful tool we provide to our partners to cross check to ensure accuracy with our bookings and your room reservations or room blocks. <Br /> Changes may occur between the time of our typical Tuesday noon report and the actual time staff has a chance to review the email report. <br /> Always assume the information provided on this dynamic page is always update and would supersede the Tuesday report. <br /> If there are any discrepancies or questions please address them to: <a href='mailto:teetimes@bcgolfguide.com'>teetimes@bcgolfguide.com</a></p>";
echo "<p>This report looks at active bookings from TODAY and ahead for 60 days only.</p>";

//Find all hotels which contain fully paid bookings that meet the target date ranges
$strSQL = "SELECT DISTINCT  hotel.id As hotel_id,
                            hotel.hotel_name,
                            hotel.frontdesk_email As contact_email,
                            hotel.booking_report_email,
                            hotel.booking_report_frequency,
                            brands.contact_email as brand_contact_email,
                            brands.contact_email2 as brand_contact_email2,
                            brands.business_name
             FROM package_hotel ph
             JOIN hotel ON (ph.hotel_id = hotel.id)
             JOIN packages ON (ph.package_id = packages.id)
             LEFT JOIN brands ON (18 = brands.id)
            WHERE
             hotel.guid = '$uuid'
             AND packages.status = 'Active'
             AND check_in_date >= '$strNow'
             AND check_in_date < '$strPlusOneMonth'
             #AND (last_edit > last_update_sent OR last_update_sent is NULL)
             #AND (SELECT sum(final_price) from package_hotel_detail WHERE package_hotel_id IN (SELECT id FROM package_hotel WHERE package_id = ph.package_id and `default` = 1)) = 0 ";
//var_dump($strSQL);
$arrHotels = $objDB->getMysqliResults($strSQL,true);

foreach ($arrHotels AS $arrHotel) {

    $intHotelId = $arrHotel['hotel_id'];

    $strSQL = "SELECT   ph.*,
                        packages.group_name,
                        hotel.id as hotel_id,
                        hotel.frontdesk_email As contact_email,
                        hotel.hotel_name,
                        hotel.booking_report_email,
                        hotel.booking_report_frequency,
                        brands.business_name,
                        brands.contact_email as brand_contact_email,
                        brands.contact_email2 as brand_contact_email2
                 FROM package_hotel ph
                 JOIN hotel ON (ph.hotel_id = hotel.id)
                 JOIN packages ON (ph.package_id = packages.id)
                 LEFT JOIN brands ON (packages.brandID = brands.id)
                WHERE packages.status = 'Active'
                 AND hotel.id = $intHotelId
                 AND check_in_date >= '$strNow'
                 AND check_in_date < '$strPlusOneMonth'
                 #AND (last_edit > last_update_sent OR last_update_sent is NULL)
                 #AND (SELECT sum(final_price) from package_hotel_detail WHERE package_hotel_id IN (SELECT id FROM package_hotel WHERE package_id = ph.package_id and `default` = 1)) = 0";

    //if ((($arrHotelPackage['booking_report_frequency'] == 'weekly') && (date('w') == '0')) ||
    //  (($arrHotelPackage['booking_report_frequency'] == 'monthly') && (date('d') == '01'))) {

    $arrHotelPackages = $objDB->getMysqliResults($strSQL,true);
    $strReservationSummary = '';

    foreach ($arrHotelPackages as $arrHotelPackage) {

        //Get the reservation details for booking
        $strSQL = "SELECT * FROM package_hotel_detail WHERE package_hotel_id = " . $arrHotelPackage['id'];

        $arrHotelPackageDetails = $objDB->getMysqliResults($strSQL,true);
        $intNumGuests = 0;

        if (count($arrHotelPackageDetails) > 0) {
            $intNumGuests = count($arrHotelPackageDetails);
        }

        // Build a row table representing reservation summary
        $strReservationSummary .= "
            <table>
                <tr>
                    <td colspan=2>&nbsp;</td>
                </tr>
                <tr>
                    <td>Group Name:</td>
                    <td>".$arrHotelPackage['group_name']."</td>
                </tr>
                <tr>
                    <td>Check-in:</td>
                    <td>".$arrHotelPackage['check_in_date']."</td>
                </tr>
                <tr>
                    <td>Check-out:</td>
                    <td>".$arrHotelPackage['check_out_date']."</td>
                </tr>
                <tr>
                    <td># Guests:</td>
                    <td>".$intNumGuests."</td>
                </tr>
                <tr>
                    <td># Nights:</td>
                    <td>".$arrHotelPackage['nights']."</td>
                </tr>
                <tr>
                    <td># Rooms:</td>
                    <td>".$arrHotelPackage['rooms']."</td>
                </tr>
                <tr>
                    <td>Confirmation #:</td>
                    <td>".$arrHotelPackage['confirm_num']."</td>
                </tr>
                <tr>
                    <td>Notes:</td>
                    <td>".$arrHotelPackage['public_notes']."</td>
                </tr>
            </table>
        ";
    }
}

echo $strReservationSummary;
die();