<?
/*
Cron Job to send emails to hotels & golf courses with confirmed packages

The logic for this cron is as follows:
- get list of confirmed groups for each hotel / golf course anywhere within the span of <today> + 1 month
- send an email of that list to the contact
*/

$uuid = $_GET['guid'];
if (strlen($uuid) != 36) {
    die('unauthorized');
}

include($_SERVER['DOCUMENT_ROOT']."/application/config.php");
$objDB = new database;

$arrEmails = array();

$now = new DateTime();

// Get current year start and end
$currentYearStart = new DateTime('first day of January this year');
$currentYearEnd = new DateTime('last day of December this year');

$strCurrentYearStart = $currentYearStart->format('Y-m-d');
$strCurrentYearEnd = $currentYearEnd->format('Y-m-d');

$arrAgentEmails = Cron::getEmailList('detail_reports_cron');

$strSqlCourseInfo = "SELECT * FROM course WHERE guid = '$uuid'";
$arrCourseInfo = $objDB->getMysqliResults($strSqlCourseInfo,true);

if (empty($arrCourseInfo)) {
    die('unable to find course');
}

echo "<h1>".$arrCourseInfo[0]['course_name']."</h1>";
echo "<h2>Booking Snapshot as of ".$strCurrentYearStart. "</h2>";
echo "<h3>Intended for ".$arrCourseInfo[0]['teetimes_email']. "</h3>";
echo "<p>This is our useful tool we provide to our partners to cross check to ensure accuracy with our bookings and your tee sheet. <Br /> Changes may occur between the time of our typical Tuesday noon report and the actual time staff has a chance to review the email report. <br /> Always assume the information provided on this dynamic page is always update and would supersede the Tuesday report. <br /> If there are any discrepancies or questions please address them to: <a href='mailto:teetimes@bcgolfguide.com'>teetimes@bcgolfguide.com</a></p>";
echo "<p>This report looks at active bookings for the current year.</p>";

// SQL query to fetch course data for the current year
$strSQL = "SELECT DISTINCT course.id as course_id,
                    course.teetimes_email As contact_email,
                    course.course_name,
                    course.booking_report_email,
                    course.booking_report_frequency,
                    brands.business_name,
                    brands.contact_email as brand_contact_email,
                    brands.contact_email2 as brand_contact_email2
             FROM package_golf pg
             JOIN course ON (pg.course_id = course.id)
             JOIN packages ON (pg.package_id = packages.id)
             LEFT JOIN brands ON (18 = brands.id)
            WHERE course.guid = '$uuid'
             AND packages.status = 'Active'
             AND tee_date >= '$strCurrentYearStart'
             AND tee_date <= '$strCurrentYearEnd'";

$arrCourses = $objDB->getMysqliResults($strSQL,true);

foreach ($arrCourses as $arrCourse) {

    $intCourseId = $arrCourse['course_id'];

    $strSQL = "SELECT   pg.*,
                        packages.group_name,
                        course.contact_email As contact_email,
                        course.course_name,
                        course.booking_report_email,
                        course.booking_report_frequency,
                        brands.business_name,
                        brands.contact_email as brand_contact_email,
                        brands.contact_email2 as brand_contact_email2
                 FROM package_golf pg
                 JOIN course ON (pg.course_id = course.id)
                 JOIN packages ON (pg.package_id = packages.id)
                 LEFT JOIN brands ON (packages.brandID = brands.id)
                WHERE packages.status = 'Active'
                 AND course.id = $intCourseId
                 AND tee_date >= '$strCurrentYearStart'
                 AND tee_date <= '$strCurrentYearEnd'";

    $arrGolfPackages = $objDB->getMysqliResults($strSQL,true);
    $strReservationSummary = '';

    foreach ($arrGolfPackages as $arrGolfPackage) {

        // Build 1 row table representing reservation summary
        $strReservationSummary .= "
            <table>
                <tr>
                    <td colspan=2>&nbsp;</td>
                </tr>
                <tr>
                    <td>Group Name:</td>
                    <td>".$arrGolfPackage['group_name']."</td>
                </tr>
                <tr>
                    <td>Tee Time:</td>
                    <td>".$arrGolfPackage['tee_date']. " " . $arrGolfPackage['tee_time'] . "</td>
                </tr>
                <tr>
                    <td># Golfers:</td>
                    <td>".$arrGolfPackage['golfer_num']."</td>
                </tr>
                <tr>
                    <td># of Carts:</td>
                    <td>".$arrGolfPackage['carts']."</td>
                </tr>
                <tr>
                    <td># of Range Balls:</td>
                    <td>".$arrGolfPackage['range_ball']."</td>
                </tr>
                <tr>
                    <td>Shuttle:</td>
                    <td>".$arrGolfPackage['shuttle']."</td>
                </tr>
                <tr>
                    <td>Confirmation #:</td>
                    <td>".$arrGolfPackage['confirm_num']."</td>
                </tr>
                <tr>
                    <td>Notes:</td>
                    <td>".$arrGolfPackage['public_notes']."</td>
                </tr>
            </table>
        ";
    }
}

echo $strReservationSummary;
?>
<style>
    @media print {
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        h1, h2, h3 {
            font-size: 18px;
            margin: 10px 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }

        table, th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        .no-print {
            display: none;
        }
    }
</style>

<!-- Link to print-friendly version -->
<a href="#" onclick="window.print();return false;"  target="_blank">Print Version</a>
