<?
/*

Cron Job to send emails to clients that have outstanding payments

The logic for this cron is as follows:
- get list of packages that start in 30 or 40 days that have payment remaining
- send organizer email and contact1 (Ross) and contact2 (Danny) emails

Connect to the database.


wget -q http://bcgolfguide.com/application/cron/sendOneMonthReminder.php

*/


//Reminder Emails
// Select all packages that are potentailly due & have a balance owing

include($_SERVER['DOCUMENT_ROOT']."/application/config.php");
include($_SERVER['DOCUMENT_ROOT']."/application/models/admin/brand.php");
include($_SERVER['DOCUMENT_ROOT']."/application/models/admin/package.php");

$objDB = new database;
$objBrand = new Brand;
$objPackage = new Package;

// get list of packages
/*$strSQL = "SELECT `p`.`id`,
				  `p`.`session_id`,
				  `ph`.`check_in_date`,
				  `ph`.`check_out_date`,
				  `p`.`user_name`,
				  `p`.`user_email`,
				  `b`.`id` AS `brand_id`,
				  `b`.`business_name` AS `brand_name`,
				  `b`.`oneMonthEmail`,
				  `b`.`firstEmailNotice`,
				  `ph`.`hotel_id`,
				  `h`.`hotel_name`,
				  (SELECT SUM(`phd`.`final_price`)
			   		  FROM `package_hotel_detail` `phd`
			   		 WHERE `phd`.`package_hotel_id` = `ph`.`id`) AS `final_price`
		     FROM `packages` `p`
		     LEFT JOIN `package_hotel` `ph`
		     	ON `ph`.`package_id` = `p`.`id`
		     LEFT JOIN `brands` `b`
		     	ON `b`.`id` = `p`.`brandID`
		     LEFT JOIN `hotel` `h`
		     	ON `h`.`id` = `ph`.`hotel_id`
		     WHERE (   `check_in_date` = '" . $strDate40Days . "'
		     		OR `check_in_date` = '" . $strDate30Days . "' )
			   AND (SELECT SUM(`phd`.`final_price`)
			   		  FROM `package_hotel_detail` `phd`
			   		 WHERE `phd`.`package_hotel_id` = `ph`.`id`) > 0
		 	   AND `ph`.`default` = 1
		 	   AND `p`.`blnNotify` = 1";*/

$strSQL = 'SELECT *,
				(SELECT sum(final_price) from package_hotel_detail WHERE package_hotel_id IN (SELECT id FROM package_hotel WHERE package_id = packages.id and `default` = 1)) as final_price,
				(SELECT min(check_in_date) from package_hotel WHERE package_id = packages.id) as check_in_date
 			FROM packages WHERE (SELECT min(check_in_date) from package_hotel WHERE package_id = packages.id) > now()
			AND (SELECT sum(final_price) from package_hotel_detail WHERE package_hotel_id IN (SELECT id FROM package_hotel WHERE package_id = packages.id and `default` = 1)) > 0;';

$arrPackages = $objDB->getMysqliResults($strSQL,true);

print_r($arrPackages);die();

Util::sendMailCore('adil@navigator.ca', 'Alert - BCgolfguide.com payment cron started', json_encode(array_column((array) $arrPackages, 'user_email', 'id')), 'From: noreply@bcgolfguide.com');

$now = new DateTime();
$arrEmails = array();

foreach ($arrPackages AS $arrPackage) {
//If (today + (x days) == arrival_date) send that email

	$arrivial_date = new DateTime($arrPackage['check_in_date']);

	for ($i=1;$i<=6;$i++) {

		$reminder_days = $arrPackage['reminder_email_'.$i.'_days'];

		if($reminder_days == 180){
		    
		    $interval = $now->diff($arrivial_date);
			$numDays = $interval->format("%R%a");
			
			if (strpos($numDays,'+') > -1) {
                $numDays = str_replace('+', '', $numDays);
                $numDays = $numDays + 1;
			    
			    if ($numDays == $reminder_days) {
			        
			        //Send Email to Main Contact
					$arrEmail = array(
						'send' => true,
						'package_id' => $arrPackage['id'],
						'contact_email' => null,
						'email_addresses' => array(),
						'message' => null,
						'type' => null
					);

					// Find courses.
				    $strSQL = "SELECT `course_id`,
									    `course_name`,
									    `slug`
				    			   FROM `package_golf`, `course`
				    			  WHERE `course`.`id` = `package_golf`.`course_id`
				    				AND `package_id` = " . $arrPackage['id'] ;

				    $arrCourses = $objDB->getMysqliResults($strSQL,true);

				    // Compile a list of courses.
				    $strCourses = '<br /><br />';
				    if(!empty($arrCourses)){

				        $strCourses = '<ul>';

				        foreach($arrCourses as $arrCourse){
				            $strCourses .= '<li><a href="' . ROOT_URL . '/golf-courses/' . $arrCourse['slug'] . '">' . $arrCourse['course_name'] . '</a></li>';
				        }

				        $strCourses .= '</ul>';
				    }
				    


					$arrBrandContacts = $objBrand->getBookingPeople($arrPackage['brandID']);
					

					if (count($arrBrandContacts) == 0) {
						$arrBrandContacts[0]['business_name'] = "BCGolfGuide.com";
					}

					$strContactEmail = 'info@bcgolfguide.com';

					$arrBookingPeople = $objPackage->getBookingPeople($arrPackage['id']);

					foreach ($arrBookingPeople as $arrBookingPerson) {

						if ($arrBookingPerson['blnPrimary'] == '1') {
							$arrEmail['email_addresses'][] = $arrBookingPerson['booking_email'];
							$strContactEmail = $arrBookingPerson['booking_email'];
						} else if ($arrBookingPerson['blnContact'] == '1') {
							$arrEmail['email_addresses'][] = $arrBookingPerson['booking_email'];
						}
					}

					$arrEmail['contact_email'] = $strContactEmail;

					// add event organizer
					$arrEmail['email_addresses'][] = $arrPackage['user_email'];

					$strMessage = $arrPackage['reminder_email_' . $i];

					$strMiniUrl = '<a href="' . ROOT_URL . '/package/' . $arrPackage['session_id'] . '/">' . ROOT_URL . '/package/' . $arrPackage['session_id'] . '/</a>';

					// replace special codes with values in email
				    $strMessage = str_replace("[people_name]", $arrPackage['user_name'], $strMessage);
				    //$strMessage = str_replace("[hotel_name]", $arrPackage['hotel_name'], $strMessage);
				    $strMessage = str_replace("[arrival_date]", $arrPackage['check_in_date'], $strMessage);
				    $strMessage = str_replace("[brand_name]", $arrBrandContacts[0]['business_name'], $strMessage);
				    $strMessage = str_replace("[num_days]", $numDays, $strMessage);
				    $strMessage = str_replace("[mini_url]", $strMiniUrl , $strMessage);
				    $strMessage = str_replace("[courses]", $strCourses, $strMessage);
				    $strMessage = str_replace("[final_price]", number_format($arrPackage['final_price'], 2), $strMessage);
				    $strMessage = str_replace("[newsletter-signup]", ROOT_URL.'/newsletter-signup/', $strMessage);

				    $arrEmail['message'] = $strMessage;

				    $arrEmail['subject'] = $arrBrandContacts[0]['business_name'] . ' ' . $numDays . ' Days until arrival date' . ' Payment Reminder for ' . $arrPackage['group_name'];

				    // add to list of all emails
				    $arrEmails[] = $arrEmail;

					$strSQL = 'SELECT * FROM package_hotel_detail WHERE package_hotel_id IN (SELECT id FROM package_hotel WHERE package_id = ' . $arrPackage['id'] . ' AND `default` = 1);';
					$arrPackageMembers = $objDB->getMysqliResults($strSQL,true);
					
					// Send Email to all players with valid email address and owe a balance (exclude the organizer -- he gets an email for the whole balance)
					foreach ($arrPackageMembers as $arrPackageMember) {

						if (($arrPackageMember['people_email'] != '') &&
							($arrPackageMember['people_email'] != $arrPackage['user_email']) &&
							($arrPackageMember['final_price'] > 0)) {

							$arrEmail = array(
								'send' => true,
								'package_id' => $arrPackage['id'],
								'contact_email' => $strContactEmail,
								'email_addresses' => array($arrPackageMember['people_email']),
								'message' => null,
								'type' => null
								);

							$strMessage = $arrPackage['reminder_email_' . $i];

							$strMiniUrl = '<a href="' . ROOT_URL . '/package/' . $arrPackage['session_id'] . '/">' . ROOT_URL . '/package/' . $arrPackage['session_id'] . '/</a>';

							// replace special codes with values in email
						    $strMessage = str_replace("[people_name]", $arrPackageMember['people_name'] . ' ' . $arrPackageMember['people_lname'], $strMessage);
						    //$strMessage = str_replace("[hotel_name]", $arrPackage['hotel_name'], $strMessage);
						    $strMessage = str_replace("[arrival_date]", $arrPackage['check_in_date'], $strMessage);
						    $strMessage = str_replace("[brand_name]", $arrBrandContacts[0]['business_name'], $strMessage);
						    $strMessage = str_replace("[num_days]", $numDays, $strMessage);
						    $strMessage = str_replace("[mini_url]", $strMiniUrl , $strMessage);
						    $strMessage = str_replace("[courses]", $strCourses, $strMessage);
						    $strMessage = str_replace("[final_price]", number_format($arrPackageMember['final_price'], 2), $strMessage);
						    $strMessage = str_replace("[newsletter-signup]", ROOT_URL.'/newsletter-signup/', $strMessage);

						    $arrEmail['message'] = $strMessage;

						    $arrEmail['subject'] = $arrBrandContacts[0]['business_name'] . ' ' . $numDays . ' Days until arrival date' . ' Payment Reminder';
                            
						    // add to list of all emails
				    		$arrEmails[] = $arrEmail;
						}
					}
			    }
			}
		}elseif ($reminder_days > 0) {

			$interval = $now->diff($arrivial_date);
			$numDays = $interval->format("%R%a");

			if (strpos($numDays,'+') > -1) {
			    $numDays = str_replace('+', '', $numDays);
			    $numDays = $numDays + 1;

				if ($numDays == $reminder_days) {

					//Send Email to Main Contact
					$arrEmail = array(
						'send' => true,
						'package_id' => $arrPackage['id'],
						'contact_email' => null,
						'email_addresses' => array(),
						'message' => null,
						'type' => null
					);

					// Find courses.
				    $strSQL = "SELECT `course_id`,
									    `course_name`,
									    `slug`
				    			   FROM `package_golf`, `course`
				    			  WHERE `course`.`id` = `package_golf`.`course_id`
				    				AND `package_id` = " . $arrPackage['id'] ;

				    $arrCourses = $objDB->getMysqliResults($strSQL,true);

				    // Compile a list of courses.
				    $strCourses = '<br /><br />';
				    if(!empty($arrCourses)){

				        $strCourses = '<ul>';

				        foreach($arrCourses as $arrCourse){
				            $strCourses .= '<li><a href="' . ROOT_URL . '/golf-courses/' . $arrCourse['slug'] . '">' . $arrCourse['course_name'] . '</a></li>';
				        }

				        $strCourses .= '</ul>';
				    }


					$arrBrandContacts = $objBrand->getBookingPeople($arrPackage['brandID']);

					if (count($arrBrandContacts) == 0) {
						$arrBrandContacts[0]['business_name'] = "BCGolfGuide.com";
					}

					$strContactEmail = 'info@bcgolfguide.com';

					$arrBookingPeople = $objPackage->getBookingPeople($arrPackage['id']);

					foreach ($arrBookingPeople as $arrBookingPerson) {

						if ($arrBookingPerson['blnPrimary'] == '1') {
							$arrEmail['email_addresses'][] = $arrBookingPerson['booking_email'];
							$strContactEmail = $arrBookingPerson['booking_email'];
						} else if ($arrBookingPerson['blnContact'] == '1') {
							$arrEmail['email_addresses'][] = $arrBookingPerson['booking_email'];
						}
					}

					$arrEmail['contact_email'] = $strContactEmail;

					// add event organizer
					$arrEmail['email_addresses'][] = $arrPackage['user_email'];

					$strMessage = $arrPackage['reminder_email_' . $i];

					$strMiniUrl = '<a href="' . ROOT_URL . '/package/' . $arrPackage['session_id'] . '/">' . ROOT_URL . '/package/' . $arrPackage['session_id'] . '/</a>';

					// replace special codes with values in email
				    $strMessage = str_replace("[people_name]", $arrPackage['user_name'], $strMessage);
				    //$strMessage = str_replace("[hotel_name]", $arrPackage['hotel_name'], $strMessage);
				    $strMessage = str_replace("[arrival_date]", $arrPackage['check_in_date'], $strMessage);
				    $strMessage = str_replace("[brand_name]", $arrBrandContacts[0]['business_name'], $strMessage);
				    $strMessage = str_replace("[num_days]", $numDays, $strMessage);
				    $strMessage = str_replace("[mini_url]", $strMiniUrl , $strMessage);
				    $strMessage = str_replace("[courses]", $strCourses, $strMessage);
				    $strMessage = str_replace("[final_price]", number_format($arrPackage['final_price'], 2), $strMessage);
				    $strMessage = str_replace("[newsletter-signup]", ROOT_URL.'/newsletter-signup/', $strMessage);

				    $arrEmail['message'] = $strMessage;

				    $arrEmail['subject'] = $arrBrandContacts[0]['business_name'] . ' ' . $numDays . ' Days until arrival date' . ' Payment Reminder for ' . $arrPackage['group_name'];

				    // add to list of all emails
				    $arrEmails[] = $arrEmail;

					$strSQL = 'SELECT * FROM package_hotel_detail WHERE package_hotel_id IN (SELECT id FROM package_hotel WHERE package_id = ' . $arrPackage['id'] . ' AND `default` = 1);';
					$arrPackageMembers = $objDB->getMysqliResults($strSQL,true);

					// Send Email to all players with valid email address and owe a balance (exclude the organizer -- he gets an email for the whole balance)
					foreach ($arrPackageMembers as $arrPackageMember) {

						if (($arrPackageMember['people_email'] != '') &&
							($arrPackageMember['people_email'] != $arrPackage['user_email']) &&
							($arrPackageMember['final_price'] > 0)) {

							$arrEmail = array(
								'send' => true,
								'package_id' => $arrPackage['id'],
								'contact_email' => $strContactEmail,
								'email_addresses' => array($arrPackageMember['people_email']),
								'message' => null,
								'type' => null
								);

							$strMessage = $arrPackage['reminder_email_' . $i];

							$strMiniUrl = '<a href="' . ROOT_URL . '/package/' . $arrPackage['session_id'] . '/">' . ROOT_URL . '/package/' . $arrPackage['session_id'] . '/</a>';

							// replace special codes with values in email
						    $strMessage = str_replace("[people_name]", $arrPackageMember['people_name'] . ' ' . $arrPackageMember['people_lname'], $strMessage);
						    //$strMessage = str_replace("[hotel_name]", $arrPackage['hotel_name'], $strMessage);
						    $strMessage = str_replace("[arrival_date]", $arrPackage['check_in_date'], $strMessage);
						    $strMessage = str_replace("[brand_name]", $arrBrandContacts[0]['business_name'], $strMessage);
						    $strMessage = str_replace("[num_days]", $numDays, $strMessage);
						    $strMessage = str_replace("[mini_url]", $strMiniUrl , $strMessage);
						    $strMessage = str_replace("[courses]", $strCourses, $strMessage);
						    $strMessage = str_replace("[final_price]", number_format($arrPackageMember['final_price'], 2), $strMessage);
						    $strMessage = str_replace("[newsletter-signup]", ROOT_URL.'/newsletter-signup/', $strMessage);

						    $arrEmail['message'] = $strMessage;

						    $arrEmail['subject'] = $arrBrandContacts[0]['business_name'] . ' ' . $numDays . ' Days until arrival date' . ' Payment Reminder';

						    // add to list of all emails
				    		$arrEmails[] = $arrEmail;
						}
					}
				}
			}
		}else{
		    
		}
	}
}

// send out emails
$arrStats = array(
	'total_count' => 0,
	'sent' => array(),
	'not_sent' => array()
);

foreach($arrEmails as $arrEmail){

    $arrStats['total_count'] += count($arrEmail['email_addresses']);

    foreach ($arrEmail['email_addresses'] as $strEmailTo) {

        // Don't send to this package
        if (!$arrEmail['send']) {
            $arrStats['not_sent'][] = [
                'send_date' => date('Y-m-d g:ia'),
                'to' => $strEmailTo,
                'message' => 'ERROR: Package set to not send.',
                'package_id' => $arrEmail['package_id'],
            ];

            continue;
        }

        $strHeaders = "MIME-Version: 1.0\r\n";
        $strHeaders .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
        $strHeaders .= "From: " . $arrEmail['contact_email'] . "\r\n";

        // Email failed to send
        if (! Util::sendMailCore($strEmailTo, $arrEmail['subject'], $arrEmail['message'], $strHeaders)) {
            $arrStats['not_sent'][] = [
                'send_date' => date('Y-m-d g:ia'),
                'to' => $strEmailTo,
                'message' => 'ERROR: Call to mail API failed.',
                'package_id' => $arrEmail['package_id'],
            ];

            continue;
        }

        // Sent successfully!
        $arrStats['sent'][] = [
            'send_date' => date('Y-m-d g:ia'),
            'to' => $strEmailTo,
            'message' => 'SUCCESS',
            'package_id' => $arrEmail['package_id'],
        ];
    }
}

Util::sendMailCore('adil@navigator.ca', 'Alert - BCgolfguide.com payment cron ended', json_encode((array) $arrStats), 'From: noreply@bcgolfguide.com');

echo '<strong>Total Email Addresses:</strong> ' . $arrStats['total_count'] . '<br />';
echo '<strong>Total Emails Sent:</strong> ' . count($arrStats['sent']) . '<br />';
echo '<strong>Total Emails Not Sent:</strong> ' . count($arrStats['not_sent']) . '<br />';
die();
