<?
/*

Cron Job to send emails to clients 4 week's prior their checkout date.

The logic for this cron is as follows:
- get list of packages that start in 30 or 40 days that have payment remaining
- send organizer email and contact1 (Ross) and contact2 (Danny) emails

Connect to the database.


wget -q http://bcgolfguide.com/application/cron/sendOneMonthReminder.php

*/


//Reminder Emails
//SELECT * FROM packages WHERE dates_arrival > now();
/*
$strSQL = 'SELECT * FROM packages WHERE dates_arrival > now()';
$arrPackages = $objDB->getMysqliResults($strSQL,true);

foreach ($arrPackages AS $arrPackage) {
//If (today + (x days) == arrival_date) send that email	

	$now = new DateTime();
	$arrivial_date = new DateTime($arrPackage['dates_arrival']);	

	for ($i=1;$i<=6;$i++) {

		$reminder_days = $arrPackage['reminder_email_'.$i.'_days'];

		if ($reminder_days > 0) {
			
			$interval = $now->diff($arrivial_date);
			$numDays = $interval->format("%R%a");

			if (strpos($strNumDays,'+') > -1) {
			    $numDays = str_replace('+', '', $strNumDays);
			    $numDays = $numDays + 1;
			
				if ($numDays == $reminder_days) {
					//Send Email
				}
			}
		}
	}
}
*/

include($_SERVER['DOCUMENT_ROOT']."/application/config.php");
$objDB = new database;

$strDate40Days = date( 'Y-m-d', strtotime( '+40 days' ) );
$strDate30Days = date( 'Y-m-d', strtotime( '+30 days' ) );

// get list of packages
$strSQL = "SELECT `p`.`id`,
				  `p`.`session_id`,
				  `ph`.`check_in_date`,
				  `ph`.`check_out_date`,
				  `p`.`user_name`,
				  `p`.`user_email`,
				  `b`.`id` AS `brand_id`,
				  `b`.`business_name` AS `brand_name`,
				  `b`.`oneMonthEmail`,
				  `b`.`firstEmailNotice`,
				  `ph`.`hotel_id`,
				  `h`.`hotel_name`,
				  (SELECT SUM(`phd`.`final_price`) 
			   		  FROM `package_hotel_detail` `phd` 
			   		 WHERE `phd`.`package_hotel_id` = `ph`.`id`) AS `final_price`
		     FROM `packages` `p`
		     LEFT JOIN `package_hotel` `ph`
		     	ON `ph`.`package_id` = `p`.`id`
		     LEFT JOIN `brands` `b`
		     	ON `b`.`id` = `p`.`brandID`
		     LEFT JOIN `hotel` `h`
		     	ON `h`.`id` = `ph`.`hotel_id`
		     WHERE (   `check_in_date` = '" . $strDate40Days . "' 
		     		OR `check_in_date` = '" . $strDate30Days . "' )
			   AND (SELECT SUM(`phd`.`final_price`) 
			   		  FROM `package_hotel_detail` `phd` 
			   		 WHERE `phd`.`package_hotel_id` = `ph`.`id`) > 0 
		 	   AND `ph`.`default` = 1
		 	   AND `p`.`blnNotify` = 1";

$arrPackages = $objDB->getMysqliResults($strSQL,true);

var_dump($arrPackages);
die();

$arrEmails = array();
foreach($arrPackages as $arrPackage){
	$arrEmail = array(
		'send' => true,
		'package_id' => $arrPackage['id'],
		'contact_email' => null,
		'email_addresses' => array(),
		'message' => null,
		'type' => null
	);

	// Find courses.
    $strSQL = "SELECT `course_id`,  
					    `course_name`, 
					    `slug` 
    			   FROM `package_golf`, `course`
    			  WHERE `course`.`id` = `package_golf`.`course_id`
    				AND `package_id` = " . $arrPackage['id'] ;

    $arrCourses = $objDB->getMysqliResults($strSQL,true);

    // Compile a list of courses.
    $strCourses = '<br /><br />';
    if(!empty($arrCourses)){

        $strCourses = '<ul>';

        foreach($arrCourses as $arrCourse){
            $strCourses .= '<li><a href="' . ROOT_URL . '/golf-courses/' . $arrCourse['slug'] . '">' . $arrCourse['course_name'] . '</a></li>';
        }

        $strCourses .= '</ul>';
    }


	// get contact1/2 email
	$strSQL = "SELECT `contact_email`,
					  `contact_email2`
				 FROM `brands`
				WHERE `id` = " . $arrPackage['brand_id'];

	$arrBrandContacts = $objDB->getMysqliResults($strSQL,true);

	foreach($arrBrandContacts as $arrContact){
		if(!empty($arrContact['contact_email'])){
			$arrEmail['email_addresses'][] = $arrContact['contact_email'];
			$arrEmail['contact_email'] = $arrContact['contact_email'];
		}

		if(!empty($arrContact['contact_email2'])){
			$arrEmail['email_addresses'][] = $arrContact['contact_email2'];
		}
	}

	// add event organizer
	$arrEmail['email_addresses'][] = $arrPackage['user_email'];

	// make email content from white label system
	if($arrPackage['check_in_date'] == $strDate40Days){
		$strMessage = $arrPackage['firstEmailNotice'];
		$arrEmail['type'] = '40 Day';
	}else{
		$strMessage = $arrPackage['oneMonthEmail'];
		$arrEmail['type'] = '30 Day';
	}

	$strMiniUrl = '<a href="' . ROOT_URL . '/package/' . $arrPackage['session_id'] . '/">' . ROOT_URL . '/package/' . $arrPackage['session_id'] . '/</a>';

	// replace special codes with values in email
    $strMessage = str_replace("[people_name]", $arrPackage['user_name'], $strMessage);
    $strMessage = str_replace("[hotel_name]", $arrPackage['hotel_name'], $strMessage);
    $strMessage = str_replace("[mini_url]", $strMiniUrl , $strMessage);
    $strMessage = str_replace("[courses]", $strCourses, $strMessage);
    $strMessage = str_replace("[final_price]", number_format($arrPackage['final_price'], 2), $strMessage);
    $strMessage = str_replace("[newsletter-signup]", ROOT_URL.'/newsletter-signup/', $strMessage);

    $arrEmail['message'] = $strMessage;

    $arrEmail['subject'] = $arrPackage['brand_name'] . ' ' . $arrEmail['type'] . ' Payment Reminder';

    // add to list of all emails
    $arrEmails[] = $arrEmail;
}

// send out emails
$arrStats = array(
	'total_count' => 0,
	'sent' => array(),
	'not_sent' => array()
);

foreach($arrEmails as $arrEmail){
	$arrStats['total_count'] += count($arrEmail['email_addresses']);

	if(!$arrEmail['send']){
		// don't send this email
		$arrEmail['send_date'] = date('Y-m-d g:ia');
		$arrEmail['error'] = 'Set to Not Send';
		$arrStats['not_sent'][] = $arrEmail;
		continue;
	}

	$strHeaders = "MIME-Version: 1.0\r\n";
    $strHeaders .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
    $strHeaders .= "Bcc: " . implode(', ', $arrEmail['email_addresses']) . "\r\n";
    $strHeaders .= "From: " . $arrEmail['contact_email'] . "\r\n";

	// try to send this email
	if(!Util::sendMailCore(null, $arrEmail['subject'], $arrEmail['message'], $strHeaders)){
		// email wasn't sent
		$arrEmail['send_date'] = date('Y-m-d g:ia');
		$arrEmail['error'] = 'Error when calling MAIL()';
		$arrStats['not_sent'][] = $arrEmail;
		continue;
	}

	// echo '<pre>';
	// print_r($arrEmail);
	// echo '</pre><br /><hr /><br />';

	//email sent successfully
	$arrEmail['send_date'] = date('Y-m-d g:ia');
	$arrStats['sent'] = $arrEmail;
}

echo '<strong>Total Emails:</strong> ' . $arrStats['total_count'] . '<br />';
echo '<strong>Total Sent:</strong> ' . count($arrStats['sent']) . '<br />';
echo '<strong>Total Not Sent:</strong> ' . count($arrStats['not_sent']) . '<br />';
die();