<?
/*

Cron Job to send emails to hotels & golf courses with confirmed packages

The logic for this cron is as follows:
- get list of confirmed groups for each hotel / golf course anywhere within the span of <today> + 1 month
- send an email of that list to the contact

*/


//Reminder Emails
// Select all packages that are potentailly due & have a balance owing

include($_SERVER['DOCUMENT_ROOT']."/application/config.php");
$objDB = new database;

$arrEmails = array();

$now = new DateTime();

// For Testing
//$now = new DateTime('2018-12-01');

$plusOneMonth = clone $now;
$yesterday = clone $now;
$tomorrow = clone $now;

$plusOneMonth->add(new DateInterval("P60D"));
$yesterday->sub(new DateInterval("P1D"));
$tomorrow->add(new DateInterval("P1D"));

$strNow = $now->format('Y-m-d');
$strPlusOneMonth = $plusOneMonth->format('Y-m-d');
$strYesterday = $yesterday->format('Y-m-d');
$strTomorrow = $tomorrow->format('Y-m-d');

$arrAgentEmails = Cron::getEmailList('detail_reports_cron');

//Find all hotels which contain fully paid bookings that meet the target date ranges
$strSQL = "SELECT DISTINCT  hotel.id As hotel_id,
                            hotel.hotel_name,
                            hotel.frontdesk_email As contact_email,
                            hotel.frontdesk_email_alt As contact_email2,
                            hotel.booking_report_email,
                            hotel.booking_report_frequency,
                            hotel.guid,
                            brands.contact_email as brand_contact_email,
                            brands.contact_email2 as brand_contact_email2,
                            brands.business_name
             FROM package_hotel ph
             JOIN hotel ON (ph.hotel_id = hotel.id)
             JOIN packages ON (ph.package_id = packages.id)
             LEFT JOIN brands ON (18 = brands.id)
            WHERE packages.status = 'Active'
             AND check_in_date >= '$strNow'
             AND check_in_date < '$strPlusOneMonth'
             #AND (last_edit > last_update_sent OR last_update_sent is NULL)
             #AND (SELECT sum(final_price) from package_hotel_detail WHERE package_hotel_id IN (SELECT id FROM package_hotel WHERE package_id = ph.package_id and `default` = 1)) = 0 ";
//var_dump($strSQL);
$arrHotels = $objDB->getMysqliResults($strSQL,true);

foreach ($arrHotels AS $arrHotel) {

    if ($arrHotel['booking_report_frequency'] == '') {
        continue;
    }

    $intHotelId = $arrHotel['hotel_id'];

    $strSQL = "SELECT   ph.*,
                        packages.group_name,
                        hotel.id as hotel_id,
                        hotel.frontdesk_email As contact_email,
                        hotel.frontdesk_email_alt As contact_email2,
                        hotel.hotel_name,
                        hotel.booking_report_email,
                        hotel.booking_report_frequency,
                        brands.business_name,
                        brands.contact_email as brand_contact_email,
                        brands.contact_email2 as brand_contact_email2
                 FROM package_hotel ph
                 JOIN hotel ON (ph.hotel_id = hotel.id)
                 JOIN packages ON (ph.package_id = packages.id)
                 LEFT JOIN brands ON (packages.brandID = brands.id)
                WHERE packages.status = 'Active'
                 AND hotel.id = $intHotelId
                 AND check_in_date >= '$strNow'
                 AND check_in_date < '$strPlusOneMonth'
                 #AND (last_edit > last_update_sent OR last_update_sent is NULL)
                 #AND (SELECT sum(final_price) from package_hotel_detail WHERE package_hotel_id IN (SELECT id FROM package_hotel WHERE package_id = ph.package_id and `default` = 1)) = 0";

    //if ((($arrHotelPackage['booking_report_frequency'] == 'weekly') && (date('w') == '0')) ||
    //  (($arrHotelPackage['booking_report_frequency'] == 'monthly') && (date('d') == '01'))) {
        //var_dump($strSQL);

        $arrHotelPackages = $objDB->getMysqliResults($strSQL,true);
        $strReservationSummary = '';
        $strReservationSummary .= "<p>This link provides the viewer with real time and accurate information pertaining to all our bookings looking ahead 60 days from ".$strNow."
                <p><a href='https://bcgolfguide.com/application/cron/viewDetailReportHotel.php?guid=".$arrHotel['guid']."'>View All Bookings</a></p>
            ";

        foreach ($arrHotelPackages as $arrHotelPackage) {

            //update last send date
            $sqlUpdateSQL = "UPDATE package_hotel SET last_update_sent = now() WHERE id = " . $arrHotelPackage['id'];
            $objDB->short_query($sqlUpdateSQL);

            //Get the reservation details for booking
            $strSQL = "SELECT * FROM package_hotel_detail WHERE package_hotel_id = " . $arrHotelPackage['id'];

            $arrHotelPackageDetails = $objDB->getMysqliResults($strSQL,true);
            $intNumGuests = 0;

            if (count($arrHotelPackageDetails) > 0) {
                $intNumGuests = count($arrHotelPackageDetails);
            }

            // Build a row table representing reservation summary
            $strReservationSummary .= "
                <table>
                    <tr>
                        <td colspan=2>&nbsp;</td>
                    </tr>
                    <tr>
                        <td>Group Name:</td>
                        <td>".$arrHotelPackage['group_name']."</td>
                    </tr>
                    <tr " . (($arrHotelPackage['check_in_date_last_edit'] > $arrHotelPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td>Check-in:</td>
                        <td>".$arrHotelPackage['check_in_date']."</td>
                    </tr>
                    <tr " . (($arrHotelPackage['check_out_date_last_edit'] > $arrHotelPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td>Check-out:</td>
                        <td>".$arrHotelPackage['check_out_date']."</td>
                    </tr>
                    <tr>
                        <td># Guests:</td>
                        <td>".$intNumGuests."</td>
                    </tr>
                    <tr " . (($arrHotelPackage['nights_last_edit'] > $arrHotelPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td># Nights:</td>
                        <td>".$arrHotelPackage['nights']."</td>
                    </tr>
                    <tr " . (($arrHotelPackage['rooms_last_edit'] > $arrHotelPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td># Rooms:</td>
                        <td>".$arrHotelPackage['rooms']."</td>
                    </tr>
                    <tr " . (($arrHotelPackage['confirm_num_last_edit'] > $arrHotelPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td>Confirmation #:</td>
                        <td>".$arrHotelPackage['confirm_num']."</td>
                    </tr>
                    <tr " . (($arrHotelPackage['notes_last_edit'] > $arrHotelPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td>Notes:</td>
                        <td>".$arrHotelPackage['public_notes']."</td>
                    </tr>
                </table>
            ";
        }

        $arrEmail = array(
                            'send' => true,
                            'contact_email' => null,
                            'email_addresses' => array(),
                            'message' => null,
                            'type' => null
                        );

        if ($arrHotel['contact_email'] != '') {

            // add hotel contact email
            $arrEmail['email_addresses'][] = $arrHotel['contact_email'];

            // add hotel alt contact email if exists
            if ($arrHotel['contact_email2'] != '') {
                $arrEmail['email_addresses'][] = $arrHotel['contact_email2'];
            }

            // add BCC (bcgolfguide employees)
            //$arrEmail['email_addresses'][] = 'teetimes@bcgolfguide.com';
            $arrEmail['email_addresses'][] = 'danny@bcgolfguide.com';
            $arrEmail['email_addresses'][] = 'glen@bcgolfguide.com';
            $arrEmail['email_addresses'][] = 'ross@bcgolfguide.com';

            //if ($arrHotel['brand_contact_email'] != '') {
                //$arrEmail['email_addresses'][] = $arrHotel['brand_contact_email'];
                //$arrEmail['contact_email'] = $arrHotel['brand_contact_email'];
            //}

            //if ($arrHotel['brand_contact_email2'] != '') {
                //$arrEmail['email_addresses'][] = $arrHotel['brand_contact_email2'];
            //}

            $arrEmail['contact_email'] = 'info@bcgolfguide.com';

            //foreach ($arrAgentEmails as $strAgentEmail) {
                //$arrEmail['email_addresses'][] = $strAgentEmail;
            //}



            $strMessage = nl2br($arrHotel['booking_report_email']);

            // replace special codes with values in email
            $strMessage = str_replace("[brand_name]", $arrHotel['business_name'], $strMessage);
            $strMessage = str_replace("[hotel_name]", $arrHotel['hotel_name'], $strMessage);
            $strMessage = str_replace("[reservation_details]", $strReservationSummary, $strMessage);

            $arrEmail['message'] = $strMessage;

            $arrEmail['subject'] = $arrHotel['business_name'] .' ' . $arrHotel['hotel_name'] . ' Reservations Summary - ' . $strNow;

            // add to list of all emails
            $arrEmails[] = $arrEmail;
        }
    //}
}

//REMOVE -- Reset emails
//$arrEmails = array();
//REMOVE

$strSQL = "SELECT DISTINCT course.id as course_id,
                    course.teetimes_email As contact_email,
                    course.course_name,
                    course.booking_report_email,
                    course.booking_report_frequency,
                    course.guid,
                    brands.business_name,
                    brands.contact_email as brand_contact_email,
                    brands.contact_email2 as brand_contact_email2
             FROM package_golf pg
             JOIN course ON (pg.course_id = course.id)
             JOIN packages ON (pg.package_id = packages.id)
             LEFT JOIN brands ON (18 = brands.id)
            WHERE packages.status = 'Active'
             AND tee_date > '$strNow'
             #AND (last_edit > last_update_sent OR last_update_sent is NULL)
             AND tee_date < '$strPlusOneMonth'
             #AND (SELECT sum(final_price) from package_hotel_detail WHERE package_hotel_id IN (SELECT id FROM package_hotel WHERE package_id = pg.package_id and `default` = 1)) = 0; ";

$arrCourses = $objDB->getMysqliResults($strSQL,true);

foreach ($arrCourses as $arrCourse) {

    $intCourseId = $arrCourse['course_id'];

    //if ((($arrCourse['booking_report_frequency'] == 'weekly') && (date('w') == '0')) ||
    //  (($arrCourse['booking_report_frequency'] == 'monthly') && (date('d') == '01'))) {

    if ($arrCourse['booking_report_frequency'] == '') {
        continue;
    }

        $strSQL = "SELECT   pg.*,
                            packages.group_name,
                            course.contact_email As contact_email,
                            course.course_name,
                            course.booking_report_email,
                            course.booking_report_frequency,
                            brands.business_name,
                            brands.contact_email as brand_contact_email,
                            brands.contact_email2 as brand_contact_email2
                     FROM package_golf pg
                     JOIN course ON (pg.course_id = course.id)
                     JOIN packages ON (pg.package_id = packages.id)
                     LEFT JOIN brands ON (packages.brandID = brands.id)
                    WHERE packages.status = 'Active'
                     AND course.id = $intCourseId
                     #AND (last_edit > last_update_sent OR last_update_sent is NULL)
                     AND tee_date > '$strNow'
                     AND tee_date < '$strPlusOneMonth'
                     #AND (SELECT sum(final_price) from package_hotel_detail WHERE package_hotel_id IN (SELECT id FROM package_hotel WHERE package_id = pg.package_id and `default` = 1)) = 0; ";

        //var_dump($strSQL);

        $arrGolfPackages = $objDB->getMysqliResults($strSQL,true);
        $strReservationSummary = '';
        $strReservationSummary .= "<p>This link provides the viewer with real time and accurate information pertaining to all our bookings looking ahead 60 days from ".$strNow."
                <p><a href='https://bcgolfguide.com/application/cron/viewDetailReportCourse.php?guid=".$arrCourse['guid']."'>View All Bookings</a></p>
            ";

        foreach ($arrGolfPackages as $arrGolfPackage) {

            //update last send date
            $sqlUpdateSQL = "UPDATE package_golf SET last_update_sent = now() WHERE id = " . $arrGolfPackage['id'];
            $objDB->short_query($sqlUpdateSQL);

            // Build 1 row table representing reservation summary
            $strReservationSummary .= "
                <table>
                    <tr>
                        <td colspan=2>&nbsp;</td>
                    </tr>
                    <tr>
                        <td>Group Name:</td>
                        <td>".$arrGolfPackage['group_name']."</td>
                    </tr>
                    <tr " . (($arrGolfPackage['tee_time_last_edit'] > $arrGolfPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td>Tee Time:</td>
                        <td>".$arrGolfPackage['tee_date']. " " . $arrGolfPackage['tee_time'] . "</td>
                    </tr>
                    <tr " . (($arrGolfPackage['golfer_num_last_edit'] > $arrGolfPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td># Golfers:</td>
                        <td>".$arrGolfPackage['golfer_num']."</td>
                    </tr>
                    <tr " . (($arrGolfPackage['carts_last_edit'] > $arrGolfPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td># of Carts:</td>
                        <td>".$arrGolfPackage['carts']."</td>
                    </tr>
                    <tr " . (($arrGolfPackage['range_ball_last_edit'] > $arrGolfPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td># of Range Balls:</td>
                        <td>".$arrGolfPackage['range_ball']."</td>
                    </tr>
                    <tr " . (($arrGolfPackage['shuttle_last_edit'] > $arrGolfPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td>Shuttle:</td>
                        <td>".$arrGolfPackage['shuttle']."</td>
                    </tr>
                    <tr " . (($arrGolfPackage['confirm_num_last_edit'] > $arrGolfPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td>Confirmation #:</td>
                        <td>".$arrGolfPackage['confirm_num']."</td>
                    </tr>
                    <tr " . (($arrGolfPackage['notes_last_edit'] > $arrGolfPackage['last_update_sent']) ? 'style=\'font-weight:bold;color:red;\'' : 'style=\'color:#006400;\'') . ">
                        <td>Notes:</td>
                        <td>".$arrGolfPackage['public_notes']."</td>
                    </tr>
                </table>
            ";
        }

        $arrEmail = array(
                            'send' => true,
                            'contact_email' => null,
                            'email_addresses' => array(),
                            'message' => null,
                            'type' => null
                        );

        if ($arrCourse['contact_email'] != '') {

            // add course contact email
            $arrEmail['email_addresses'][] = $arrCourse['contact_email'];

            // add first BCC (bcgolfguide employees)
            //$arrEmail['email_addresses'][] = 'teetimes@bcgolfguide.com';
            $arrEmail['email_addresses'][] = 'danny@bcgolfguide.com';
            $arrEmail['email_addresses'][] = 'glen@bcgolfguide.com';
            $arrEmail['email_addresses'][] = 'ross@bcgolfguide.com';


            //if ($arrCourse['brand_contact_email'] != '') {
                //$arrEmail['email_addresses'][] = $arrCourse['brand_contact_email'];
                //$arrEmail['contact_email'] = $arrCourse['brand_contact_email'];
            //}

            //if ($arrCourse['brand_contact_email2'] != '') {
                //$arrEmail['email_addresses'][] = $arrCourse['brand_contact_email2'];
            //}

            $arrEmail['contact_email'] = 'info@bcgolfguide.com';

            //foreach ($arrAgentEmails as $strAgentEmail) {
            //    $arrEmail['email_addresses'][] = $strAgentEmail;
           //}

            $strMessage = nl2br($arrCourse['booking_report_email']);

            //$strMiniUrl = '<a href="' . ROOT_URL . '/package/' . $arrPackage['session_id'] . '/">' . ROOT_URL . '/package/' . $arrPackage['session_id'] . '/</a>';

            // replace special codes with values in email
            $strMessage = str_replace("[brand_name]", $arrCourse['business_name'], $strMessage);
            $strMessage = str_replace("[course_name]", $arrCourse['course_name'], $strMessage);
            $strMessage = str_replace("[reservation_details]", $strReservationSummary, $strMessage);



            $arrEmail['message'] = $strMessage;

            $arrEmail['subject'] = $arrCourse['business_name'] .' ' . $arrCourse['course_name'] . ' Reservations Summary - ' . $strNow;

            // add to list of all emails
            $arrEmails[] = $arrEmail;
        }
    //}
}

//var_dump($arrEmails);
/*
foreach ($arrEmails as $arrEmail) {
    echo "<hr />";
    echo 'Send mail to: ' . print_r($arrEmail['email_addresses'], true) . "<br />";
    echo 'From: ' . print_r($arrEmail['contact_email'], true) . "<br />";
    echo $arrEmail['message'];
}
*/

// send out emails

$arrStats = array(
    'total_count' => 0,
    'sent' => array(),
    'not_sent' => array()
);

foreach($arrEmails as $i => $arrEmail){
    $arrStats['total_count'] += count($arrEmail['email_addresses']);

    if(!$arrEmail['send']){
        // don't send this email
        $arrEmail['send_date'] = date('Y-m-d g:ia');
        $arrEmail['error'] = 'Set to Not Send';
        $arrStats['not_sent'][] = $arrEmail;
        continue;
    }
//

    $arrEmail['primary_email'] = $arrEmail['email_addresses'][0];
    unset($arrEmail['email_addresses'][0]);

    $strHeaders = "MIME-Version: 1.0\r\n";
    $strHeaders .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
    $strHeaders .= "Bcc: " . implode(', ', $arrEmail['email_addresses']) . "\r\n";
    $strHeaders .= "From: ross@bcgolfguide.com" . "\r\n";

    //var_dump($arrEmail);

    // if(!Util::sendMailCore($arrEmail['primary_email'], $arrEmail['subject'], $arrEmail['message'], $strHeaders)){
    //     // email wasn't sent
    //     $arrEmail['send_date'] = date('Y-m-d g:ia');
    //     $arrEmail['error'] = 'Error when calling MAIL()';
    //     $arrStats['not_sent'][] = $arrEmail;
    //     continue;
    // }

/*
     echo '<pre>';
     print_r($arrEmail);
     echo '</pre><br /><hr /><br />';
*/

    //email sent successfully
    $arrEmail['send_date'] = date('Y-m-d g:ia');
    $arrStats['sent'][] = $arrEmail;
}

//var_dump(count($arrEmails));

echo '<strong>Total Email Addresses:</strong> ' . $arrStats['total_count'] . '<br />';
echo '<strong>Total Emails Sent:</strong> ' . count($arrStats['sent']) . '<br />';
echo '<strong>Total Emails Not Sent:</strong> ' . count($arrStats['not_sent']) . '<br />';
die();