<?
/*

Cron Job to send an alert 2 days after a group has checked into their primary hotel so one of the agents can check up on them should they choose to

The logic for this cron is as follows:
- Get a list of groups where check in date (of primary hotel) + 2 days == today
- Send that list to BC Golf Guide Employees

*/


//Reminder Emails
// Select all packages that are potentailly due & have a balance owing

include($_SERVER['DOCUMENT_ROOT']."/application/config.php");
$objDB = new database;

$arrEmails = array();

$now = new DateTime();
$strPlusTwoDays = new DateTime();
$objInterval = new DateInterval("P1D");
$objInterval->invert = 1;
$strPlusTwoDays->add($objInterval);

$strNow = $now->format('Y-m-d');
$strPlusTwoDays = $strPlusTwoDays->format('Y-m-d');

//Find all hotels which contain fully paid bookings that meet the target date ranges
$strSQL = "SELECT DISTINCT 	packages.id as package_id,
							packages.group_name,
							packages.phone,
							packages.cell_phone,
							ph.check_in_date as check_in_date, 
							hotel.id As hotel_id,
				 			hotel.hotel_name,
				 			hotel.contact_person as contact_person,
				 			hotel.contact_phone as contact_phone,
							hotel.frontdesk_email As contact_email,
							hotel.booking_report_email,
							hotel.booking_report_frequency,
							brands.contact_email as brand_contact_email,
							brands.contact_email2 as brand_contact_email2,
							brands.business_name
			 FROM package_hotel ph
			 JOIN hotel ON (ph.hotel_id = hotel.id)
			 JOIN packages ON (ph.package_id = packages.id)
			 LEFT JOIN brands ON (18 = brands.id)
			WHERE packages.status = 'Active' 
			 AND `default` = 1
			 AND check_in_date = '$strPlusTwoDays'";

			 #AND (last_edit > last_update_sent OR last_update_sent is NULL)
			 #AND (SELECT sum(final_price) from package_hotel_detail WHERE package_hotel_id IN (SELECT id FROM package_hotel WHERE package_id = ph.package_id and `default` = 1)) = 0 ";

$arrBookings = $objDB->getMysqliResults($strSQL,true);

foreach ($arrBookings as $arrBooking) {
	$strSql = "SELECT booking_people_id FROM package_booking_people WHERE package_id = " . $arrBooking['package_id'] . " AND primary_contact = 1";

	$arrBookingPeopleIds = $objDB->getMysqliResults($strSql,true);

	if (count($arrBookingPeopleIds) > 0) {
		$intBookingPersonId = $arrBookingPeopleIds[0]['booking_people_id'];
	} else {
		$intBookingPersonId = 1; // ROSS
	}



	$strSql = "SELECT * FROM booking_people WHERE id = $intBookingPersonId";

	$arrBookingPeople = $objDB->getMysqliResults($strSql,true);

	$strMessage = '<h1>Check In Alert for Group '.$arrBooking['group_name'].'</h1>';
	$strMessage .= '<p>Check in Date: ' . $arrBooking['check_in_date'] . '</p>';
	$strMessage .= '<p>Phone #: ' . $arrBooking['phone'] . '</p>';
	$strMessage .= '<p>Cell #: ' . $arrBooking['cell_phone'] . '</p>';
	$strMessage .= '<p>Hotel Name: ' . $arrBooking['hotel_name'] . '</p>';
	$strMessage .= '<p>Hotel Contact Person: ' . $arrBooking['contact_person'] . '</p>';
	$strMessage .= '<p>Hotel Phone #: ' . $arrBooking['contact_phone'] . '</p>';
	$strMessage .= '<p>Hotel Email: ' . $arrBooking['contact_email'] . '</p>';

	$arrEmail = array(
						'send' => true,
						'contact_email' => $arrBookingPeople[0]['booking_email'],
						'subject'	=> 'Check-In Alert - ' . $arrBooking['group_name'],
						'email_addresses' => array($arrBookingPeople[0]['booking_email']),
						'message' => $strMessage,
						'type' => null
					);

	$arrEmails[] = $arrEmail;
}

foreach ($arrEmails as $arrEmail) {
	echo "<hr />";
	echo 'Send mail to: ' . print_r($arrEmail['email_addresses'], true) . "<br />";
	echo 'From: ' . print_r($arrEmail['contact_email'], true) . "<br />";
	echo $arrEmail['message'];
}

//die();

// send out emails

$arrStats = array(
	'total_count' => 0,
	'sent' => array(),
	'not_sent' => array()
);

foreach($arrEmails as $arrEmail){
	$arrStats['total_count'] += count($arrEmail['email_addresses']);

	if(!$arrEmail['send']){
		// don't send this email
		$arrEmail['send_date'] = date('Y-m-d g:ia');
		$arrEmail['error'] = 'Set to Not Send';
		$arrStats['not_sent'][] = $arrEmail;
		continue;
	}

	$strHeaders = "MIME-Version: 1.0\r\n";
    $strHeaders .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
    $strHeaders .= "Bcc: " . implode(', ', $arrEmail['email_addresses']) . "\r\n";
    $strHeaders .= "From: " . $arrEmail['contact_email'] . "\r\n";

	// try to send this email
// 	if(!Util::sendMailCore(null, $arrEmail['subject'], $arrEmail['message'], $strHeaders)){
// 		// email wasn't sent
// 		$arrEmail['send_date'] = date('Y-m-d g:ia');
// 		$arrEmail['error'] = 'Error when calling MAIL()';
// 		$arrStats['not_sent'][] = $arrEmail;
// 		continue;
// 	}

	 echo '<pre>';
	 print_r($arrEmail);
	 echo '</pre><br /><hr /><br />';

	//email sent successfully
	$arrEmail['send_date'] = date('Y-m-d g:ia');
	$arrStats['sent'][] = $arrEmail;
}

//var_dump(count($arrEmails));

echo '<strong>Total Email Addresses:</strong> ' . $arrStats['total_count'] . '<br />';
echo '<strong>Total Emails Sent:</strong> ' . count($arrStats['sent']) . '<br />';
echo '<strong>Total Emails Not Sent:</strong> ' . count($arrStats['not_sent']) . '<br />';
die();