<?php

// Get the models
include($_SERVER['DOCUMENT_ROOT']."/application/config.php");

// Get list of upcoming hotel packages
$arrPackagesUpcoming = Cron::getPackagesUpcoming(array(
    'date_range' => 60
));

// Get list of overdue hotel packages
$arrPackagesOverdue = Cron::getPackagesOverdue(array(
    'date_range' => 60
));

// Start output
$strHtml = '';

// Get the emails where this cron is sent
$strEmailTo = implode(',', Cron::getEmailList('payment_status_cron'));

// Check if data is empty
if (!empty($arrPackagesUpcoming) || !empty($arrPackagesOverdue)) {

    // Start email output message
    $strHtml = '<style>'
             . '.name { width: 185px; text-align: left; }'
             . '.date { width: 100px; text-align: center; }'
             . '.price { width: 100px; text-align: right; }'
             . '.status {  }'
             . '</style>';

    $strHtml .= 'Greetings Ross, <br /><br />';


    if (!empty($arrPackagesUpcoming)) {

        // Start the table
        $strHtml .= 'There are <strong>' . count($arrPackagesUpcoming) . '</strong> packages nearing or on their designated check in date and have NOT paid in full, they are listed below in order of urgency:'
                  . '<br /><h2>Upcoming:</h2>'
                  . '<table>'
                  . '<tr>'
                  . '<th class="date">Check In Date</th>'
                  . '<th class="name">Group Name</th>'
                  . '<th class="name">Contact Phone</th>'
                  . '<th class="name">Booking Agent</th>'
                  . '<th class="price">Package Price</th>'
                  . '<th class="price">Package Paid</th>'
                  . '<th class="price">Remaining</th>'
                  . '<th class="status">Status</th>'
                  . '</tr>';

        // Loop through upcoming hotel list
        foreach ($arrPackagesUpcoming as $arrPackage) {

            $strHtml .= '<tr>'
                      . '<td class="date">' . $arrPackage['check_in_date'] . '</td>'
                      . '<td class="name"><a href="' . ROOT_URL . '/admin/package/edit/' . $arrPackage['id'] .'" target="_blank">' . $arrPackage['group_name'] . '</a></td>'
                      . '<td class="name">' . $arrPackage['group_contact_phone'] . '</td>'
                      . '<td class="name">' . $arrPackage['booking_agent'] . '</td>'
                      . '<td class="price">' . Util::formatPrice($arrPackage['package_total']) . '</td>'
                      . '<td class="price">' . Util::formatPrice($arrPackage['package_paid']) . '</td>'
                      . '<td class="price"><strong>' . Util::formatPrice($arrPackage['package_total'] - $arrPackage['package_paid']) . '</strong></td>'
                      . '<td class="status">' . $arrPackage['package_status'] . '</td>'
                      . '</tr>';
        }

        // Close upcoming table
        $strHtml .= '</table>';
    }

    if (!empty($arrPackagesOverdue)) {

        if (!empty($arrPackagesUpcoming)) {
            // Divider
            $strHtml .= '<br /><hr /><br />';
        }

        $strHtml .= 'There are <strong>' . count($arrPackagesOverdue) . '</strong> packages past due their check in date and have NOT paid in full, they are listed below in order of urgency:'
                  . '<br /><h2>Past Due:</h2>'
                  . '<table>'
                  . '<tr>'
                  . '<th class="date">Check In Date</th>'
                  . '<th class="name">Group Name</th>'
                  . '<th class="name">Contact Phone</th>'
                  . '<th class="name">Booking Agent</th>'
                  . '<th class="price">Package Price</th>'
                  . '<th class="price">Package Paid</th>'
                  . '<th class="price">Remaining</th>'
                  . '<th class="status">Status</th>'
                  . '</tr>';

        foreach ($arrPackagesOverdue as $arrPackage) {
            $strHtml .= '<tr>'
                      . '<td class="date">' . $arrPackage['check_in_date'] . '</td>'
                      . '<td class="name"><a href="' . ROOT_URL . '/admin/package/edit/' . $arrPackage['id'] .'" target="_blank">' . $arrPackage['group_name'] . '</a></td>'
                      . '<td class="name">' . $arrPackage['group_contact_phone'] . '</td>'
                      . '<td class="name">' . $arrPackage['booking_agent'] . '</td>'
                      . '<td class="price">' . Util::formatPrice($arrPackage['package_total']) . '</td>'
                      . '<td class="price">' . Util::formatPrice($arrPackage['package_paid']) . '</td>'
                      . '<td class="price"><strong>' . Util::formatPrice($arrPackage['package_total'] - $arrPackage['package_paid']) . '</strong></td>'
                      . '<td class="status">' . $arrPackage['package_status'] . '</td>'
                      . '</tr>';
        }

        // Close overdue table
        $strHtml .= '</table>';

    }

    // Finish off the email data
    //$strEmailTo = 'ross@bcgolfguide.com, danny@bcgolfguide.com';
    $strEmailSubject = 'Check Payment Status Cron Job';
    $strEmailHeaders = 'From: ross@bcgolfguide.com' . "\r\n"
                     . 'Reply-To: ross@bcgolfguide.com'. "\r\n"
                     . 'MIME-Version: 1.0' . "\r\n"
                     . 'Content-Type: text/html; charset=ISO-8859-1' . "\r\n";

    // Send email
    // $blnMailSent = Util::sendMailCore($strEmailTo, $strEmailSubject, $strHtml, $strEmailHeaders);
    //echo ($strHtml);

} else {
    // Send email saying no packages to send info about
    // Start email output message
    $strHtml = '<style>'
             . '.name { width: 175px; text-align: left; }'
             . '.date { width: 100px; text-align: center; }'
             . '.price { width: 100px; text-align: right; }'
             . '.status {  }'
             . '</style>';

    $strHtml .= 'Greetings, <br /><br />';

    // Start the table
    $strHtml .= 'There are <strong>0</strong> packages nearing or on their designated check in date and have NOT paid in full, they are listed below in order of urgency:'
              . '<br />';


    $strHtml .= '<br /><hr /><br />';


    $strHtml .= 'There are <strong>0</strong> packages past due their check in date and have NOT paid in full, they are listed below in order of urgency:'
              . '<br />';

    // Finish off the email data
    //$strEmailTo = 'ross@bcgolfguide.com, danny@bcgolfguide.com';
    $strEmailSubject = 'Check Payment Status Cron Job';
    $strEmailHeaders = 'From: ross@bcgolfguide.com' . "\r\n"
                     . 'Reply-To: ross@bcgolfguide.com'. "\r\n"
                     . 'MIME-Version: 1.0' . "\r\n"
                     . 'Content-Type: text/html; charset=ISO-8859-1' . "\r\n";

    // Send email
    // $blnMailSent = Util::sendMailCore($strEmailTo, $strEmailSubject, $strHtml, $strEmailHeaders);
    //echo ($strHtml);
}
