<?php


class sitemap_controller extends default_controller {


    public function __construct($strPageId) {

        parent::__construct($strPageId);

        // Set out table name
        $this->strTableName = 'pages';
        $this->blnShowFeatured = $this->objModel->blnShowFeatured;
        $this->strSlug = isset($_GET['slug']) ? $_GET['slug'] : '';

        global $objSettings;

        // Get the regions
        $this->arrRegionsBc = $objSettings->getRegionsForNav(array('state' => 2));
        $this->arrRegionsUsa = $objSettings->getRegionsForNav(array('country' => 148));
        $this->arrRegionsInt = $objSettings->getRegionsForNav(array('international' => true));

        // Get canadian regions, remove BC regions
        $this->arrRegionsCa = $objSettings->getRegionsForNav(array('country' => 261)); // CA
        foreach ($this->arrRegionsCa as $i => $arrRegion) {
            if ($arrRegion['state_id'] == 2) {
                unset($this->arrRegionsCa[$i]);
            }
        }

        // Get the packages
        $this->arrPackagesBc   = $objSettings->getRegionsForNav(array('state' => 2, 'packages' => true));
        $this->arrPackagesUsa  = $objSettings->getRegionsForNav(array('country' => 148, 'packages' => true));
        $this->arrPackagesInt  = $objSettings->getRegionsForNav(array('international' => true, 'packages' => true));

        // Get canadian package regions, remove BC regions
        $this->arrPackagesCa = $objSettings->getRegionsForNav(array('country' => 261, 'packages' => true)); // CA
        foreach ($this->arrPackagesCa as $i => $arrRegion) {
            if ($arrRegion['state_id'] == 2) {
                unset($this->arrPackagesCa[$i]);
            }
        }

        // Misc Pages
        $this->arrPages1 = $objSettings->getPagesForNav(2);
        $this->arrPages2 = $objSettings->getPagesForNav(5);
        $this->arrPages3 = $objSettings->getPagesForNav(7);
    }


    public function setModel($strPageId) {

        $this->objModel = New Page($strPageId);

    }

    public function getPageContent() {

        include(ROOT_DIR.'/application/views/sitemap.php');

    }


}