<?php


class regions_controller extends default_controller {


	public function __construct($strPageId) {

		$this->strPgSize = isset($_REQUEST['pgSize']) ? $_REQUEST['pgSize'] : 5;

		$this->intRegionId = isset($_REQUEST['region']) ? $_REQUEST['region'] : 0;
		$this->strRegionSlug = isset($_REQUEST['region_slug']) ? $_REQUEST['region_slug'] : '';

		parent::__construct($strPageId);

        // Set SEO model
        $this->objSEO = $this->objRegion;

		// Set out table name
		$this->strTableName = 'pages';
		$this->blnShowFeatured = true;
		$this->strView = 'region';

		$this->strType = isset($_GET['type']) ? $_GET['type'] : '';
		$this->strSlug = isset($_GET['slug']) ? $_GET['slug'] : '';

		//override the default sort parameter
		//$this->strSortBy = isset($_REQUEST['sortBy']) ? $_REQUEST['sortBy'] : 'region_name';

		if($this->strRegionSlug != ''){

			$this->intRegionId = $this->objRegion->getRegionId($this->strRegionSlug);

		}

		$this->arrData = new stdClass();

		$this->arrCourses = $this->objPartner->getCourseListForRegion($this->intRegionId, false);
		$this->arrHotels = $this->objPartner->getHotelListForRegion($this->intRegionId);

		$this->arrData->arrCourses = $this->arrCourses;
		$this->arrData->arrHotels = $this->arrHotels;

		$this->arrBCPackages = $this->objModel->getPackageListForRegion($this->intRegionId, 3, '', false) ;

		//stuff for the search box drop down lists
		$this->objLocation = new Location;
		$this->arrRegions = $this->objLocation->getRegions();
		$this->arrDetails = $this->objRegion->getRegionDetail('',$this->intRegionId,false);
		$this->arrImages = $this->objRegion->getRegionImageList($this->intRegionId);

		$this->objModel->strMetaTitle .= ' - ' . $this->arrDetails['region_name'];
		$this->objModel->strMetaDescription = Util::cleanForHtml($this->arrDetails['text1']);

        // var_dump($this->objSEO);

	}


	public function setModel($strPageId) {

        $this->objModel = New Page($strPageId);
        $this->objCourse = new Course();
        $this->objHotel = new Hotel();
        $this->objRegion = new Region();
        $this->intRegionId = $this->objRegion->getRegionId($this->strRegionSlug);


        $this->objPartner = New Partner($strPageId);
        $this->objFeatured = New Featured($strPageId);
        //$this->objPartner->setSlug('bc_golf_guide');
        //$this->objPartner->setBaseUrl('r/package-builder');
        //$this->objPartner->setIdentUrl($this->intRegionId);
        //$this->objPartner->setDisplayImage($this->objModel->strDisplayImage);
        //$this->objPartner->init();



    }

}