<?php


class package_builder_controller extends default_controller {

	public $objContact;
	public $strUsername;
	public $strEmail;
	public $strComment;
	public $intFeaturedId = 0;

	public function __construct($strPageId) {

		parent::__construct($strPageId);

		// Default values
		$this->strUsername = '';
		$this->strEmail = '';
		$this->strComment = '';
		$this->blnShowFeatured = false;
		$this->strView = 'builder';

		$this->arrDetails = $this->objModel->arrDetails;
		$this->intStep = $this->objModel->intStep;

        // For search drop down list
        $this->objLocation = new Location;
        $this->arrRegions = $this->objLocation->getRegions();
	}



	public function setModel($strPageId) {
        // Set the variables
		$this->intFeaturedId = !empty($_REQUEST['featuredID']) ? $_REQUEST['featuredID'] : 0;
		$this->intRegionId = !empty($_REQUEST['r']) ? $_REQUEST['r'] : 0;

        // Set the ID and slug
		if (!empty($this->intRegionId)) {
			$ident = $this->intRegionId;
			$base = 'r/golf-vacation-builder';
        }
        if (!empty($this->intFeaturedId)) {
            $ident = $this->intFeaturedId;
            $base = 'golf-vacation-builder';
        }

        $this->objPage = New Page('golf-vacation-builder');

        $this->objModel = New Partner($strPageId);
        $this->objModel->setSlug('bc_golf_guide');
        $this->objModel->setBaseUrl($base);
        $this->objModel->setIdentUrl($ident);
        $this->objModel->setDisplayImage($this->objPage->strDisplayImage);
        $this->objModel->init();
        //$this->objBrand = New Brand($strPageId);
    }



}