<?php


class map_controller extends default_controller {


	public function __construct($strPageId) {

		parent::__construct($strPageId);

		// Set out table name
		$this->strTableName = 'pages';
		$this->blnShowFeatured = false;

		$this->strMapType = isset($_GET['maptype']) ? $_GET['maptype'] : '';
		$this->strSlug = isset($_GET['slug']) ? $_GET['slug'] : '';

		if($this->strMapType == 'course') {


			$this->objCourse = new Course();
			$this->arrDetails = $this->objCourse->getCourseDetail($this->strSlug);
			$this->arrDetails['item_name'] = $this->arrDetails['course_name'];

		} else if($this->strMapType == 'hotel') {

			$this->objHotel = new Hotel();
			$this->arrDetails = $this->objHotel->getHotelDetail($this->strSlug);
			$this->arrDetails['item_name'] = $this->arrDetails['hotel_name'];

		}



	}


	public function setModel($strPageId) {

        $this->objModel = New Page($strPageId);

    }

}