<?php


class hotels_controller extends default_controller {


	public function __construct($strPageId) {

		parent::__construct($strPageId);

		// Set out table name
		$this->strTableName = 'pages';
		//$this->blnShowFeatured = true;
		$this->blnShowFeatured = $this->objModel->blnShowFeatured;


		$this->strType = isset($_GET['type']) ? $_GET['type'] : '';
		$this->strSlug = isset($_GET['slug']) ? $_GET['slug'] : '';
		$this->strView = 'list_hotels';

		//override the default sort parameter
		$this->strSortBy = isset($_REQUEST['sortBy']) ? $_REQUEST['sortBy'] : 'hotel_name';
		//override default page size
		$this->strPgSize = isset($_REQUEST['pgSize']) ? $_REQUEST['pgSize'] : 25;


		$this->intCountryId = isset($_REQUEST['country']) ? $_REQUEST['country'] : '261';//default Canada
		$this->intStateId = isset($_REQUEST['state']) ? $_REQUEST['state'] : '2'; //default BC
		$this->intCityId = isset($_REQUEST['city']) ? $_REQUEST['city'] : '6345'; //default Kelowna


		$this->arrHotels = $this->objHotel->getHotelList($this->strPgSize, $this->strPg, $this->strSortBy,
			$this->strSortOrder, $this->strSearchWord, $this->strStatus, $this->intCountryId, $this->intStateId, $this->intCityId, false);

		//stuff for the search box drop down lists
		$this->objLocation = new Location;
		$this->arrCountries = $this->objLocation->getCountries();
		$this->arrStates = $this->objLocation->getStates($this->intCountryId);
		$this->arrCities = $this->objLocation->getCities($this->intStateId);


	}


	public function setModel($strPageId) {

        $this->objModel = New Page($strPageId);
        $this->objHotel = new Hotel();

    }

}