<?php


class featured_controller extends default_controller {


	public function __construct($strPageId) {

		parent::__construct($strPageId);

		// Set out table name
		$this->strTableName = 'pages';
		$this->blnShowFeatured = false;

		$this->strSlug = isset($_GET['featured_slug']) ? $_GET['featured_slug'] : '';
		$this->strArrivalDate = isset($_POST['arrival_date']) ? $_POST['arrival_date'] : '';
		$this->strDepartureDate = isset($_POST['departure_date']) ? $_POST['departure_date'] : '';
		$this->intStep = isset($_GET['step']) ? $_GET['step'] : 1;

		//override the default sort parameter
		$this->strSortBy = isset($_REQUEST['sortBy']) ? $_REQUEST['sortBy'] : 'end_date';

		//override default page size
		$this->strPgSize = isset($_REQUEST['pgSize']) ? $_REQUEST['pgSize'] : 5;
		$this->intRegionId = isset($_REQUEST['region']) ? $_REQUEST['region'] : 0;
		$this->intCountryId = isset($_REQUEST['country_id_search']) ? $_REQUEST['country_id_search'] : '';
		$this->strRegionName = isset($_REQUEST['region_name']) ? $_REQUEST['region_name'] : '';

		//list of sidebar advertisements
		$this->arrAds = $this->objModel->getAds();

		if($this->strSlug != '') {

			$this->arrDetails = $this->objFeatured->getPackageDetail($this->strSlug,'',false);
			$this->arrCourses = $this->arrDetails['golf_course'];
			$this->arrHotels = $this->arrDetails['hotel'];
			$this->strView = 'featured';
			$id = $this->objFeatured->getPackageId($this->strSlug);

			//increment the hit counter
			$this->objFeatured->updateHits($id);

			$this->objSEO = $this->objFeatured;

            // Get the region details
            $objRegion = new Region;
            $arrRegion = $objRegion->getRegionDetail('', $this->arrDetails['region_id']);
            $this->strBack = !empty($arrRegion['slug']) ? '/region/featured-golf-packages/' . $arrRegion['slug'] . '/' : '/featured-golf-packages/';

			if($this->intStep == 3) {
				$this->strView = 'featured';

                // Force noindex on request form
                $this->objSEO->strMetaRobots = 'noindex,nofollow';

				if(isset($_POST['Submit']) && $_POST['Submit'] != '') {
					$this->objFeatured->setSlug('bc_golf_guide');
					$this->objFeatured->handlePost($_POST,$this->arrDetails);
				}

			}


		} else {


			$this->strView = 'list_featured';

			//stuff for the search box drop down lists
			$this->objLocation = new Location;
			$this->arrRegions = $this->objLocation->getRegionsByCountry($this->intCountryId);

			if($this->strRegionName != '') {

				$this->intRegionId = $this->objLocation->getRegionIdByName($this->strRegionName);

			}


			if($this->intRegionId != '' && $this->intRegionId != '0') {
				$this->arrPackages = $this->objFeatured->getPackageListByRegion($this->strPgSize, $this->strPg,
						$this->strSearchWord, $this->strStatus, $this->intRegionId, $this->strArrivalDate, $this->strDepartureDate, false);
				$this->arrDetails = $this->objRegion->getRegionDetail('',$this->intRegionId,false);
				$this->arrCourses = $this->objFeatured->getCoursesForPackages($this->arrPackages,false);
				$this->arrHotels = $this->objFeatured->getHotelsForPackages($this->arrPackages,false);
			}


		}

	}


	public function setModel($strPageId) {

        $this->objModel = New Page('featured-golf-packages');
        $this->objFeatured = new Featured();
        $this->objRegion = new Region();

    }

}