<?php


class detail_controller extends default_controller {


	public function __construct($strPageId) {

		parent::__construct($strPageId);

		// Set out table name
		$this->strTableName = 'pages';
		//$this->blnShowFeatured = 0;
		$this->blnShowFeatured = $this->objModel->blnShowFeatured;
		$this->strType = isset($_GET['type']) ? $_GET['type'] : '';
		$this->strSlug = isset($_GET['slug']) ? $_GET['slug'] : '';
		$this->strView = 'course';


		//$this->arrAds = array();
		$this->arrAds = $this->objModel->getAds();

		//for search drop down list
		$this->objLocation = new Location;
		$this->arrRegions = $this->objLocation->getRegions();


		if($this->strType == 'course') {

			$this->strView = 'course';

			$this->objCourse = new Course();
			//$this->objSEO = $this->objCourse->setSEO();

			$this->arrDetails = $this->objCourse->getCourseDetail($this->strSlug,false);
			$this->arrPhotos = $this->objCourse->getCoursePhotos($this->arrDetails['id']);
			$this->arrVideos = $this->objCourse->getCourseVideos($this->arrDetails['id']);
			$this->arrTestimonials = $this->objCourse->getCourseTestimonials($this->arrDetails['id']);
			$this->arrReviews = $this->objCourse->getCourseReviews($this->arrDetails['id']);
			$this->arrHoleInOnes = $this->objCourse->getCourseHoleInOne($this->arrDetails['id']);
			$this->objCourse->updateHits($this->arrDetails['id'],false);

/*
			$this->objModel->setMetaData(
				$this->arrDetails['meta_title'], // Title
				strip_tags($this->arrDetails['meta_description']), // Description
				$this->arrDetails['meta_keywords'], // Keywords
				$this->arrDetails['meta_robots'], // Robots
				false // Debug
			);
*/
			$this->objSEO = $this->objCourse;

			//we need a default list of all featured packages that contain this course
			//$this->arrBCPackages = $this->objModel->getPackageList(4, 1, 'start_date','DESC','', 'Active', 2, '', false);
			$this->arrBCPackages = $this->objModel->getPackageListForCourse($this->arrDetails['id'], 4, false);
			//$this->arrUSPackages = $this->objModel->getPackageList(3, 1, 'start_date','DESC','', 'Active', '', 261, false);



		} else if($this->strType == 'hotel') {

			$this->strView = 'hotel';

			$this->objHotel = new Hotel();
			//$this->objSEO = $this->objHotel->setSEO();

			$this->arrDetails = $this->objHotel->getHotelDetail($this->strSlug);
			$this->arrPhotos = $this->objHotel->getHotelPhotos($this->arrDetails['id'],false);
			$this->arrVideos = $this->objHotel->getHotelVideos($this->arrDetails['id']);
			$this->arrFiles = $this->objHotel->getHotelFiles($this->arrDetails['id']);
			$this->objHotel->updateHits($this->arrDetails['id'],false);
/*
			$this->objModel->setMetaData(
				$this->arrDetails['meta_title'], // Title
				strip_tags($this->arrDetails['meta_description']), // Description
				$this->arrDetails['meta_keywords'], // Keywords
				$this->arrDetails['meta_robots'], // Robots
				false // Debug
			);
*/
			$this->objSEO = $this->objHotel;


			$this->arrBCPackages = $this->objModel->getPackageListForHotel($this->arrDetails['id'], 4, false);
			//var_dump($this->arrDetails);

		}


	}


	public function setModel($strPageId) {

        $this->objModel = New Page($strPageId);

    }

}