<?php


class default_controller {

    // The last query we executed
    public $strQuery = '';

    // The resource returned from above query
    public $arrResult = null;

    // Number of affected rows from above query.
    public $intAffectedRows = null;
    public $strErrorMessage = '';
    public $strSuccessMessage = '';

    public $strTitle = '';
    public $strContent = '';
    public $strTableName = 'pages';
    public $strTableSlug = 'pages';
    public $objModel = null;
    public $strView = '';

    public $strPg = '1';
    public $strPgSize = '50';
    public $strSortBy = 'id';
    public $strSortOrder = 'ASC';
    public $strSearchWord = '';
    public $strStatus = 'Active';

    public function __construct($strPageId) {

        $this->strTableSlug = $strPageId;


        $this->strPg = (isset($_REQUEST['pg']) && $_REQUEST['pg'] != '') ? $_REQUEST['pg'] : $this->strPg;
        $this->strPgSize = isset($_REQUEST['pgSize'])  ? $_REQUEST['pgSize'] : $this->strPgSize;
        $this->strSortBy = isset($_REQUEST['sortBy']) ? $_REQUEST['sortBy'] : $this->strSortBy;
        $this->strSortOrder = isset($_REQUEST['sortOrder']) ? $_REQUEST['sortOrder'] : $this->strSortOrder;
        $this->strSearchWord = isset($_REQUEST['searchWord']) ? $_REQUEST['searchWord'] : $this->strSearchWord;
        $this->strStatus = isset($_REQUEST['status']) ? $_REQUEST['status'] : $this->strStatus;


        // the model for this controller
        $this->setModel($strPageId);

        //page specific data
        $this->strTitle = $this->objModel->strTitle;
        $this->strContent = $this->objModel->strContent;
        $this->strView = $this->objModel->strView;
        $this->blnShowFeatured = true;

        $this->objSEO = $this->objModel;
    }


    public function setModel($strPageId) {

        $this->objModel = New Page($strPageId);

    }


    public function getPageContent() {

        include(ROOT_DIR.'/application/views/'.$this->strView.'.php');

    }


    public function getPageScripts() {

        //this method must be present, even if no scripts are needed
        echo '<!-- custom page scripts -->';

    }

}