<?php


class courses_controller extends default_controller {


	public function __construct($strPageId) {

		parent::__construct($strPageId);

		// Set out table name
		$this->strTableName = 'pages';
		//$this->blnShowFeatured = false;
		$this->blnShowFeatured = $this->objModel->blnShowFeatured;
		$this->strView = 'list_courses';

		$this->strType = isset($_GET['type']) ? $_GET['type'] : '';
		$this->strSlug = isset($_GET['slug']) ? $_GET['slug'] : '';
		

		//override the default sort parameter
		$this->strSortBy = isset($_REQUEST['sortBy']) ? $_REQUEST['sortBy'] : 'course_name';
		//override default page size
		$this->strPgSize = isset($_REQUEST['pgSize']) ? $_REQUEST['pgSize'] : 50;

		$this->intCountryId = isset($_REQUEST['country']) ? $_REQUEST['country'] : '261';//default Canada
		$this->intStateId = isset($_REQUEST['state']) ? $_REQUEST['state'] : '2'; //default BC
		$this->intCityId = isset($_REQUEST['city']) ? $_REQUEST['city'] : '6345'; //default Kelowna

		$this->arrCourses = $this->objCourse->getCourseList($this->strPgSize, $this->strPg, $this->strSortBy, 
			$this->strSortOrder, $this->strSearchWord, 'Active', $this->intCountryId, $this->intStateId, $this->intCityId, false);

		//stuff for the search box drop down lists
		$this->objLocation = new Location;
		$this->arrCountries = $this->objLocation->getCountries();
		$this->arrStates = $this->objLocation->getStates($this->intCountryId);
		$this->arrCities = $this->objLocation->getCities($this->intStateId);

		//list of sidebar advertisements
		$this->arrAds = $this->objModel->getAds();

	}


	public function setModel($strPageId) {

        $this->objModel = New Page($strPageId);
        $this->objCourse = new Course();

    }

}