<?php


class user_controller extends default_controller {

	public function __construct($strPageId) {


        $this->strSortBy = 'userID DESC, userID';
        $this->strSortOrder = 'ASC';
        
        $this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

        parent::__construct($strPageId);

		$this->strTableName = 'users';
		$this->strAdminSlug = '/admin/user/';
        $this->tab = isset($_REQUEST['tab']) ? $_REQUEST['tab'] : '';

		$this->arrTableSQLArray = array('','Alias','Email','role_id');
		$this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">','Alias','Email','Role');
		$this->arrTableSortArray = array(false,true,true,true,true,true,true, true);

        $this->strOptions = '?searchWord='.$this->strSearchWord . '&amp;status='.$this->strStatus;

        if($this->intID == ''){
            $this->arrImages = array();
        } else {
            $this->arrImages = $this->objModel->getPageImageList($this->intID);
        }
        

        if($this->strAction == '') {
            $this->strView =   'list_users';
        } else {
            $this->strView =   'user_form';
        }

	}


    /**
     * Function that sets the model for the controller
     *
     */
    public function setModel($strPageId, $strAction) {

        $this->objModel = New User($strPageId, $strAction);

    }

    /**
     * Note title
     * Note description
     */
    public function getPageContent() {
        if (empty($this->strAction)) {
            // If the action is empty get the list view
            include(ROOT_DIR.'/application/views/admin/default_list_view.php');
        } else {
            // If the action is set get the edit / add form
            include(ROOT_DIR.'/application/views/admin/detail/'.$this->strView.'.php');
        }
    }

    public function getPageControls($id, $slug, $status, $lock = false, $visible = true) {
        $html = '';
        $visibleClass = ($visible) ? '' : 'invisible';

        $html .= '<ul data-d='.$status.'  class="grid-actions list-inline '.$visibleClass.'">';
        if ($status == 'test') {
            $html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/' . $this->strOptions . '">Restore</a></li>';
            $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
        
        } else {
            $html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/' . $this->strOptions . '">Edit</a></li>';
            if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
                if(!$lock){
                    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
                }
            }
        }
        $html .= '</ul>';

        return $html;
    }




}