<?php


class report_controller extends default_controller {

	public $blnShowExport = false;
	public $blnShowSearch = true;

	public function __construct($strPageId) {
	    
	    $this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

		parent::__construct($strPageId);

		//$this->strTableName = 'city';
		$this->strAdminSlug = '/admin/report/'.$strPageId;
		$this->arrTableSQLArray = array('');
		$this->arrTableDisplayArray = array('');
		$this->arrTableSortArray = array(false);
		$this->intYear = isset($_REQUEST['year']) ? $_REQUEST['year'] :  date("Y");
		$this->intMonth = isset($_REQUEST['month']) ? $_REQUEST['month'] : '';
		$this->strExport = isset($_REQUEST['export']) ? $_REQUEST['export'] : '';

		$this->blnShowFilters = false;
		$this->blnShowMonthFilter = true;
        $this->blnShowRangeFilter = false;
        $this->blnShowPagination = true;

		$this->strView =   $strPageId;
		$this->strSubmit = isset($_REQUEST['Submit']) ? $_REQUEST['Submit'] : '';
		$this->strContent = isset($_REQUEST['description']) ? $_REQUEST['description'] : '';
		$this->intHotelId = isset($_REQUEST['hotel_id']) ? $_REQUEST['hotel_id'] : '';
		$this->intBrandId = isset($_REQUEST['brand_id']) ? $_REQUEST['brand_id'] : '';
		$this->intCourseId = isset($_REQUEST['course_id']) ? $_REQUEST['course_id'] : '';
		$this->strSendDate = isset($_REQUEST['send_date']) ? $_REQUEST['send_date'] : Date('Y-m-d');
		$this->arrFilter = array();

		//$this->intGridCompleted = isset($_REQUEST['grid_completed']) ? $_REQUEST['grid_completed'] : '';
		$this->strFilterType = isset($_REQUEST['filter_type']) ? $_REQUEST['filter_type'] : '';
		$this->strStartDate = isset($_REQUEST['start_date']) ? $_REQUEST['start_date'] : '';
		$this->strEndDate = isset($_REQUEST['end_date']) ? $_REQUEST['end_date'] : '';

        $this->strGridAgency = isset($_REQUEST['grid_agency']) ? $_REQUEST['grid_agency'] : '';
        $this->strGridAgent = isset($_REQUEST['grid_agent']) ? $_REQUEST['grid_agent'] : '';
        $this->strGridDateType = isset($_REQUEST['grid_date']) ? $_REQUEST['grid_date'] : '';

		switch ($strPageId) {

		    case 'course':
		        $this->strTitle = ' Course Report';
		        $this->arrTableSQLArray = array_merge($this->arrTableSQLArray,array('course_name','','action'));
				$this->arrTableDisplayArray = array_merge($this->arrTableDisplayArray,array('Course Name','Export Report','Actions'));
				$this->arrTableSortArray = array_merge($this->arrTableSortArray,array(true,false,false));
				
				$checkaccess = $this->objModel->checkpageaccess($this->controller."_hotel_detail_range", $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }

				$this->strAdminSlug .= '/0';
				//$this->strOptions .= "&year=".$this->intYear;

				//need a complete list of courses
				//$this->objCourse = New Course('','');
				$this->arrDetails = $this->objModel->getCourseList('50000',$this->strPg,'course_name','ASC',
					$this->strSearchWord, $this->intYear,'Active', '', '', false);
				$this->objModel->setRecords($this->objModel->records);
				$this->blnShowFilters = true;
				$this->blnShowMonthFilter = false;

				$this->blnShowExport = true;

		    	if($this->strExport != '') {

		    		//first create the file
		    		$num = 0;

					if(count($this->arrDetails) > 0) {
					     foreach($this->arrDetails As $course) {

					     	$arrReportDetails = $this->objModel->getCourseReportDetails($course['id'],$this->intYear,false);
					     	if(count($arrReportDetails) > 0) {

					     		foreach($arrReportDetails As $p) {

                                    $prod[$num]['id']            = $p['id'];
                                    $prod[$num]['course_name']   = $course['course_name'];
                                    $prod[$num]['group_name']    = $p['group_name'];
                                    $prod[$num]['phone']         = $p['phone'];
                                    $prod[$num]['golfer_num']    = $p['golfer_num'];
                                    $prod[$num]['tee_date']      = $p['tee_date'];
                                    $prod[$num]['tee_time']      = $p['tee_time'].' '.$p['tee_ap'];
                                    $prod[$num]['carts']         = $p['carts'];
                                    $prod[$num]['range_ball']    = $p['range_ball'];
                                    $prod[$num]['shuttle']       = $p['shuttle'];
                                    $prod[$num]['rental_club']   = $p['rental_club'] == 0 ? 'No' : 'Yes';
                                    $prod[$num]['net_rate']      = $p['net_rate'];
                                    $prod[$num]['confirm_num']   = $p['confirm_num'];
                                    $prod[$num]['paidout']       = $p['paidout'] == 0 ? 'No' : 'Yes';

                                    $prod[$num]['order_date']     = $p['order_date'];
                                    $prod[$num]['dates_booking']  = $p['dates_booking'];
                                    // $prod[$num]['sell_value']     = $p['sell_value'];
                                    $prod[$num]['repeat']         = $p['repeat'] == 0 ? 'No' : 'Yes';
                                    $prod[$num]['business_name']  = $p['business_name'];
                                    $prod[$num]['booking_name']   = $p['booking_name'];

                                    $num++;
						     	}
							}



					    }



					}

					$output = fopen("php://output",'w+') or die("Can't open php://output");

					header("Content-Type:application/csv");
					header("Content-Disposition:attachment;filename=course_report_$this->intYear.csv");

					fputcsv($output, array('id','course_name','group_name','phone','golfer_num','tee_date','tee_time','carts','range_ball','shuttle','rental_club','net_rate','confirm_num','paidout','order_date','dates_booking','repeat','business_name','booking_name'));
    				if (!empty($prod)) {
                        foreach($prod as $product) {
    					    fputcsv($output, $product);
    					}
                    }
					fclose($output) or die("Can't close php://output");
					die();


		    	}

		        break;

		    case 'course_detail':

		    	//Process Private Notes Update
		    	$objPackageGolf = new Packagecourses;

		    	if (isset($_REQUEST['private_notes'])) {
		    		foreach ($_REQUEST['private_notes'] as $key=>$value) {
		    			$arrKeys = array('notes');
		    			$arrVals = array($value);

		    			$objPackageGolf->mysqliupdate('package_golf',$arrKeys, $arrVals, '', $key);
		    		}
		    	}


		    	$this->strTitle = ' Course Report Details';
		    	$this->intCourseId = isset($_REQUEST['id']) ? $_REQUEST['id'] : '';

				$this->strAdminSlug .= '/'. $this->intCourseId;

		    	$this->arrTableSQLArray = array_merge($this->arrTableSQLArray,array('','','','','','','','','','','','action'));
				/*$this->arrTableDisplayArray = array_merge($this->arrTableDisplayArray,array('Payment','Group Name',
					'Playing Date','Playing Time','# Golfers','Carts','Range Balls Included','Shuttle',
					'Rental Clubs Or Pull Carts','Track Code','Net Rate','Confirmation Number','Private Notes','Paid Out'));*/
				$this->arrTableDisplayArray = array_merge($this->arrTableDisplayArray,array('Payment','Group Name',
					'City','Playing Date','Playing Time','# Golfers','Carts',
					'Public Cost','Private Cost','Confirmation Number','Private Notes','Paid Out'));
				$this->arrTableSortArray = array_merge($this->arrTableSortArray,array(true,false,false,false,false,false,false,false,false,false,false,false));

				$this->arrDetails = $this->objModel->getCourseReportDetails($this->intCourseId,$this->intYear,false);

				if($this->strExport != '') {
		    		$num = 0;
		    		if(count($this->arrDetails) > 0) {
					     foreach($this->arrDetails As $p) {
					         $prod[$num]['group_name']   = $p['group_name'];
					         $prod[$num]['phone']	= $p['phone'];

								$prod[$num]['cell_phone']	= $p['cell_phone'];
								$prod[$num]['state']	= $p['state'];
								$prod[$num]['country']	= $p['country'];

					         $prod[$num]['tee_date']     = $p['tee_date'];
					         $prod[$num]['tee_time']     = $p['tee_time'] . ' ' . $p['tee_ap'];
					         $prod[$num]['golfer_num']   = $p['golfer_num'];
					         $prod[$num]['carts']        = $p['carts'];
					         //$prod[$num]['range_ball']   = $p['range_ball'];
					         //$prod[$num]['shuttle']      = $p['shuttle'];
					         //$rental_club = $p['rental_club'] == 0 ? 'No' : 'Yes';
							 //$prod[$num]['rental_club'] = $rental_club;
					         //$prod[$num]['track_code'] 	 = $p['track_code'];
					         $prod[$num]['course_public_rate'] 	 	= $p['public_course_grand_total'];
					         $prod[$num]['public_summary'] 	 	= $p['public_summary'];
					         $prod[$num]['course_private_rate'] 	 = $p['private_course_grand_total'];
					         $prod[$num]['private_summary'] 	 	= $p['private_summary'];
					         //$prod[$num]['net_rate'] 	 = $p['net_rate'];
					    	 $prod[$num]['confirm_num']  = $p['confirm_num'];
					    	 $prod[$num]['private_notes'] = $p['private_notes'];
					    	 $paidout = $p['paidout'] == 0 ? 'No' : 'Yes';
							 $prod[$num]['paidout'] = $paidout;

					    	 //$prod[$num]['dates_booking'] = $p['dates_booking'];

					    	 //$prod[$num]['repeat_customer'] = ($p['repeat_customer'] == 0 ? 'No' : 'Yes');
					         $num++;
					    }
						$output = fopen("php://output",'w+') or die("Can't open php://output");

						header("Content-Type:application/csv");
						header("Content-Disposition:attachment;filename=course_report_$this->intHotelId.csv");

						fputcsv($output, array('group_name','phone','cell_phone','state','country','tee_date','tee_time','golfer_num','carts','course_public_rate','public_summary','course_private_rate','private_summary','confirm_num','private_notes','paidout'));
						foreach($prod as $product) {
						    fputcsv($output, $product);
						}
						fclose($output) or die("Can't close php://output");
						die();
					}
		    	}


				break;

			case 'course_detail_range':
				$this->strTitle = ' Course Detail Range Report';

                $this->blnShowFilters = true;
                $this->blnShowRangeFilter = true;
                $this->blnShowAgencyFilter = true;
                $this->blnShowExport = false;
                $this->blnShowMonthFilter = false;

                $objGroup = new Group;
                $this->arrAgency = $objGroup->getAgencyAll();
                $this->arrAgent  = $objGroup->getAgentAll();

		        $this->arrTableSQLArray = array('course_name');
				$this->arrTableDisplayArray = array('Course Name');
				$this->arrTableSortArray = array(false);

				$this->arrDetailTableSQLArray = array('','','','','','','action');
				$this->arrDetailTableDisplayArray = array('Group Name',
					'Playing Date','Playing Time','# Golfers','Carts',
					'Confirmation Number','Paid Out');
				$this->arrDetailTableSortArray = array(false,false,false,false,false,false,false);

				$this->strAdminSlug .= '/0';
				//$this->strOptions .= "&year=".$this->intYear;

				//need a complete list of courses
				//$this->objCourse = New Course('','');


				// default date filters if they are empty to show last month
				if(empty($this->strStartDate)){
					$this->strStartDate = date('Y-m-d', strtotime('last month'));
				}

				if(empty($this->strEndDate)){
					$this->strEndDate = date('Y-m-d');
				}

				$this->arrDetails = $this->objModel->getCourseDetailRangeList('50000',$this->strPg,'course_name','ASC',
					$this->strSearchWord, $this->strStartDate, $this->strEndDate,'Active', '', '', false);
				$this->objModel->setRecords($this->objModel->records);
				$this->blnShowFilters = true;

				// get the detail records for each course
				if(!empty($this->arrDetails)){
					foreach($this->arrDetails as &$arrCourse){
						$arrCourse['detail_records'] = $this->objModel->getCourseDetailRangeChildren($arrCourse['id'], $this->strStartDate, $this->strEndDate);
					}
				}

		    	if($this->strExport != '') {

		    		//first create the file
		    		$num = 0;
					//$sql = "SELECT id, name, description FROM products";
					if(count($this->arrDetails) > 0) {
					     foreach($this->arrDetails As $course) {

					     	$arrReportDetails = $this->objModel->getCourseReportDetails($course['id'],$this->strStartDate,$this->strEndDate,false);
					     	if(count($arrReportDetails) > 0) {

					     		foreach($arrReportDetails As $p) {
							         $prod[$num]['id']          = $p['id'];
							         $prod[$num]['course_name']        = $course['course_name'];
							         $prod[$num]['group_name']        = $p['group_name'];
							         $prod[$num]['golfer_num']        = $p['golfer_num'];
							         $prod[$num]['tee_date']        = $p['tee_date'];
							         $prod[$num]['tee_time']        = $p['tee_time'].' '.$p['tee_ap'];
							         $prod[$num]['carts']        = $p['carts'];
							         //$prod[$num]['range_ball']        = $p['range_ball'];
							         //$prod[$num]['shuttle']        = $p['shuttle'];
							         //$prod[$num]['rental_club'] = $p['rental_club'];
							         //$prod[$num]['net_rate'] = $p['net_rate'];
							         $prod[$num]['confirm_num'] = $p['confirm_num'];
							         $paidout = $p['paidout'] == 0 ? 'No' : 'Yes';
							         $prod[$num]['paidout'] = $paidout;
							         $num++;
						     	}
							}



					    }



					}

					$output = fopen("php://output",'w+') or die("Can't open php://output");

					header("Content-Type:application/csv");
					header("Content-Disposition:attachment;filename=course_report_$this->intYear.csv");

					fputcsv($output, array('id','course_name','group_name','golfer_num','tee_date','tee_time','carts','confirm_num','paidout'));
					foreach($prod as $product) {
					    fputcsv($output, $product);
					}
					fclose($output) or die("Can't close php://output");
					die();


		    	}

				break;

		    case 'hotel':

		    	$this->strTitle = ' Hotel Report';
		    	$this->arrTableSQLArray = array_merge($this->arrTableSQLArray,array('hotel_name','','action'));
				$this->arrTableDisplayArray = array_merge($this->arrTableDisplayArray,array('Hotel Name','Export Report','Actions'));
				$this->arrTableSortArray = array_merge($this->arrTableSortArray,array(true,false,false));
				$this->strAdminSlug .= '/0';				$checkaccess = $this->objModel->checkpageaccess($this->controller."_hotel", $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }

				//need a complete list of hotels
				//$this->objHotel = New Hotel('','');
				$this->arrDetails = $this->objModel->getHotelList('50000',$this->strPg,'hotel_name','ASC', $this->strSearchWord, $this->intYear,'Active', '', '', false);

		        $this->objModel->setRecords($this->objModel->records);
		        $this->blnShowFilters = true;
		        $this->blnShowMonthFilter = false;


		        $this->blnShowExport = true;

		    	if($this->strExport != '') {

		    		//first create the file
		    		$num = 0;
					//$sql = "SELECT id, name, description FROM products";
					if(count($this->arrDetails) > 0) {
					     foreach($this->arrDetails As $hotel) {

					     	$arrReportDetails = $this->objModel->getHotelReportDetails($hotel['id'],$this->intYear,false);

					     	if(count($arrReportDetails) > 0) {
					     		foreach($arrReportDetails As $p) {
                                    $prod[$num]['id']             = $p['id'];
                                    $prod[$num]['hotel_name']     = $hotel['hotel_name'];
                                    $prod[$num]['group_name']     = $p['group_name'];
                                    $prod[$num]['phone']          = $p['phone'];
                                    $prod[$num]['check_in_date']  = $p['check_in_date'];
                                    $prod[$num]['check_out_date'] = $p['check_out_date'];
                                    $prod[$num]['confirm_num']    = $p['confirm_num'];
                                    $prod[$num]['nights']         = $p['nights'];
                                    $prod[$num]['rooms']          = $p['rooms'];
                                    $prod[$num]['golfers']        = $p['golfers'];
                                    $prod[$num]['non_golfers']    = $p['non_golfers'];
                                    $prod[$num]['paidout']        = $p['paidout'] == 0 ? 'No' : 'Yes';

                                    $prod[$num]['order_date']     = $p['order_date'];
                                    $prod[$num]['dates_booking']  = $p['dates_booking'];
                                    $prod[$num]['sell_value']     = $p['sell_value'];
                                    $prod[$num]['repeat']         = $p['repeat'] == 0 ? 'No' : 'Yes';
                                    $prod[$num]['business_name']  = $p['business_name'];
                                    $prod[$num]['booking_name']   = $p['booking_name'];

                                    $num++;
						     	}
							}



					    }



					}

					$output = fopen("php://output",'w+') or die("Can't open php://output");

					header("Content-Type:application/csv");
					header("Content-Disposition:attachment;filename=hotel_report_$this->intYear.csv");

					fputcsv($output, array('id','hotel_name','group_name','phone','check_in_date','check_out_date','confirm_num','nights','rooms','golfers','non_golfers','paidout','order_date','dates_booking','sell_value','repeat','business_name','booking_name'));
					if (!empty($prod)) {
                        foreach($prod as $product) {
    					    fputcsv($output, $product);
    					}
                    }
					fclose($output) or die("Can't close php://output");
					die();


		    	}




		        break;
		    case 'hotel_detail':

		    	//Process Private Notes Update
		    	$objPackageHotel = new Packagehotels;

		    	if (isset($_REQUEST['private_notes'])) {
		    		foreach ($_REQUEST['private_notes'] as $key=>$value) {
		    			$arrKeys = array('room_notes');
		    			$arrVals = array($value);

		    			$objPackageHotel->mysqliupdate('package_hotel',$arrKeys, $arrVals, '', $key);
		    		}
		    	}

		    	$this->strTitle = ' Hotel Detail Report';
		    	$this->intHotelId = isset($_REQUEST['id']) ? $_REQUEST['id'] : '';
		    	$this->strAdminSlug .= '/'. $this->intHotelId;
		    	
		    	

		    	$this->arrTableSQLArray = array_merge($this->arrTableSQLArray,array('','','','','','','','','','','','action'));
				$this->arrTableDisplayArray = array_merge($this->arrTableDisplayArray,array('Payment','Group Name',
					'Check In','Check Out','# Night','# Rooms','# Golfers','# Non Golfers',
					'Public Cost','Private cost','Confirmation Number','Private Notes','Paid Out'));
				$this->arrTableSortArray = array_merge($this->arrTableSortArray,array(true,false,false,false,false,false,false,false,false,false,false,false,false));
				$this->arrDetails = $this->objModel->getHotelReportDetails($this->intHotelId,$this->intYear,false);

		        if($this->strExport != '') {
		    		$num = 0;
		    		if(count($this->arrDetails) > 0) {
					     foreach($this->arrDetails As $p) {

					         $prod[$num]['group_name']        = $p['group_name'];
					         $prod[$num]['phone']        = $p['phone'];

					         $prod[$num]['cell_phone']        = $p['cell_phone'];
					         $prod[$num]['state']        = $p['state'];
					         $prod[$num]['country']        = $p['country'];

					         $prod[$num]['check_in_date']        = $p['check_in_date'];
					         $prod[$num]['check_out_date']        = $p['check_out_date'];
					         $prod[$num]['nights']        = $p['nights'];
					         $prod[$num]['rooms']        = $p['rooms'];
					         $prod[$num]['golfers']        = $p['golfers'];
					         $prod[$num]['public_hotel_cost']        = $p['public_hotel_grand_total'];
					         $prod[$num]['public_summary']        = $p['public_summary'];
							 $prod[$num]['private_hotel_cost']        = $p['private_hotel_grand_total'];
					         $prod[$num]['private_summary']        = $p['private_summary'];
					         $prod[$num]['confirm_num']        = $p['confirm_num'];
					         $prod[$num]['paidout'] = $p['paidout'];

					         $num++;
					    }
						$output = fopen("php://output",'w+') or die("Can't open php://output");

						header("Content-Type:application/csv");
						header("Content-Disposition:attachment;filename=hotel_report_$this->intHotelId.csv");

						fputcsv($output, array('group_name','phone','cell_phone','state','country','check_in_date','check_out_date','nights','rooms','golfers','public_hotel_cost','public_summary','private_hotel_cost','private_summary','confirm_num','paidout'));
						foreach($prod as $product) {
						    fputcsv($output, $product);
						}
						fclose($output) or die("Can't close php://output");
						die();
					}
		    	}


				break;

			case 'hotel_detail_range':
				$this->strTitle = ' Hotel Detail Range Report';

                $this->blnShowFilters = true;
                $this->blnShowRangeFilter = true;
                $this->blnShowAgencyFilter = true;
                $this->blnShowExport = false;
                $this->blnShowMonthFilter = false;

                $this->blnShowPagination = false;

                $objGroup = new Group;
                $this->arrAgency = $objGroup->getAgencyAll();
                $this->arrAgent  = $objGroup->getAgentAll();
                $checkaccess = $this->objModel->checkpageaccess($this->controller."_hotel_detail_range", $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }

		        $this->arrTableSQLArray = array('hotel_name');
				$this->arrTableDisplayArray = array('Hotel Name');
				$this->arrTableSortArray = array(false);

				$this->arrDetailTableSQLArray = array('','','','','','','','','action');
				$this->arrDetailTableDisplayArray = array('Group Name',
					'Check In','Check Out','# Night','# Rooms','# Golfers','# Non Golfers',
					'Confirmation Number','Paid Out');
				$this->arrDetailTableSortArray = array(false,false,false,false,false,false,false,false,false);

				$this->strAdminSlug .= '/0';
				//$this->strOptions .= "&year=".$this->intYear;

				//need a complete list of courses
				//$this->objCourse = New Course('','');


				// default date filters if they are empty to show last month
				if(empty($this->strStartDate)){
					$this->strStartDate = date('Y-m-d', strtotime('last month'));
				}

				if(empty($this->strEndDate)){
					$this->strEndDate = date('Y-m-d');
				}

				$this->arrDetails = $this->objModel->getHotelDetailRangeList('50000',$this->strPg,'hotel_name','ASC',
					$this->strSearchWord, $this->strStartDate, $this->strEndDate,'Active', '', '', false);

				$this->objModel->setRecords($this->objModel->records);
				$this->blnShowFilters = true;
				$this->blnShowMonthFilter = false;

				// get the detail records for each course
				if(!empty($this->arrDetails)){
					foreach($this->arrDetails as $i => $arrCourse){
                        $arrDetailRecords = $this->objModel->getHotelDetailRangeChildren($arrCourse['id'], $this->strStartDate, $this->strEndDate);
                        if (!empty($arrDetailRecords)) {
						  $this->arrDetails[$i]['detail_records'] = $arrDetailRecords;
                        } else {
                            unset($this->arrDetails[$i]);
                        }
					}
				}

				$this->blnShowExport = true;

		    	if($this->strExport != '') {

		    		//first create the file
		    		$num = 0;
					//$sql = "SELECT id, name, description FROM products";
					if(count($this->arrDetails) > 0) {
					     foreach($this->arrDetails As $course) {

					     	$arrReportDetails = $this->objModel->getCourseReportDetails($course['id'],$this->strStartDate,$this->strEndDate,false);
					     	if(count($arrReportDetails) > 0) {

					     		foreach($arrReportDetails As $p) {
							         $prod[$num]['id']          = $p['id'];
							         $prod[$num]['course_name']        = $course['course_name'];
							         $prod[$num]['group_name']        = $p['group_name'];
							         $prod[$num]['golfer_num']        = $p['golfer_num'];
							         $prod[$num]['tee_date']        = $p['tee_date'];
							         $prod[$num]['tee_time']        = $p['tee_time'].' '.$p['tee_ap'];
							         $prod[$num]['carts']        = $p['carts'];
							         $prod[$num]['range_ball']        = $p['range_ball'];
							         $prod[$num]['shuttle']        = $p['shuttle'];
							         $prod[$num]['rental_club'] = $p['rental_club'];
							         $prod[$num]['net_rate'] = $p['net_rate'];
							         $prod[$num]['confirm_num'] = $p['confirm_num'];
							         $paidout = $p['paidout'] == 0 ? 'No' : 'Yes';
							         $prod[$num]['paidout'] = $paidout;
							         $num++;
						     	}
							}



					    }



					}

					$output = fopen("php://output",'w+') or die("Can't open php://output");

					header("Content-Type:application/csv");
					header("Content-Disposition:attachment;filename=course_report_$this->intYear.csv");

					fputcsv($output, array('id','course_name','group_name','golfer_num','tee_date','tee_time','carts','range_ball','shuttle','rental_club','net_rate','confirm_num','paidout'));
					foreach($prod as $product) {
					    fputcsv($output, $product);
					}
					fclose($output) or die("Can't close php://output");
					die();


		    	}

				break;

			case 'cc_decrypt':

				$this->strTitle = 'Decrypt CC Number';
				$this->blnShowFilters = false;
				$this->blnShowSearch = false;
    
                $checkaccess = $this->objModel->checkpageaccess("report_".$this->controller, $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }
                
				$this->strEncrypted = isset($_REQUEST['encrypted']) ? $_REQUEST['encrypted'] : '';
				$this->strKey = isset($_REQUEST['key']) ? $_REQUEST['key'] : '';

				if($this->strKey != '' && $this->strEncrypted != ''){
					$this->strSuccessMessage = $this->objModel->decryptCC($this->strEncrypted, $this->strKey);
				}

				break;
		    case 'payment':

		    	$this->strTitle = ' Payment Report';
		    	$this->strAdminSlug .= '/0';
		    	$this->arrTableSQLArray = array_merge($this->arrTableSQLArray,array('group_name','','locations','','','','','','','','action'));
				$this->arrTableDisplayArray = array_merge($this->arrTableDisplayArray,array('Group Name','Arrival Date','Locations','# Golfers','# Rooms','#Nights','Paid','Invoice','Notes','Paid','Actions'));
				$this->arrTableSortArray = array_merge($this->arrTableSortArray,array(true,false,false,false,false,false,false,false,false,false,false));
				
				$checkaccess = $this->objModel->adminpageaccess("report_".$this->controller, $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }
				$this->arrDetails = $this->objModel->getPaymentReport($this->strPgSize,$this->strPg,
					$this->strSortBy,$this->strSortOrder,$this->strSearchWord,$this->strFilterType,$this->intMonth,$this->intYear,false);

				$this->arrFilter = array('Paid'=>1,'Unpaid'=>2,"Both"=>3);
				//$this->objModel->setFilterType($this->strFilterType);


		        break;

		    case 'payment_golf':

		    	$this->strTitle = 'Make Payment to Golf Course';
		    	$this->blnShowFilters = false;
		    	$this->strAdminSlug .= '/0';
		    	
		    	$checkaccess = $this->objModel->checkpageaccess($this->controller."_payment_golf", $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }

		    	// need a complete list of brands
		    	$this->objBrand = new Brand();
		    	$this->arrBrands = $this->objBrand->getList(-1,$this->strPg,$this->strSortBy,$this->strSortOrder,$this->strSearchWord, 'Active', '', '', false);

		    	//need a complete list of courses
				$this->objCourse = New Course('','');
				$this->arrCourses = array();
		    	if($this->strSubmit != "") {
		    		$this->objModel->makeGolfPayment($this->objCourse,$this->intBrandId,$this->intCourseId,$this->strContent,$this->strSendDate);
		    		$this->strErrorMessage = $this->objModel->strErrorMessage;
		    		$this->strSuccessMessage = $this->objModel->strSuccessMessage;
		    	} else {

		    		$this->strContent = $this->getDefaultContent();

				}

		    	break;

		    case 'paypal':

		    	$this->strTitle = 'Transaction Details';
		    	$this->blnShowFilters = false;
		    	$this->strAdminSlug .= '/0';

		    	$arrConditions = array();
		    	
		    	$checkaccess = $this->objModel->checkpageaccess($this->controller."_paypal", $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }

		    	// check for date filters
		    	if(isset($_REQUEST['start_date']) && !empty($_REQUEST['start_date'])){
		    		$arrConditions[] = "transaction_date >= '" . $_REQUEST['start_date'] . " 00:00:00'";
		    	}

		    	if(isset($_REQUEST['end_date']) && !empty($_REQUEST['end_date'])){
		    		$arrConditions[] = "transaction_date <= '" . $_REQUEST['end_date'] . " 24:59:59'";
		    	}

		    	include(ROOT_DIR.'/application/models/transaction.php');
				$this->objModel = New Transaction();
				$this->arrDetails = $this->objModel->getList($this->strPgSize,$this->strPg,$this->strSortBy,$this->strSortOrder,$this->strSearchWord, 'Active', '', '', false, $arrConditions);

				$this->arrTableSQLArray = array('','group_name','last_name','package_id','transaction_id','receipt_id','transaction_date','amount','fee','gross','currency','notes','rec_date','');
				$this->arrTableDisplayArray = array('','Group Name','User Name','Package ID','Transaction ID','Receipt ID','Order Date','Amount','Fee','Net','Currency','Notes','Reconciled Date','Actions');
				$this->arrTableSortArray = array(false,true,true,true,true,true,true,true,true,true,false,true,false,false);

		    	break;
		    case 'paypal-detail':

		    	$this->strTitle = 'Paypal Report';
		    	$this->blnShowFilters = false;
		    	$this->blnShowSearch = false;

		    	$this->intPaypalId = isset($_REQUEST['id']) ? $_REQUEST['id'] : '';
		    	$this->strNotes = isset($_REQUEST['notes']) ? $_REQUEST['notes'] : '';
		    	$this->strFee = isset($_REQUEST['fee']) ? $_REQUEST['fee'] : '0';
		    	$this->strGross = isset($_REQUEST['gross']) ? $_REQUEST['gross'] : '0';
		    	$this->strReconciled = isset($_REQUEST['reconciled']) ? $_REQUEST['reconciled'] : '0';
		    	$this->strRecDate = isset($_REQUEST['rec_date']) ? $_REQUEST['rec_date'] : Date('Y-m-d H:i:s');

		    	if($this->strSubmit != "") {
		    		$this->objModel->updatePaypal($this->intPaypalId,$this->strNotes,$this->strFee,
		    			$this->strGross,$this->strReconciled,$this->strRecDate, false);
		    		$this->strErrorMessage = $this->objModel->strErrorMessage;
		    		$this->strSuccessMessage = $this->objModel->strSuccessMessage;
		    	}
				$this->arrDetails = $this->objModel->getPaypalReportDetails($this->intPaypalId,false);

		    	break;
            case 'paypal-receipt':

                $this->strTitle = 'Paypal Transaction Receipt';

                $this->intPaypalId = isset($_REQUEST['id']) ? $_REQUEST['id'] : '';
                $this->strNotes = isset($_REQUEST['notes']) ? $_REQUEST['notes'] : '';
                $this->strFee = isset($_REQUEST['fee']) ? $_REQUEST['fee'] : '0';
                $this->strGross = isset($_REQUEST['gross']) ? $_REQUEST['gross'] : '0';
                $this->strReconciled = isset($_REQUEST['reconciled']) ? $_REQUEST['reconciled'] : '0';
                $this->strRecDate = isset($_REQUEST['rec_date']) ? $_REQUEST['rec_date'] : Date('Y-m-d H:i:s');

                $this->arrDetails = $this->objModel->getPaypalReportDetails($this->intPaypalId,false);

                break;
		    case 'payment_hotel':

		    	$this->strTitle = 'Make Payment to Hotel';
		    	$this->blnShowFilters = false;
		    	
		    	$checkaccess = $this->objModel->checkpageaccess($this->controller."_payment_hotel", $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }

		    	// need a complete list of brands
		    	$this->objBrand = new Brand();
		    	$this->arrBrands = $this->objBrand->getList(-1,$this->strPg,$this->strSortBy,$this->strSortOrder,$this->strSearchWord, 'Active', '', '', false);

		    	//need a complete list of hotels
				$this->objHotel = New Hotel('','');
				$this->arrHotels = array();

				if($this->strSubmit != "") {
		    		$this->objModel->makeHotelPayment($this->objHotel,$this->intBrandId,$this->intHotelId,$this->strContent,$this->strSendDate);
		    		$this->strErrorMessage = $this->objModel->strErrorMessage;
		    		$this->strSuccessMessage = $this->objModel->strSuccessMessage;
		    	} else {
					$this->strContent = $this->getDefaultContent();
				}

		    	break;

		    case 'package':

		    	$this->strTitle = 'Golf Package Report';
		    	$this->blnShowFilters = true;
                $this->blnShowRangeFilter = true;
                $this->blnShowAgencyFilter = true;
                
                $checkaccess = $this->objModel->adminpageaccess("report_".$this->controller, $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }

                $objGroup = new Group;
                $this->arrAgency = $objGroup->getAgencyAll();
                $this->arrAgent  = $objGroup->getAgentAll();

		    	$this->strAdminSlug .= '/0';
		    	//$this->objPackage = New Package('','');

		    	//$this->arrTableSQLArray = array('','group_name','order_date','dates_booking','check_in_date','blnRepeat','business_name','booking_name','hotel_name','players_num','rounds_num','rooms','','','','','');
				//$this->arrTableDisplayArray = array('','Group Name','Order Date','Booking Date','Arrival Date','Repeat Client','WL','Booking Person','Hotel','# People','Rounds','Rooms','Sell Value','Cost','Margin','PPM','Actions');

		    	$this->arrTableSQLArray = array('','group_name','order_date','dates_booking','check_in_date','blnRepeat','business_name','booking_name','course_private_cost','hotel_private_cost','package_total_cost','sell_value','profit','profit_margin','');
				$this->arrTableDisplayArray = array('','Group Name','Order Date','Booking Date','Arrival Date','Repeat Client','WL','Booking Person','Course Total','Hotel Total','Package Total','Sell Value','Profit','Margin','Actions');

				$this->arrTableSortArray = array(false,true,true,true,true,true,true,true,false,false,false,true,false,false,false);

				$this->strSortBy = ($this->strSortBy != '' ? $this->strSortBy : 'order_date');
				$this->strSortOrder = ($this->strSortOrder != '' ? $this->strSortOrder : 'DESC');

				$this->blnShowExport = true;

                $arrRange = array(
                    'grid_date' => $_REQUEST['grid_date'],
                    'start_date' => $_REQUEST['start_date'],
                    'end_date' => $_REQUEST['end_date'],
                );

                $arrAgent = array(
                    'agency' => $this->strGridAgency,
                    'agent' => $this->strGridAgent,
                );

		    	if($this->strExport != '') {

		    		//Perform the query without pagincation
		    		//$this->arrPackages = $this->objModel->getPackageList(-1,-1,$this->strSortBy,$this->strSortOrder,$this->strSearchWord, 'Active', $this->intYear,$this->intMonth,false);

                    $this->arrPackages = $this->objModel->getPackageList(-1,-1,$this->strSortBy,$this->strSortOrder,$this->strSearchWord, 'Active', $this->intYear,$this->intMonth,$arrRange,$arrAgent,false);


		    		//first create the file
		    		$num = 0;
					//$sql = "SELECT id, name, description FROM products";
					if(count($this->arrPackages) > 0) {
					     foreach($this->arrPackages As $p) {
					         $prod[$num]['id']          = $p['id'];
					         $prod[$num]['group_name']        = $p['group_name'];
					         $prod[$num]['phone']        = $p['phone'];

					         $prod[$num]['cell_phone']        = $p['cell_phone'];
					         $prod[$num]['city']        = $p['city'];
                             $prod[$num]['state']        = $p['state'];
					         $prod[$num]['country']        = $p['country'];
					         $prod[$num]['user_email']        = $p['user_email'];
					         $prod[$num]['golfer_count']        = $p['golfer_count'];
					         $prod[$num]['where_did_you_hear']        = $p['where_did_you_hear'];
					         $prod[$num]['on_trip_comments']        = $p['on_trip_comments'];

					         $prod[$num]['order_date']        = $p['order_date'];
					         $prod[$num]['dates_booking']        = $p['dates_booking'];
					         $prod[$num]['check_in_date']        = $p['check_in_date'];
					         $prod[$num]['blnRepeat']        = $p['blnRepeat'];
					         $prod[$num]['business_name']        = $p['business_name'];
					         $prod[$num]['booking_name']        = $p['booking_name'];
					         //$prod[$num]['hotel_name']        = $p['hotel_name'];
					         $prod[$num]['course_private_cost']        = $p['course_private_cost'];
					         $prod[$num]['hotel_private_cost']        = $p['hotel_private_cost'];
					         $prod[$num]['package_total_cost']        = $p['package_total_cost'];
					         $prod[$num]['sell_value']        = $p['sell_value'];
					         $prod[$num]['profit']        = $p['profit'];
					         $prod[$num]['profit_margin']        = $p['profit_margin'];

                             $prod[$num]['hotel_details'] = $p['hotel_details'];
                             $prod[$num]['course_details'] = $p['course_details'];
					         //$prod[$num]['players_num']        = $p['players_num'];
					         //$prod[$num]['rounds_num'] = $p['rounds_num'];
					         //$prod[$num]['rooms'] = $p['rooms'];
					         $num++;
					    }
					}

					$output = fopen("php://output",'w+') or die("Can't open php://output");

					header("Content-Type:application/csv");
					header("Content-Disposition:attachment;filename=temp.csv");

					fputcsv($output, array('id','group_name','phone','cell_phone','city','state','country','user_email','golfer_count','where_did_you_hear','on_trip_comments','order_date','dates_booking','check_in_date','blnRepeat','business_name','booking_name','course_private_cost','hotel_private_cost','package_total_cost','sell_value','proft','profit_margin','hotel_details','course_details'));
					foreach($prod as $product) {
					    fputcsv($output, $product);
					}
					fclose($output) or die("Can't close php://output");
					die();


		    	} else { // Perform the query with paginiation

		    		//$this->arrPackages = $this->objModel->getPackageList($this->strPgSize,$this->strPg,$this->strSortBy,$this->strSortOrder,$this->strSearchWord, 'Active', $this->intYear,$this->intMonth,false);
                    $this->arrPackages = $this->objModel->getPackageList($this->strPgSize,$this->strPg,$this->strSortBy,$this->strSortOrder,$this->strSearchWord, 'Active', $this->intYear,$this->intMonth,$arrRange, $arrAgent,false);

		    	}







		    	break;

		}




	}


	/**
	 * Function that sets our Model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New Report();

	}

	public function doActions() {


	}



	/**
	 * Note title
	 * Note description
	 */
	public function getPageContent() {
		if ($this->strView == 'paypal-receipt' || $this->strView == 'payment_golf' || $this->strView == 'payment_hotel' || $this->strView == 'course_detail_range' || $this->strView == 'hotel_detail_range') {
			// If the action is empty get the list view
			include(ROOT_DIR.'/application/views/admin/reports/'.$this->strView.'.php');
		} else {
			// If the action is set get the edit / add form
			include(ROOT_DIR.'/application/views/admin/report_list_view.php');
		}
	}





	/**
	 * Function that creates the list of actions the user can do to the record
	 * Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true) {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
		$html .= '<li><a href="'.$this->strAdminSlug.'_detail/' . $id . '/?s=true' . $this->strOptions . '">Edit</a></li>';
		$html .= '</ul>';

		return $html;
	}


	public function getPageGridControls($id, $slug, $year='', $fa_icon='fa fa-pencil fa-lg',$target="") {

		$html = '<a target="'.$target.'" href="'.$slug.''.$id.'/?s=true'.$this->strOptions.'&year='.$year.'"><i class="'.$fa_icon.'"></i></a>';

		return $html;
	}


	public function getDefaultContent() {

		return "<center><H1>CREDIT CARD AUTHORIZATION FORM</H1></center>
<h2>[item_name]</h2>
<h3>
I authorize the following to be incurred by/for the guests…

Date to be processed: ".$this->strSendDate."

Charges of $ as per the latest statement

Please email a receipt to ross@bcgolfguide.com

Name on Card -  John Ross Marrington
Visa#        -
Exp          -
CVV          -

<b>
BCgolfguide.com Inc.
Tel 250-764-0700 - fax 250-800-0912 Toll - 1-877-223-7226
Member of IAGTO, IATA, ACTA & Consumer Protection Authority BC
http://www.facebook.com/golftrip
http://www.twitter.com/bcgolfguide
</b>
</h3>";


	}



}



?>