<?php


class region_controller extends default_controller {

	public function __construct($strPageId) {

		$this->strSortBy = 'display_order';
		$this->strSortOrder = 'ASC';
		
		$this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];


		parent::__construct($strPageId);

		$this->strTableName = 'region';
		$this->strAdminSlug = '/admin/region/';
		$this->tab = isset($_REQUEST['tab']) ? $_REQUEST['tab'] : '';

		$this->arrTableSQLArray = array('','display_order','region_name','state_name','country_name','score_seo');
		$this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">','Order','Region Name','State','Country','SEO Score');
		$this->arrTableSortArray = array(false,true,true,true,true,true);

		$this->strOptions = '?searchWord='.$this->strSearchWord . '&amp;status='.$this->strStatus;

		$this->arrStates = $this->objModel->getStates();
		$this->arrCountrys = $this->objModel->getCountrys();


		if(!isset($this->page['id'])) {
			$this->page['country_id'] = 261;
			$this->page['state_id'] = 2;
			$this->arrImages = Null;
			$this->page['slug'] = '/region/';

		} else {
			$this->arrImages = $this->objModel->getRegionImageList($this->page['id']);
			$this->page['slug'] = '/region/'.$this->page['slug'];
		}




		if($this->strAction == '') {
			$this->strView =   'list_regions';
		} else {
			$this->strView =   'region_form';
			$this->arrCourses = $this->objModel->getCourses($this->intID);
			$this->arrHotels = $this->objModel->getHotels($this->intID);
		}


	}


	/**
	 * Function that sets our Model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New Region($strPageId, $strAction);

	}

	/**
	 * Function that creates the list of actions the user can do to the record
	 * Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true) {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
		if ($status == 'Trash') {
			$html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/' . $this->strOptions . '">Restore</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
		} else {
		    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
			$html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/' . $this->strOptions . '">Edit</a></li>';
			}
			if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
			    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
			}
		}
		$html .= '</ul>';

		return $html;
	}

	/**
	 * Note title
	 * Note description
	 */
	public function getPageContent() {
		if (empty($this->strAction)) {
			// If the action is empty get the list view, in it we use the $this->strView property
			include(ROOT_DIR.'/application/views/admin/default_list_view.php');
		} else {
			// If the action is set get the edit / add form
			include(ROOT_DIR.'/application/views/admin/detail/'.$this->strView.'.php');
		}
	}

}



?>