<?php

class rates_controller{
	public $strErrorMessage = '';
    public $strSuccessMessage = '';

    public $strTitle = '';
    public $strContent = '';
    public $strTableName = 'pages';
    public $strTableSlug = 'pages';
    public $objModel = null;
    public $strView = '';

    public $strPg = '1';
    public $strPgSize = '50';
    public $strSortBy = 'id';
    public $strSortOrder = 'ASC';
    public $strSearchWord = '';
    public $strStatus = 'Active';

	public function __construct($strPageId){
		$strAction = 'dashboard';
		
// 		print_r($_REQUEST);die();

		if(isset($_REQUEST['action']) && !empty($_REQUEST['action'])){
			$strAction = $_REQUEST['action'];
		}

		switch(strtolower($strAction)){
			case 'dashboard':
			    $objRate = new Rate;
			    $checkaccess = $objRate->checkpageaccess("rates", $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }
				static::pageDashboard();
				die();
				break;

			case 'course':
			    $objRate = new Rate;
			    $checkaccess = $objRate->checkpageaccess("rate_course", $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }
				if(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'new'){
				    $checkaccess = $objRate->checkpageaccess("rate_course", 'add');
                    if(!$checkaccess){
                        header("Location: /admin");
                    }
					static::pageCourseRateSingleNew((int)$_REQUEST['id'], (int)$_REQUEST['rate_id']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'delete'){
					static::deleteCourseRate((int)$_REQUEST['id'], (int)$_REQUEST['rate_id']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'duplicate'){
					static::duplicateCourseRate((int)$_REQUEST['id'], (int)$_REQUEST['rate_id']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'ajax_searchtype'){
					static::ajax_searchCourses($_REQUEST['s']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'ajax_gettype'){
					static::ajax_getCourseType($_REQUEST['type_id']);
					die();
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'ajax_search'){
					static::ajax_searchCourseRate((int)$_REQUEST['id'], $_REQUEST['s']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'ajax_children'){
					static::ajax_getCourseChildren((int)$_REQUEST['id'], $_REQUEST['rate_id']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'ajax_getrate'){
					static::ajax_getCourseRate((int)$_REQUEST['id'], $_REQUEST['rate_id']);
					die();
				}elseif(isset($_REQUEST['rate_id']) && !empty($_REQUEST['rate_id'])){
				    $checkaccess = $objRate->checkpageaccess("rate_course", 'edit');
                    if(!$checkaccess){
                        header("Location: /admin");
                    }
					static::pageCourseRateSingle((int)$_REQUEST['rate_id']);
					die();
					break;
				}elseif(isset($_REQUEST['id']) && !empty($_REQUEST['id'])){
					static::pageCourseSingle((int)$_REQUEST['id']);
					die();
					break;
				}

				static::pageCourseList();
				die();
				break;	;

			case 'hotel':
			    $objRate = new Rate;
			    $checkaccess = $objRate->checkpageaccess("rate_hotel", $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }
				if(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'new'){
				    $checkaccess = $objRate->checkpageaccess("rate_hotel", 'add');
                    if(!$checkaccess){
                        header("Location: /admin");
                    }
					static::pageHotelRateSingleNew((int)$_REQUEST['id'], (int)$_REQUEST['rate_id']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'delete'){
					static::deleteHotelRate((int)$_REQUEST['id'], (int)$_REQUEST['rate_id']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'duplicate'){
					static::duplicateHotelRate((int)$_REQUEST['id'], (int)$_REQUEST['rate_id']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'ajax_searchtype'){
					static::ajax_searchHotels($_REQUEST['s']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'ajax_gettype'){
					static::ajax_getHotelType($_REQUEST['type_id']);
					die();
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'ajax_search'){
					static::ajax_searchHotelRate((int)$_REQUEST['id'], $_REQUEST['s']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'ajax_children'){
					static::ajax_getHotelChildren((int)$_REQUEST['id'], $_REQUEST['rate_id']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'ajax_getrate'){
					static::ajax_getHotelRate((int)$_REQUEST['id'], $_REQUEST['rate_id']);
					die();
				}elseif(isset($_REQUEST['rate_id']) && !empty($_REQUEST['rate_id'])){
				    $checkaccess = $objRate->checkpageaccess("rate_hotel", 'edit');
                    if(!$checkaccess){
                        header("Location: /admin");
                    }
					static::pageHotelRateSingle((int)$_REQUEST['rate_id']);
					die();
					break;
				}elseif(isset($_REQUEST['id']) && !empty($_REQUEST['id'])){
					static::pageHotelSingle((int)$_REQUEST['id']);
					die();
					break;
				}

				static::pageHotelList();
				die();
				break;

			case 'detail_types':
				if(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'new'){
					static::pageDetailTypeSingleNew((int)$_REQUEST['id']);
					die();
					break;
				}elseif(isset($_REQUEST['subaction']) && !empty($_REQUEST['subaction']) && strtolower($_REQUEST['subaction']) == 'delete'){
					static::deleteDetailType((int)$_REQUEST['id']);
					die();
					break;
				}elseif(isset($_REQUEST['id']) && !empty($_REQUEST['id'])){
					static::pageDetailTypeSingle((int)$_REQUEST['id']);
					die();
					break;
				}

				static::pageDetailTypes();
				die();
				break;

            case 'calculator':
                $objRate = new Rate;
			    $checkaccess = $objRate->checkpageaccess("rates_calculator", $this->module);
                if(!$checkaccess){
                    header("Location: /admin");
                }

                static::pageCalculator();
                die();
                break;

			default:
				static::pageDashboard();
				die();
				break;
		}
	}

	public static function pageDashboard(){
		$objSettings = new Settings;
		$strController = 'rates_controller';

		$arrHotelNoRateOptions = array(
			'min_start_date' => date('Y', time()) . '-01-01', // start of year
			'max_start_date' => date('Y') . '-12-31', // end of year
			'min_end_date' => date('Y') . '-01-01', // start of year
			'max_end_date' => date('Y') . '-12-31', // end of year
			'limit' => 10
		);

		$arrHotelsNoRates = Rate::getHotelsNoRatesInRange($arrHotelNoRateOptions);

		$arrCourseNoRateOptions = array(
			'min_start_date' => date('Y', time()) . '-01-01', // start of year
			'max_start_date' => date('Y') . '-12-31', // end of year
			'min_end_date' => date('Y') . '-01-01', // start of year
			'max_end_date' => date('Y') . '-12-31', // end of year
			'limit' => 10
		);

		$arrCoursesNoRates = Rate::getCoursesNoRatesInRange($arrCourseNoRateOptions);

		// load view
		include(ROOT_DIR . '/application/views/admin/rates/dashboard.php');
		die();
	}

	public static function pageDetailTypes(){
		$objSettings = new Settings;
		$strController = 'rates_controller';
		$objMessage = array();

		if(isset($_REQUEST['message']) && !empty($_REQUEST['message'])){
			$objMessage = json_decode(urldecode($_REQUEST['message']), true);
		}

		$arrHotelOptions = array(
			'type' => 'hotel'
		);

		$arrCourseOptions = array(
			'type' => 'course'
		);

		// deal with filters
		$strFilter['name'] = null;
		if(isset($_REQUEST['name']) && !empty($_REQUEST['name'])){
			$strFilter['name'] = $_REQUEST['name'];
			$arrHotelOptions['name'] = $_REQUEST['name'];
			$arrCourseOptions['name'] = $_REQUEST['name'];
		}

		$arrDetailHotels = Rate::getHotelDetailTypes($arrHotelOptions);

		$arrDetailCourses = Rate::getHotelDetailTypes($arrCourseOptions);

		// load view
		include(ROOT_DIR . '/application/views/admin/rates/detail_types.php');
		die();
	}

	public static function pageDetailTypeSingle($intDetailId){
		$objSettings = new Settings;
		$strController = 'rates_controller';
		$blnNew = false;
		$objMessage = array();

		if(isset($_REQUEST['message']) && !empty($_REQUEST['message'])){
			$objMessage = json_decode(urldecode($_REQUEST['message']), true);
		}

		if(isset($_POST['detail_type']) && !empty($_POST['detail_type'])){
			// update detail_type
			$intReturnedDetailTypeId = Rate::updateDetailType($_POST['detail_type']);

			if($intReturnedDetailTypeId){
				$intRateId = $intReturnedDetailTypeId;
				$objMessage = array(
					'blnError' => false,
					'arrMessages' => array(
						'<strong>' . $_POST['detail_type']['name'] . ' was successfully updated.</strong>'
					)
				);
			}else{
				$objMessage = array(
					'blnError' => true,
					'arrMessages' => array(
						'<strong>' . $_POST['detail_type']['name'] . ' could not be updated.</strong> Please try again.'
					)
				);
			}
		}

		$arrDetailType = Rate::getDetailTypeById($intDetailId);

		// load view
		include(ROOT_DIR . '/application/views/admin/rates/detail_type_single.php');
		die();
	}

	public static function pageDetailTypeSingleNew(){
		$objSettings = new Settings;
		$strController = 'rates_controller';
		$blnNew = false;
		$objMessage = array();

		if(isset($_REQUEST['message']) && !empty($_REQUEST['message'])){
			$objMessage = json_decode(urldecode($_REQUEST['message']), true);
		}

		$arrDetailType = array(
			'id' => null,
			'name' => null,
			'description' => null,
			'type' => 'hotel',
			'rating' => null
		);

		if(isset($_POST['detail_type']) && !empty($_POST['detail_type'])){
			// update detail_type
			$intReturnedDetailTypeId = Rate::insertDetailType($_POST['detail_type']);

			if($intReturnedDetailTypeId){
				$objMessage = array(
					'blnError' => false,
					'arrMessages' => array(
						'<strong>' . $_POST['detail_type']['name'] . ' was successfully created.</strong>'
					)
				);

				header('Location: ' . ROOT_URL . '/admin/rates/detail_types/' . $intReturnedDetailTypeId . '?message=' . urlencode(json_encode($objMessage)));
				die();
			}else{
				$objMessage = array(
					'blnError' => true,
					'arrMessages' => array(
						'<strong>' . $_POST['detail_type']['name'] . ' could not be created.</strong> Please try again.'
					)
				);

				$arrDetailType = $_POST['detail_type'];
			}
		}

		if(isset($_REQUEST['type']) || !empty($_REQUEST['type'])){
			$arrDetailType['type'] = $_REQUEST['type'];
		}

		// load view
		include(ROOT_DIR . '/application/views/admin/rates/detail_type_single.php');
		die();
	}

	public static function deleteDetailType($intDetailId){
		if(empty($intDetailId)){
			// no rate to delete
			echo '<strong>No detail type passed in.</strong>';
		}

		$arrDetailType = Rate::getDetailTypeById($intDetailId);
		$blnDeleted = Rate::deleteDetailTypeById($intDetailId);

		if(!$blnDeleted){
			// error occured
			$objMessage = array(
				'blnError' => true,
				'arrMessages' => array(
					'<strong>Detail Type could not be deleted.</strong> Please try again.'
				)
			);

			// redirect to detail type page
			header('Location: ' . ROOT_URL . '/admin/rates/detail_types/' . $intDetailId . '?message=' . urlencode(json_encode($objMessage)));
			die();
		}

		// success
		$objMessage = array(
			'blnError' => false,
			'arrMessages' => array(
				'<strong>' . (!empty($arrDetailType['name']) ? $arrDetailType['name'] : ('#' . $arrDetailType['id'])) . ' was successfully deleted.</strong>'
			)
		);

		// redirect to detail type hotel page
		header('Location: ' . ROOT_URL . '/admin/rates/detail_types/?message=' . urlencode(json_encode($objMessage)));
		die();
	}

	public static function pageHotelList(){
		$objSettings = new Settings;
		$strController = 'rates_controller';

		$arrHotelNoRateOptions = array(
			'min_start_date' => date('Y', time()) . '-01-01', // start of year
			'max_start_date' => date('Y') . '-12-31', // end of year
			'min_end_date' => date('Y') . '-01-01', // start of year
			'max_end_date' => date('Y') . '-12-31', // end of year
		);

		$arrHotelRateOptions = array();

		$strFilter['name'] = null;
		if(isset($_REQUEST['name']) && !empty($_REQUEST['name'])){
			$strFilter['name'] = $_REQUEST['name'];
			$arrHotelNoRateOptions['hotel_name'] = $_REQUEST['name'];
			$arrHotelRateOptions['hotel_name'] = $_REQUEST['name'];
		}

		$arrHotelsNoRates = Rate::getHotelsNoRatesInRange($arrHotelNoRateOptions);

		$arrHotels = Rate::getHotelsWithRates($arrHotelRateOptions);

		// load view
		include(ROOT_DIR . '/application/views/admin/rates/hotel_list.php');
		die();
	}

	public static function pageHotelSingle($intHotelId){
		$objSettings = new Settings;
		$strController = 'rates_controller';
		$objMessage = array();

		$arrHotel = Rate::getHotelById($intHotelId);

		if(isset($_REQUEST['message']) && !empty($_REQUEST['message'])){
			$objMessage = json_decode(urldecode($_REQUEST['message']), true);
		}

		$arrQueryOptions = array(
			'hotel_id' => $intHotelId,
			'parent_id' => 'empty',
			'order_by' => 'start_date',
			'sort_order' => 'ASC'
		);

		if(isset($_REQUEST['order_by']) && !empty($_REQUEST['order_by'])){
			$arrQueryOptions['order_by'] = $_REQUEST['order_by'];
		}

		if(isset($_REQUEST['sort_order']) && !empty($_REQUEST['sort_order'])){
			$arrQueryOptions['sort_order'] = $_REQUEST['sort_order'];
		}

		if(isset($_REQUEST['name']) && !empty($_REQUEST['name'])){
			$arrQueryOptions['name'] = $_REQUEST['name'];
		}

		if(isset($_REQUEST['min_start_date']) && !empty($_REQUEST['min_start_date'])){
			$arrQueryOptions['min_start_date'] = $_REQUEST['min_start_date'];
		}

		if(isset($_REQUEST['max_start_date']) && !empty($_REQUEST['max_start_date'])){
			$arrQueryOptions['max_start_date'] = $_REQUEST['max_start_date'];
		}

		if(isset($_REQUEST['min_end_date']) && !empty($_REQUEST['min_end_date'])){
			$arrQueryOptions['min_end_date'] = $_REQUEST['min_end_date'];
		}

		if(isset($_REQUEST['max_start_date']) && !empty($_REQUEST['max_start_date'])){
			$arrQueryOptions['max_start_date'] = $_REQUEST['max_start_date'];
		}

		$arrRates = Rate::getHotelRates($arrQueryOptions);

		// setup columns for datagrid
		$arrColumns = array(
			array(
				'name' => 'name',
				'label' => 'Name',
				'sortable' => true
			),
			array(
				'name' => 'start_date',
				'label' => 'Start Date',
				'sortable' => true
			),
			array(
				'name' => 'end_date',
				'label' => 'End Date',
				'sortable' => true
			),
			array(
				'name' => 'price',
				'label' => 'Price',
				'sortable' => true
			),
            /*
			array(
				'name' => 'rack_rate',
				'label' => 'Rack Rate',
				'sortable' => true
			),
			array(
				'name' => 'room_type',
				'label' => 'Room Type',
				'sortable' => true
			),
			array(
				'name' => 'occupancy',
				'label' => 'occupancy',
				'sortable' => true
			),
			array(
				'name' => 'minimum_stay',
				'label' => 'Minimum Stay',
				'sortable' => true
			)
            */
		);

		// load view
		include(ROOT_DIR . '/application/views/admin/rates/hotel_single.php');
		die();
	}

	public static function pageHotelRateSingle($intRateId){
		$objSettings = new Settings;
		$strController = 'rates_controller';
		$objMessage = array();
		$blnNew = false;

		if(isset($_REQUEST['message']) && !empty($_REQUEST['message'])){
			$objMessage = json_decode(urldecode($_REQUEST['message']), true);
		}

		if(isset($_POST['rate']) && !empty($_POST['rate'])){
			// update rate
			$intReturnedRateId = Rate::updateHotelRate($_POST['rate']);

			// update all listed rates
			Rate::updateHotelRates($_POST);

			// update all fees
			Rate::updateHotelFees($_POST);

			// save new rates & Fees
			Rate::addNewHotelRates($_POST);

			// save new fees
			Rate::addNewHotelFees($_POST);

			// delete rates marked for deletion
			if (isset($_POST['ratesToDelete'])) {

				$arrRateIds = explode(',',$_POST['ratesToDelete']);
				foreach ($arrRateIds AS $strRateId) {
					if ($strRateId != '') {
						Rate::deleteHotelRateById($strRateId);
						//var_dump('delete' . $strRateId);
					}
				}
			}

			// delete fees marked for deletion
			if (isset($_POST['feesToDelete'])) {

				$arrFeeIds = explode(',',$_POST['feesToDelete']);
				foreach ($arrFeeIds AS $strFeeId) {
					if ($strFeeId != '') {
						Rate::deleteFeeById($strFeeId);
						//var_dump('delete' . $strRateId);
					}
				}
			}


			if($intReturnedRateId){
				$intRateId = $intReturnedRateId;
				$objMessage = array(
					'blnError' => false,
					'arrMessages' => array(
						'<strong>Rate was successfully updated.</strong>'
					)
				);
			}else{
				$objMessage = array(
					'blnError' => true,
					'arrMessages' => array(
						'<strong>Rate could not be updated.</strong> Please try again.'
					)
				);
			}
		}

		$arrRate = Rate::getHotelRateById($intRateId);

		// get child rates
		$arrChildQueryOptions = array(
			'hotel_id' => $arrRate['hotel_id'],
			'parent_id' => $intRateId,
			'min_start_date' => null,
			'max_start_date' => null,
			'order_by' => 'start_date',
			'sort_order' => 'ASC'
		);

		if(isset($_REQUEST['order_by']) && !empty($_REQUEST['order_by'])){
			$arrChildQueryOptions['order_by'] = $_REQUEST['order_by'];
		}

		if(isset($_REQUEST['sort_order']) && !empty($_REQUEST['sort_order'])){
			$arrChildQueryOptions['sort_order'] = $_REQUEST['sort_order'];
		}

		if(isset($_REQUEST['name']) && !empty($_REQUEST['name'])){
			$arrChildQueryOptions['name'] = $_REQUEST['name'];
		}

		if(isset($_REQUEST['min_start_date']) && !empty($_REQUEST['min_start_date'])){
			$arrChildQueryOptions['min_start_date'] = $_REQUEST['min_start_date'];
		}

		if(isset($_REQUEST['max_start_date']) && !empty($_REQUEST['max_start_date'])){
			$arrChildQueryOptions['max_start_date'] = $_REQUEST['max_start_date'];
		}

		if(isset($_REQUEST['min_end_date']) && !empty($_REQUEST['min_end_date'])){
			$arrChildQueryOptions['min_end_date'] = $_REQUEST['min_end_date'];
		}

		if(isset($_REQUEST['max_start_date']) && !empty($_REQUEST['max_start_date'])){
			$arrChildQueryOptions['max_start_date'] = $_REQUEST['max_start_date'];
		}

		$arrChildRates = Rate::getHotelRates($arrChildQueryOptions);
		$arrSeasonFees = Rate::getHotelRateFees($intRateId);

		// setup columns for datagrid
		$arrChildColumns = array(
			array(
				'name' => 'name',
				'label' => 'Name',
				'sortable' => true
			),
			array(
				'name' => 'start_date',
				'label' => 'Start Date',
				'sortable' => true
			),
			array(
				'name' => 'end_date',
				'label' => 'End Date',
				'sortable' => true
			),
			array(
				'name' => 'price',
				'label' => 'Price',
				'sortable' => true
			),
            /*
			array(
				'name' => 'rack_rate',
				'label' => 'Rack Rate',
				'sortable' => true
			),
			array(
				'name' => 'room_type',
				'label' => 'Room Type',
				'sortable' => true
			),
			array(
				'name' => 'occupancy',
				'label' => 'occupancy',
				'sortable' => true
			),
			array(
				'name' => 'minimum_stay',
				'label' => 'Minimum Stay',
				'sortable' => true
			)
            */
		);

		// get list of room types
		$arrRoomTypes = Rate::getHotelRoomTypes();

		// add an empty value at the beginning
		array_unshift($arrRoomTypes, array(
			'name' => 'No Room Type',
			'id' => null
		));
		
		
		$objRate = new Rate;
		$checkaccess = $objRate->checkpageaccess("rate_hotel", 'delete');
		$checkaccessadd = $objRate->checkpageaccess("rate_hotel", 'add');

		// load view
		include(ROOT_DIR . '/application/views/admin/rates/hotel_rate_single.php');
		die();
	}

	public static function pageHotelRateSingleNew($intHotelId, $intParentRateId = null){
		$objSettings = new Settings;
		$strController = 'rates_controller';
		$objMessage = array();
		$blnNew = true;

		if(isset($_POST['rate']) && !empty($_POST['rate'])){
			// update rate
			$intReturnedRateId = Rate::insertHotelRate($_POST['rate']);

			if($intReturnedRateId){
				$objMessage = array(
					'blnError' => false,
					'arrMessages' => array(
						'<strong>Rate was successfully created.</strong>'
					)
				);

				header('Location: ' . ROOT_URL . '/admin/rates/hotel/' . $_POST['rate']['hotel_id'] . '/' . $intReturnedRateId . '?message=' . urlencode(json_encode($objMessage)));
				die();
			}else{
				$objMessage = array(
					'blnError' => true,
					'arrMessages' => array(
						'<strong>Rate could not be created.</strong> Please try again.'
					)
				);
			}
		}

		if(empty($intParentRateId)){
			$intParentRateId = null;
		}

		$arrRate = array(
			'id' => null,
			'hotel_id' => $intHotelId,
			'start_date' => date('Y-m-d'),
			'end_date' => date('Y-m-d'),
			'name' => null,
			'length' => null,
			'parent_id' => $intParentRateId,
			'price' => null,
			'rack_rate' => null,
			'room_type' => null,
			'occupancy' => null,
			'additional_guest_fee' => null,
			'minimum_stay' => null,
			'deposit' => null,
			'notes' => null,
			'status' => 'active'
		);

		// get list of room types
		$arrRoomTypes = Rate::getHotelRoomTypes();

		// add an empty value at the beginning
		array_unshift($arrRoomTypes, array(
			'name' => 'No Room Type',
			'id' => null
		));

		// load view
		include(ROOT_DIR . '/application/views/admin/rates/hotel_rate_single.php');
		die();
	}

	public static function deleteHotelRate($intHotelId, $intRateId){
		if(empty($intRateId)){
			// no rate to delete
			echo '<strong>No rate passed in.</strong>';
		}

		$arrRate = Rate::getHotelRateById($intRateId);
		$blnDeleted = Rate::deleteHotelRateById($intRateId);

		if(!$blnDeleted){
			// error occured
			$objMessage = array(
				'blnError' => true,
				'arrMessages' => array(
					'<strong>Rate could not be deleted.</strong> Please try again.'
				)
			);

			// redirect to rate page
			header('Location: ' . ROOT_URL . '/admin/rates/hotel/' . $intHotelId . '/' . $intRateId . '?message=' . urlencode(json_encode($objMessage)));
			die();
		}

		// success
		$objMessage = array(
			'blnError' => false,
			'arrMessages' => array(
				'<strong>' . (!empty($arrRate['name']) ? $arrRate['name'] : ('#' . $arrRate['id'])) . ' Rate was successfully deleted.</strong>'
			)
		);

		if(empty($arrRate)){
			// redirect to hotel page
			header('Location: ' . ROOT_URL . '/admin/rates/hotel/' . $intHotelId . '/?message=' . urlencode(json_encode($objMessage)));
			die();
		}


		if(!empty($arrRate['parent_id'])){
			// redirect to parent rate page
			header('Location: ' . ROOT_URL . '/admin/rates/hotel/' . $intHotelId . '/' . $arrRate['parent_id'] . '?message=' . urlencode(json_encode($objMessage)));
			die();
		}

		// redirect to rate hotel page
		header('Location: ' . ROOT_URL . '/admin/rates/hotel/' . $arrRate['hotel_id'] . '/?message=' . urlencode(json_encode($objMessage)));
		die();
	}

	public static function duplicateHotelRate($intHotelId, $intRateId){
		if(empty($intHotelId) || empty($intRateId)){
			// missing required info
			echo '<strong>No hotel or rate passed in.</strong>';
		}

		$arrOptions = array(
			'rate_id' => $intRateId,
			'hotel_id' => $intHotelId,
			'deep' => true,
			'parent_id' => null
		);

		if(isset($_POST['duplicate']) && isset($_POST['duplicate']['deep']) && !empty($_POST['duplicate']['deep'])){
			$arrOptions['deep'] = $_POST['duplicate']['deep'];
		}

		if(isset($_POST['duplicate']) && isset($_POST['duplicate']['parent_id']) && !empty($_POST['duplicate']['parent_id'])){
			$arrOptions['parent_id'] = $_POST['duplicate']['parent_id'];
		}

		// duplicate records
		$intNewRateId = Rate::duplicateHotelRates($arrOptions);

		$arrRate = Rate::getHotelRateById($intRateId);

		if($intNewRateId === false){
			// error
			$objMessage = array(
				'blnError' => true,
				'arrMessages' => array(
					'<strong>' . (!empty($arrRate['name']) ? $arrRate['name'] : ('#' . $arrRate['id'])) . ' Rate could not be duplicated.</strong> Please try again.'
				)
			);

			header('Location: ' . ROOT_URL . '/admin/rates/hotel/' . $arrRate['hotel_id'] . '/' . $arrRate['id'] . '?message=' . urlencode(json_encode($objMessage)));
			die();
		}

		// success
		$arrNewRate = Rate::getHotelRateById($intNewRateId);

		$objMessage = array(
			'blnError' => false,
			'arrMessages' => array(
				'<strong>' . (!empty($arrRate['name']) ? $arrRate['name'] : ('#' . $arrRate['id'])) . ' Rate was successfully duplicated.</strong>'
			)
		);

		header('Location: ' . ROOT_URL . '/admin/rates/hotel/' . $arrNewRate['hotel_id'] . '/' . $arrNewRate['id'] . '?message=' . urlencode(json_encode($objMessage)));
		die();
	}

    public static function pageCalculator() {
        $objSettings = new Settings;
        $strController = 'rates_controller';

        // Get the data
        $objRegions = new Region;
        $arrRegions = $objRegions->getRegions();

        // Get hotel list
        $arrHotelsWithRates = Rate::getHotelsWithRates();
        $arrHotelsWithoutRates = Rate::getHotelsNoRates();

        // Get course list
        $arrCoursesWithRates = Rate::getCoursesWithRates();
        $arrCoursesWithoutRates = Rate::getCoursesNoRates();

        $objCalculator = new Rates_Calculator();

        // Check the post to see if the import value is set
        // if true, decode the import and set it as the $_POST
        if (!empty($_POST['import'])) {
            $_POST = json_decode($_POST['import'], true);
        }

        // Set post values
        $intNumberOfGolfers = !empty($_POST['number_of_golfers']) ? $_POST['number_of_golfers'] : 2;
        $intOccupancy = !empty($_POST['occupancy']) ? $_POST['occupancy'] : 2;
        $strDateStart = !empty($_POST['date_start']) ? $_POST['date_start'] : '';
        $strDateEnd = !empty($_POST['date_end']) ? $_POST['date_end'] : '';
        $arrRegionsSelected = !empty($_POST['regions']) ? $_POST['regions'] : array();
        $arrHotels = !empty($_POST['hotels']) ? $_POST['hotels'] : array();
        $arrCourses = !empty($_POST['courses']) ? $_POST['courses'] : array();
        $arrRatesHotels = !empty($_POST['rates_hotels']) ? $_POST['rates_hotels'] : array();
        $arrRatesCourses = !empty($_POST['rates_courses']) ? $_POST['rates_courses'] : array();
        $arrModifiers = !empty($_POST['modifiers']) ? $_POST['modifiers'] : $objCalculator->arrModifiers;

        if (!empty($_POST)) {
            // Calculate the costs
            $objCalculator = new Rates_Calculator(array(
                'calculate' => true,
                'number_of_golfers' => $intNumberOfGolfers,
                'occupancy' => $intOccupancy,
                'date_start' => $strDateStart,
                'date_end' => $strDateEnd,
                'regions' => $arrRegionsSelected,
                'hotels' => $arrHotels,
                'courses' => $arrCourses,
                'rates_hotels' => $arrRatesHotels,
                'rates_courses' => $arrRatesCourses,
                'modifiers' => $arrModifiers
            ));
        }

        // Include the view
        include(ROOT_DIR . '/application/views/admin/rates/calculator.php');
    }

	public static function ajax_searchHotelRate($intHotelId, $strSearch){
		// this is an ajax call
		$arrReturn = array(
			'error' => false,
			'messages' => array(),
			'request' => array(
				'hotel_id' => $intHotelId,
				'search' => $strSearch
			),
			'rates' => array()
		);

		if(empty($intHotelId)){
			// no hotel to search rates for
			$arrReturn['error'] = false;
			$arrRaturn['messages'][] = 'No hotel id passed.';

			echo json_encode($arrReturn);
			die();
		}

		if(empty($strSearch)){
			// nothing to search so load base rates for this hotel
			$arrRates = Rate::getHotelRates(array(
				'hotel_id' => $intHotelId,
				'parent_id' => 'empty'
			));

			$arrRatesFinal = array();
			foreach($arrRates as $arrRate){
				if(array_key_exists($arrRate['id'], $arrRatesFinal)){
					// already in array
					continue;
				}

				$arrRatesFinal[$arrRate['id']] = $arrRate;
			}

			$arrReturn['rates'] = $arrRatesFinal;

			echo json_encode($arrReturn);
			die();
		}

		// get rates based on search term (name)
		$arrRatesName = Rate::getHotelRates(array(
			'hotel_id' => $intHotelId,
			'name' => $strSearch
		));

		// get rates based on search term (notes)
		$arrRatesNotes = Rate::getHotelRates(array(
			'hotel_id' => $intHotelId,
			'notes' => $strSearch
		));

		// get rates based on search term (deposit)
		$arrRatesDeposit = Rate::getHotelRates(array(
			'hotel_id' => $intHotelId,
			'deposit' => $strSearch
		));

		// get rates based on search term (id)
		$arrRatesId = array();
		if(is_numeric($strSearch)){
			$arrRatesId = Rate::getHotelRates(array(
				'hotel_id' => $intHotelId,
				'id' => (int)$strSearch
			));
		}

		$arrRates = array();

		foreach($arrRatesName as $arrRateName){
			if(array_key_exists($arrRateName['id'], $arrRates)){
				// already in array
				continue;
			}

			$arrRates[$arrRateName['id']] = $arrRateName;
		}

		foreach($arrRatesNotes as $arrRateNote){
			if(array_key_exists($arrRateNote['id'], $arrRates)){
				// already in array
				continue;
			}

			$arrRates[$arrRateNote['id']] = $arrRateNote;
		}

		foreach($arrRatesDeposit as $arrRateDeposit){
			if(array_key_exists($arrRateDeposit['id'], $arrRates)){
				// already in array
				continue;
			}

			$arrRates[$arrRateDeposit['id']] = $arrRateDeposit;
		}

		foreach($arrRatesId as $arrRateId){
			if(array_key_exists($arrRateId['id'], $arrRates)){
				// already in array
				continue;
			}

			$arrRates[$arrRateId['id']] = $arrRateId;
		}


		$arrReturn['rates'] = $arrRates;

		echo json_encode($arrReturn);
		die();
	}

	public static function ajax_getHotelChildren($intHotelId, $intParentId){
		// this is an ajax call
		$arrReturn = array(
			'error' => false,
			'messages' => array(),
			'request' => array(
				'hotel_id' => $intHotelId,
				'rate_id' => $intParentId
			),
			'rates' => array()
		);

		if(empty($intHotelId)){
			// no hotel to search rates for
			$arrReturn['error'] = false;
			$arrRaturn['messages'][] = 'No hotel id passed.';

			echo json_encode($arrReturn);
			die();
		}

		if(empty($intParentId)){
			// no hotel to search rates for
			$arrReturn['error'] = false;
			$arrRaturn['messages'][] = 'No rate id passed.';

			echo json_encode($arrReturn);
			die();
		}

		$arrRates = Rate::getHotelRates(array(
			'hotel_id' => $intHotelId,
			'parent_id' => $intParentId
		));

		$arrRatesFinal = array();
		foreach($arrRates as $arrRate){
			if(array_key_exists($arrRate['id'], $arrRates)){
				// already in array
				continue;
			}

			$arrRatesFinal[$arrRate['id']] = $arrRate;
		}


		$arrReturn['rates'] = $arrRatesFinal;

		echo json_encode($arrReturn);
		die();
	}

	public static function ajax_getHotelRate($intHotelId, $intRateId){
		// this is an ajax call
		$arrReturn = array(
			'error' => false,
			'messages' => array(),
			'request' => array(
				'hotel_id' => $intHotelId,
				'rate_id' => $intRateId
			),
			'rate' => array()
		);

		if(empty($intHotelId)){
			// no hotel to search rates for
			$arrReturn['error'] = false;
			$arrRaturn['messages'][] = 'No hotel id passed.';

			echo json_encode($arrReturn);
			die();
		}

		if(empty($intRateId)){
			// no hotel to search rates for
			$arrReturn['error'] = false;
			$arrRaturn['messages'][] = 'No rate id passed.';

			echo json_encode($arrReturn);
			die();
		}

		$arrRate = Rate::getHotelRateById($intRateId);

		$arrReturn['rate'] = $arrRate;

		echo json_encode($arrReturn);
		die();
	}

	/* courses */
	public static function pageCourseList(){
		$objSettings = new Settings;
		$strController = 'rates_controller';

		$arrCourseNoRateOptions = array(
			'min_start_date' => date('Y', time()) . '-01-01', // start of year
			'max_start_date' => date('Y') . '-12-31', // end of year
			'min_end_date' => date('Y') . '-01-01', // start of year
			'max_end_date' => date('Y') . '-12-31', // end of year
		);

		$arrCourseRateOptions = array();

		$strFilter['name'] = null;
		if(isset($_REQUEST['name']) && !empty($_REQUEST['name'])){
			$strFilter['name'] = $_REQUEST['name'];
			$arrCourseNoRateOptions['course_name'] = $_REQUEST['name'];
			$arrCourseRateOptions['course_name'] = $_REQUEST['name'];
		}

		$arrCoursesNoRates = Rate::getCoursesNoRatesInRange($arrCourseNoRateOptions);
		$arrCourses = Rate::getCoursesWithRates($arrCourseRateOptions);

		// load view
		include(ROOT_DIR . '/application/views/admin/rates/course_list.php');
		die();
	}

	public static function pageCourseSingle($intCourseId){
		$objSettings = new Settings;
		$strController = 'rates_controller';
		$objMessage = array();

		$arrCourse = Rate::getCourseById($intCourseId);

		if(isset($_REQUEST['message']) && !empty($_REQUEST['message'])){
			$objMessage = json_decode(urldecode($_REQUEST['message']), true);
		}

		$arrQueryOptions = array(
			'course_id' => $intCourseId,
			'parent_id' => 'empty',
			'order_by' => 'start_date',
			'sort_order' => 'ASC'
		);

		if(isset($_REQUEST['order_by']) && !empty($_REQUEST['order_by'])){
			$arrQueryOptions['order_by'] = $_REQUEST['order_by'];
		}

		if(isset($_REQUEST['sort_order']) && !empty($_REQUEST['sort_order'])){
			$arrQueryOptions['sort_order'] = $_REQUEST['sort_order'];
		}

		if(isset($_REQUEST['name']) && !empty($_REQUEST['name'])){
			$arrQueryOptions['name'] = $_REQUEST['name'];
		}

		if(isset($_REQUEST['min_start_date']) && !empty($_REQUEST['min_start_date'])){
			$arrQueryOptions['min_start_date'] = $_REQUEST['min_start_date'];
		}

		if(isset($_REQUEST['max_start_date']) && !empty($_REQUEST['max_start_date'])){
			$arrQueryOptions['max_start_date'] = $_REQUEST['max_start_date'];
		}

		if(isset($_REQUEST['min_end_date']) && !empty($_REQUEST['min_end_date'])){
			$arrQueryOptions['min_end_date'] = $_REQUEST['min_end_date'];
		}

		if(isset($_REQUEST['max_start_date']) && !empty($_REQUEST['max_start_date'])){
			$arrQueryOptions['max_start_date'] = $_REQUEST['max_start_date'];
		}

		$arrRates = Rate::getCourseRates($arrQueryOptions);

		// setup columns for datagrid
		$arrColumns = array(
			array(
				'name' => 'name',
				'label' => 'Name',
				'sortable' => true
			),
			array(
				'name' => 'start_date',
				'label' => 'Start Date',
				'sortable' => true
			),
			array(
				'name' => 'end_date',
				'label' => 'End Date',
				'sortable' => true
			),
			array(
				'name' => 'price',
				'label' => 'Price',
				'sortable' => true
			),
            /*
			array(
				'name' => 'rack_rate',
				'label' => 'Rack Rate',
				'sortable' => true
			),
			array(
				'name' => 'rate_based_count',
				'label' => 'Rate Based Count',
				'sortable' => true
			),
			array(
				'name' => 'course_type',
				'label' => 'course_type',
				'sortable' => true
			),
            */
		);

		// load view
		include(ROOT_DIR . '/application/views/admin/rates/course_single.php');
		die();
	}

	public static function pageCourseRateSingleNew($intCourseId, $intParentRateId = null){
		$objSettings = new Settings;
		$strController = 'rates_controller';
		$objMessage = array();
		$blnNew = true;

		if(isset($_POST['rate']) && !empty($_POST['rate'])){
			// update rate
			$intReturnedRateId = Rate::insertCourseRate($_POST['rate']);

			if($intReturnedRateId){
				$objMessage = array(
					'blnError' => false,
					'arrMessages' => array(
						'<strong>Rate was successfully created.</strong>'
					)
				);

				header('Location: ' . ROOT_URL . '/admin/rates/course/' . $_POST['rate']['course_id'] . '/' . $intReturnedRateId . '?message=' . urlencode(json_encode($objMessage)));
				die();
			}else{
				$objMessage = array(
					'blnError' => true,
					'arrMessages' => array(
						'<strong>Rate could not be created.</strong> Please try again.'
					)
				);
			}
		}

		if(empty($intParentRateId)){
			$intParentRateId = null;
		}

		$arrRate = array(
			'id' => null,
			'course_id' => $intCourseId,
			'start_date' => date('Y-m-d'),
			'end_date' => date('Y-m-d'),
			'name' => null,
			'length' => null,
			'parent_id' => $intParentRateId,
			'price' => null,
			'rack_rate' => null,
			'course_type' => null,
			'rate_based_count' => null,
			'deposit' => null,
			'notes' => null,
			'status' => 'active'
		);

		// get list of room types
		$arrCourseTypes = Rate::getCourseTypes();

		// add an empty value at the beginning
		array_unshift($arrCourseTypes, array(
			'name' => 'No Course Type',
			'id' => null
		));

		// load view
		include(ROOT_DIR . '/application/views/admin/rates/course_rate_single.php');
		die();
	}

	public static function pageCourseRateSingle($intRateId){

		$objSettings = new Settings;
		$strController = 'rates_controller';
		$objMessage = array();
		$blnNew = false;

		if(isset($_REQUEST['message']) && !empty($_REQUEST['message'])){
			$objMessage = json_decode(urldecode($_REQUEST['message']), true);
		}

		if(isset($_POST['rate']) && !empty($_POST['rate'])){
			// update main rate entry
			$intReturnedRateId = Rate::updateCourseRate($_POST['rate']);

			// update all listed rates
			Rate::updateCourseRates($_POST);

			// update all fees
			Rate::updateCourseFees($_POST);

			// save new rates & Fees
			Rate::addNewCourseRates($_POST);

			// save new fees
			Rate::addNewCourseFees($_POST);

			// delete rates marked for deletion
			if (isset($_POST['ratesToDelete'])) {

				$arrRateIds = explode(',',$_POST['ratesToDelete']);
				foreach ($arrRateIds AS $strRateId) {
					if ($strRateId != '') {
						Rate::deleteCourseRateById($strRateId);
						//var_dump('delete' . $strRateId);
					}
				}
			}

			// delete fees marked for deletion
			if (isset($_POST['feesToDelete'])) {

				$arrFeeIds = explode(',',$_POST['feesToDelete']);
				foreach ($arrFeeIds AS $strFeeId) {
					if ($strFeeId != '') {
						Rate::deleteFeeById($strFeeId);
						//var_dump('delete' . $strRateId);
					}
				}
			}

			// die();

			if($intReturnedRateId){
				$intRateId = $intReturnedRateId;
				$objMessage = array(
					'blnError' => false,
					'arrMessages' => array(
						'<strong>Rate was successfully updated.</strong>'
					)
				);
			}else{
				$objMessage = array(
					'blnError' => true,
					'arrMessages' => array(
						'<strong>Rate could not be updated.</strong> Please try again.'
					)
				);
			}
		}

		$arrRate = Rate::getCourseRateById($intRateId);

		// get child rates
		$arrChildQueryOptions = array(
			'course_id' => $arrRate['course_id'],
			'parent_id' => $intRateId,
			'min_start_date' => null,
			'max_start_date' => null,
			'order_by' => 'start_date',
			'sort_order' => 'ASC'
		);

		if(isset($_REQUEST['order_by']) && !empty($_REQUEST['order_by'])){
			$arrChildQueryOptions['order_by'] = $_REQUEST['order_by'];
		}

		if(isset($_REQUEST['sort_order']) && !empty($_REQUEST['sort_order'])){
			$arrChildQueryOptions['sort_order'] = $_REQUEST['sort_order'];
		}

		if(isset($_REQUEST['name']) && !empty($_REQUEST['name'])){
			$arrChildQueryOptions['name'] = $_REQUEST['name'];
		}

		if(isset($_REQUEST['min_start_date']) && !empty($_REQUEST['min_start_date'])){
			$arrChildQueryOptions['min_start_date'] = $_REQUEST['min_start_date'];
		}

		if(isset($_REQUEST['max_start_date']) && !empty($_REQUEST['max_start_date'])){
			$arrChildQueryOptions['max_start_date'] = $_REQUEST['max_start_date'];
		}

		if(isset($_REQUEST['min_end_date']) && !empty($_REQUEST['min_end_date'])){
			$arrChildQueryOptions['min_end_date'] = $_REQUEST['min_end_date'];
		}

		if(isset($_REQUEST['max_start_date']) && !empty($_REQUEST['max_start_date'])){
			$arrChildQueryOptions['max_start_date'] = $_REQUEST['max_start_date'];
		}

		$arrChildRates = Rate::getCourseRates($arrChildQueryOptions);
		$arrSeasonFees = Rate::getCourseRateFees($intRateId);

		// setup columns for datagrid
		$arrChildColumns = array(
			array(
				'name' => 'name',
				'label' => 'Name',
				'sortable' => true
			),
			array(
				'name' => 'start_date',
				'label' => 'Start Date',
				'sortable' => true
			),
			array(
				'name' => 'end_date',
				'label' => 'End Date',
				'sortable' => true
			),
			array(
				'name' => 'price',
				'label' => 'Price',
				'sortable' => true
			),
            /*
			array(
				'name' => 'rack_rate',
				'label' => 'Rack Rate',
				'sortable' => true
			),
			array(
				'name' => 'course_type',
				'label' => 'Course Type',
				'sortable' => true
			),
			array(
				'name' => 'rate_based_count',
				'label' => 'Rate Based Count',
				'sortable' => true
			)
            */
		);

		// get list of room types
		$arrCourseTypes = Rate::getCourseTypes();

		// add an empty value at the beginning
		array_unshift($arrCourseTypes, array(
			'name' => 'No Course Type',
			'id' => null
		));
		
		$objRate = new Rate;
		$checkaccess = $objRate->checkpageaccess("rate_course", 'delete');
		$checkaccessadd = $objRate->checkpageaccess("rate_course", 'add');

		// load view
		include(ROOT_DIR . '/application/views/admin/rates/course_rate_single.php');
		die();
	}

	public static function deleteCourseRate($intCourseId, $intRateId){
		if(empty($intRateId)){
			// no rate to delete
			echo '<strong>No rate passed in.</strong>';
		}

		$arrRate = Rate::getCourseRateById($intRateId);
		$blnDeleted = Rate::deleteCourseRateById($intRateId);

		if(!$blnDeleted){
			// error occured
			$objMessage = array(
				'blnError' => true,
				'arrMessages' => array(
					'<strong>Rate could not be deleted.</strong> Please try again.'
				)
			);

			// redirect to rate page
			header('Location: ' . ROOT_URL . '/admin/rates/course/' . $intCourseId . '/' . $intRateId . '?message=' . urlencode(json_encode($objMessage)));
			die();
		}

		// success
		$objMessage = array(
			'blnError' => false,
			'arrMessages' => array(
				'<strong>' . (!empty($arrRate['name']) ? $arrRate['name'] : ('#' . $arrRate['id'])) . ' Rate was successfully deleted.</strong>'
			)
		);

		if(empty($arrRate)){
			// redirect to course page
			header('Location: ' . ROOT_URL . '/admin/rates/course/' . $intCourseId . '/?message=' . urlencode(json_encode($objMessage)));
			die();
		}


		if(!empty($arrRate['parent_id'])){
			// redirect to parent rate page
			header('Location: ' . ROOT_URL . '/admin/rates/course/' . $intCourseId . '/' . $arrRate['parent_id'] . '?message=' . urlencode(json_encode($objMessage)));
			die();
		}

		// redirect to rate course page
		header('Location: ' . ROOT_URL . '/admin/rates/course/' . $arrRate['course_id'] . '/?message=' . urlencode(json_encode($objMessage)));
		die();
	}

	public static function duplicateCourseRate($intCourseId, $intRateId){
		if(empty($intCourseId) || empty($intRateId)){
			// missing required info
			echo '<strong>No course or rate passed in.</strong>';
		}

		$arrOptions = array(
			'rate_id' => $intRateId,
			'course_id' => $intCourseId,
			'deep' => true,
			'parent_id' => null
		);
/*
		if(isset($_POST['duplicate']) && isset($_POST['duplicate']['deep']) && !empty($_POST['duplicate']['deep'])){
			$arrOptions['deep'] = $_POST['duplicate']['deep'];
		}

		if(isset($_POST['duplicate']) && isset($_POST['duplicate']['parent_id']) && !empty($_POST['duplicate']['parent_id'])){
			$arrOptions['parent_id'] = $_POST['duplicate']['parent_id'];
		}
*/

		// duplicate records
		$intNewRateId = Rate::duplicateCourseRates($arrOptions);

		$arrRate = Rate::getCourseRateById($intRateId);

		if($intNewRateId === false){
			// error
			$objMessage = array(
				'blnError' => true,
				'arrMessages' => array(
					'<strong>' . (!empty($arrRate['name']) ? $arrRate['name'] : ('#' . $arrRate['id'])) . ' Rate could not be duplicated.</strong> Please try again.'
				)
			);

			header('Location: ' . ROOT_URL . '/admin/rates/course/' . $arrRate['course_id'] . '/' . $arrRate['id'] . '?message=' . urlencode(json_encode($objMessage)));
			die();
		}

		// success
		$arrNewRate = Rate::getCourseRateById($intNewRateId);

		$objMessage = array(
			'blnError' => false,
			'arrMessages' => array(
				'<strong>' . (!empty($arrRate['name']) ? $arrRate['name'] : ('#' . $arrRate['id'])) . ' Rate was successfully duplicated.</strong>'
			)
		);

		header('Location: ' . ROOT_URL . '/admin/rates/course/' . $arrNewRate['course_id'] . '/' . $arrNewRate['id'] . '?message=' . urlencode(json_encode($objMessage)));
		die();
	}

	public static function ajax_getCourseRate($intCourseId, $intRateId){
		// this is an ajax call
		$arrReturn = array(
			'error' => false,
			'messages' => array(),
			'request' => array(
				'course_id' => $intCourseId,
				'rate_id' => $intRateId
			),
			'rate' => array()
		);

		if(empty($intCourseId)){
			// no course to search rates for
			$arrReturn['error'] = false;
			$arrRaturn['messages'][] = 'No course id passed.';

			echo json_encode($arrReturn);
			die();
		}

		if(empty($intRateId)){
			// no course to search rates for
			$arrReturn['error'] = false;
			$arrRaturn['messages'][] = 'No rate id passed.';

			echo json_encode($arrReturn);
			die();
		}

		$arrRate = Rate::getCourseRateById($intRateId);

		$arrReturn['rate'] = $arrRate;

		echo json_encode($arrReturn);
		die();
	}

	public static function ajax_searchCourseRate($intCourseId, $strSearch){
		// this is an ajax call
		$arrReturn = array(
			'error' => false,
			'messages' => array(),
			'request' => array(
				'course_id' => $intCourseId,
				'search' => $strSearch
			),
			'rates' => array()
		);

		if(empty($intCourseId)){
			// no course to search rates for
			$arrReturn['error'] = false;
			$arrRaturn['messages'][] = 'No course id passed.';

			echo json_encode($arrReturn);
			die();
		}

		if(empty($strSearch)){
			// nothing to search so load base rates for this course
			$arrRates = Rate::getCourseRates(array(
				'course_id' => $intCourseId,
				'parent_id' => 'empty'
			));

			$arrRatesFinal = array();
			foreach($arrRates as $arrRate){
				if(array_key_exists($arrRate['id'], $arrRatesFinal)){
					// already in array
					continue;
				}

				$arrRatesFinal[$arrRate['id']] = $arrRate;
			}

			$arrReturn['rates'] = $arrRatesFinal;

			echo json_encode($arrReturn);
			die();
		}

		// get rates based on search term (name)
		$arrRatesName = Rate::getCourseRates(array(
			'course_id' => $intCourseId,
			'name' => $strSearch
		));

		// get rates based on search term (notes)
		$arrRatesNotes = Rate::getCourseRates(array(
			'course_id' => $intCourseId,
			'notes' => $strSearch
		));

		// get rates based on search term (deposit)
		$arrRatesDeposit = Rate::getCourseRates(array(
			'course_id' => $intCourseId,
			'deposit' => $strSearch
		));

		// get rates based on search term (id)
		$arrRatesId = array();
		if(is_numeric($strSearch)){
			$arrRatesId = Rate::getCourseRates(array(
				'course_id' => $intCourseId,
				'id' => (int)$strSearch
			));
		}

		$arrRates = array();

		foreach($arrRatesName as $arrRateName){
			if(array_key_exists($arrRateName['id'], $arrRates)){
				// already in array
				continue;
			}

			$arrRates[$arrRateName['id']] = $arrRateName;
		}

		foreach($arrRatesNotes as $arrRateNote){
			if(array_key_exists($arrRateNote['id'], $arrRates)){
				// already in array
				continue;
			}

			$arrRates[$arrRateNote['id']] = $arrRateNote;
		}

		foreach($arrRatesDeposit as $arrRateDeposit){
			if(array_key_exists($arrRateDeposit['id'], $arrRates)){
				// already in array
				continue;
			}

			$arrRates[$arrRateDeposit['id']] = $arrRateDeposit;
		}

		foreach($arrRatesId as $arrRateId){
			if(array_key_exists($arrRateId['id'], $arrRates)){
				// already in array
				continue;
			}

			$arrRates[$arrRateId['id']] = $arrRateId;
		}


		$arrReturn['rates'] = $arrRates;

		echo json_encode($arrReturn);
		die();
	}

	public static function ajax_getCourseChildren($intCourseId, $intParentId){
		// this is an ajax call
		$arrReturn = array(
			'error' => false,
			'messages' => array(),
			'request' => array(
				'course_id' => $intCourseId,
				'rate_id' => $intParentId
			),
			'rates' => array()
		);

		if(empty($intCourseId)){
			// no course to search rates for
			$arrReturn['error'] = false;
			$arrRaturn['messages'][] = 'No course id passed.';

			echo json_encode($arrReturn);
			die();
		}

		if(empty($intParentId)){
			// no course to search rates for
			$arrReturn['error'] = false;
			$arrRaturn['messages'][] = 'No rate id passed.';

			echo json_encode($arrReturn);
			die();
		}

		$arrRates = Rate::getCourseRates(array(
			'course_id' => $intCourseId,
			'parent_id' => $intParentId
		));

		$arrRatesFinal = array();
		foreach($arrRates as $arrRate){
			if(array_key_exists($arrRate['id'], $arrRates)){
				// already in array
				continue;
			}

			$arrRatesFinal[$arrRate['id']] = $arrRate;
		}


		$arrReturn['rates'] = $arrRatesFinal;

		echo json_encode($arrReturn);
		die();
	}

	/* type control functions */
	public static function ajax_searchHotels($strSearch){
		// this is an ajax call
		$arrReturn = array(
			'error' => false,
			'messages' => array(),
			'request' => array(
				'type' => 'hotel',
				'search' => $strSearch
			),
			'types' => array()
		);

		if(empty($strSearch)){
			// nothing to search so load base hotels for this hotel
			$arrHotels = Rate::getHotels(array(
				'limit' => 5
			));

			$arrHotelsFinal = array();
			foreach($arrHotels as $arrHotel){
				if(array_key_exists($arrHotel['id'], $arrHotelsFinal)){
					// already in array
					continue;
				}

				// setup proporty for type changer control
				$arrHotel['name'] = $arrHotel['hotel_name'];

				$arrHotelsFinal[$arrHotel['id']] = $arrHotel;
			}

			$arrReturn['types'] = $arrHotelsFinal;

			echo json_encode($arrReturn);
			die();
		}

		// get hotels based on search term (name)
		$arrHotelsName = Rate::getHotels(array(
			'hotel_name' => $strSearch
		));

		// get hotels based on search term (id)
		$arrHotelsId = array();
		if(is_numeric($strSearch)){
			$arrHotelsId = Rate::getHotels(array(
				'id' => (int)$strSearch
			));
		}

		$arrHotels = array();

		foreach($arrHotelsName as $arrHotelName){
			if(array_key_exists($arrHotelName['id'], $arrHotels)){
				// already in array
				continue;
			}

			// setup proporty for type changer control
			$arrHotelName['name'] = $arrHotelName['hotel_name'];

			$arrHotels[$arrHotelName['id']] = $arrHotelName;
		}

		foreach($arrHotelsId as $arrHotelId){
			if(array_key_exists($arrHotelId['id'], $arrHotels)){
				// already in array
				continue;
			}

			// setup proporty for type changer control
			$arrHotelId['name'] = $arrHotelId['hotel_name'];

			$arrHotels[$arrHotelId['id']] = $arrHotelId;
		}

		$arrReturn['types'] = $arrHotels;

		echo json_encode($arrReturn);
		die();
	}

	public static function ajax_getHotelType($intHotelId){
		// this is an ajax call
		$arrReturn = array(
			'error' => false,
			'messages' => array(),
			'request' => array(
				'hotel_id' => $intHotelId,
			),
			'type' => array()
		);

		if(empty($intHotelId)){
			// no hotel to search for
			$arrReturn['error'] = false;
			$arrRaturn['messages'][] = 'No hotel id passed.';

			echo json_encode($arrReturn);
			die();
		}

		$arrHotel = Rate::getHotelById($intHotelId);

		$arrHotel['name'] = $arrHotel['hotel_name'];

		$arrReturn['type'] = $arrHotel;

		echo json_encode($arrReturn);
		die();
	}

	public static function ajax_searchCourses($strSearch){
		// this is an ajax call
		$arrReturn = array(
			'error' => false,
			'messages' => array(),
			'request' => array(
				'type' => 'course',
				'search' => $strSearch
			),
			'types' => array()
		);

		if(empty($strSearch)){
			// nothing to search so load base courses for this course
			$arrCourses = Rate::getCourses(array(
				'limit' => 5
			));

			$arrCoursesFinal = array();
			foreach($arrCourses as $arrCourse){
				if(array_key_exists($arrCourse['id'], $arrCoursesFinal)){
					// already in array
					continue;
				}

				// setup proporty for type changer control
				$arrCourse['name'] = $arrCourse['course_name'];

				$arrCoursesFinal[$arrCourse['id']] = $arrCourse;
			}

			$arrReturn['types'] = $arrCoursesFinal;

			echo json_encode($arrReturn);
			die();
		}

		// get courses based on search term (name)
		$arrCoursesName = Rate::getCourses(array(
			'course_name' => $strSearch
		));

		// get courses based on search term (id)
		$arrCoursesId = array();
		if(is_numeric($strSearch)){
			$arrCoursesId = Rate::getCourses(array(
				'id' => (int)$strSearch
			));
		}

		$arrCourses = array();

		foreach($arrCoursesName as $arrCourseName){
			if(array_key_exists($arrCourseName['id'], $arrCourses)){
				// already in array
				continue;
			}

			// setup proporty for type changer control
			$arrCourseName['name'] = $arrCourseName['course_name'];

			$arrCourses[$arrCourseName['id']] = $arrCourseName;
		}

		foreach($arrCoursesId as $arrCourseId){
			if(array_key_exists($arrCourseId['id'], $arrCourses)){
				// already in array
				continue;
			}

			// setup proporty for type changer control
			$arrCourseId['name'] = $arrCourseId['course_name'];

			$arrCourses[$arrCourseId['id']] = $arrCourseId;
		}


		//UTF-8 Encode fields to pass through json correctly
		foreach ($arrCourses as &$arrCourse) {
			foreach ($arrCourse as $key=>$value) {
				$arrCourse[$key] = utf8_encode($value);
			}
		}

		$arrReturn['types'] = $arrCourses;

		echo json_encode($arrReturn);
		die();
	}

	public static function ajax_getCourseType($intCourseId){
		// this is an ajax call
		$arrReturn = array(
			'error' => false,
			'messages' => array(),
			'request' => array(
				'course_id' => $intCourseId,
			),
			'type' => array()
		);

		if(empty($intCourseId)){
			// no course to search for
			$arrReturn['error'] = false;
			$arrRaturn['messages'][] = 'No course id passed.';

			echo json_encode($arrReturn);
			die();
		}

		$arrCourse = Rate::getCourseById($intCourseId);

		$arrCourse['name'] = $arrCourse['course_name'];

		$arrReturn['type'] = $arrCourse;

		echo json_encode($arrReturn);
		die();
	}
}
