<?php


class quote_group_controller extends default_controller {



    public function __construct($strPageId) {
        // Export action
        $this->strExport = isset($_REQUEST['export']) ? $_REQUEST['export'] : '';

        // Export filters
        $this->tab = isset($_REQUEST['tab']) ? $_REQUEST['tab'] : '';
        $this->strGridAgency = isset($_REQUEST['grid_agency']) ? $_REQUEST['grid_agency'] : '';
        $this->strGridAgent = isset($_REQUEST['grid_agent']) ? $_REQUEST['grid_agent'] : '';
        $this->strGridEmailRead = isset($_REQUEST['grid_email_read']) ? $_REQUEST['grid_email_read'] : '';
        $this->strGridDateType = isset($_REQUEST['grid_date']) && $_REQUEST['grid_date'] != '' ? $_REQUEST['grid_date'] : '';
        $this->strStartDate = isset($_REQUEST['start_date']) ? $_REQUEST['start_date'] : '';
        $this->strEndDate = isset($_REQUEST['end_date']) ? $_REQUEST['end_date'] : '';
        $this->intYear = isset($_REQUEST['year']) ? $_REQUEST['year'] :  date("Y");
        $this->intMonth = isset($_REQUEST['month']) ? $_REQUEST['month'] : '';

        $this->strSortBy = 'id';
        
        $this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

        //this handles post back variables, decides which method to use for the dataset
        parent::__construct($strPageId);

        $this->strTableName = 'quote_goup';
        $this->strAdminSlug = '/admin/quote-group/';
        $this->strGroupSlug = '/admin/quote/';

        // Filter options data
        $this->arrAgency = $this->objModel->getAgency();
        $this->arrAgent  = $this->objModel->getAgent();

        $this->arrTableSQLArray     = array('', 'group_name', 'quote_name', 'user_name', 'agency', 'booking_person','players_num', 'email_read', 'quote_order_date', 'quote_last_edit', 'quote_arrival_date', 'quote_status');
        $this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">','Group', 'Quote Name', 'User Name', 'Agency', 'Booking Person','#','Email Read', 'Inq Date', 'Last Edit Date', 'Expected Arrival Date', 'Quote Status');
        $this->arrTableSortArray    = array(false, true, true, true, true, true, true, true, true, true, true, true);

        // Build the query options
        $this->strOptions = http_build_query(array(
            'searchWord' => $this->strSearchWord,
            'status' => $this->strStatus,
            'pgSize' => $this->strPgSize,
            'year' => $this->intYear,
            'month' => $this->intMonth,
            'grid_agency' => $this->strGridAgency,
            'grid_agent' => $this->strGridAgent,
            'grid_email_read' => $this->strGridEmailRead,
            'grid_date' => $this->strGridDateType,
            'grid_completed' => $this->intGridCompleted,
        ));

        if($this->strAction == '') {
            // show list of quote groups
            $this->strView = 'list_quote_group';
        }
    }

    public function doActions() {
        // Export
        if ($this->strExport != '') {
            $this->export();
        }
        // Update / edit
        if($this->strSubmit != '') {
            $this->intID = $this->objModel->handlePost($_POST, $this->intID);
        }
        // Trash
        if($this->strTrash != '') {
            $this->objModel->updateStatus($this->intID,'Trash');
        }
        // Restore
        if($this->strRestore != '') {
            $this->objModel->updateStatus($this->intID,'Active');
        }
        // Delete
        if($this->strDelete != '') {
            $this->objModel->deleteRecord($this->intID);
            $this->intID = '';
            $this->strAction = '';
        }

        switch(strtolower($this->strAction)){
            case 'add':
                // create new group
                $intNewGroup = Group::createGroup();

                if($intNewId !== false){
                    // redirect to new group
                    header('Location: /admin/quote-group/');
                    die();
                }

                // something went wrong, load the normal view with message
                $this->strAction = '';
                break;
        }

        // Bulk Actions
        if($this->strBulk != '') {
            $this->csvPageID = isset($_REQUEST['pageID']) ? implode($_REQUEST['pageID'],',') : "";
            if($this->strBulk == 'trash') {
                $this->objModel->updateStatus($this->csvPageID,'Trash');
            } else if($this->strBulk == 'restore') {
                $this->objModel->updateStatus($this->csvPageID,'Active');
            }
        }

        // Set our admin messages after the model functions run
        $this->strErrorMessage = $this->objModel->strErrorMessage;
        $this->strSuccessMessage = $this->objModel->strSuccessMessage;

        // Get the Grid / Detail view
        if($this->strAction == '') {
            // Get the Page Array
            $this->arrPages = $this->objModel->getList(
                $this->strPgSize,
                $this->strPg,
                $this->strSortBy,
                $this->strSortOrder,
                $this->strSearchWord,
                $this->strStatus,
                $this->strGridDates,
                $this->intGridCategories,
                false
            );

            $this->strQuery = $this->objModel->strQuery;
        } else {
            // Get the detail vie
            //if($this->strSubmit == '') {
                $this->page = $this->objModel->getDetail($this->intID);
            //}
        }
    }


    /**
     * Function that sets our Model for the controller
     *
     */
    public function setModel($strPageId, $strAction) {
        $this->objModel = New Group($strPageId, $strAction);

        $this->objModel->setAgency($this->strGridAgency);
        $this->objModel->setAgent($this->strGridAgent);
        $this->objModel->setEmailRead($this->strGridEmailRead);
        $this->objModel->setDateType($this->strGridDateType);
        $this->objModel->setStartDate($this->strStartDate);
        $this->objModel->setEndDate($this->strEndDate);
        $this->objModel->setYear($this->intYear);
        $this->objModel->setMonth($this->intMonth);
    }

    /**
     * Note title
     * Note description
     */
    public function getPageContent() {
        if (empty($this->strAction)) {
            // If the action is empty get the list view
            include(ROOT_DIR.'/application/views/admin/quote_group_list_view.php');
        } else {
            // If the action is set get the edit / add form
            include(ROOT_DIR.'/application/views/admin/detail/'.$this->strView.'.php');
        }
    }



    public function getCourseDDL($courseID) {
        if($courseID != '') {
            $arrCourseSelected = explode("|",$courseID);
            //$arrCourseSelected = $courseID;
        }

        echo '<select name="courses[]" id="courses[]" multiple="multiple" class="form-control" style="height:300px;">';
        echo '<option value="" style="background-color:#B9C5D9;">------ SELECT GOLF COURSE ------</option>';
        foreach($this->arrCourses As $course) {
            echo '<option value="'.$course['id'].'" '.Util::isSelected($arrCourseSelected,$course['id']).'>'.$course['course_name'].'</option>';
        }

        echo'</select>';

    }

    public function getHotelDDL($hotelID) {
        if($hotelID != '') {
            $arrHotelSelected = explode("|",$hotelID);
            //$arrHotelSelected = $hotelID;
        }

        echo '<select name="hotels[]" id="hotels[]" multiple="multiple" class="form-control" style="height:300px;">';
        echo '<option value="" style="background-color:#B9C5D9;">------ SELECT HOTEL ------</option>';
        foreach($this->arrHotels As $hotel) {
            echo '<option value="'.$hotel['id'].'" '.Util::isSelected($arrHotelSelected,$hotel['id']).'>'.$hotel['hotel_name'].'</option>';
        }

        echo'</select>';

    }

    public function getStatusDDL($id, $completed) {
        echo '<select name="completed" id="completed" class="form-control color-coded-select">';
        echo '<option value="0">Please Choose</option>';

        foreach($this->arrStatus As $status) {
            $strStatusColor = '#000000';
            if(!empty($status['color'])){
                $strStatusColor = $status['color'];
            }

            echo '<option value="'.$status['id'].'" '.Util::isSelected($status['id'],$completed).' style="color: ' . $strStatusColor . '">'.$status['status_name'].'</option>';
        }

        echo'</select>';

    }

    public function getBookingDDL($id, $bookingID) {

        echo '<select name="bookingID" id="bookingID" class="form-control">';

        foreach($this->arrBooking As $booking) {
            echo '<option value="'.$booking['id'].'" '.Util::isSelected($booking['id'],$bookingID).'>'.$booking['booking_name'].'</option>';
        }

        echo'</select>';

    }

    public function getBrandDDL($id, $brandID) {

        echo '<select name="brandID" id="brandID" class="form-control">';

        foreach($this->arrBrands As $brand) {
            echo '<option value="'.$brand['id'].'" '.Util::isSelected($brand['id'],$brandID).'>'.$brand['business_name'].'</option>';
        }

        echo'</select>';

    }


    /**
     * Function that creates the list of actions the user can do to the record
     * Edit, Restore, Trash, Delete
     */
    public function getPageControls($id, $slug, $status, $visible = true) {
        $html = '';
        $visibleClass = ($visible) ? '' : 'invisible';

        $html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
        if ($status == 'Trash') {
            $html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/?' . $this->strOptions . '&amp;sub=true">Restore</a></li>';
            $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/?' . $this->strOptions . '&amp;sub=true\');" class="text-danger">Permanently Delete</a></li>';
        } else {
            if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
            $html .= '<li><a href="'.$this->strGroupSlug.'' . $id . '/?' . $this->strOptions . '&amp;sub=true">Edit</a></li>';
            }
            if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
                $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/?' . $this->strOptions . '&amp;sub=true\');" class="text-danger">Trash</a></li>';
            }
        }
        $html .= '</ul>';

        return $html;
    }



    public function getPageGridControls($id, $slug) {

        $html = '<a href="'.$slug.'edit/'.$id.'/?'.$this->strOptions.'&amp;sub=true"><i class="fa fa-pencil fa-lg"></i></a> |
             <a href="javascript:confirmDelete(\''.$slug.'trash/'.$id.'/\');"><i class="fa fa-trash-o fa-lg"></i></a>';

        return $html;
    }

    /**
     * Exports the data as a CSV
     *
     */
    public function export() {
        // Get all package data
        $arrQuoteData = $this->objModel->getList(
            $this->strPgSize,
            $this->strPg,
            $this->strSortBy,
            $this->strSortOrder,
            $this->strSearchWord,
            $this->strStatus,
            $this->strGridDates,
            $this->intGridCategories,
            false
        );

        // Exit if no data
        if (empty($arrQuoteData)) {
            return;
        }

        // Build the CSV rows
        $data = array();
        $i = 0;
        foreach ($arrQuoteData as $r) {
            $data[$i] = array(
                'id' => $r['id'],
                'quote_status' => $r['quote_status'],
                'group_name' => $r['group_name'],
                'user_name' => $r['user_name'],
                'phone' => $r['phone'],
                'cell' => $r['cell_phone'],
                'state' => $r['state'],
                'country' => $r['country'],
                'user_email' => $r['user_email'],
                'golfer_count' => $r['players_num'],
                'order_date' => $r['quote_order_date'],
                'last_edit' => $r['quote_last_edit'],
                'arrival_date' => $r['quote_arrival_date'],
                'repeat' => $r['blnRepeat'],
                'agency' => $r['agency'],
                'agent' => $r['booking_person'],
                'status' => $r['status'],
            );

            $i++;
        }

        // Start the output
        $output = fopen("php://output", 'w+') or die("Can't open php://output");
        header("Content-Type:application/csv");
        header("Content-Disposition:attachment;filename=quote_export.csv");

        // Column headers
        fputcsv($output, array_keys($data[0]));

        // Column data
        foreach($data as $row) {
            fputcsv($output, $row);
        }

        fclose($output) or die("Can't close php://output");
        die; // end of file
    }

}