<?php


class quote_controller extends default_controller {



	public function __construct($strPageId) {

		$this->tab = isset($_REQUEST['tab']) ? $_REQUEST['tab'] : '';
		$this->intGridCompleted = isset($_REQUEST['grid_completed']) ? $_REQUEST['grid_completed'] : '';
		$this->strGridDateType = isset($_REQUEST['grid_date']) && $_REQUEST['grid_date'] != '' ? $_REQUEST['grid_date'] : '';
		$this->strStartDate = isset($_REQUEST['start_date']) ? $_REQUEST['start_date'] : '';
		$this->strEndDate = isset($_REQUEST['end_date']) ? $_REQUEST['end_date'] : '';
		$this->intYear = isset($_REQUEST['year']) ? $_REQUEST['year'] :  date("Y");
		$this->intMonth = isset($_REQUEST['month']) ? $_REQUEST['month'] : '';

		$this->intGroupId = isset($_REQUEST['group']) ? $_REQUEST['group'] : '';

		$this->strGroupName = null;
		$this->strGroupStatus = null;
		$this->strAdminNote = null;
		if(!empty($this->intGroupId)){
			// lookup group name for current group of quotes
			$this->strGroupName = Group::getGroupName($this->intGroupId);
			$this->strGroupStatus = Group::getGroupStatus($this->intGroupId);
			$this->strAdminNote = Group::getGroupAdminNote($this->intGroupId);
		}

		$this->strSortBy = 'edit_date';
		
		$this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];
        
        // print_r($_REQUEST);die();

		//this handles post back variables, decides which method to use for the dataset
        parent::__construct($strPageId);

		$this->strTableName = 'quotes';
		$this->strAdminSlug = '/admin/quote/' . $this->intGroupId . '/';
		$this->strGroupsSlug = '/admin/quote-group/';

		$this->arrTableSQLArray = array('', 'group_name', 'quote_name', 'user_name','players_num','business_name','booking_name','order_date','status','ready_to_book', 'date_created', 'edit_date');
		$this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">', 'Group Name','Quote Name', 'User Name','Golfers','Agency','Booking Person','Original Inquiry Date','Status','Ready to Book','Date Created', 'Date Modified');
		$this->arrTableSortArray = array(false, false, true,true,true,false,true,true,true,true,false, true);

		$this->strOptions = '&searchWord='.$this->strSearchWord . '&amp;status='.$this->strStatus;

		$this->arrStatus = $this->objModel->getStatus();

		$this->arrBookingPeople = $this->objModel->getBookingPeople($this->intID);

		if($this->strAction == '') {
			if(!empty($this->strGroupName)){
				// append group name if there is one to the page title
				$this->objModel->strTitle = $this->objModel->strTitle . ' for ' . $this->strGroupName;
			}

			$this->strView =   'list_quotes';

		} else {

			$this->arrBooking = $this->objModel->getBooking();
			$this->arrBrands = $this->objModel->getBrands();
			$this->arrHotels = $this->objModel->getHotels();
			$this->arrCourses = $this->objModel->getCourses();
			$this->arrNotes = $this->objModel->getNotesForQuote($this->intID);

			if(isset($_REQUEST['success_message']) && !empty($_REQUEST['success_message'])){
				$this->strSuccessMessage = urldecode($_REQUEST['success_message']);
			}

			if(isset($_REQUEST['error_message']) && !empty($_REQUEST['error_message'])){
				$this->strErrorMessage = urldecode($_REQUEST['error_message']);
			}

			$this->strView =   'quote_form';
		}


	}


	public function doActions() {
		// Update / edit
		if($this->strSubmit != '') {
			$this->intID = $this->objModel->handlePost($_POST, $this->intID);
		}
		// Trash
		if($this->strTrash != '') {
			$this->objModel->updateStatus($this->intID,'Trash');
		}
		// Restore
		if($this->strRestore != '') {
			$this->objModel->updateStatus($this->intID,'Active');
		}
		// Delete
		if($this->strDelete != '') {
			Quote::deleteQuote($this->intID);
			$this->intID = '';
			$this->strAction = '';
		}

		// Bulk Actions
		if($this->strBulk != '') {
			$this->csvPageID = isset($_REQUEST['pageID']) ? implode($_REQUEST['pageID'],',') : "";
			if($this->strBulk == 'trash') {
				$this->objModel->updateStatus($this->csvPageID,'Trash');
			} else if($this->strBulk == 'restore') {
				$this->objModel->updateStatus($this->csvPageID,'Active');
			}
		}

		switch(strtolower($this->strAction)){
			case 'updategroup':
				// update the name/status of this group
				$arrPost['group_name'] = isset($_POST['group_name']) ? $_POST['group_name'] : '';
				$arrPost['status'] = isset($_POST['status']) ? $_POST['status'] : '';
				$arrPost['admin_note'] = isset($_POST['admin_note']) ? $_POST['admin_note'] : '';

				$objGroup = new Group;
				$objGroup->handlePost($arrPost, $this->intGroupId);

				$this->strGroupSuccessMessage = $objGroup->strSuccessMessage;
				$this->strGroupErrorMessage = $objGroup->strErrorMessage;

				// get the new group name, we got the it before it was changed (in controller creator)
				if(!empty($this->intGroupId)){
					// lookup group name for current group of quotes
					$this->strGroupName = Group::getGroupName($this->intGroupId);
				}

				// get the new group status, we got the it before it was changed (in controller creator)
				if(!empty($this->intGroupId)){
					// lookup group name for current group of quotes
					$this->strGroupStatus = Group::getGroupStatus($this->intGroupId);
				}



				// reset action to show multi-view
				$this->strAction = '';
				break;

			case 'duplicate':
				$blnError = false;
				$intNewGroup = null;

				switch(strtolower($_REQUEST['group_type'])){
					case 'current':
						$intNewGroup = $_REQUEST['group'];
						break;

					case 'existing':
						$intNewGroup = $_REQUEST['existing_group'];
						break;

					case 'new':
						$strGroupName = isset($_REQUEST['group_name']) ? $_REQUEST['group_name'] : null;

						$intNewGroup = Group::createGroup($strGroupName);

						if($intNewGroup === false){
							// error occured
							$this->objModel->strErrorMessage = 'Quote group could not be created.';
							$blnError = true;
						}
						break;

					default:
						$intNewGroup = $this->intGroupId;
						break;
				}

				if(!$blnError){
					// only run if we are successfull up to this point
					$intNewId = $this->objModel->duplicateQuote($this->intID, $intNewGroup);

					if($intNewId !== false){

						// new quote was created so redirect to it
						header('Location: /admin/quote/' . $intNewGroup . '/edit/' . $intNewId . '/');
						die();
						break;
					}
				}

				// something went wrong, redirect to list page
				$this->strAction = '';
				break;

			case 'convert-package':
				// try to conver to package
				$intNewPackageId = $this->objModel->convertPackage($this->intID);

				if($intNewPackageId !== false){
					// new quote was created so redirect to it
					$strSuccessMessage = urlencode('Package successfully created from quote.');

					header('Location: /admin/package/edit/' . $intNewPackageId . '/?success_message=' . $strSuccessMessage);
					die();
					break;
				}

				// error occured, message already set to model
				$this->strAction = '';
				break;

            case 'copy-quote':

                $intNewQuoteId = $this->objModel->copyQuoteById($this->intID);

                if($intNewQuoteId !== false){
                    // new quote was created so redirect to it
                    $strSuccessMessage = urlencode('quote copied.');

                    header('Location: /admin/quote/' . $intNewQuoteId . '/?success_message=' . $strSuccessMessage);
                    die();
                    break;
                }

                break;

			case 'convert-from-package':
				$intPackageId = $this->intID;

				$objQuote = $this->objModel->convertFromPackage($intPackageId);

				if(empty($objQuote->strErrorMessage)){
					// new quote was created so redirect to it
					$strSuccessMessage = urlencode('Quote successfully created from package.');

					header('Location: /admin/quote/' . $objQuote->intGroupID . '/edit/' . $objQuote->intId . '/?success_message=' . $strSuccessMessage);
					die();
					break;
				}

				// error occured, message already set to model
				$strErrorMessage = $objQuote->strErrorMessage;
				header('Location: /admin/package/edit/'. $intPackageId . '/?error_message=' . $strErrorMessage);
				die();
				break;
		}

		// Set our admin messages after the model functions run
		$this->strErrorMessage = $this->objModel->strErrorMessage;
		$this->strSuccessMessage = $this->objModel->strSuccessMessage;

		// Get the Grid / Detail view
		if($this->strAction == '') {
		    $checkaccess = $this->objModel->checkpageaccess('quote-group', 'edit');
		    if(!$checkaccess){
                header("Location: /admin");
            }
            
			// Get the Page Array
			$this->arrGroups = Group::getAllGroups(null, 'ISNULL(`group_name`), `group_name` ASC');

			$this->arrPages = $this->objModel->getList($this->strPgSize,$this->strPg,$this->strSortBy,
			$this->strSortOrder,$this->strSearchWord,$this->strStatus,$this->strGridDates,$this->intGridCategories, $this->intGroupId, false);

			$this->strQuery = $this->objModel->strQuery;
		} else {
		  //  print_r($_REQUEST);die();
		    if(isset($this->intID)){
		        $checkaccess = $this->objModel->checkpageaccess('quote', $this->module);
    		    if(!$checkaccess){
                    header("Location: /admin");
                } 
		    }else{
		        $checkaccess = $this->objModel->checkpageaccess($this->controller, $this->module);
    		    if(!$checkaccess){
                    header("Location: /admin");
                }  
		    }
		    
            
			// Get the detail vie
			//if($this->strSubmit == '') {
				$this->page = $this->objModel->getDetail($this->intID);
			//}
		}
	}

	/**
	 * Function that sets our Model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {
		$this->objModel = New Quote($strPageId, $strAction);

		$this->objModel->setStatus($this->intGridCompleted);
		$this->objModel->setDateType($this->strGridDateType);
		$this->objModel->setStartDate($this->strStartDate);
		$this->objModel->setEndDate($this->strEndDate);
		$this->objModel->setYear($this->intYear);
		$this->objModel->setMonth($this->intMonth);
	}

	/**
	 * Note title
	 * Note description
	 */
	public function getPageContent() {
		if (empty($this->strAction)) {
			// If the action is empty get the list view
			include(ROOT_DIR.'/application/views/admin/quote_list_view.php');
		} else {
			// If the action is set get the edit / add form
			include(ROOT_DIR.'/application/views/admin/detail/'.$this->strView.'.php');
		}
	}



	public function getCourseDDL($courseID) {
		if($courseID != '') {
			$arrCourseSelected = explode("|",$courseID);
			//$arrCourseSelected = $courseID;
		}

		echo '<select name="courses[]" id="courses[]" multiple="multiple" class="form-control" style="height:300px;">';
		echo '<option value="" style="background-color:#B9C5D9;">------ SELECT GOLF COURSE ------</option>';
		foreach($this->arrCourses As $course) {
			echo '<option value="'.$course['id'].'" '.Util::isSelected($arrCourseSelected,$course['id']).'>'.$course['course_name'].'</option>';
		}

		echo'</select>';

	}

	public function getHotelDDL($hotelID) {
		if($hotelID != '') {
			$arrHotelSelected = explode("|",$hotelID);
			//$arrHotelSelected = $hotelID;
		}

		echo '<select name="hotels[]" id="hotels[]" multiple="multiple" class="form-control" style="height:300px;">';
		echo '<option value="" style="background-color:#B9C5D9;">------ SELECT HOTEL ------</option>';
		foreach($this->arrHotels As $hotel) {
			echo '<option value="'.$hotel['id'].'" '.Util::isSelected($arrHotelSelected,$hotel['id']).'>'.$hotel['hotel_name'].'</option>';
		}

		echo'</select>';

	}

	public function getStatusDDL($id, $completed) {
		echo '<select name="completed" id="completed" class="form-control color-coded-select">';
		echo '<option value="0">Please Choose</option>';

		foreach($this->arrStatus As $status) {
			$strStatusColor = '#000000';
			if(!empty($status['color'])){
				$strStatusColor = $status['color'];
			}

			echo '<option value="'.$status['id'].'" '.Util::isSelected($status['id'],$completed).' style="color: ' . $strStatusColor . '">'.$status['status_name'].'</option>';
		}

		echo'</select>';

	}

	public function getBookingDDL($id, $bookingID) {

		echo '<select name="bookingID" id="bookingID" class="form-control">';

		foreach($this->arrBooking As $booking) {
			echo '<option value="'.$booking['id'].'" '.Util::isSelected($booking['id'],$bookingID).'>'.$booking['booking_name'].'</option>';
		}

		echo'</select>';

	}

	public function getBrandDDL($id, $brandID) {

		echo '<select name="brandID" id="brandID" class="form-control">';

		foreach($this->arrBrands As $brand) {
			echo '<option value="'.$brand['id'].'" '.Util::isSelected($brand['id'],$brandID).'>'.$brand['business_name'].'</option>';
		}

		echo'</select>';

	}


	/**
	 * Function that creates the list of actions the user can do to the record
	 * Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true) {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
		if ($status == 'Trash') {
			$html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/?sub=true' . $this->strOptions . '">Restore</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/?sub=true' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
		} else {
		    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
			$html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/?sub=true' . $this->strOptions . '">Edit</a></li>';
		    }
			if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
			    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/?sub=true' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
			}
		    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'add')){
			$html .= '<li><a href="#" class="js-btn-duplicate-quote" data-quote-id="' . $id . '">Duplicate</a></li>';
		    }
		}
		$html .= '</ul>';

		return $html;
	}



	public function getPageGridControls($id, $slug) {

		$html = '<a href="'.$slug.'edit/'.$id.'/?sub=true'.$this->strOptions.'"><i class="fa fa-pencil fa-lg"></i></a> |
             <a href="javascript:confirmDelete(\''.$slug.'trash/'.$id.'/\');"><i class="fa fa-trash-o fa-lg"></i></a>';

		return $html;
	}




}