<?php


class profile_controller extends default_controller {


	public function __construct($strPageId) {
		
		$_SESSION['userID'] = isset($_SESSION['userID']) ? $_SESSION['userID'] : '';
		$this->intUserID = $_SESSION['userID'];

		parent::__construct($strPageId);

		//the model for this controller
		$this->objModel = New Profile($_SESSION['userID']);

		//page specific data
		$this->strTitle = "Your Profile";


		$this->page = $this->objModel->getDetail();

		$this->strView =   'detail/profile';
		
	}


	/**
	 * Function that sets the model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New Profile($_SESSION['userID']);

	}


	/**
	 * Function that controls what actions / views are used
	 *
	 */
	public function doActions() {

		// Update / edit
		if($this->strSubmit != '') {
			$this->intUserID = $this->objModel->handlePost($_POST, $this->intUserID);
			$this->strErrorMessage = $this->objModel->strErrorMessage;
			$this->strSuccessMessage = $this->objModel->strSuccessMessage;
		}

		// Get the detail view
		$this->page = $this->objModel->getDetail($this->intUserID);


	}


	public function getPageContent() {

		include(ROOT_DIR.'/application/views/admin/'.$this->strView.'.php');

	}

}