<?php


class page_controller extends default_controller {

	public function __construct($strPageId) {


        $this->strSortBy = 'cat_id DESC, nav_order';
        $this->strSortOrder = 'ASC';
        
        $this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];


        parent::__construct($strPageId);

		$this->strTableName = 'pages';
		$this->strAdminSlug = '/admin/page/';
        $this->tab = isset($_REQUEST['tab']) ? $_REQUEST['tab'] : '';

		$this->arrTableSQLArray = array('','nav_order','title','category_name','pub_status','date_created','date_modified','score_seo');
		$this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">','Order','Page Name','Category','Status','Created Date','Last Modified','SEO Score');
		$this->arrTableSortArray = array(false,true,true,true,true,true,true, true);

        $this->strOptions = '?searchWord='.$this->strSearchWord . '&amp;grid_categories='.$this->intGridCategories . '&amp;status='.$this->strStatus;

        if($this->intID == ''){
            $this->arrImages = array();
        } else {
            $this->arrImages = $this->objModel->getPageImageList($this->intID);
        }

        if($this->strAction == '') {
            $this->strView =   'list_pages';
        } else {
            $this->strView =   'page_form';
        }

	}


    /**
     * Function that sets the model for the controller
     *
     */
    public function setModel($strPageId, $strAction) {

        $this->objModel = New aPage($strPageId, $strAction);

    }

    /**
     * Note title
     * Note description
     */
    public function getPageContent() {
        if (empty($this->strAction)) {
            // If the action is empty get the list view
            include(ROOT_DIR.'/application/views/admin/default_list_view.php');
        } else {
            // If the action is set get the edit / add form
            include(ROOT_DIR.'/application/views/admin/detail/'.$this->strView.'.php');
        }
    }

    public function getPageControls($id, $slug, $status, $lock = false, $visible = true) {
        $html = '';
        $visibleClass = ($visible) ? '' : 'invisible';

        $html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
        if ($status == 'Trash') {
            $html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/' . $this->strOptions . '">Restore</a></li>';
            $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
        
        } else {
            if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
            $html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/' . $this->strOptions . '">Edit</a></li>';
            }
            $html .= '<li><a href="/'.$slug.'/" target="_blank">View</a></li>';
            if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
                if(!$lock){
                    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
                }
            }
        }
        $html .= '</ul>';

        return $html;
    }




}