<?php


class package_hotel_controller extends default_controller {

	//public $imgID;


	public function __construct($strPageId) {


		$this->intID = isset($_REQUEST['id']) ? $_REQUEST['id'] : $this->intID;
		$this->intRelHotelID = isset($_REQUEST['rel_id']) ? $_REQUEST['rel_id'] : '';
		$this->strTableName = 'package_hotel';
		
		$this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

        parent::__construct($strPageId);

		$this->strAdminSlug = '/admin/package/edit/'.$this->intID.'/';
		$this->strOptions = '&amp;tab=booking&amp;searchWord='.$this->strSearchWord . '&amp;status='.$this->strStatus;


		if($this->strAction == '') {
			$this->strView =   'list_package_hotels';
		} else {
			$this->arrSelectedRates = $this->objModel->getSelectedRates();
			//$typeID = $this->page['type_id'];
			$this->arrHotels = $this->objModel->getHotels();
			//$this->arrDetails = $this->objModel->getHotelDetails($this->intRelHotelID,false);
			$this->arrDetails = $this->objModel->arrDetails;

			$this->strView =   'package_hotel_form';
		}

		//var_dump($this->arrSelectedRates);

	}


	/**
	 * Function that sets our Model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New Packagehotels();

	}


	public function getHotelDDL($hotelID) {

		echo '<select name="hotel_id" id="hotel_id" class="form-control input-sm">';
		echo '<option value="" style="background-color:#B9C5D9;">------ SELECT HOTEL ------</option>';
		foreach($this->arrHotels As $hotel) {
			echo '<option value="'.$hotel['id'].'" '.Util::isSelected($hotel['id'],$hotelID).'>'.$hotel['hotel_name'].'</option>';
		}

		echo'</select>';

	}


	/**
	 * Function that creates the list of actions the user can do to the record
	 * Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true) {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
		if ($status == 'Trash') {
			$html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/' . $this->strOptions . '">Restore</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
		} else {
		    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
			$html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/' . $this->strOptions . '">Edit</a></li>';
		    }
			if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
			    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
			}
		}
		$html .= '</ul>';

		return $html;
	}





		/**
	 * Function that controls what actions / views are used
	 *
	 */
	public function doActions() {

		// Update / edit
		if($this->strSubmit != '') {
			$this->intRelHotelID = $this->objModel->handlePost($_POST, $this->intID,false);
			$this->strErrorMessage = $this->objModel->strErrorMessage;
			$this->strSuccessMessage = $this->objModel->strSuccessMessage;
		}
		// Trash
		if($this->strTrash != '') {
			//$this->objModel->updateStatus($this->intRelCourseID,'Trash',false);
			$this->objModel->deleteRecord($this->intRelHotelID,false);

			header( 'Location: /admin/package/edit/'.$this->intID.'/?tab=booking' );
			$this->strErrorMessage = $this->objModel->strErrorMessage;
			$this->strSuccessMessage = $this->objModel->strSuccessMessage;
		}
		// Restore
		if($this->strRestore != '') {
			$this->objModel->updateStatus($this->intRelHotelID,'Active',false);
			header( 'Location: /admin/package/edit/'.$this->intID.'/?tab=booking' );
			$this->strErrorMessage = $this->objModel->strErrorMessage;
			$this->strSuccessMessage = $this->objModel->strSuccessMessage;
		}
		// Delete
		if($this->strDelete != '') {
			$this->objModel->deleteRecord($this->intRelHotelID,false);
			header( 'Location: /admin/package/edit/'.$this->intID.'/?tab=booking' );
			$this->strErrorMessage = $this->objModel->strErrorMessage;
			$this->strSuccessMessage = $this->objModel->strSuccessMessage;
		}

		// Bulk Actions
		if($this->strBulk != '') {
			$this->csvPageID = isset($_REQUEST['pageID']) ? implode($_REQUEST['pageID'],',') : "";
			if($this->strBulk == 'trash') {
				$this->objModel->updateStatus($this->csvPageID,'Trash');
			} else if($this->strBulk == 'restore') {
				$this->objModel->updateStatus($this->csvPageID,'Active');
			}
		}

		// Get the Grid / Detail view
		if($this->strAction == '') {
			// Get the Page Array
			$this->arrPages = $this->objModel->getList($this->strPgSize,$this->strPg,$this->strSortBy,
				$this->strSortOrder,$this->strSearchWord,$this->strStatus,$this->strGridDates,$this->intGridCategories,false);

			$this->strQuery = $this->objModel->strQuery;
		} else {
			// Get the detail view
			if($this->strSubmit == '') {
				$this->page = $this->objModel->getDetail($this->intRelHotelID,false);
			}
		}
	}






}