<?php


class package_controller extends default_controller {


	public function __construct($strPageId) {

		$this->tab = isset($_REQUEST['tab']) ? $_REQUEST['tab'] : '';
		$this->intGridCompleted = isset($_REQUEST['grid_completed']) ? $_REQUEST['grid_completed'] : '';
		$this->strGridDateType = isset($_REQUEST['grid_date']) && $_REQUEST['grid_date'] != '' ? $_REQUEST['grid_date'] : '';
		$this->strStartDate = isset($_REQUEST['start_date']) ? $_REQUEST['start_date'] : '';
		$this->strEndDate = isset($_REQUEST['end_date']) ? $_REQUEST['end_date'] : '';
		$this->intYear = isset($_REQUEST['year']) ? $_REQUEST['year'] :  '';
		$this->intMonth = isset($_REQUEST['month']) ? $_REQUEST['month'] : '';

		$this->strSortBy = 'dates_booking';
		
		$this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

		//this handles post back variables, decides which method to use for the dataset
        parent::__construct($strPageId);

		$this->strTableName = 'packages';
		$this->strAdminSlug = '/admin/package/';

		$this->arrTableSQLArray = array('','group_name','user_name', 'user_email','golfer_num','golfer_unpaid','package_total','package_paid','business_name','booking_name','dates_booking','check_in_date','status_name');
		$this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">','Group Name','User Name', 'User Email','Golfers','Unpaid','Package Total','Package Paid','Agency','Booking Person','Booking Date','Arrival Date','Status');
		$this->arrTableSortArray = array(false,true,true,true,true,true,true,true,true,true,true,true,true);

		$this->strOptions = '&searchWord='.$this->strSearchWord . '&amp;status='.$this->strStatus;

		$this->arrStatus = $this->objModel->getStatus();

		$this->arrBookingPeople = $this->objModel->getBookingPeople($this->intID);

		if($this->strAction == '') {
			$this->strView =   'list_packages';

		} else {

			$this->arrBooking = $this->objModel->getBooking();
			$this->arrBrands = $this->objModel->getBrands();
			$this->arrHotels = $this->objModel->getHotels();
			$this->arrHotelsNotUses = $this->objModel->getHotelsNotUsed($this->intID);
			$this->arrCourses = $this->objModel->getCourses();
			$this->arrNotes = $this->objModel->getNotesForPackage($this->intID);

			if(isset($_REQUEST['success_message']) && !empty($_REQUEST['success_message'])){
				$this->strSuccessMessage = urldecode($_REQUEST['success_message']);
			}

			if(isset($_REQUEST['error_message']) && !empty($_REQUEST['error_message'])){
				$this->strErrorMessage = urldecode($_REQUEST['error_message']);
			}

			$this->strView =   'package_form';
		}


	}


	/**
	 * Function that sets our Model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New Package($strPageId, $strAction);
		$this->objModel->setStatus($this->intGridCompleted);
		$this->objModel->setDateType($this->strGridDateType);
		$this->objModel->setStartDate($this->strStartDate);
		$this->objModel->setEndDate($this->strEndDate);
		$this->objModel->setYear($this->intYear);
		$this->objModel->setMonth($this->intMonth);
	}

	/**
	 * Note title
	 * Note description
	 */
	public function getPageContent() {
		if (empty($this->strAction)) {
			// If the action is empty get the list view
			include(ROOT_DIR.'/application/views/admin/package_list_view.php');
		} else {
			// If the action is set get the edit / add form
			include(ROOT_DIR.'/application/views/admin/detail/'.$this->strView.'.php');
		}
	}



	public function getCourseDDL($courseID) {
		if($courseID != '') {
			$arrCourseSelected = explode("|",$courseID);
			//$arrCourseSelected = $courseID;
		}

		echo '<select name="courses[]" id="courses[]" multiple="multiple" class="form-control" style="height:300px;">';
		echo '<option value="" style="background-color:#B9C5D9;">------ SELECT GOLF COURSE ------</option>';
		foreach($this->arrCourses As $course) {
			echo '<option value="'.$course['id'].'" '.Util::isSelected($arrCourseSelected,$course['id']).'>'.$course['course_name'].'</option>';
		}

		echo'</select>';

	}

	public function getHotelDDL($hotelID) {
		if($hotelID != '') {
			$arrHotelSelected = explode("|",$hotelID);
			//$arrHotelSelected = $hotelID;
		}

		echo '<select name="hotels[]" id="hotels[]" multiple="multiple" class="form-control" style="height:300px;">';
		echo '<option value="" style="background-color:#B9C5D9;">------ SELECT HOTEL ------</option>';
		foreach($this->arrHotels As $hotel) {
			echo '<option value="'.$hotel['id'].'" '.Util::isSelected($arrHotelSelected,$hotel['id']).'>'.$hotel['hotel_name'].'</option>';
		}

		echo'</select>';

	}

	public function getStatusDDL($id, $completed) {
		echo '<select name="completed" id="completed" class="form-control color-coded-select">';
		echo '<option value="0">Please Choose</option>';

		foreach($this->arrStatus As $status) {
			$strStatusColor = '#000000';
			if(!empty($status['color'])){
				$strStatusColor = $status['color'];
			}

			echo '<option value="'.$status['id'].'" '.Util::isSelected($status['id'],$completed).' style="color: ' . $strStatusColor . '">'.$status['status_name'].'</option>';
		}

		echo'</select>';

	}

	public function getBookingDDL($id, $bookingID) {

		echo '<select name="bookingID" id="bookingID" class="form-control">';

		foreach($this->arrBooking As $booking) {
			echo '<option value="'.$booking['id'].'" '.Util::isSelected($booking['id'],$bookingID).'>'.$booking['booking_name'].'</option>';
		}

		echo'</select>';

	}

	public function getBrandDDL($id, $brandID) {

		echo '<select name="brandID" id="brandID" class="form-control">';

		foreach($this->arrBrands As $brand) {
			echo '<option value="'.$brand['id'].'" '.Util::isSelected($brand['id'],$brandID).'>'.$brand['business_name'].'</option>';
		}

		echo'</select>';

	}


	/**
	 * Function that creates the list of actions the user can do to the record
	 * Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true) {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
		if ($status == 'Trash') {
			$html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/?sub=true' . $this->strOptions . '">Restore</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/?sub=true' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
		} else {
		    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
			$html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/?sub=true' . $this->strOptions . '">Edit</a></li>';
		    }
			if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
			    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/?sub=true' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
			}
		}
		$html .= '</ul>';

		return $html;
	}



	public function getPageGridControls($id, $slug) {

		$html = '<a href="'.$slug.'edit/'.$id.'/?sub=true'.$this->strOptions.'"><i class="fa fa-pencil fa-lg"></i></a> |
             <a href="javascript:confirmDelete(\''.$slug.'trash/'.$id.'/\');"><i class="fa fa-trash-o fa-lg"></i></a>';

		return $html;
	}

	public function getPageGridGolfControls($id, $slug){
		return $this->getPageGridControls($id, $slug);
	}

	public function getPageGridHotelControls($id, $slug) {

		$html = '<a href="'.$slug.'edit/'.$id.'/?sub=true'.$this->strOptions.'"><i class="fa fa-pencil fa-lg"></i></a> | '
			  . '<a href="#" class="js-duplicate-package-hotel" data-package-hotel-id="' . $id . '" data-package-id="' . $this->intID . '"><i class="fa fa-files-o fa-lg"></i></a> | '
			  . '<a href="javascript:confirmDelete(\''.$slug.'trash/'.$id.'/\');"><i class="fa fa-trash-o fa-lg"></i></a>';

		return $html;
	}


}
