<?php


class member_controller extends default_controller {

	public function __construct($strPageId) {
	    
	    $this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

		parent::__construct($strPageId);

		$this->strTableName = 'member';
		$this->strAdminSlug = '/admin/member/';

		$this->arrTableSQLArray = array('','last_name','email','phone','country_id','state_id','city_id');
		$this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">','Name','Email','Phone','Country','Province','City');
		$this->arrTableSortArray = array(false,true,true,true,false,false,false);

		$this->strOptions = '&searchWord='.$this->strSearchWord . '&amp;status='.$this->strStatus;


		if($this->strAction != ''){
			$this->objLocation = new Location;
			$this->arrCountries = $this->objLocation->getCountries();
			$this->arrStates = $this->objLocation->getStates($this->page['country_id']);
			$this->arrCities = $this->objLocation->getCities($this->page['state_id']);
			$this->arrProviders = $this->objModel->getProviders();
		}

		if($this->strAction == '') {
			$this->strView =   'list_members';
		} else {
			$this->strView =   'member_form';


		}
	}


	/**
	 * Function that sets our Model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New Member($strPageId, $strAction);

	}

	/**
	 * Function that creates the list of actions the user can do to the record
	 * Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true) {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
		if ($status == 'Trash') {
			$html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/?sub=true' . $this->strOptions . '">Restore</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/?sub=true' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
		} else {
		    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
			$html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/?sub=true' . $this->strOptions . '">Edit</a></li>';
		    }
			if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
			    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/?sub=true' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
			}
		}
		$html .= '</ul>';

		return $html;
	}


}



?>