<?php


class mass_mailer_controller extends default_controller {

    public function __construct($strPageId) {
        
        $this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

        parent::__construct($strPageId);

        // Page specific data
        $this->strTitle = $this->objModel->strTitle;
        //$this->page = $this->objModel->getDetail();
        //$this->page = $this->page[0];

    }


    /**
     * Function that sets our Model for the controller
     *
     */
    public function setModel($strPageId, $strAction) {

        // The model for this controller is in the helpers folder (special case for site settings)
        $this->objModel = New Mass_Mailer();

        $this->arrBrands = $this->objModel->getBrands();
        $this->arrBookingPeople = $this->objModel->getBookingPeople();
        $this->arrPackageStatus = $this->objModel->getPackageStatus();

        $this->arrCourses = $this->objModel->getCourses();
        $this->arrHotels = $this->objModel->getHotels();
    }

    public function getBrandDDL($brandID, $strNameID = 'brandID') {

        echo '<select name="'.$strNameID.'" id="'.$strNameID.'" class="form-control">';
        echo '<option value=""></option>';

        foreach($this->arrBrands As $brand) {
            echo '<option value="'.$brand['id'].'" '.Util::isSelected($brand['id'],$brandID).'>'.$brand['business_name'].'</option>';
        }

        echo'</select>';

    }

    public function getBookingPeopleDDL($bookingID, $strNameID = 'bookingAgentID') {

        echo '<select name="'.$strNameID.'" id="'.$strNameID.'" class="form-control">';
        echo '<option value=""></option>';

        foreach($this->arrBookingPeople As $booking_person) {
            echo '<option value="'.$booking_person['id'].'" '.Util::isSelected($booking_person['id'],$bookingID).'>'.$booking_person['booking_name'].'</option>';
        }

        echo'</select>';

    }

    public function getEmailsReadDDL($strEmailsRead) {

        echo '<select name="emails_read" id="emails_read" class="form-control">';

        $arrEmailsRead = array(
            array(
                'value' => '',
                'name' => ''
            ),
            array(
                'value' => '1',
                'name' => 'Yes'
            ),
            array(
                'value' => '0',
                'name' => 'No'
            ),
        );

        foreach($arrEmailsRead As $arrEmailRead) {
            echo '<option value="'.$arrEmailRead['value'].'" '.Util::isSelected($arrEmailRead['value'],$strEmailsRead).'>'.$arrEmailRead['name'].'</option>';
        }

        echo'</select>';

    }

    public function getPackageStatus($packageStatusID, $strNameID = 'packageStatusID') {

        echo '<select name="'.$strNameID.'" id="'.$strNameID.'" class="form-control">';
        echo '<option value=""></option>';

        foreach($this->arrPackageStatus As $package_status) {
            $strStatusColor = '#000000';
            if(!empty($package_status['color'])){
                $strStatusColor = $package_status['color'];
            }
            echo '<option  style="color: ' . $strStatusColor . '" value="'.$package_status['id'].'" '.Util::isSelected($package_status['id'],$packageStatusID).'>'.$package_status['status_name'].'</option>';
        }

        echo'</select>';

    }

    /**
     * Function that controls what actions / views are used
     *
     */
    public function doActions() {
        if($this->strSubmit != '') {
            $this->objModel->handlePost($_POST);
            $this->strErrorMessage = $this->objModel->strErrorMessage;
            $this->strSuccessMessage = $this->objModel->strSuccessMessage;
        }
    }


    /**
     * Controlls the view that gets loaded
     *
     */
    public function getPageContent() {

        include(ROOT_DIR.'/application/views/admin/detail/mass_mailer.php');

    }


}