<?php


class hotel_videos_controller extends default_controller {

	public $imgID;


	public function __construct($strPageId) {
	    
	    $this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

        parent::__construct($strPageId);
		$this->strTableName = 'hotel_videos';
		$this->strAdminSlug = '/admin/hotel/edit/'.$this->intID.'/';

		//$this->arrTableSQLArray = array('','display_order','title','blnPrimary','');
		//$this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">','Order','Image','Caption','Primary','Actions');
		//$this->arrTableSortArray = array(false,true,true,true,false);

		$this->strOptions = '?tab=videos&amp;searchWord='.$this->strSearchWord . '&amp;status='.$this->strStatus;

		if($this->strAction == '') {
			$this->strView =   'list_hotel_videos';
		} else {
			$this->strView =   'hotel_video_form';
		}


	}


	/**
	 * Function that sets our Model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New Hotelvideo($strPageId, $strAction);

	}


	/**
	 * Function that creates the list of actions the user can do to the record
	 * Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true) {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
		if ($status == 'Trash') {
			$html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/' . $this->strOptions . '">Restore</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
		} else {
		    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
			$html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/' . $this->strOptions . '">Edit</a></li>';
		    }
			if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
			    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
			}
		}
		$html .= '</ul>';

		return $html;
	}


	/**
	 * Function that sets our base controller variables
	 *
	 */
	public function setRequestVariables() {
		$this->intID = isset($_REQUEST['id']) ? $_REQUEST['id'] : $this->intID;
		$this->intVideoID = isset($_REQUEST['video_id']) ? $_REQUEST['video_id'] : '';
		$this->strPg = (isset($_REQUEST['pg']) && $_REQUEST['pg'] != '') ? $_REQUEST['pg'] : $this->strPg;
		$this->strPgSize = isset($_REQUEST['pgSize'])  ? $_REQUEST['pgSize'] : $this->strPgSize;
		$this->strSortBy = isset($_REQUEST['sortBy']) ? $_REQUEST['sortBy'] : $this->strSortBy;
		$this->strSortOrder = isset($_REQUEST['sortOrder']) ? $_REQUEST['sortOrder'] : $this->strSortOrder;
		$this->strSearchWord = isset($_REQUEST['searchWord']) ? $_REQUEST['searchWord'] : $this->strSearchWord;
		$this->strStatus = isset($_REQUEST['status']) ? $_REQUEST['status'] : $this->strStatus;
		$this->strGridDates = isset($_REQUEST['grid_dates']) ? $_REQUEST['grid_dates'] : $this->strGridDates;
		$this->intGridCategories = isset($_REQUEST['grid_categories']) ? $_REQUEST['grid_categories'] : $this->intGridCategories;

		$this->strAction = isset($_REQUEST['action']) ? $_REQUEST['action'] : $this->strAction;
		$this->strSubmit = isset($_REQUEST['submit']) ? $_REQUEST['submit'] : $this->strSubmit;
		$this->strTrash = isset($_REQUEST['trash']) ? $_REQUEST['trash'] : $this->strTrash;
		$this->strDelete = isset($_REQUEST['delete']) ? $_REQUEST['delete'] : $this->strDelete;
		$this->strRestore = isset($_REQUEST['restore']) ? $_REQUEST['restore'] : $this->strRestore;
		$this->strBulk = isset($_REQUEST['bulk_action']) ? $_REQUEST['bulk_action'] : $this->strBulk;
		$this->strOptions = '?searchWord='.$this->strSearchWord . '&grid_categories='.$this->intGridCategories . '&status='.$this->strStatus;
	}



		/**
	 * Function that controls what actions / views are used
	 *
	 */
	public function doActions() {

		// Update / edit
		if($this->strSubmit != '') {
			$this->intVideoID = $this->objModel->handlePost($_POST, $this->intID,false);
			$this->strErrorMessage = $this->objModel->strErrorMessage;
			$this->strSuccessMessage = $this->objModel->strSuccessMessage;
		}
		// Trash
		if($this->strTrash != '') {
			$this->objModel->updateStatus($this->intVideoID,'Trash',false);
			header( 'Location: /admin/hotel/edit/'.$this->intID.'/?tab=videos' );
			$this->strErrorMessage = $this->objModel->strErrorMessage;
			$this->strSuccessMessage = $this->objModel->strSuccessMessage;
		}
		// Restore
		if($this->strRestore != '') {
			$this->objModel->updateStatus($this->intVideoID,'Active',false);
			header( 'Location: /admin/hotel/edit/'.$this->intID.'/?tab=videos' );
			$this->strErrorMessage = $this->objModel->strErrorMessage;
			$this->strSuccessMessage = $this->objModel->strSuccessMessage;
		}
		// Delete
		if($this->strDelete != '') {
			$this->objModel->deleteRecord($this->intVideoID,false);
			header( 'Location: /admin/hotel/edit/'.$this->intID.'/?tab=videos' );
			$this->strErrorMessage = $this->objModel->strErrorMessage;
			$this->strSuccessMessage = $this->objModel->strSuccessMessage;
		}

		// Bulk Actions
		if($this->strBulk != '') {
			$this->csvPageID = isset($_REQUEST['pageID']) ? implode($_REQUEST['pageID'],',') : "";
			if($this->strBulk == 'trash') {
				$this->objModel->updateStatus($this->csvPageID,'Trash');
			} else if($this->strBulk == 'restore') {
				$this->objModel->updateStatus($this->csvPageID,'Active');
			}
		}

		// Get the Grid / Detail view
		if($this->strAction == '') {
			// Get the Page Array
			$this->arrPages = $this->objModel->getList($this->strPgSize,$this->strPg,$this->strSortBy,
				$this->strSortOrder,$this->strSearchWord,$this->strStatus,$this->strGridDates,$this->intGridCategories,false);

			$this->strQuery = $this->objModel->strQuery;
		} else {
			// Get the detail view
			$this->page = $this->objModel->getDetail($this->intVideoID,false);

		}
	}






}