<?php


class hotel_controller extends default_controller {

	public function __construct($strPageId) {

		$this->strSortBy = 'edit_date';
		$this->strSortOrder = 'DESC';
		
		$this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

		parent::__construct($strPageId);

		$this->strTableName = 'hotel';
		$this->strAdminSlug = '/admin/hotel/';
		$this->tab = isset($_REQUEST['tab']) ? $_REQUEST['tab'] : '';

		$this->arrTableSQLArray = array('','hotel_name','edit_date','score_seo');
		$this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">','Name','Modified','SEO Score');
		$this->arrTableSortArray = array(false,true,true,true);

		$this->strOptions = '?searchWord='.$this->strSearchWord . '&amp;status='.$this->strStatus;

		if(!isset($this->page['id'])) {

			$this->page['country_id'] = 261;
			$this->page['state_id'] = 2;
			$this->arrImages = Null;
			$this->arrVideos = Null;
			//$this->page['slug'] = '/hotel-detail/hotel/';

		} else {

			$this->arrDocs = $this->objModel->getHotelDocList($this->page['id']);
			$this->arrImages = $this->objModel->getHotelImageList($this->page['id']);
			$this->arrVideos = $this->objModel->getHotelVideoList($this->page['id']);
			//$this->page['slug'] = '/hotel-detail/hotel/'.$this->page['slug'];
		}

		if($this->strAction == '') {
			$this->strView =   'list_hotels';
		} else {

			$this->arrCategories = $this->objModel->getCategories();
			$this->arrManagers = $this->objModel->getManagers();

			$this->objLocation = new Location;
			$this->arrCountries = $this->objLocation->getCountries();
			$this->arrStates = $this->objLocation->getStates($this->page['country_id']);
			$this->arrCities = $this->objLocation->getCities($this->page['state_id'],false);

			//$this->page['slug'] = '/hotel-detail/'.$this->page['slug'];
			$this->strView =   'hotel_form';
		}

	}


	/**
	 * Function that sets our Model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New Hotel($strPageId, $strAction);

	}

	/**
	 * Function that creates the list of actions the user can do to the record
	 * Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true, $guid = '') {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';

        if ($guid != '') {
            $html .= '<li><a target="_blank" href="/application/cron/viewDetailReportHotel.php?guid='. $guid . '">View Detail Weekly Report emailer</a></li>';
            $html .= '<li><a target="_blank" href="/application/cron/viewDetailReportHotelPrint.php?guid='. $guid . '">View full Calendar Detail Report</a></li>';
        }

		if ($status == 'Trash') {
			$html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/' . $this->strOptions . '">Restore</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
		} else {
		    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
			$html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/' . $this->strOptions . '">Edit</a></li>';
		    }
			if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
			    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
			}
		}

		$html .= '</ul>';

		return $html;
	}


}



?>