<?php


class featured_package_controller extends default_controller {

	public function __construct($strPageId) {


		$this->strSortBy = 'end_date';
		$this->strSortOrder = 'DESC';
		
		$this->controller = $_REQUEST['controller'];
        $this->module = $_REQUEST['action'];

        parent::__construct($strPageId);

		$this->strTableName = 'feature_packages';
		$this->strAdminSlug = '/admin/featured_package/';

		$this->tab = isset($_REQUEST['tab']) ? $_REQUEST['tab'] : '';

		$this->arrTableSQLArray = array('','thumb','title','start_date','end_date','price','priority','hits','score_seo');
		$this->arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">','Image','Title','Start','End','Price','Priority','Hits','SEO Score');
		$this->arrTableSortArray = array(false,false,true,true,true,true,true,true,true);

		$this->strOptions = '&searchWord='.$this->strSearchWord . '&amp;status='.$this->strStatus;

		//$this->arrStatus = $this->objModel->getStatus();


		if($this->strAction == '') {
			$this->strView =   'list_featured_packages';
		} else {

			$this->arrBrands = $this->objModel->getBrands();
			//$this->arrSelectedBrands = $this->objModel->getSelectedBrands($_GET['id'],true);
			$this->arrRegions = $this->objModel->getRegions(false);
			$this->arrHotels = $this->objModel->getHotels();
			$this->arrCourses = $this->objModel->getCourses();
			//$this->arrPackageCourses = $this->objModel->getCoursesForPackage($this->intID);



			$this->strView =   'featured_package_form';
		}


	}


	/**
	 * Function that sets our Model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New FeaturedPackage($strPageId, $strAction);

	}

	public function getCourseDDL($courseID) {
		$arrCourseSelected = array();
		if($courseID != '') {
			foreach($courseID As $c){
				$arrCourseSelected[] = $c['courseID'];
			}
		}

		echo '<select name="courses[]" id="courses[]" multiple="multiple" class="form-control input-sm" style="height:300px;">';
		echo '<option value="" style="background-color:#B9C5D9;">------ SELECT GOLF COURSE ------</option>';
		foreach($this->arrCourses As $course) {
			echo '<option value="'.$course['id'].'" '.Util::isSelected($arrCourseSelected,$course['id']).'>'.$course['course_name'].' :: '.$course['title'].'</option>';
		}

		echo'</select>';

	}

	public function getHotelDDL($hotelID) {

		$arrHotelSelected = array();
		if($hotelID != '') {
			foreach($hotelID As $h){
				$arrHotelSelected[] = $h['hotelID'];
			}
		}

		echo '<select name="hotels[]" id="hotels[]" multiple="multiple" class="form-control input-sm" style="height:300px;">';
		echo '<option value="" style="background-color:#B9C5D9;">------ SELECT HOTEL ------</option>';
		foreach($this->arrHotels As $hotel) {
			echo '<option value="'.$hotel['id'].'" '.Util::isSelected($arrHotelSelected,$hotel['id']).'>'.$hotel['hotel_name'].' :: '.$hotel['title'].'</option>';
		}

		echo'</select>';

	}

	public function isHotelInRegion($intHotelId, $intRegionId) {

		if ($intRegionId == '0') {
			return true;
		
		} else{

			$arrResults = $this->objModel->getMysqliResults("SELECT * FROM hotel_region WHERE hotel_id = $intHotelId AND region_id = $intRegionId");
			
			if (count($arrResults) == 0) {
				return false;
			} else {
				return true;
			}
		}

		return false;
	}

	public function isCourseInRegion($intCourseId, $intRegionId) {

		if ($intRegionId == '0') {
			return true;
		
		} else{

			$arrResults = $this->objModel->getMysqliResults("SELECT * FROM course_region WHERE course_id = $intCourseId AND region_id = $intRegionId");
			
			if (count($arrResults) == 0) {
				return false;
			} else {
				return true;
			}
		}

		return false;
	}

	public function getFeaturePackageRateYearDDL($yearPosted) { 

		$strSql = ' SELECT DISTINCT year(end_date) as year FROM hotel_rates
					UNION
					SELECT DISTINCT year(end_date) as year FROM course_rates';

		$arrResults = $this->objModel->getMysqliResults($strSql);

		if ($yearPosted == '') {
			$yearPosted = Date('Y');
		}

		$strHtml = "<select name='filter_year'>
						<option value=''>All years</option>";

		foreach ($arrResults AS $arrYear) {
			$strYear = $arrYear[0];
			$strHtml .= "<option value='$strYear' " . ($yearPosted == $strYear ? 'selected':''). " >$strYear</option>";
		}

		$strHtml .= "</select>";

		return $strHtml;

	}

	public function getFeaturePackageHotelDDL($intPackageId, $intRegionId, $strFilterYear='') {

		$strSql = "SELECT * FROM feature_packages_hotel WHERE packageID = " . $intPackageId;

		$arrResults = $this->objModel->getMysqliResults($strSql, true);
		
		$arrPackageHotels = array();

		if (count($arrResults) > 0) {

			foreach ($arrResults AS $arrResult) {
				$arrPackageHotels[$arrResult['hotelID']] = $arrResult;
			}
		}

		echo "<div class='well well-sm calculator-control-list' style='height:300px; overflow-y:scroll;'>";
		echo "<table class='js-hotels table table-condensed'><thead><tr><th width='30%''>Hotel Name</th><th>Rate</th><th>Room Nights</th><th>Selected</th></tr></thead><tbody>";

		foreach ($this->arrHotels as $hotel) {

			//If hotel is in region or already selected 
			if ((isset($arrPackageHotels[$hotel['id']])) || ($this->isHotelInRegion($hotel['id'], $intRegionId))) {

				$strHotelSelected = isset($arrPackageHotels[$hotel['id']]) ? 'checked' : '';
				$strHotelSelectedRate = isset($arrPackageHotels[$hotel['id']]['rateID']) ? $arrPackageHotels[$hotel['id']]['rateID'] : '';
				$strHotelRoomNights = isset($arrPackageHotels[$hotel['id']]['room_nights']) ? $arrPackageHotels[$hotel['id']]['room_nights'] : '';

				$strSqlFilterYear = '';
				if ($strFilterYear != '') {
					$strSqlFilterYear = " AND year(start_date) = '$strFilterYear' AND year(end_date) = '$strFilterYear' ";
				}

				$strSQL = "SELECT * FROM hotel_rates 
								WHERE (hotel_id = " . $hotel['id'] . " AND parent_id IS NOT NULL AND deleted = 0 $strSqlFilterYear) 
									OR (hotel_id = ". $hotel['id'] . " AND id IN (SELECT rateID FROM feature_packages_hotel WHERE packageID = " . $intPackageId . "))";

				$arrHotelRates = $this->objModel->getMysqliResults($strSQL, true);
				
				//if (!empty($arrHotelRates)) {
					$strRatesDDL = "<select disabled class='js-hotel-select' name ='hotel_rate[" . $hotel['id'] . "]'><option value=''>Select Rate</option>";

					foreach ($arrHotelRates AS $arrHotelRate) {

						$strRate = "$" . number_format($arrHotelRate['private_price'], 2) . " : " . $arrHotelRate['start_date'] . ' to ' . $arrHotelRate['end_date'] . ' : ' . $arrHotelRate['name'];

						$strRatesDDL .= "<option value='".$arrHotelRate['id']."' ".($arrHotelRate['id'] == $strHotelSelectedRate ? 'selected' : '' ) . " >".$strRate."</option>";
					}

					$strRatesDDL .= "</select>";

					echo "<tr><td>".$hotel['hotel_name']."<td>".$strRatesDDL."</td></td><td><input disabled name='hotel_room_nights[".$hotel['id']."]' style='width:60px' class='js-hotel-roomnights form-control input-sm' type='number' min='0' value='$strHotelRoomNights' /></td><td style='text-align:center'><input class='js-hotel-selected' name='hotel_selected[".$hotel['id']."]' type='checkbox' $strHotelSelected /></td></tr>";
				//}

			}
		}

		echo '</tbody></table>';
		echo '</div>';
	}

	public function getFeatureCourseDDL($intPackageId, $intRegionId, $strFilterYear='') {

		$strSql = "SELECT * FROM feature_packages_course WHERE packageID = " . $intPackageId;

		$arrResults = $this->objModel->getMysqliResults($strSql, true);
		
		$arrPackageCourses = array();

		if (count($arrResults) > 0) {

			foreach ($arrResults AS $arrResult) {
				$arrPackageCourses[$arrResult['courseID']] = $arrResult;
			}
		}

		echo "<div class='well well-sm calculator-control-list' style='height:300px; overflow-y:scroll;'>";
		echo "<table class='js-courses table table-condensed'><thead><tr><th width='60%''>Course Name</th><th>Rate</th><th>Rounds</th><th>Selected</th></tr></thead><tbody>";

		foreach ($this->arrCourses as $course) {

			//If course is in region or already selected 
			if ((isset($arrPackageHotels[$course['id']])) || ($this->isCourseInRegion($course['id'], $intRegionId))) {

				$strCourseSelected = isset($arrPackageCourses[$course['id']]) ? 'checked' : '';
				$strCourseSelectedRate = isset($arrPackageCourses[$course['id']]['rateID']) ? $arrPackageCourses[$course['id']]['rateID'] : '';
				$strCourseRounds = isset($arrPackageCourses[$course['id']]['rounds']) ? $arrPackageCourses[$course['id']]['rounds'] : '';;

				$strSqlFilterYear = '';
				if ($strFilterYear != '') {
					$strSqlFilterYear = " AND year(start_date) = '$strFilterYear' AND year(end_date) = '$strFilterYear' ";
				}

				$strSQL = "SELECT * FROM course_rates 
								WHERE (course_id = " . $course['id'] . " and parent_id IS NOT NULL AND deleted = 0 $strSqlFilterYear) 
									OR (course_id = ". $course['id'] . " AND id IN (SELECT rateID FROM feature_packages_course WHERE packageID = " . $intPackageId . "))";

				$arrCourseRates = $this->objModel->getMysqliResults($strSQL, true);

				//if (!empty($arrCourseRates)) {

					$strRatesDDL = "<select class='js-course-select' disabled name ='course_rate[" . $course['id'] . "]'><option value=''>Select Rate</option>";

					foreach ($arrCourseRates AS $arrCourseRate) {

						//$strRate = substr("$" . number_format($arrCourseRate['private_price'], 2) . " - " . $arrCourseRate['name'], 0, 50);
						$strRate = "$" . number_format($arrCourseRate['private_price'], 2) . " : " . $arrCourseRate['start_date'] . ' to ' . $arrCourseRate['end_date'] . ' : ' . $arrCourseRate['name'];

						$strRatesDDL .= "<option value='".$arrCourseRate['id']."' ".($arrCourseRate['id'] == $strCourseSelectedRate ? 'selected' : '' ) ." >".$strRate."</option>";
					}
					
					$strRatesDDL .= "</select>";

					echo "<tr><td>".$course['course_name']."<td>".$strRatesDDL."</td></td><td><input name='course_rounds[".$course['id']."]' value='$strCourseRounds' style='width:60px' class='js-course-rounds form-control input-sm' type='number' min='0' disabled /></td><td style='text-align:center'><input class='js-course-selected' name='course_selected[".$course['id']."]' type='checkbox' $strCourseSelected /></td></tr>";
				//}
			}
		}

		echo '</tbody></table>';
		echo '</div>';
	}	


	public function getBookingDDL($id, $bookingID) {

		echo '<select name="bookingID" class="form-control">';

		foreach($this->arrBooking As $booking) {
			echo '<option value="'.$booking['id'].'" '.Util::isSelected($booking['id'],$bookingID).'>'.$booking['booking_name'].'</option>';
		}

		echo'</select>';

	}

	public function getBrandDDL($id, $brandID) {

		echo '<select name="brandID" class="form-control">';

		foreach($this->arrBrands As $brand) {
			echo '<option value="'.$brand['id'].'" '.Util::isSelected($brand['id'],$brandID).'>'.$brand['business_name'].'</option>';
		}

		echo'</select>';

	}


	/**
	 * Function that creates the list of actions the user can do to the record
	 * Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true) {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
		if ($status == 'Trash') {
			$html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/?sub=true' . $this->strOptions . '">Restore</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/?sub=true' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
		} else {
		    if($this->objModel->checkpageaccess($_REQUEST['controller'], 'edit')){
			$html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/?sub=true' . $this->strOptions . '">Edit</a></li>';
		    }
			if($this->objModel->checkpageaccess($_REQUEST['controller'], 'delete')){
			    $html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/?sub=true' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
			}
		}
		$html .= '</ul>';

		return $html;
	}


}