<?php


class default_controller {

	// The last query we executed
	public $strQuery = '';

	// The resource returned from above query
	public $arrResult = null;

	// Number of affected rows from above query.
	public $intAffectedRows = null;

	// Error Messages
	public $strErrorMessage = '';
	public $strSuccessMessage = '';

	public $strTitle = '';
	public $strContent = '';
	public $strTableSlug = '';
	public $strTableName = 'pages';
	public $strAdminSlug = '/admin/page/';

	// Model and view
	public $objModel = null;
	public $strView = '';

	// Define and give our request parameters a default value
	public $intID = null;
	public $strPg = '1';
	public $strPgSize = '50';
	public $strSortBy = 'id';
	public $strSortOrder = 'DESC';
	public $strSearchWord = '';
	public $strStatus = 'Active';
	public $strGridDates = '';
	public $intGridCategories = null;
	public $controller = '';
	public $module = '';

	public $strAction = '';
	public $strSubmit = '';
	public $strTrash = '';
	public $strDelete = '';
	public $strRestore = '';
	public $strBulk = '';
	public $strOptions = '';

	// Table column defaults
	public $arrTableSQLArray = array('', 'title', 'cat_title', 'date_created', 'date_modified', 'pub_status', '');
	public $arrTableDisplayArray = array('<input type="checkbox" name="" id="" class="selectall" value="" onclick="toggle(this);">', 'Page Name', 'Category', 'Date Created', 'date_modified', 'Status', 'Actions');
	public $arrTableSortArray = array(false, true, true, true, true, true, false);

	public $intCatID;
	public $arrCategories;
	public $csvPageID;

	public $arrScoreSEO;

	public function __construct($strPageId) {

		$this->strTableSlug = $strPageId;
		// Set our request variables
		
		$this->setRequestVariables();
		// The model for this controller
		
// 		 var_dump($_REQUEST);die();
        // die($this->controller);
		
		$this->setModel($strPageId, $this->strAction);
        
		// Prepare the page actions
		$this->doActions();

	}


	/**
	 * Function that sets our base controller variables
	 *
	 */
	public function setRequestVariables() {
	    
	   // print_r($_REQUEST);die();
	    
		$this->intID = isset($_GET['id']) ? $_GET['id'] : $this->intID;
		if(isset($_POST['id'])) { $this->intID = $_POST['id']; }
		
		$this->user_name = isset($_REQUEST['user_name']) ? $_REQUEST['user_name'] : '';
		$this->user_alias = isset($_REQUEST['user_alias']) ? $_REQUEST['user_alias'] : '';
		$this->user_email = isset($_REQUEST['user_email']) ? $_REQUEST['user_email'] : '';
		$this->user_password = isset($_REQUEST['user_password']) ? $_REQUEST['user_password'] : '';
		$this->is_admin = isset($_REQUEST['is_admin']) ? true : 'false';
		$this->strStatus = isset($_REQUEST['status']) ? $_REQUEST['status'] : '';
		$this->strSearchWord = isset($_REQUEST['searchWord']) ? $_REQUEST['searchWord'] : $this->strSearchWord;

		$this->strAction = isset($_REQUEST['action']) ? $_REQUEST['action'] : $this->strAction;
		$this->strSubmit = isset($_REQUEST['submit']) ? $_REQUEST['submit'] : $this->strSubmit;
		$this->strTrash = isset($_REQUEST['trash']) ? $_REQUEST['trash'] : $this->strTrash;
		$this->strDelete = isset($_REQUEST['delete']) ? $_REQUEST['delete'] : $this->strDelete;
		$this->strRestore = isset($_REQUEST['restore']) ? $_REQUEST['restore'] : $this->strRestore;
		$this->strBulk = isset($_REQUEST['bulk_action']) ? $_REQUEST['bulk_action'] : $this->strBulk;
		
		if(isset($_POST['submit']) && isset($_REQUEST['action'])){
		    $_POST['action'] = $_REQUEST['action'];
		}
	}


	/**
	 * Function that sets the model for the controller
	 *
	 */
	public function setModel($strPageId, $strAction) {

		$this->objModel = New aPage($strPageId, $strAction);

	}


	/**
	 * Function that controls what actions / views are used
	 *
	 */
	public function doActions() {
        $checkaccess = $this->objModel->checkpageaccess($this->controller, $this->module);
        if(!$checkaccess){
            header("Location: /admin");
        }
	    
		// Update / edit
		if($this->strSubmit != '') {
		  //  print_r($this->objModel->handlePost($_POST, $this->intID));die();
			$this->intID = $this->objModel->handlePost($_POST, $this->intID);
		}
		// Trash
		if($this->strTrash != '') {
			$this->objModel->updateStatus($this->intID,'Trash');
		}
		// Restore
		if($this->strRestore != '') {
			$this->objModel->updateStatus($this->intID,'Active');
		}
		// Delete
		if($this->strDelete != '') {
			$this->objModel->deleteRecord($this->intID);
			$this->intID = '';
			$this->strAction = '';
		}

		// Bulk Actions
		if($this->strBulk != '') {
			$this->csvPageID = isset($_REQUEST['pageID']) ? implode($_REQUEST['pageID'],',') : "";
			if($this->strBulk == 'trash') {
				$this->objModel->updateStatus($this->csvPageID,'Trash');
			} else if($this->strBulk == 'restore') {
				$this->objModel->updateStatus($this->csvPageID,'Active');
			}
		}

		// Set our admin messages after the model functions run
		$this->strErrorMessage = $this->objModel->strErrorMessage;
		$this->strSuccessMessage = $this->objModel->strSuccessMessage;
        
		// Get the Grid / Detail view
		if($this->strAction == '') {
			// Get the Page Array
			$this->arrPages = $this->objModel->getList($this->strPgSize,$this->strPg,$this->strSortBy,
			$this->strSortOrder,$this->strSearchWord,$this->strStatus,$this->strGridDates,$this->intGridCategories,false);
			$this->strQuery = $this->objModel->strQuery;
		} else {
			// Get the detail vie
			//if($this->strSubmit == '') {
		  //  print_r($this->objModel->getDetail($this->intID));die();
				$this->page = $this->objModel->getDetail($this->intID);
			//}
		}


	}


	/**
	 * Loads the view
	 *
	 */
	public function getPageContent() {
		if (empty($this->strAction)) {
			// If the action is empty get the list view, in it we use the $this->strView property
			include(ROOT_DIR.'/application/views/admin/default_list_view.php');
		} else {
			// If the action is set get the edit / add form
			include(ROOT_DIR.'/application/views/admin/detail/'.$this->strView.'.php');
		}
	}


	public function getPageScripts() {

		// This method must be present, even if no scripts are needed
		echo '<!-- custom page scripts -->';

	}


	/**
	 * Function that creates the list of actions the user can do to the record
	 * View, Edit, Restore, Trash, Delete
	 */
	public function getPageControls($id, $slug, $status, $visible = true) {
		$html = '';
		$visibleClass = ($visible) ? '' : 'invisible';

		$html .= '<ul class="grid-actions list-inline '.$visibleClass.'">';
		if ($status == 'Trash') {
			$html .= '<li><a href="'.$this->strAdminSlug.'restore/' . $id . '/' . $this->strOptions . '">Restore</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'delete/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Permanently Delete</a></li>';
		} else {
			$html .= '<li><a href="'.$this->strAdminSlug.'edit/' . $id . '/' . $this->strOptions . '">Edit</a></li>';
			if (!empty($slug)) $html .= '<li><a href="/'.$slug.'/" target="_blank">View</a></li>';
			$html .= '<li><a href="javascript:confirmDelete(\''.$this->strAdminSlug.'trash/' . $id . '/' . $this->strOptions . '\');" class="text-danger">Trash</a></li>';
		}
		$html .= '</ul>';

		return $html;
	}



	public function getPageGridControls($id, $slug) {

		$html = '<a href="'.$slug.'edit/'.$id.'/'.$this->strOptions.'"><i class="fa fa-pencil fa-lg"></i></a> |
             <a href="javascript:confirmDelete(\''.$slug.'trash/'.$id.'/\');"><i class="fa fa-trash-o fa-lg"></i></a>';

		return $html;
	}



}